<?php    
                         
$yiw_slider = yiw_get_option( 'slider_choosen', 'none' );      

$yiw_sliders = array(
    'none'        => __( 'None', 'yiw' ),
    'fixed-image' => __( 'Fixed Image', 'yiw' ),
    'elegant'     => __( 'Slider Elegant', 'yiw' ),
    'cycle'       => __( 'Slider Cycle' , 'yiw' ),
    'nivo'        => __( 'Slider Nivo' , 'yiw' ),
    'carousel'    => __( 'Slider Carousel' , 'yiw' ),
    'elastic'     => __('Slider Elastic', 'yiw'),
    //'flash'       => __( 'Slider Flash', 'yiw' ),
    //'rotating'    => __( 'Slider Rotating', 'yiw' )
);      

// configuration slides
switch ( $yiw_slider ) {
    case 'elegant' :
        $slide_config = 'title, image, caption, link';
        break;
    case 'cycle' :
        $slide_config = 'title, image, caption, link, video';
        break;
    case 'nivo' :
        $slide_config = 'title, image, link';
        break;
    case 'carousel' :
        $slide_config = 'title, image, caption, link';
        break;
    case 'elastic' :
        $slide_config = 'title, caption, image, link';
        break;
//  case 'flash' :
//      $slide_config = 'title, image, caption, link';
//      break;
//  case 'rotating' :       
//      $slide_config = 'title, image';
//      break;
    default :
        $slide_config = 'title, image, caption, link';
        break;
}

$yiw_options['sliders'] = array (         
    
    /* =================== ARROW FADE SLIDER =================== */
    'title' => array(    
        array( 'name' => __('Sliders Manager', 'yiw'),
               'type' => 'title'),
    ),        
            
    'config' => array(    
        array( 'name' => __('Select slider to show or configure', 'yiw'),
               'type' => 'section',
               'effect' => 0),
        array( 'type' => 'open'),         
        
        array( 'name' => __('Default Header image type', 'yiw'),
               'desc' => __('Select the default header type for homepage pages.', 'yiw') . ' <br />Note: ' . sprintf( __('for "Fixed Image", you can configure it on %s -> %s.', 'yiw' ), __( 'Appearance', 'yiw' ), __( 'Header', 'yiw' ) ),
               'id' => 'slider_type',
               'type' => 'radio',
               'options' => $yiw_sliders,
               'std' => __('none', 'yiw') ),             
         
        array( 'name' => __('Configure slider.', 'yiw'),
               'id' => 'slider_choosen',       
               'desc' => __('Choose a slider and save, to configure below your slider choosen.', 'yiw'),
               'type' => 'select',
               'options' => $yiw_sliders,
               'button' => __( 'Configure', 'yiw' ),
               'std' => 'none' ),     
        
        array(  'name' => __('Responsive Behavior', 'yiw'),
                'id' => 'slider_responsive',       
                'desc' => __('Say what you want to do when the website is loaded by lower resolution screen.', 'yiw' ) . ' <br /><br /><b>NB:</b> '.__('The option "Leave the slider" is available only for "elastic" slider, because is the only one that has a correct responsive behavior. If you use another slider type, the slider will be hidden in lower resolutions.', 'yiw'),
                'type' => 'select',
                'options' => array(                               
                    'leave' => __( 'Leave the slider', 'yiw' ),
                    'remove' => __( 'Remove the slider', 'yiw' ),
                    'fixed-image' => __( 'Replace with "Fixed Image"', 'yiw' )
                ),
                'std' => 'leave' ),
            
        array( 'type' => 'close')
    ),
/*    
    'settings-flash' => array(  
        array( 'name' => __('Slider Settings', 'yiw'),
               'type' => 'section'),
        array( 'type' => 'open'),          
         
        array( 'name' => __('Settings flash slider', 'yiw'),
               'desc' => __('To configure the flash slider settings, go to the "Flash slider" tab.', 'yiw'),
               'type' => 'simple-text'),
            
        array( 'type' => 'close')       
    ),
*/
    'settings-elegant' => array(    
        array( 'name' => __('Slider Settings', 'yiw'),
               'type' => 'section'),
        array( 'type' => 'open'),  
         
        array( 'name' => __('Effect', 'yiw'),
               'desc' => __('Select the effect you want for slides transiction.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_effect',
               'type' => 'select',
               'options' => $GLOBALS['yiw_cycle_fxs'],
               'std' => 'fade'),    
         
        array( 'name' => __('Easing', 'yiw'),
               'desc' => __('Select the easing for effect transition.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_easing',
               'type' => 'select',
               'options' => $GLOBALS['yiw_easings'],
               'std' => FALSE ),    
            
        array( 'name' => __('Speed (s)', 'yiw'),
               'desc' => __('Select the speed of transiction between slides, expressed in seconds.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_speed',
               'min' => 0,
               'max' => 5,
               'step' => 0.1,
               'type' => 'slider_control',
               'std' => 0.5),  
            
        array( 'name' => __('Timeout (s)', 'yiw'),
               'desc' => __('Select the delay between slides, expressed in seconds.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_timeout',
               'min' => 0,
               'max' => 20,
               'step' => 0.5,
               'type' => 'slider_control',
               'std' => 5),     
            
        array( 'name' => __('Caption position', 'yiw'),
               'desc' => __('Select the position of caption.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_caption_position',
               'type' => 'select',
               'options' => array(
                    'top' => __( 'Top', 'yiw' ),
                    'bottom' => __( 'Bottom', 'yiw' ),
                    'left' => __( 'Left', 'yiw' ),
                    'right' => __( 'Right', 'yiw' ),
               ),
               'std' => 'right'),    
            
        array( 'name' => __('Caption Speed (s)', 'yiw'),
               'desc' => __('Select the speed of caption appearance.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_caption_speed',
               'min' => 0,
               'max' => 5,
               'step' => 0.1,
               'type' => 'slider_control',
               'std' => 0.5),      
         
        array( 'name' => __('More text', 'yiw'),
               'desc' => __('Write what you want to show on more link, if you have selected "YES" on option above.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_more_text',
               'type' => 'text',
               'std' => __( 'Read more...', 'yiw' ) ),
            
        array( 'type' => 'close')
    ),   
    
    'settings-cycle' => array(    
        array( 'name' => __('Slider Settings', 'yiw'),
               'type' => 'section'),
        array( 'type' => 'open'),  
         
        array( 'name' => __('Effect', 'yiw'),
               'desc' => __('Select the effect you want for slides transiction.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_effect',
               'type' => 'select',
               'options' => $GLOBALS['yiw_cycle_fxs'],
               'std' => 'fade'),    
         
        array( 'name' => __('Easing', 'yiw'),
               'desc' => __('Select the easing for effect transition.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_easing',
               'type' => 'select',
               'options' => $GLOBALS['yiw_easings'],
               'std' => FALSE ),    
            
        array( 'name' => __('Speed (s)', 'yiw'),
               'desc' => __('Select the speed of transiction between slides, expressed in seconds.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_speed',
               'min' => 0,
               'max' => 5,
               'step' => 0.1,
               'type' => 'slider_control',
               'std' => 0.5),  
            
        array( 'name' => __('Timeout (s)', 'yiw'),
               'desc' => __('Select the delay between slides, expressed in seconds.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_timeout',
               'min' => 0,
               'max' => 20,
               'step' => 0.5,
               'type' => 'slider_control',
               'std' => 5),     
               
        array( "name" => __("Show more text", 'yiw'),
               "desc" => __("Select if you want to show more text after tooltip content, linked with slide's link.", 'yiw'),
               "id" => 'slider_' . $yiw_slider . '_show_more_text',
               "type" => "on-off",
               "std" => 'no'),
         
        array( 'name' => __('More text', 'yiw'),
               'desc' => __('Write what you want to show on more link, if you have selected "YES" on option above.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_more_text',
               'type' => 'text',
               'std' => __( 'Read more...', 'yiw' ) ),
            
        array( 'type' => 'close')
    ),          

    'settings-nivo' => array(    
        array( 'name' => __('Slider Settings', 'yiw'),
               'type' => 'section'),
        array( 'type' => 'open'),  
         
        array( 'name' => __('Effect', 'yiw'),
               'desc' => __('Select the effect you want for slides transiction.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_effect',
               'type' => 'select',
               'options' => array(
                                'random' => 'random',
                                'sliceDown' => 'sliceDown',
                                'sliceDownLeft' => 'sliceDownLeft',
                                'sliceUp' => 'sliceUp',
                                'sliceUpLeft' => 'sliceUpLeft',
                                'sliceUpDown' => 'sliceUpDown',
                                'sliceUpDownLeft' => 'sliceUpDownLeft',
                                'fold' => 'fold',
                                'fade' => 'fade',
                                'sliceInRight' => 'sliceInRight',
                                'sliceInLeft' => 'sliceInLeft',
                                'boxRandom' => 'boxRandom',
                                'boxRain' => 'boxRain',
                                'boxRainReverse' => 'boxRainReverse',
                                'boxRainGrow' => 'boxRainGrow',
                                'boxRainGrowReverse' => 'boxRainGrowReverse'
                            ),
               'std' => 'fade'),    
            
        array( 'name' => __('Speed (s)', 'yiw'),
               'desc' => __('Select the speed of transiction between slides, expressed in seconds.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_speed',
               'min' => 0,
               'max' => 5,
               'step' => 0.1,
               'type' => 'slider_control',
               'std' => 0.5),  
            
        array( 'name' => __('Timeout (s)', 'yiw'),
               'desc' => __('Select the delay between slides, expressed in seconds.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_timeout',
               'min' => 0,
               'max' => 20,
               'step' => 0.5,
               'type' => 'slider_control',
               'std' => 5),     

        array( "name" => __("Next & Prev navigation", 'yiw'),
               "desc" => __("Choose if you want to show Next & Prev arrows", 'yiw'),
               "id" => 'slider_' . $yiw_slider . '_directionNav',
               "type" => "on-off",
               "std" => 1),
            
        array( "name" => __("Next & Prev navigation only on hover", 'yiw'),
               "desc" => __("Choose if you want to show Next & Prev arrows only on hover", 'yiw'), 
               "id" => 'slider_' . $yiw_slider . '_directionNavHide',
               "type" => "on-off",
               "std" => 1),
            
        array( "name" => __("Enable Bullets", 'yiw'),
               "desc" => __("Choose if you want to show bullets navigation below the slider", 'yiw'),
               "id" => 'slider_' . $yiw_slider . '_controlNav',
               "type" => "on-off",
               "std" => 0),
            
        array( 'type' => 'close')
    ),          

    'settings-carousel' => array(    
        array( 'name' => __('Slider Settings', 'yiw'),
               'type' => 'section'),
        array( 'type' => 'open'),  
         
        array( 'name' => __('Speed (s)', 'yiw'),
               'desc' => __('Specifies how many seconds to periodically autoscroll the content. If set to 0 then autoscrolling is turned off. ', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_auto',
               'min' => 0,
               'max' => 5,
               'step' => 1,
               'type' => 'slider_control',
               'std' => 2),  
            
        array( 'name' => __('Animation (s)', 'yiw'),
               'desc' => __('Select the speed of the scroll animation.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_animation',
               'min' => 0,
               'max' => 5,
               'step' => 0.1,
               'type' => 'slider_control',
               'std' => 1.6),     
            
        array( 'type' => 'close')
    ),       
    
    'settings-elastic' => array(    
        array( 'name' => __('Slider Settings', 'yiw'),
               'type' => 'section'),
        array( 'type' => 'open'),    
            
        array( 'name' => __('Height of slider', 'yiw'),
               'desc' => __('Select the height of the slider, in base of the images that you want to add.', 'yiw'),
               'id' => 'slider_elastic_height',
               'type' => 'text',
               'std' => 400),     
            
        array( 'name' => __('Autoplay', 'yiw'),
               'desc' => __('Select if you want that the slider change the slide automatically.', 'yiw'),
               'id' => 'slider_elastic_autoplay',
               'type' => 'on-off',
               'std' => 1),     
            
        array( 'name' => __('Animation', 'yiw'),
               'desc' => __('Animation types -> "sides" : new slides will slide in from left / right; "center": new slides will appear in the center.', 'yiw'),
               'id' => 'slider_elastic_animation',
               'type' => 'select',
               'options' => array(
                    'sides' => __( 'Sides', 'yiw' ),
                    'center' => __( 'Center', 'yiw' )
               ),
               'std' => 'slide'),     
            
        array( 'name' => __('Speed (s)', 'yiw'),
               'desc' => __('Select the speed of transiction between slides, expressed in seconds.', 'yiw'),
               'id' => 'slider_elastic_speed',
               'min' => 0,
               'max' => 5,
               'step' => 0.1,
               'type' => 'slider_control',
               'std' => 0.8),  
            
        array( 'name' => __('Timeout (s)', 'yiw'),
               'desc' => __('Select the delay between slides, expressed in seconds.', 'yiw'),
               'id' => 'slider_elastic_timeout',
               'min' => 0,
               'max' => 20,
               'step' => 0.5,
               'type' => 'slider_control',
               'std' => 3),     
            
        array( 'type' => 'close')
    ),   


/*
    'settings-rotating' => array(    
    
        array( 'name' => __('Rotating Slider Settings', 'yiw'),
               'type' => 'section'),
        array( 'type' => 'open'),  
         
        array( 'name' => __('Slider Title', 'yiw'),
               'desc' => __('Te title that appears above slides.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_title',
               'type' => 'text',
               'std' => __( 'Fashion Explosion 2012', 'yiw' ) ),
         
        array( 'name' => __('Number of panel', 'yiw'),
               'desc' => __('Number of panels for each slide.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_n_panels',
               'type' => 'slider_control',
               'min' => 2,
               'max' => 5,
               'std' => 4 ),
               
        array( 'name' => __('Speed (s)', 'yiw'),
               'desc' => __('Difference of animation time between the items.', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_speed1',
               'min' => 0,
               'max' => 5,
               'step' => 0.1,
               'type' => 'slider_control',
               'std' => 0.2), 
               
        array( 'name' => __('Speed (s)', 'yiw'),
               'desc' => __('Time between each image animation (slideshow)', 'yiw'),
               'id' => 'slider_' . $yiw_slider . '_speed2',
               'min' => 0,
               'max' => 20,
               'step' => 0.1,
               'type' => 'slider_control',
               'std' => 7), 

        array( 'type' => 'close')
    ),
*/
    'slides' => array(    
        array( 'name' => __('Slides', 'yiw'),
               'type' => 'section',
               'valueButton' => __('Add/Edit Slide', 'yiw'),
               'effect' => 0),
        array( 'type' => 'open'),  
         
        array( 'id' => 'slider_' . $yiw_slider . '_slides',
               'data' => 'array',
               'type' => 'slides-table',
               'config' => $slide_config,
               'max-height' => 180 ),   
            
        array( 'type' => 'close')
    )        
    /* =================== END ARROW FADE SLIDER =================== */
 
);         

if ( $yiw_slider == 'none' || $yiw_slider == 'fixed-image' )
    unset( $yiw_options['sliders']['slides'] );  

foreach ( $yiw_options['sliders'] as $section => $options ) {
    if ( preg_match( '/settings-(.*)/', $section ) && $section != 'settings-' . $yiw_slider )
        unset( $yiw_options['sliders'][$section] );
}     
   
?>