<?php
/**
 * All hooks for the theme.
 *
 * @package WordPress
 * @subpackage YIW Themes
 * @since 1.0
 */   
 
if ( ! get_option('yiw_installed_impero_premium') ) { 

    // extend the options in the db
    $yiw_theme_options = wp_parse_args( $yiw_theme_options, yiw_get_default_options() );
    
    // set correctly the home page, as in the free version
    $yiw_theme_options['portfolio_show_home_page'] = $yiw_theme_options['gallery_show_home_page'] = 0;
    
    // add the default contact form
    $yiw_theme_options['contact_forms'] = serialize( array( 'default' ) );
    $yiw_theme_options['contact_form_choosen'] = 'default';
    $yiw_theme_options['contact_fields_default'] = serialize( $yiw_default_contact_form );
    
    // save the theme options
    yiw_update_theme_options();
    
    // set the fixed image in the static home
    if ( get_option('show_on_front') == 'page' )
        update_post_meta( get_option('page_on_front'), 'slider_type', 'fixed-image' );
    
    update_option('yiw_installed_impero_premium', true);
}        

?>