<?php
/**
 * The functions of theme 
 * 
 * @package WordPress
 * @subpackage YIW Themes
 * @since 1.0 
 */ 
 
// default theme setup
function yiw_theme_setup() {   
    global $wp_version;

    // This theme styles the visual editor with editor-style.css to match the theme style.
    add_editor_style( 'css/editor-style.css' );

    // This theme uses post thumbnails
    add_theme_support( 'post-thumbnails' );  

    // This theme uses the menues
    add_theme_support( 'menus' );          

    // Add default posts and comments RSS feed links to head
    add_theme_support( 'automatic-feed-links' );
    
    // Post Format support.      
    //add_theme_support( 'post-formats', array( 'aside', 'gallery' ) ); 
    
    // Post Format support.      
    //add_theme_support( 'post-formats', array( 'aside', 'gallery' ) ); // Your changeable header business starts here
    if ( ! defined( 'HEADER_TEXTCOLOR' ) )
        define( 'HEADER_TEXTCOLOR', '' );

    // No CSS, just IMG call. The %s is a placeholder for the theme template directory URI.
    if ( ! defined( 'HEADER_IMAGE' ) )
        define( 'HEADER_IMAGE', '%s/images/fixed-images/001.jpg' );

    // The height and width of your custom header. You can hook into the theme's own filters to change these values.
    // Add a filter to twentyten_header_image_width and twentyten_header_image_height to change these values.
    define( 'HEADER_IMAGE_WIDTH', apply_filters( 'yiw_header_image_width', 1023 ) );
    define( 'HEADER_IMAGE_HEIGHT', apply_filters( 'yiw_header_image_height', 457 ) );

    // We'll be using post thumbnails for custom header images on posts and pages.
    // We want them to be 940 pixels wide by 198 pixels tall.
    // Larger images will be auto-cropped to fit, smaller ones will be ignored. See header.php.
    //set_post_thumbnail_size( HEADER_IMAGE_WIDTH, HEADER_IMAGE_HEIGHT, true );
    add_image_size( 'thumb_home_page'       , 220, 178, true );
    add_image_size( 'thumb_gallery'         , 208, 168, true );
    add_image_size( 'thumb_recentposts'     , 55, 55, true );
    add_image_size( 'thumb_testimonial'     , 147, 147, true );
    add_image_size( 'thumb_news'            , 170, 140, true );
    add_image_size( 'thumb_portfolio_3cols' , 280, 143, true );
    add_image_size( 'thumb_portfolio_slider' , 205, 118, true );
    add_image_size( 'thumb-slider-elastic' , 150, 59,  true );
    add_image_size( 'thumb_portfolio_big'   , 617, 295, true );
    add_image_size( 'blog_big'              , 700, 295, true );
    add_image_size( 'blog_small'            , 295, 295, true );

    // Don't support text inside the header image.
    if ( ! defined( 'NO_HEADER_TEXT' ) )
        define( 'NO_HEADER_TEXT', true );

    // Add a way for the custom header to be styled in the admin panel that controls
    // custom headers. See twentyten_admin_header_style(), below.
    if( version_compare( $wp_version, '3.4', ">=" ) )
        add_theme_support( 'custom-header', array( 'admin-head-callback' => 'yiw_admin_header_style' ) );
    else
        add_custom_image_header( '', 'yiw_admin_header_style' );

    // ... and thus ends the changeable header business.

    // Default custom headers packaged with the theme. %s is a placeholder for the theme template directory URI.
    register_default_headers( array(
        'design1' => array(
            'url' => '%s/images/fixed-images/001.jpg',
            'thumbnail_url' => '%s/images/fixed-images/thumb/001.jpg',
            /* translators: header image description */
            'description' => __( 'Design', 'yiw' ) . ' 1'
        ),
        'design2' => array(
            'url' => '%s/images/fixed-images/002.jpg',
            'thumbnail_url' => '%s/images/fixed-images/thumb/002.jpg',
            /* translators: header image description */
            'description' => __( 'Design', 'yiw' ) . ' 2'
        ),
        'design3' => array(
            'url' => '%s/images/fixed-images/003.jpg',
            'thumbnail_url' => '%s/images/fixed-images/thumb/003.jpg',
            /* translators: header image description */
            'description' => __( 'Design', 'yiw' ) . ' 3'
        )
    ) );

    $locale = get_locale();      
    $locale_file = TEMPLATEPATH . "/languages/$locale.php";
    if ( is_readable( $locale_file ) )
        require_once( $locale_file ); 
    
    // This theme uses wp_nav_menu() in more locations.
    register_nav_menus(
        array(
            'nav'           => __( 'Navigation', 'yiw' )
        )
    );
    
    // images size
    //add_image_size( 'thumb', 100, 100 );           
    
    // sidebars registers                                                                                             
    register_sidebar( yiw_sidebar_args( 'Default Sidebar', __( 'This sidebar will be shown in all pages with empty sidebar or without any sidebat set.', 'yiw' ), 'widget', 'h2' ) );      
	
    register_sidebar( yiw_sidebar_args( 'Home Sidebar', __( 'The sidebar that you can use in the Home page', 'yiw'), 'widget', 'h2' ) );   
    register_sidebar( yiw_sidebar_args( 'Blog Sidebar', __( 'The sidebar showed on page with Blog template', 'yiw'), 'widget', 'h2' ) );            
    register_sidebar( yiw_sidebar_args( 'Gallery Sidebar', __( 'The sidebar used in Gallery Template', 'yiw'), 'widget', 'h2' ) );            
    register_sidebar( yiw_sidebar_args( 'Portfolio Sidebar', __( 'The sidebar used in Portfolio Template.', 'yiw'), 'widget', 'h2' ) );            
    register_sidebar( yiw_sidebar_args( 'Services Sidebar', __( 'The sidebar used in Services Template.', 'yiw'), 'widget', 'h2' ) );            
    register_sidebar( yiw_sidebar_args( 'News Sidebar', __( 'The sidebar used in News Template.', 'yiw'), 'widget', 'h2' ) );         
    register_sidebar( yiw_sidebar_args( 'Contact Sidebar', __( 'The sidebar that you can use in the Contact page', 'yiw'), 'widget', 'h2' ) );
    register_sidebar( yiw_sidebar_args( 'Shop Sidebar', __( 'The sidebar that you can use in the Shop pages', 'yiw'), 'widget', 'h2' ) );     
    
    // add sidebar created from plugin
    $sidebars = maybe_unserialize( yiw_get_option( 'sidebars' ) );
    if( is_array( $sidebars ) && ! empty( $sidebars ) )
    {
        foreach( $sidebars as $sidebar )
        {
            register_sidebar( yiw_sidebar_args( $sidebar, '', 'widget', 'h2' ) );
        }
    }
    
    // footer sidebars
    for( $i = 1; $i <= yiw_get_option( 'footer_rows', 0 ); $i++ )
        register_sidebar( yiw_sidebar_args( "Footer Row $i", __( "The widget area nr. {$i} used in Footer section", 'yiw'), 'widget', 'h2' ) );            
}

if ( ! function_exists( 'yiw_admin_header_style' ) ) :
/**
 * Styles the header image displayed on the Appearance > Header admin panel.
 *
 * Referenced via add_custom_image_header() in twentyten_setup().
 *
 * @since Twenty Ten 1.0
 */
function yiw_admin_header_style() {
?>
<style type="text/css">
/* Shows the same border as on front end */
#headimg {
    border-bottom: 1px solid #000;
    border-top: 4px solid #000;
}
/* If NO_HEADER_TEXT is false, you would style the text with these selectors:
    #headimg #name { }
    #headimg #desc { }
*/
</style>
<?php
}
endif; 

/** SLIDERS
-------------------------------------------------------------------- */

/**
 * vars for elegant slider
 */
function yiw_slider_elegant_scripts() {
    if ( yiw_get_option( 'slider_type' ) != 'elegant' )
        return;
    
    $easing = ( $eas = yiw_get_option( 'slider_elegant_easing') ) ? "'$eas'" : 'null';
    ?>
    <script type="text/javascript">      
        var     yiw_slider_type = 'elegant',
                yiw_slider_elegant_easing = <?php echo $easing ?>,
                yiw_slider_elegant_fx = '<?php echo yiw_get_option('slider_elegant_effect') ?>',
                yiw_slider_elegant_speed = <?php echo yiw_get_option('slider_elegant_speed') * 1000 ?>,
                yiw_slider_elegant_timeout = <?php echo yiw_get_option('slider_elegant_timeout') * 1000 ?>,
                yiw_slider_elegant_caption_speed = <?php echo yiw_get_option('slider_elegant_caption_speed') * 1000 ?>;  
    </script>
    <?php
} 


/**
 * vars for cycle slider
 */
function yiw_slider_cycle_scripts() {
    if ( yiw_get_option( 'slider_type' ) != 'cycle' )
        return;
    
    $easing = ( $eas = yiw_get_option( 'slider_cycle_easing') ) ? "'$eas'" : 'null';
    ?>
    <script type="text/javascript">      
        var     yiw_slider_type = 'cycle',
                yiw_slider_cycle_easing = <?php echo $easing ?>,
                yiw_slider_cycle_fx = '<?php echo yiw_get_option('slider_cycle_effect', 'fade') ?>',
                yiw_slider_cycle_speed = <?php echo yiw_get_option('slider_cycle_speed', 0.5) * 1000 ?>,
                yiw_slider_cycle_timeout = <?php echo yiw_get_option('slider_cycle_timeout', 5) * 1000 ?>;
    </script>
    <?php
} 



/**
 * vars for nivo slider
 */
function yiw_slider_nivo_scripts() {
    if ( yiw_get_option( 'slider_type' ) != 'nivo' )
        return;
    ?>
    <script type="text/javascript">      
        var     yiw_slider_type = 'nivo',
                yiw_slider_nivo_fx = '<?php echo yiw_get_option('slider_nivo_effect', 'random') ?>',
                yiw_slider_nivo_speed = <?php echo yiw_get_option('slider_nivo_speed', 0.5) * 1000 ?>,
                yiw_slider_nivo_timeout = <?php echo yiw_get_option('slider_nivo_timeout', 5) * 1000 ?>,
                yiw_slider_nivo_directionNav = <?php echo yiw_get_option('slider_nivo_directionNav', 1) ? yiw_get_option('slider_nivo_directionNav', 1) : 0 ?>,
                yiw_slider_nivo_directionNavHide = <?php echo yiw_get_option('slider_nivo_directionNavHide', 1) ? yiw_get_option('slider_nivo_directionNavHide', 1) : 0 ?>, 
                yiw_slider_nivo_controlNav = <?php echo yiw_get_option('slider_nivo_controlNav', 0) ? yiw_get_option('slider_nivo_controlNav', 0)  : 0 ?>;
    </script>
    <?php
} 


/**
 * vars for nivo slider
 */
function yiw_slider_carousel_scripts() {
    if ( yiw_get_option( 'slider_type' ) != 'carousel' )
        return;
    ?>
    <script type="text/javascript">      
        var     yiw_slider_type = 'carousel',
                yiw_slider_carousel_auto = <?php echo yiw_get_option('slider_carousel_auto', 2) ?>,
                yiw_slider_carousel_animation = <?php echo yiw_get_option('slider_carousel_animation', 5) * 1000 ?>;
    </script>
    <?php
} 

/**
 * vars for elastic slider
 */
function yiw_slider_elastic_scripts() {
    if ( yiw_slider_type() != 'elastic' )
        return;
    ?>
    <script type="text/javascript">      
        var     yiw_slider_type = 'elastic',
                yiw_slider_elastic_speed = <?php echo yiw_slide_get('speed') * 1000 ?>,
                yiw_slider_elastic_timeout = <?php echo yiw_slide_get('timeout') * 1000 ?>,
                yiw_slider_elastic_autoplay = <?php echo yiw_slide_get('autoplay') ? 'true' : 'false' ?>,
                yiw_slider_elastic_animation = '<?php yiw_slide_the('animation') ?>';
    </script>
    <?php
} 


add_action( 'wp_print_scripts', 'yiw_slider_elegant_scripts' );
add_action( 'wp_print_scripts', 'yiw_slider_cycle_scripts' );
add_action( 'wp_print_scripts', 'yiw_slider_nivo_scripts' );
add_action( 'wp_print_scripts', 'yiw_slider_carousel_scripts' );
add_action( 'wp_print_scripts', 'yiw_slider_elastic_scripts' );



function yiw_slider_elastic_height() {
    ?>.ei-slider {height:<?php echo yiw_get_option('slider_elastic_height') ?>px;}<?php
}
add_action( 'yiw_custom_styles', 'yiw_slider_elastic_height' );



/**
 * Different excerpt size
 * 
 * @return int
 */
function yiw_excerpt_length() {
    return 10;
}
function yiw_news_excerpt_length() {
    return 15;
}


/**
 * Different excerpt more text 
 * 
 * @return string
 */
function yiw_excerpt_more() {
    return '...';
}


/**
 * Get Page ID by page name
 * 
 * @param string $page_name
 * 
 * @return string|int
 */
function yiw_get_pageID_by_pagename( $page_name ) {
    global $wpdb;
    return $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_name = '$page_name'");
}      


/**
 * Return icon path by filename
 * 
 * @param string $icon
 * @param string $size
 * 
 * @return string
 */
function yiw_get_url_icon($icon, $size = 32)
{
    global $icons_name;
    
    $path = "/images/icons/{$icon}{$size}.png";
    
    if( file_exists( STYLESHEETPATH . $path ) )
        return get_template_directory_uri() . "/images/icons/{$icon}{$size}.png";
    else
        return get_template_directory_uri() . "/images/icons/{$icon}.png";
}  


/**
 * Return post content with read more link (if needed)
 * 
 * @param int|string $limit
 * @param string $more_text
 * 
 * @return string
 */
function yiw_content( $limit = 25, $more_text = '' ) {
    $content = explode( ' ', get_the_content(), $limit );

/*
    if ( count( $content ) >= $limit ) {
        array_pop( $content );
        if( $more_text != "" )
            $readmore = implode( " ", $content ) . '<a class="read-more" href="' . get_permalink() . '">' . $more_text . '</a>';
        else
            $content = implode( " ", $content ) . ' &#91;...&#93;';
    } else
        $content = implode( " ", $content );    
*/
    if ( count( $content ) >= $limit && $more_text != "" ) {
        array_pop( $content );
        $more_text = '<a class="read-more" href="' . get_permalink() . '">' . $more_text . '</a>';
    } else {
         $more_text = '';
    }
    
    $content = implode( " ", $content );

    $content = preg_replace( '/\[.+\]/', '', $content );
    $content = preg_replace( '/<img[^>]+./', '', $content ); //remove images
    $content = apply_filters( 'the_content', $content ); 
    $content = str_replace( ']]>', ']]&gt;', $content );
    
    return $content.$more_text;
}


/**
 * Return the page breadcrumbs
 * 
 */
function the_breadcrumb() {
    //if ( is_page_with_breadcrumb() ) :
    
        $delimiter = ' > ';
        $home = 'Home Page'; // text for the 'Home' link
        $before = '<a class="no-link current" href="#">'; // tag before the current crumb
        $after = '</a>'; // tag after the current crumb
     
        if ( !is_home() && !is_front_page() || is_paged() ) {
     
            echo '<div id="crumbs" class="theme_breadcumb">';
         
            global $post;
            $homeLink = site_url();
            echo '<a class="home" href="' . $homeLink . '">' . $home . '</a> ' . $delimiter . ' ';
         
            if ( is_category() ) {
                global $wp_query;
                $cat_obj = $wp_query->get_queried_object();
                $thisCat = $cat_obj->term_id;
                $thisCat = get_category($thisCat);
                $parentCat = get_category($thisCat->parent);
                if ( $thisCat->parent != 0 ) 
    echo get_category_parents( $parentCat, TRUE, ' ' . $delimiter . ' ' );
                echo $before . 'Archive by category "' . single_cat_title('', false) . '"' . $after;
         
            } elseif ( is_day() ) {
                echo '<a class="no-link" href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
                echo '<a class="no-link" href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $delimiter . ' ';
                echo $before . get_the_time('d') . $after;
         
            } elseif ( is_month() ) {
                echo '<a class="no-link" href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
                echo $before . get_the_time('F') . $after;
         
            } elseif ( is_year() ) {
                echo $before . get_the_time('Y') . $after;
         
            } elseif ( is_single() && !is_attachment() ) {
                if ( get_post_type() != 'post' ) {
    $post_type = get_post_type_object(get_post_type());
    $slug = $post_type->rewrite;
    echo '<a class="no-link" href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a> ' . $delimiter . ' ';
    echo $before . get_the_title() . $after;
                } else {
    $cat = get_the_category(); $cat = $cat[0];
    echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
    echo $before . get_the_title() . $after;
                }
    
            } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
                $post_type = get_post_type_object(get_post_type());
                echo $before . $post_type->labels->singular_name . $after;
         
            } elseif ( is_attachment() ) {
                $parent = get_post($post->post_parent);
                $cat = get_the_category($parent->ID); $cat = $cat[0];
                echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
                echo '<a class="no-link" href="' . get_permalink($parent) . '">' . $parent->post_title . '</a> ' . $delimiter . ' ';
                echo $before . get_the_title() . $after;
         
            } elseif ( is_page() && !$post->post_parent ) {
                echo $before . get_the_title() . $after;
         
            } elseif ( is_page() && $post->post_parent ) {
                $parent_id  = $post->post_parent;
                $breadcrumbs = array();
                while ( $parent_id ) {
    $page = get_page($parent_id);
    $breadcrumbs[] = '<a class="no-link" href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
    $parent_id  = $page->post_parent;
                }
                $breadcrumbs = array_reverse($breadcrumbs);
                foreach ( $breadcrumbs as $crumb ) 
    echo $crumb . ' ' . $delimiter . ' ';
                echo $before . get_the_title() . $after;
         
            } elseif ( is_search() ) {
                echo $before . 'Search results for "' . get_search_query() . '"' . $after;
         
            } elseif ( is_tag() ) {
                echo $before . 'Posts tagged "' . single_tag_title('', false) . '"' . $after;
         
            } elseif ( is_author() ) {
                global $author;
                $userdata = get_userdata($author);
                echo $before . 'Articles posted by ' . $userdata->display_name . $after;
         
            } elseif ( is_404() ) {
                echo $before . 'Error 404' . $after;
            }
         
            if ( get_query_var('paged') ) {
                if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) 
    echo ' (';
                echo $before . __('Page', 'yiw') . ' ' . get_query_var('paged') . $after;
                if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) 
    echo ')';
            }
         
            echo '<div class="breadcrumb-end"></div>';
            echo '</div>';
         
        }
        
    //endif;
}
            
/**
 * Add style of body
 *
 * @since 1.0
 */
function yiw_body_style() {
    

    
    $role = '';
    
    $bg_type = yiw_get_option( 'body_bg_type' );
    $color_bg = yiw_get_option( 'body_bg_color' );
    
    switch ( $bg_type ) {
    
        case 'color-unit' :
            $role = 'background:' . $color_bg . ';';
            break;
    
        case 'bg-image' :
            $image = yiw_get_option( 'body_bg_image' );         
            
            // image
            if ( $image != 'custom' ) {
                $url_image = get_template_directory_uri() . '/' . $image;   
                $position = 'top left'; 
                $repeat = 'repeat';
                $attachment = 'fixed';
            } else {
                $url_image = yiw_get_option( 'body_bg_image_custom' ); 
                $position = yiw_get_option( 'body_bg_image_custom_position' ); 
                $repeat = yiw_get_option( 'body_bg_image_custom_repeat' );
                $attachment = yiw_get_option( 'body_bg_image_custom_attachment' );
            }
            
            $role = "background:$color_bg url('$url_image') $repeat $position $attachment;";
            break;
    
    }
?>
body {
    <?php echo $role ?>
}
<?php
}   
add_action( 'yiw_custom_styles', 'yiw_body_style' );    


/**
 * Add style of header
 *
 * @since 1.0
 */
function yiw_header_style() {
    $role = '';
    
    $bg_type = yiw_get_option( 'header_bg_type' );
    $color_bg = yiw_get_option( 'header_bg_color' );
    
    switch ( $bg_type ) {
    
        case 'color-unit' :
            $role = 'background:' . $color_bg . ';';
            break;
    
        case 'bg-image' :
            $image = yiw_get_option( 'header_bg_image' );
            
            // image
            if ( $image != 'custom' ) {
                $url_image = get_template_directory_uri() . '/' . $image;   
                $position = 'bottom center'; 
                $repeat = 'no-repeat';
            } else {
                $url_image = yiw_get_option( 'header_bg_image_custom' ); 
                $position = yiw_get_option( 'header_bg_image_custom_position' ); 
                $repeat = yiw_get_option( 'header_bg_image_custom_repeat' );
            }
            
            
            $role = 'background:' . $color_bg . ' url(\'' . $url_image . '\') ' . $repeat . ' ' . $position . ';';
            break;
    
    }
?>
#header {
    <?php echo $role ?>
}
<?php
}   
//add_action( 'yiw_custom_styles', 'yiw_header_style' );


            


/** ADMIN
-------------------------------------------------------------------- */

// add new type to theme options
function yiw_select_with_header_preview( $value ) {
    
    if ( isset( $value['id'] ) )
        $id_container = 'id="' . $value['id'] . '-option" ';       
        
    // deps                   
    if ( isset( $value['deps'] ) ) {
        $value['deps']['id_input'] = yiw_option_id( $value['deps']['id'], false );
        $deps[ $value['id'] ] = $value['deps'];
        $class_dep = ' yiw-deps';
        $fade_color_dep = '<div class="fade_color"></div>';
    }
    ?>
    
        <div <?php echo $id_container ?>class="rm_option rm_input rm_select<?php echo $class_dep ?> rm_with_preview">
            <label for="<?php yiw_option_id( $value['id'] ); ?>"><?php echo $value['name']; ?></label>
            
            <select name="<?php yiw_option_name( $value['id'] ); ?>" id="<?php yiw_option_id( $value['id'] ); ?>" <?php if( isset( $value['button'] ) ) : ?>style="width:240px;" <?php endif ?>>
                <?php foreach ($value['options'] as $val => $option) { ?>
    <option value="<?php echo $val ?>" <?php selected( yiw_get_option( $value['id'], $value['std'] ), $val ) ?>><?php echo $option; ?></option>
                <?php } ?>
            </select>          
            
            <?php if( isset( $value['button'] ) ) : ?>
            <input type="submit" value="<?php echo $value['button']; ?>" class="button" name="<?php yiw_option_id( $value['id'] ); ?>_save" id="<?php yiw_option_id( $value['id'] ); ?>_save">
            <?php endif ?>
            
            <small><?php echo $value['desc']; ?></small>
            <div class="clearfix"></div>
            <?php $style = ( $value['std'] == 'custom' ) ? ' style="display:none;"' : ''; ?>
            <div class="preview"<?php echo $style ?>><img class="min" src="<?php echo get_template_directory_uri() . '/' . yiw_get_option( $value['id'], $value['std'] ) ?>" title="<?php _e( 'Click to expand the image to the natural size', 'yiw' ) ?>" /></div>
            <script type="text/javascript">
                jQuery(document).ready(function($){
                    var select = $('#<?php yiw_option_id( $value['id'] ); ?>');
                    var preview = $('#<?php echo $value['id'] ?>-option .preview');
                    
                    var change_preview = function(){
                        var value = select.val();
                        if ( value != 'custom' ) {
                            preview.find('img').attr('src', '<?php echo get_template_directory_uri() . '/'; ?>'+value);
                            preview.show();
                        } else {
                            preview.hide(); 
                        }
                    };
                    
                    select.change(change_preview).keypress(change_preview);
                    
                    preview.find('img').click(function(){
                        $(this).toggleClass('min');
                        if ( $(this).hasClass('min') )
                            $(this).attr('title', '<?php _e( 'Click to expand the image to the natural size', 'yiw' ) ?>');
                        else
                            $(this).attr('title', '<?php _e( 'Click to minimize the image', 'yiw' ) ?>');
                    });
                });
            </script>
        </div>  
         
    <?php       
}
add_action( 'yiw_panel_type_header_preview', 'yiw_select_with_header_preview' );

// add new type to theme options
function yiw_select_with_bg_preview( $value ) {
    
    if ( isset( $value['id'] ) )
        $id_container = 'id="' . $value['id'] . '-option" ';            
        
    // deps                   
    if ( isset( $value['deps'] ) ) {
        $value['deps']['id_input'] = yiw_option_id( $value['deps']['id'], false );
        $deps[ $value['id'] ] = $value['deps'];
        $class_dep = ' yiw-deps';
        $fade_color_dep = '<div class="fade_color"></div>';
    }
    ?>
    
        <div <?php echo $id_container ?>class="rm_option rm_input rm_select<?php echo $class_dep ?> rm_with_preview rm_with_bg_preview">
            <label for="<?php yiw_option_id( $value['id'] ); ?>"><?php echo $value['name']; ?></label>
            
            <select name="<?php yiw_option_name( $value['id'] ); ?>" id="<?php yiw_option_id( $value['id'] ); ?>" <?php if( isset( $value['button'] ) ) : ?>style="width:240px;" <?php endif ?>>
                <?php foreach ($value['options'] as $val => $option) { ?>
    <option value="<?php echo $val ?>" <?php selected( yiw_get_option( $value['id'], $value['std'] ), $val ) ?>><?php echo $option; ?></option>
                <?php } ?>
            </select>          
            
            <?php if( isset( $value['button'] ) ) : ?>
            <input type="submit" value="<?php echo $value['button']; ?>" class="button" name="<?php yiw_option_id( $value['id'] ); ?>_save" id="<?php yiw_option_id( $value['id'] ); ?>_save">
            <?php endif ?>
            
            <small><?php echo $value['desc']; ?></small>
            <div class="clearfix"></div>
            
            <?php 
                $url = get_template_directory_uri().'/'.yiw_get_option( $value['id'], $value['std'] );
                $color = yiw_get_option( $value['id_colors'] );
                
                $style = array(
                    "background-color:$color;",
                    "background-image:url('$url');",
                    "background-position:top center;"
                );
                $style = implode( '', $style );
                
                $style_preview = ( yiw_get_option( $value['id'], $value['std'] ) == 'custom' ) ? ' style="display:none"' : '';
            ?>
            
            <div class="preview"<?php echo $style_preview ?>><div class="img" style="<?php echo $style ?>"></div></div>
            <script type="text/javascript">
                jQuery(document).ready(function($){
                    var select = $('#<?php yiw_option_id( $value['id'] ); ?>');
                    var text_color = $('#<?php yiw_option_id( $value['id_colors'] ); ?>');
                    var preview = $('#<?php echo $value['id'] ?>-option .preview');
                    
                    preview.css('cursor', 'pointer').attr('title', '<?php _e( 'Click here to update the color selected above', 'yiw' ) ?>');
                    
                    select.change(function(){
                        var value = $(this).val();
                        if ( value != 'custom' ) {
                            $('.img', preview).css({'background-image':'url(<?php echo get_template_directory_uri() . '/'; ?>'+value+')'});
                            preview.show();
                        } else {
                            preview.hide(); 
                        }
                    });
                    
                    preview.click(function(){ 
                        var value = text_color.val();
                        $('.img', preview).css({'background-color':value});
                    });
                });
            </script>
        </div>  
         
    <?php       
}
add_action( 'yiw_panel_type_bg_preview', 'yiw_select_with_bg_preview' );
?>