<?php        
/**
 * @package WordPress
 * @subpackage Impero
 * @since 1.0
 */
 
/*
Template Name: Home
*/



if( ( is_home() || is_front_page() ) && get_option( 'show_on_front' ) == 'posts' || is_home() && get_option( 'page_for_posts' ) != '0' ) {
    $blog_type = yiw_get_option('blog_type');
    get_template_part( 'blog' ); 
    die;
}

get_header() ?>  
        
        <div class="layout-<?php echo $layout_page_type = yiw_layout_page() ?>">
            <?php if( get_post_meta( get_the_ID(), '_slogan_page', true ) ): ?>
            <div id="slogan">
                <h1><?php echo get_post_meta( get_the_ID(), '_slogan_page', true ); ?></h1>
                <h3><?php echo get_post_meta( get_the_ID(), '_subslogan_page', true ); ?></h3>
            </div>
            <?php endif ?>
        
            <!-- START CONTENT -->
            <div id="content" class="group">
                <?php 
                    if ( is_home() )
                        get_template_part( 'loop', 'index' ); 
                    else
                        get_template_part( 'loop', 'page' ); 
                ?>

                <!-- blog -->
                <?php if( yiw_get_option('blog_show_home_page') ): ?>
                <?php get_template_part( 'home', 'blog' ); ?>
                <?php endif ?>
                <!-- /blog -->
                
                <!-- services -->
                <?php if( yiw_get_option('services_show_home_page') ): ?>
                <?php get_template_part( 'home', 'services' ); ?>
                <?php endif ?>
                <!-- /services -->

                <!-- portfolio -->
                <?php if( yiw_get_option('portfolio_show_home_page') ): ?>
                <?php get_template_part( 'home', 'portfolio' ); ?>
                <?php endif ?>
                <!-- /portfolio -->

                <!-- gallery -->
                <?php if( yiw_get_option('gallery_show_home_page') ): ?>
                <?php get_template_part( 'home', 'gallery' ); ?>
                <?php endif ?>
                <!-- /services -->

            </div>
            <!-- END CONTENT -->
            
            <!-- START LATEST NEWS -->
            <?php get_sidebar() ?>
            <!-- END LATEST NEWS -->   
        
        </div>      
        
<?php get_footer() ?>
