/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright (c) 2010, Yanone (http://yanone.de/typedesign/). All rights reserved.
 * This Font Software is licensed under the SIL Open Font License, Version 1.1.
 * This license is available with a FAQ at: http://scripts.sil.org/OFL
 * 
 * Trademark:
 * Yanone Kaffeesatz is a trademark of Yanone
 * 
 * Description:
 * Yanone Kaffeesatz was first published in 2004 and is Yanone's first ever
 * finished typeface. Its Bold is reminiscent of 1920s coffee house typography,
 * while the rather thin fonts bridge the gap to present times. Lacking self
 * confidence and knowledge about the type scene Yanone decided to publish the
 * family for free under a Creative Commons License. A decision that should turn
 * out one of the best he ever made. It has been downloaded over 100,000 times to
 * date from this website alone, and you can witness Kaffeesatz use on German
 * fresh-water gyms, Dubai mall promos and New Zealand McDonald's ads. And of
 * course on coffee and foodstuff packaging and cafe design around the globe. In
 * 2009 he reworked much of the typeface and it got published in FontShop's
 * FontFont Library under the new name FF Kava. You can read more about it in an
 * extensive article by Yves Peters on the FontFeed.
 * 
 * Manufacturer:
 * Yanone
 * 
 * Designer:
 * Yanone
 * 
 * Vendor URL:
 * http://yanone.de/typedesign/
 * 
 * License information:
 * http://scripts.sil.org/OFL
 */
Cufon.registerFont({"w":432,"face":{"font-family":"YanoneKaffeesatz","font-weight":300,"font-stretch":"normal","units-per-em":"1000","panose-1":"2 0 0 0 0 0 0 0 0 0","ascent":"800","descent":"-200","x-height":"10","bbox":"-122 -955 941 200.418","underline-thickness":"50","underline-position":"-19","unicode-range":"U+0020-U+FB04"},"glyphs":{" ":{"w":172},"\ufb01":{"d":"341,-13v1,22,-35,10,-56,13r0,-473v2,-33,19,-25,56,-27r0,487xm142,-13v-1,21,-35,10,-55,13r0,-452r-76,0v2,-20,-8,-48,16,-48r60,0r0,-63v-2,-121,52,-176,169,-176v61,0,123,10,95,69v-27,-13,-59,-19,-94,-19v-107,0,-122,78,-115,189r84,0v-2,22,6,48,-14,48r-70,0r0,439","w":397,"k":{"y":10,"x":4,"\u00ff":10,"\u00fd":10,"\/":-23}},"\ufb02":{"d":"141,-13v-1,22,-35,10,-55,13r0,-452r-76,0v2,-20,-8,-48,16,-48r60,0v-8,-139,20,-238,149,-238v46,0,85,11,115,28r0,697v-1,21,-35,10,-55,13r0,-682v-17,-6,-36,-8,-57,-9v-99,-5,-101,90,-97,191r100,0v-2,22,6,48,-14,48r-86,0r0,439","w":407},"#":{"d":"395,-245v-2,29,7,46,-14,46r-67,0r-4,79v-5,18,-22,11,-51,13r5,-92r-113,0r-4,79v-5,18,-22,11,-50,13r5,-92r-64,0v2,-28,-6,-46,13,-46r53,0r7,-124r-73,0v2,-28,-6,-46,13,-46r62,0r4,-72v5,-19,21,-11,50,-13r-5,85r113,0r4,-72v5,-18,22,-11,51,-13r-5,85r70,0v-2,29,7,46,-14,46r-58,0r-7,124r79,0xm153,-245r113,0r7,-124r-113,0"},"$":{"d":"367,-154v-1,94,-46,147,-132,158r0,94v-2,24,-20,23,-49,24r0,-115v-52,-3,-102,-9,-120,-42v2,-16,9,-33,18,-43v25,19,60,31,111,31v99,0,141,-90,99,-167v-45,-82,-162,-142,-210,-225v-50,-87,21,-176,117,-176r0,-97v1,-26,21,-24,50,-25r0,121v51,1,89,14,107,32v-1,13,-7,33,-16,40v-53,-32,-219,-44,-215,48v2,41,27,62,52,88v56,57,137,110,173,181v11,21,15,46,15,73"},"%":{"d":"197,-340v-112,4,-136,-69,-136,-184v0,-115,40,-181,141,-184v108,-3,133,73,133,183v1,112,-39,182,-138,185xm202,-663v-69,0,-88,54,-88,143v1,77,8,136,82,136v67,0,88,-58,87,-141v-1,-77,-7,-138,-81,-138xm513,8v-112,4,-136,-69,-136,-184v0,-115,40,-181,141,-184v108,-3,133,73,133,183v1,112,-39,182,-138,185xm518,-314v-70,0,-89,54,-89,143v1,77,9,139,83,136v66,-2,88,-58,87,-141v-1,-77,-7,-138,-81,-138xm546,-708v30,13,39,14,14,56r-401,660v-15,-3,-31,-8,-34,-22","w":712},"&":{"d":"380,-456v66,65,69,246,26,343v27,30,56,60,84,78v-5,20,-15,40,-35,44v-26,-11,-53,-43,-79,-70v-33,41,-81,71,-157,71v-123,0,-183,-63,-183,-182v0,-93,54,-148,115,-185v-36,-64,-82,-132,-82,-211v0,-100,68,-137,167,-138v43,0,77,7,104,15v48,15,45,37,27,68v-69,-48,-254,-62,-240,62v13,117,95,211,155,297v27,38,56,73,83,105v39,-123,10,-285,-67,-338v60,-9,129,-7,193,-4v6,27,1,47,-39,46xm93,-169v2,79,39,127,123,127v61,0,96,-27,122,-61v-54,-63,-114,-140,-161,-213v-45,27,-85,74,-84,147","w":513},"'":{"d":"35,-754v-8,-47,23,-27,57,-30v1,63,-5,146,-16,199v-7,2,-21,0,-31,1","w":128,"k":{"z":70,"y":73,"x":65,"w":68,"v":67,"u":76,"t":21,"s":96,"p":104,"o":92,"n":99,"g":112,"f":42,"e":100,"d":118,"c":102,"a":74,"]":-20,"[":78,"Y":-20,"W":-13,"V":-13,"T":-16,"O":20,"J":125,"G":34,"C":47,"A":115,")":-20,"(":78,"\ufb04":42,"\ufb03":42,"\ufb02":42,"\ufb01":42,"\ufb00":42,"\u20ac":112,"\u017e":70,"\u017d":8,"\u0178":-20,"\u0161":96,"\u0160":13,"\u0153":92,"\u0152":20,"\u00ff":73,"\u00fd":73,"\u00fc":76,"\u00fb":76,"\u00fa":76,"\u00f9":76,"\u00f8":92,"\u00f6":92,"\u00f5":92,"\u00f4":92,"\u00f3":92,"\u00f2":92,"\u00f1":99,"\u00ef":-45,"\u00ee":-43,"\u00ec":-50,"\u00eb":100,"\u00ea":100,"\u00e9":100,"\u00e8":100,"\u00e7":102,"\u00e6":74,"\u00e5":74,"\u00e4":74,"\u00e3":74,"\u00e2":74,"\u00e1":74,"\u00e0":74,"\u00dd":-20,"\u00dc":13,"\u00db":13,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00d1":9,"\u00cf":-10,"\u00ce":-37,"\u00cb":8,"\u00ca":3,"\u00c7":47,"\u00c6":115,"\u00c5":115,"\u00c4":115,"\u00c3":115,"\u00c2":115,"\u00c1":115,"\u00c0":115,"\u00bf":99,"\u00a2":30,"r":99,"q":118,"m":99,"\\":-34,"Q":20,"@":73,"?":-20,"9":39,"6":32,"4":94,"3":7,"2":15,"1":39,"0":46,"\/":105,"+":39}},"(":{"d":"271,-769v-84,104,-147,250,-146,445v0,205,59,371,146,482v-6,27,-22,56,-49,26v-158,-173,-207,-630,-72,-870v27,-48,54,-92,91,-119v21,1,24,16,30,36","w":294,"k":{"\ufb02":14,"\ufb01":14,"\ufb00":27,"\u20ac":67,"\u2044":39,"\u2039":24,"\u2019":-20,"\u2018":-20,"\u2014":43,"\u2013":43,"\u017e":28,"\u0153":37,"\u0152":20,"\u00ff":-13,"\u00fd":-13,"\u00fc":40,"\u00fb":40,"\u00fa":40,"\u00f9":40,"\u00f8":37,"\u00f6":37,"\u00f5":37,"\u00f4":37,"\u00f3":37,"\u00f2":37,"\u00f1":33,"\u00ef":-7,"\u00ed":23,"\u00ec":-23,"\u00eb":30,"\u00ea":30,"\u00e9":30,"\u00e8":30,"\u00e7":30,"\u00e6":27,"\u00e4":27,"\u00e3":27,"\u00e2":27,"\u00e1":27,"\u00e0":27,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00cf":-19,"\u00ce":-55,"\u00c7":24,"\u00c6":27,"\u00c5":27,"\u00c4":27,"\u00c3":27,"\u00c2":27,"\u00c1":27,"\u00c0":27,"\u00a2":60,"r":33,"q":30,"m":33,"]":-57,"\\":-31,"[":59,"Q":20,"\/":12,"+":62,"*":21,"'":-20,"C":24,"G":20,"d":30,"t":17,"u":40,"v":39,"w":43,"y":-13,"c":30,"e":30,"o":37,"\"":-20,"-":43,"\u2212":43,"\u201c":-20,"\u201d":-20,"\u00ab":24,"O":20,"A":27,"x":22,"a":27,"\u00e5":27,"z":28,"Z":17,"\u017d":17,"n":33,"j":-131}},")":{"d":"23,158v86,-112,146,-275,146,-482v0,-195,-61,-341,-146,-445v6,-28,21,-47,47,-23v170,161,199,613,76,855v-27,55,-52,105,-92,135v-20,-1,-26,-21,-31,-40","w":294,"k":{"\u2019":74,"\u2018":74,"'":74,"\"":74,"\u201c":74,"\u201d":74}},"*":{"d":"250,-511v-2,13,-9,16,-27,12r-16,-171v3,-24,43,-13,58,-6xm433,-565v14,8,32,51,8,58r-166,48v-11,-15,-11,-25,2,-32xm201,-484v1,14,-3,26,-18,21r-162,-50v-1,-27,13,-53,40,-48xm248,-412v-6,-16,3,-17,17,-23r112,144v12,23,-20,36,-42,41xm194,-427v9,-9,18,-7,28,6r-97,156v-20,20,-42,-13,-50,-29","w":472,"k":{"\u0153":10,"\u0152":13,"\u00f8":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f3":10,"\u00f2":10,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00d8":13,"\u00d6":13,"\u00d5":13,"\u00d4":13,"\u00d3":13,"\u00d2":13,"o":10,"g":30,"e":20,"d":20,"c":20,"Z":33,"X":13,"T":13,"Q":13,"O":13,"]":21,"J":133,"A":49,")":21,"\u20ac":26,"\u017d":41,"\u00e7":24,"\u00c6":122,"\u00c5":49,"\u00c4":49,"\u00c3":49,"\u00c2":49,"\u00c1":49,"\u00c0":49,"q":10,"4":29,"\/":47}},"+":{"d":"392,-307v-2,29,6,50,-14,50r-136,0r0,137v-4,19,-22,11,-50,13r0,-150r-150,0v2,-28,-5,-46,13,-50r137,0r0,-136v3,-20,22,-12,50,-14r0,150r150,0","k":{"\"":39,"\u201d":39,"\u201c":39,"]":59,")":59,"\u2019":39,"\u2018":39,"'":39}},",":{"d":"45,90v19,-32,27,-52,30,-93v-33,-17,-24,-83,19,-81v29,2,42,15,41,47v-3,60,-29,121,-67,145v-12,0,-21,-7,-23,-18","w":180,"k":{"\u00f8":20,"y":56,"w":40,"v":44,"u":27,"t":49,"o":20,"j":-53,"f":40,"e":20,"d":20,"c":13,"Y":54,"W":30,"V":48,"U":4,"T":86,"O":36,"G":11,"C":34,"\ufb04":40,"\ufb03":40,"\ufb02":40,"\ufb01":40,"\ufb00":40,"\u0178":54,"\u0153":20,"\u0152":36,"\u00ff":56,"\u00fd":56,"\u00fc":27,"\u00fb":27,"\u00fa":27,"\u00f9":27,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":13,"\u00dd":54,"\u00dc":4,"\u00db":4,"\u00da":4,"\u00d9":4,"\u00d8":36,"\u00d6":36,"\u00d5":36,"\u00d4":36,"\u00d3":36,"\u00d2":36,"\u00c7":34,"q":20,"\\":123,"Q":36,"\/":-13}},"-":{"d":"247,-307v-2,29,6,50,-14,50r-190,0v2,-28,-5,-46,13,-50r191,0","w":290,"k":{"\ufb04":34,"\ufb03":34,"\ufb02":34,"\ufb01":34,"\ufb00":34,"\u017e":84,"\u017d":46,"\u0178":67,"\u0160":107,"\u00ff":39,"\u00fd":39,"\u00dd":67,"\u00c6":36,"\u00c5":36,"\u00c4":36,"\u00c3":36,"\u00c2":36,"\u00c1":36,"\u00c0":36,"\\":81,"T":108,"V":43,"W":34,"Y":67,"f":34,"t":34,"v":28,"w":25,"y":39,")":39,"]":39,"A":36,"J":120,"X":67,"x":90,"S":107,"z":84,"\u00bb":55,"\u203a":55,"Z":46}},".":{"d":"91,5v-30,0,-42,-16,-42,-45v0,-24,16,-45,42,-45v30,0,44,17,44,45v0,25,-18,45,-44,45","w":180,"k":{"\ufb04":40,"\ufb03":40,"\ufb02":40,"\ufb01":40,"\ufb00":40,"\u0178":54,"\u0153":20,"\u0152":36,"\u00ff":56,"\u00fd":56,"\u00fc":27,"\u00fb":27,"\u00fa":27,"\u00f9":27,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":13,"\u00dd":54,"\u00dc":4,"\u00db":4,"\u00da":4,"\u00d9":4,"\u00d8":36,"\u00d6":36,"\u00d5":36,"\u00d4":36,"\u00d3":36,"\u00d2":36,"\u00c7":34,"q":20,"\\":123,"Q":36,"\/":-13,"C":34,"G":11,"T":86,"V":48,"W":30,"Y":54,"d":20,"f":40,"t":49,"u":27,"v":44,"w":40,"y":56,"c":13,"e":20,"o":20,"\u00f8":20,"O":36,"U":4}},"\/":{"d":"72,5v-4,21,-37,13,-62,15r230,-778v12,-10,32,-6,57,-7","w":307,"k":{"\"":-38,"\u201e":177,"\u201d":-38,"\u201c":-38,"\u017f":21,"\u00ff":24,"\u00df":21,"\u00d3":26,"\u00bb":39,"\u00ab":62,"z":36,"y":24,"x":42,"w":18,"v":8,"u":39,"t":16,"s":53,"p":47,"o":55,"n":45,"j":6,"i":3,"g":52,"f":8,"e":58,"d":66,"c":63,"a":32,"Z":25,"Y":-25,"X":8,"W":-31,"V":-20,"T":-31,"O":26,"J":63,"G":28,"C":39,"A":65,":":50,".":164,")":-41,"\ufb02":14,"\ufb01":8,"\ufb00":8,"\u2212":29,"\u20ac":49,"\u203a":55,"\u2039":65,"\u2026":177,"\u2022":52,"\u201a":177,"\u2019":-54,"\u2018":-38,"\u2014":16,"\u2013":57,"\u017e":10,"\u017d":18,"\u0178":-31,"\u0161":37,"\u0160":11,"\u0153":57,"\u0152":21,"\u0131":55,"\u00fd":8,"\u00fc":37,"\u00fb":42,"\u00fa":49,"\u00f9":52,"\u00f8":75,"\u00f7":57,"\u00f6":49,"\u00f5":51,"\u00f4":47,"\u00f3":49,"\u00f2":52,"\u00f1":20,"\u00ef":-43,"\u00ee":-20,"\u00ed":8,"\u00ec":-49,"\u00eb":44,"\u00ea":50,"\u00e9":45,"\u00e8":54,"\u00e7":68,"\u00e6":49,"\u00e5":41,"\u00e4":29,"\u00e3":8,"\u00e2":34,"\u00e1":47,"\u00e0":34,"\u00dd":-25,"\u00dc":-5,"\u00d8":22,"\u00d7":65,"\u00d6":10,"\u00d5":27,"\u00d4":16,"\u00d2":15,"\u00d1":13,"\u00cf":-16,"\u00ce":-14,"\u00cb":8,"\u00ca":13,"\u00c7":29,"\u00c6":148,"\u00c5":65,"\u00c4":63,"\u00c3":65,"\u00c2":63,"\u00c1":74,"\u00c0":60,"\u00bf":45,"\u00b7":52,"\u00a2":78,"\u00a1":19,"r":45,"q":61,"m":45,"_":141,"]":-6,"\\":-26,"[":56,"Q":10,"B":10,"@":32,"?":-32,"=":62,";":52,"9":39,"8":23,"7":13,"6":33,"5":23,"4":78,"3":34,"2":29,"1":37,"0":45,"\/":118,",":164,"'":-38,"%":34}},"0":{"d":"214,8v-154,0,-178,-127,-178,-304v0,-172,33,-304,185,-304v150,0,175,121,175,291v0,179,-24,317,-182,317xm224,-550v-116,0,-129,125,-129,261v0,89,11,151,28,190v35,80,155,73,188,-9v29,-72,37,-307,4,-383v-17,-39,-46,-59,-91,-59","k":{"\"":42,"\u201d":42,"\u201c":42,"\u0178":39,"\u00dd":39,"Y":39,"X":31,"W":26,"V":25,"T":65,"J":23,"\u2019":42,"\u2018":42,"_":60,"]":75,"\\":34,"'":42}},"1":{"d":"208,-543v-42,5,-87,15,-130,24v-6,-7,-8,-27,-8,-40v46,-21,121,-33,179,-42v6,0,13,2,16,4r-12,545r109,0r34,-3v-1,21,3,50,-9,55r-350,0r-1,-41v34,-13,113,-9,158,-11","k":{"\"":91,"\u201d":91,"\u201c":91,"\u2019":91,"\u2018":91,"\/":-5,"*":67,"'":91}},"2":{"d":"315,-465v0,-127,-193,-81,-250,-43v-6,-19,-16,-46,5,-58v39,-21,98,-33,162,-34v97,-1,146,36,144,131v-2,92,-50,151,-96,209v-54,68,-124,131,-171,208r185,0r102,-4v-1,22,3,50,-10,56r-346,0v-13,-31,8,-58,20,-76v63,-105,167,-186,228,-292v18,-31,27,-63,27,-97","k":{"\"":21,"\u201d":21,"\u201c":21,"\u2019":21,"\u2018":21,"\/":-15,"'":21}},"3":{"d":"362,-484v0,93,-64,138,-120,181v86,10,143,53,143,150v0,152,-77,248,-225,253v-72,2,-131,-20,-104,-87v27,22,57,34,106,34v112,0,162,-87,164,-200v2,-93,-74,-113,-164,-115r-1,-37v68,-40,137,-83,140,-167v5,-114,-191,-77,-244,-35v-5,-19,-14,-47,5,-59v37,-24,96,-34,161,-34v87,-1,139,34,139,116","k":{"\"":34,"\u201d":34,"\u201c":34,"\u2019":34,"\u2018":34,"_":26,"\/":-10,"'":34}},"4":{"d":"209,-538v26,-32,50,-82,107,-59r-3,391r86,-2v3,16,5,55,-16,54r-70,0r-1,146v-8,13,-30,6,-54,8r0,-154r-205,0v-35,-46,2,-109,21,-153v34,-81,82,-166,135,-231xm258,-206r9,-323v-73,85,-146,197,-179,323r170,0","k":{"\"":33,"\u201d":33,"\u201c":33,"\u2019":33,"\u2018":33,"*":29,"'":33}},"5":{"d":"329,-187v6,-149,-154,-174,-281,-136r28,-277r306,0v15,84,-83,49,-151,49v-32,0,-68,0,-107,-1r-19,173v148,-28,287,23,282,185v-6,174,-58,292,-231,294v-56,1,-104,-14,-117,-40v0,-19,2,-31,7,-46v25,23,61,34,108,34v133,-2,170,-103,175,-235","k":{"_":16}},"6":{"d":"372,-632v-46,-18,-123,-29,-170,0v-78,49,-105,156,-111,285v33,-61,85,-91,156,-91v110,0,151,80,151,194v0,152,-49,252,-190,253v-160,1,-170,-145,-170,-306v0,-181,32,-321,141,-383v51,-29,138,-27,189,-4v17,8,6,35,4,52xm344,-231v0,-93,-30,-155,-112,-155v-59,0,-106,33,-141,99v1,121,3,245,119,245v94,0,134,-88,134,-189","k":{"\"":-5,"\u201d":-5,"\u201c":-5,"\u2019":-5,"\u2018":-5,"_":34,"'":-5}},"7":{"d":"330,-551r-261,2v-17,-2,-16,-30,-17,-51r360,0v-121,197,-223,417,-272,685v-24,-1,-52,2,-56,-14v48,-237,134,-454,246,-622","k":{"\u00c6":81,"q":64,"g":72,"e":47,"d":64,"a":41,"]":23,"X":23,"J":100,"A":81,";":54,":":54,")":23,"\u017e":41,"\u017d":81,"\u0161":41,"\u0160":81,"\u00ff":41,"\u00fc":41,"\u00fb":41,"\u00f6":41,"\u00f5":41,"\u00f4":41,"\u00f1":41,"\u00ef":41,"\u00ee":41,"\u00eb":47,"\u00ea":47,"\u00e9":47,"\u00e8":47,"\u00e6":41,"\u00e5":41,"\u00e4":41,"\u00e3":41,"\u00e2":41,"\u00e1":41,"\u00e0":41,"\u00dc":81,"\u00db":81,"\u00d6":81,"\u00d5":81,"\u00d4":81,"\u00d1":81,"\u00cb":81,"\u00ca":81,"\u00c5":81,"\u00c4":81,"\u00c3":81,"\u00c2":81,"\u00c1":81,"\u00c0":81,"_":189,"@":39,"\/":57}},"8":{"d":"60,-473v-45,-122,30,-237,159,-233v108,3,175,48,174,161v-1,94,-62,136,-120,173v66,44,127,85,127,191v0,112,-59,190,-174,189v-124,-1,-186,-69,-186,-189v0,-100,58,-159,126,-196v-41,-26,-89,-50,-106,-96xm223,-44v108,0,155,-126,106,-210v-25,-43,-65,-69,-110,-94v-66,28,-127,75,-127,164v0,83,46,140,131,140xm341,-543v2,-76,-45,-105,-117,-111v-124,-10,-163,153,-68,212r68,42v56,-29,115,-64,117,-143","k":{"_":24}},"9":{"d":"64,42v52,14,121,12,162,-12v82,-48,109,-153,116,-280v-30,54,-73,91,-152,91v-109,0,-154,-83,-154,-197v0,-156,47,-251,190,-254v164,-2,170,142,170,305v0,139,-22,243,-64,309v-42,66,-104,99,-188,99v-49,0,-103,-2,-80,-61xm90,-365v0,93,35,154,115,154v68,0,112,-46,139,-101v-3,-120,0,-247,-117,-247v-101,0,-137,79,-137,194","k":{"\"":23,"\u201d":23,"\u201c":23,"\u2019":23,"\u2018":23,"_":14,"'":23}},":":{"d":"91,-341v-30,0,-42,-17,-42,-45v0,-24,16,-45,42,-45v30,0,44,17,44,45v0,25,-18,45,-44,45xm91,5v-30,0,-42,-16,-42,-45v0,-24,16,-45,42,-45v30,0,44,17,44,45v0,25,-18,45,-44,45","w":180,"k":{"\/":-15,"T":55,"V":10}},";":{"d":"92,-341v-30,0,-42,-17,-42,-45v0,-24,16,-45,42,-45v30,0,44,17,44,45v0,25,-18,45,-44,45xm42,90v19,-32,27,-52,30,-93v-33,-17,-24,-84,20,-81v28,2,42,15,41,47v-3,60,-30,120,-68,145v-12,0,-21,-7,-23,-18","w":180,"k":{"j":-85,"T":55,"\/":-20,"V":10}},"=":{"d":"392,-394v-2,29,6,50,-14,50r-336,0v2,-28,-5,-46,13,-50r337,0xm392,-220v-2,29,6,50,-14,50r-336,0v2,-28,-5,-46,13,-50r337,0","k":{"\/":-10}},"?":{"d":"129,5v-30,0,-42,-16,-42,-45v0,-24,16,-45,42,-45v30,0,44,17,44,45v0,25,-18,45,-44,45xm128,-655v-40,-1,-75,13,-96,30v-4,-15,-15,-47,3,-58v26,-16,65,-27,108,-27v90,1,140,48,140,142v0,133,-97,178,-132,276v-10,30,2,66,2,89v-6,10,-36,8,-50,6v-7,-16,-11,-36,-11,-61v4,-136,128,-166,132,-301v2,-66,-34,-96,-96,-96","w":295,"k":{"\"":-26,"\u201d":-26,"\u201c":-26,"\u00c6":57,"J":14,"A":57,"\u2019":-26,"\u2018":-26,"\u017d":57,"\u0160":57,"\u00dc":57,"\u00db":57,"\u00d6":57,"\u00d5":57,"\u00d4":57,"\u00d1":57,"\u00cb":57,"\u00ca":57,"\u00c5":57,"\u00c4":57,"\u00c3":57,"\u00c2":57,"\u00c1":57,"\u00c0":57,"'":-26}},"@":{"d":"394,-493v80,2,116,32,113,118r-11,312v86,40,122,-48,139,-129v9,-38,13,-89,13,-152v0,-187,-59,-293,-245,-291v-223,2,-296,147,-295,377v0,240,42,394,275,394v103,0,171,-23,234,-52v9,18,28,45,-2,60v-115,57,-378,70,-463,-25v-74,-83,-99,-216,-99,-383v0,-261,100,-418,351,-421v213,-3,301,115,299,331v-2,151,-18,271,-99,334v-34,26,-99,22,-124,-7v-24,14,-64,26,-111,26v-96,0,-126,-51,-126,-151v0,-128,91,-182,211,-152v7,-80,4,-146,-78,-141v-47,3,-76,7,-107,24v-6,-14,-11,-40,3,-48v28,-17,69,-24,122,-24xm453,-267v-67,-14,-134,1,-149,57v-14,54,-16,151,38,162v41,8,103,-1,105,-40","w":754,"k":{"\"":39,"\u201d":39,"\u201c":39,"\u0178":8,"\u00dd":8,"x":15,"j":-67,"Y":8,"X":6,"V":17,"T":33,"J":19,"\u2019":39,"\u2018":39,"7":6,"\/":-10,"'":39}},"A":{"d":"322,-193r-208,0r-46,182v-3,20,-38,11,-61,10r189,-694v0,-12,34,-10,43,-6r189,688v5,22,-32,12,-56,13xm127,-244r181,0r-76,-299r-14,-82r-28,137","w":436,"k":{"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2019":104,"\u2018":104,"\u2014":43,"\u2013":43,"\u0178":74,"\u0161":10,"\u0153":26,"\u0152":21,"\u00ff":48,"\u00fd":48,"\u00fc":18,"\u00fb":18,"\u00fa":18,"\u00f9":18,"\u00f6":26,"\u00f5":26,"\u00f4":26,"\u00f3":26,"\u00f2":26,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"q":16,"\\":63,"Q":21,"7":11,"\/":-36,"*":58,"'":104}},"B":{"d":"369,-239v0,146,-60,233,-192,239r-122,0r0,-683v1,-14,7,-17,25,-17v147,-7,270,6,267,152v-2,87,-30,147,-98,162v77,8,120,57,120,147xm288,-538v-1,-74,-35,-113,-107,-113r-71,0r0,246r75,0v69,-3,104,-48,103,-133xm306,-234v2,-91,-39,-127,-129,-123r-67,0r0,307r67,0v97,-5,127,-79,129,-184","w":392,"k":{"\u2026":23,"\u201a":23,"\u2019":8,"\u2018":8,"\u017e":20,"\u017d":8,"\u0178":8,"\u0160":8,"\u00ff":23,"\u00fd":23,"\u00f6":15,"\u00f5":15,"\u00f4":15,"\u00f3":15,"\u00f2":15,"\u00e7":10,"\u00dd":8,"\u00dc":8,"\u00db":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":22,",":23,"'":8,"T":15,"V":8,"Y":8,"t":21,"v":16,"w":14,"y":23,"\"":8,"\u201c":8,"\u201d":8,")":13,"]":13,"A":8,".":23,"J":11,"X":31,"x":39,"\u201e":23}},"C":{"d":"319,-96v40,84,-86,123,-174,96v-54,-16,-79,-67,-91,-138v-31,-189,-30,-501,112,-558v69,-27,194,-6,150,72v-26,-26,-82,-43,-127,-20v-108,57,-105,308,-83,466v10,73,32,125,109,126v43,2,85,-23,104,-44","w":353,"k":{"\ufb04":27,"\ufb03":27,"\ufb02":27,"\ufb01":27,"\ufb00":27,"\u2039":31,"\u2026":-3,"\u201a":-3,"\u2019":-3,"\u2018":-3,"\u2014":85,"\u2013":85,"\u017e":7,"\u0161":13,"\u0160":10,"\u0153":23,"\u0152":26,"\u00ff":71,"\u00fd":71,"\u00fc":21,"\u00fb":21,"\u00fa":21,"\u00f9":21,"\u00f6":23,"\u00f5":23,"\u00f4":23,"\u00f3":23,"\u00f2":23,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":21,"\u00ea":21,"\u00e9":21,"\u00e8":21,"\u00e7":13,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"\u00d8":26,"\u00d6":26,"\u00d5":26,"\u00d4":26,"\u00d3":26,"\u00d2":26,"\u00c7":6,"q":13,"Q":26,"@":10,"0":28,"\/":-21,",":-3,"*":20,"'":-3,"C":6,"G":18,"d":13,"f":27,"t":20,"u":21,"v":67,"w":61,"y":71,"c":13,"e":21,"o":23,"\u00f8":23,"\"":-3,"-":85,"\u2212":85,"\u201c":-3,"\u201d":-3,"\u00ab":31,"O":26,".":-3,"x":17,"\u201e":-3,"S":10,"a":13,"z":7}},"D":{"d":"56,-683v1,-14,8,-17,25,-17r100,0v166,3,193,139,194,313v1,134,-17,235,-57,312v-42,81,-143,77,-262,75r0,-683xm315,-391v-2,-135,-10,-252,-135,-258r-69,0r0,596v77,2,135,3,162,-58v31,-70,43,-159,42,-280","w":414,"k":{"\u2026":41,"\u201a":41,"\u2019":37,"\u2018":37,"\u017e":3,"\u017d":34,"\u0178":26,"\u0161":3,"\u0160":34,"\u0153":10,"\u00ff":3,"\u00fc":3,"\u00fb":3,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f3":10,"\u00f2":10,"\u00f1":3,"\u00ef":3,"\u00ee":3,"\u00eb":3,"\u00ea":3,"\u00e6":3,"\u00e5":3,"\u00e4":3,"\u00e3":3,"\u00e2":3,"\u00e1":3,"\u00e0":3,"\u00dd":26,"\u00dc":34,"\u00db":34,"\u00d6":34,"\u00d5":34,"\u00d4":34,"\u00d1":34,"\u00cb":34,"\u00ca":34,"\u00c6":34,"\u00c5":34,"\u00c4":34,"\u00c3":34,"\u00c2":34,"\u00c1":34,"\u00c0":34,"q":10,"_":75,",":41,"'":37,"T":28,"V":15,"W":21,"Y":26,"o":10,"\u00f8":10,"\"":37,"\u201c":37,"\u201d":37,")":20,"]":20,"A":34,".":41,"J":44,"x":13,"\u201e":41,"a":3}},"E":{"d":"287,-408v-2,31,6,46,-12,51r-164,0r0,306r197,0v-3,33,7,46,-12,51r-239,0r0,-686v1,-7,5,-14,13,-14r239,0v-3,32,7,45,-10,51r-188,0r0,241r176,0","w":337,"k":{"\u2019":-10,"\u2018":-10,"\u2014":33,"\u2013":33,"\u017e":7,"\u0161":13,"\u0153":20,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"r":4,"q":16,"0":10,"\/":-13,"'":-10,"d":16,"u":4,"w":17,"y":17,"c":10,"e":16,"o":20,"\u00f8":20,"\"":-10,"-":33,"\u2212":33,"\u201c":-10,"\u201d":-10,"x":13,"a":13,"z":7}},"F":{"d":"111,-13v1,23,-35,10,-54,13r0,-686v1,-7,5,-14,13,-14r239,0v-3,32,7,44,-10,49r-188,0r0,242r176,0v-2,31,6,46,-12,52r-164,0r0,344","w":327,"k":{"\u2039":29,"\u2026":135,"\u201a":135,"\u2019":-10,"\u2018":-10,"\u2014":33,"\u2013":33,"\u017e":17,"\u017d":68,"\u0161":16,"\u0160":68,"\u0153":31,"\u00ff":21,"\u00fd":21,"\u00fc":20,"\u00fb":20,"\u00fa":20,"\u00f9":20,"\u00f8":31,"\u00f6":31,"\u00f5":31,"\u00f4":31,"\u00f3":31,"\u00f2":31,"\u00f1":16,"\u00ef":16,"\u00ee":16,"\u00eb":26,"\u00ea":26,"\u00e9":26,"\u00e8":26,"\u00e7":19,"\u00e6":16,"\u00e5":16,"\u00e4":16,"\u00e3":16,"\u00e2":16,"\u00e1":16,"\u00e0":16,"\u00dc":68,"\u00db":68,"\u00d6":68,"\u00d5":68,"\u00d4":68,"\u00d1":68,"\u00cb":68,"\u00ca":68,"\u00c6":68,"\u00c5":68,"\u00c4":68,"\u00c3":68,"\u00c2":68,"\u00c1":68,"\u00c0":68,"r":14,"q":26,"_":148,"@":6,"0":15,"\/":39,",":135,"'":-10,"d":26,"t":13,"u":20,"v":15,"w":17,"y":21,"c":19,"e":26,"o":31,"\"":-10,"-":33,"\u2212":33,"\u201c":-10,"\u201d":-10,"\u00ab":29,"A":68,".":135,"J":104,"x":48,"\u201e":135,"a":16,"z":17,"g":21,"\u00bb":23,"\u203a":23}},"G":{"d":"359,-46v-36,48,-141,76,-215,42v-99,-45,-108,-177,-108,-335v0,-205,20,-366,211,-371v60,-1,129,21,97,80v-22,-16,-49,-28,-87,-27v-154,5,-163,150,-163,315v0,108,12,185,38,248v27,64,147,62,175,12r0,-269r-98,0v2,-19,-8,-47,15,-47r135,0r0,352","w":399,"k":{"\u0178":4,"\u00ff":15,"\u00fd":15,"\u00dd":4,"\/":-10,"Y":4,"v":13,"y":15,")":7,"]":7,"x":16}},"H":{"d":"377,-13v1,22,-34,10,-55,13r0,-355r-212,0r0,342v1,22,-34,10,-55,13r0,-686v-2,-23,35,-11,55,-14r0,293r212,0r0,-287v11,-9,31,-5,55,-6r0,687","k":{"\/":-10}},"I":{"d":"110,-13v1,22,-35,10,-56,13r1,-688v6,-17,30,-10,55,-12r0,687","w":165,"k":{"\/":-20}},"J":{"d":"115,-41v75,1,76,-69,77,-143r1,-504v6,-16,29,-10,54,-12r0,532v0,101,-23,178,-126,178v-66,0,-122,-32,-90,-87v18,19,47,36,84,36","w":302,"k":{"\u2026":25,"\u201a":25,"\u017d":23,"\u0160":23,"\u00dc":23,"\u00db":23,"\u00d6":23,"\u00d5":23,"\u00d4":23,"\u00d1":23,"\u00cb":23,"\u00ca":23,"\u00c6":23,"\u00c5":23,"\u00c4":23,"\u00c3":23,"\u00c2":23,"\u00c1":23,"\u00c0":23,"_":41,"\/":-10,",":25,")":7,"]":7,"A":23,".":25,"J":16,"x":10,"\u201e":25}},"K":{"d":"109,-13v1,22,-34,10,-55,13r0,-686v-2,-23,35,-11,55,-14r0,305r201,-302v20,-4,73,-8,56,16r-201,286v105,75,164,210,203,379v6,26,-32,15,-57,16v-44,-140,-77,-270,-177,-346v-8,-6,-16,-9,-25,-13r0,346","w":393,"k":{"\ufb04":32,"\ufb03":32,"\ufb02":32,"\ufb01":32,"\ufb00":32,"\u2039":16,"\u2019":-6,"\u2018":-6,"\u2014":43,"\u2013":43,"\u017e":16,"\u0161":16,"\u0153":20,"\u0152":21,"\u00ff":45,"\u00fd":45,"\u00fc":15,"\u00fb":15,"\u00fa":15,"\u00f9":15,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":16,"\u00ef":16,"\u00ee":16,"\u00eb":18,"\u00ea":18,"\u00e9":18,"\u00e8":18,"\u00e7":16,"\u00e6":16,"\u00e5":16,"\u00e4":16,"\u00e3":16,"\u00e2":16,"\u00e1":16,"\u00e0":16,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":19,"q":11,"Q":21,"\/":-25,"*":33,"'":-6,"C":19,"d":11,"f":32,"t":25,"u":15,"v":44,"w":39,"y":45,"c":16,"e":18,"o":20,"\u00f8":20,"\"":-6,"-":43,"\u2212":43,"\u201c":-6,"\u201d":-6,"\u00ab":16,"O":21,"J":5,"a":16}},"L":{"d":"309,-52v-3,19,9,52,-14,52r-240,0r1,-692v8,-13,31,-6,55,-8r0,648r198,0","w":329,"k":{"\ufb04":49,"\ufb03":49,"\ufb02":49,"\ufb01":49,"\ufb00":49,"\u2039":57,"\u2019":146,"\u2018":146,"\u2014":107,"\u2013":107,"\u017e":21,"\u0178":80,"\u0161":21,"\u0160":15,"\u0153":32,"\u0152":39,"\u00ff":52,"\u00fd":52,"\u00fc":20,"\u00fb":20,"\u00fa":20,"\u00f9":20,"\u00f6":32,"\u00f5":32,"\u00f4":32,"\u00f3":32,"\u00f2":32,"\u00f1":21,"\u00ef":21,"\u00ee":21,"\u00eb":29,"\u00ea":29,"\u00e9":29,"\u00e8":29,"\u00e7":23,"\u00e6":21,"\u00e5":21,"\u00e4":21,"\u00e3":21,"\u00e2":21,"\u00e1":21,"\u00e0":21,"\u00dd":80,"\u00d8":39,"\u00d6":39,"\u00d5":39,"\u00d4":39,"\u00d3":39,"\u00d2":39,"\u00c7":26,"r":14,"q":29,"Q":39,"?":37,"0":26,"\/":-16,"*":148,"'":146,"C":26,"G":34,"T":73,"V":80,"W":65,"Y":80,"d":29,"f":49,"t":36,"u":20,"v":36,"w":54,"y":52,"c":23,"e":29,"o":32,"\u00f8":32,"\"":146,"-":107,"\u2212":107,"\u201c":146,"\u201d":146,"\u00ab":57,"O":39,")":14,"]":14,"S":15,"a":21}},"M":{"d":"109,-13v1,21,-33,10,-54,13r0,-686v-1,-24,31,-11,50,-14r144,471r143,-467v9,-9,36,-2,52,-4r0,687v1,22,-35,10,-56,13r2,-289r9,-282r-75,250r-58,170v-3,14,-22,7,-37,9r-131,-425r10,271","w":498},"N":{"d":"346,-686v-2,-23,34,-11,55,-14r0,687v0,22,-32,10,-51,13r-152,-355r-93,-239r4,581v1,22,-34,10,-54,13r0,-686v-1,-23,33,-11,52,-14r244,592r-5,-341r0,-237","w":456},"O":{"d":"408,-356v0,190,-10,366,-189,366v-180,0,-181,-178,-181,-365v0,-186,17,-355,192,-355v175,0,178,171,178,354xm170,-638v-87,66,-77,287,-64,435v8,85,28,156,115,156v134,0,128,-163,128,-310v0,-122,-1,-231,-65,-281v-29,-23,-84,-23,-114,0","w":446,"k":{"\u2026":39,"\u201a":39,"\u2019":10,"\u2018":10,"\u017d":24,"\u0178":19,"\u0160":24,"\u0152":5,"\u00e7":10,"\u00dd":19,"\u00dc":24,"\u00db":24,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"_":50,",":39,"*":13,"'":10,"T":26,"V":5,"W":16,"Y":19,"c":10,"\"":10,"\u201c":10,"\u201d":10,"O":5,"Q":5,")":20,"]":20,"A":24,".":39,"J":31,"X":23,"x":22,"\u201e":39}},"P":{"d":"109,-13v1,22,-34,10,-54,13r0,-686v0,-9,4,-14,13,-14r104,0v124,-2,174,71,175,190v2,154,-74,228,-238,214r0,283xm287,-514v0,-82,-28,-136,-110,-136r-68,0r0,302v125,11,177,-25,178,-166","w":370,"k":{"\u2039":31,"\u2026":133,"\u201a":133,"\u2014":54,"\u2013":54,"\u017e":13,"\u017d":36,"\u0178":11,"\u0161":13,"\u0160":75,"\u0153":31,"\u00ff":13,"\u00fc":13,"\u00fb":13,"\u00f8":31,"\u00f6":31,"\u00f5":31,"\u00f4":31,"\u00f3":31,"\u00f2":31,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":24,"\u00ea":24,"\u00e9":24,"\u00e8":24,"\u00e7":25,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"\u00dd":11,"\u00dc":75,"\u00db":75,"\u00d6":75,"\u00d5":75,"\u00d4":75,"\u00d1":75,"\u00cb":75,"\u00ca":75,"\u00c6":75,"\u00c5":75,"\u00c4":75,"\u00c3":75,"\u00c2":75,"\u00c1":75,"\u00c0":75,"\u00b7":11,"q":31,"_":205,"@":24,"\/":46,",":133,"Y":11,"d":31,"c":25,"e":24,"o":31,"-":54,"\u2212":54,"\u00ab":31,")":30,"]":30,"A":75,".":133,"J":114,"X":49,"x":15,"\u201e":133,"a":13,"Z":36}},"Q":{"d":"403,100v-7,29,-49,34,-84,34v-75,0,-95,-51,-113,-124v-166,-13,-168,-182,-168,-365v0,-186,17,-355,192,-355v175,0,178,171,178,354v0,171,-11,322,-140,360v10,51,15,83,61,83v25,0,46,-6,65,-17v6,6,9,20,9,30xm170,-638v-87,66,-77,287,-64,435v8,85,28,156,115,156v134,0,128,-163,128,-310v0,-122,-1,-231,-65,-281v-29,-23,-84,-23,-114,0","w":446,"k":{"\"":10,"\u201e":35,"\u201d":10,"\u201c":10,"x":29,"]":13,"Y":27,"X":29,"V":16,"T":21,"J":31,"A":15,".":35,")":13,"\u2026":35,"\u201a":35,"\u2019":10,"\u2018":10,"\u017d":15,"\u0178":27,"\u0160":15,"\u00dd":27,"\u00dc":15,"\u00db":15,"\u00d6":15,"\u00d5":15,"\u00d4":15,"\u00d1":15,"\u00cb":15,"\u00ca":15,"\u00c6":57,"\u00c5":15,"\u00c4":15,"\u00c3":15,"\u00c2":15,"\u00c1":15,"\u00c0":15,"_":-14,",":35,"'":10}},"R":{"d":"109,-13v1,22,-34,10,-54,13r0,-686v1,-7,5,-14,13,-14r104,0v124,-2,174,71,175,190v1,106,-34,170,-103,201v53,72,90,173,101,294v2,24,-33,14,-58,15v-13,-123,-44,-222,-97,-297r-81,1r0,283xm287,-512v0,-83,-27,-138,-110,-138r-68,0r0,302v124,10,177,-25,178,-164","w":379,"k":{"\u2014":14,"\u2013":14,"\u0178":11,"\u0153":18,"\u0152":3,"\u00ff":13,"\u00fd":13,"\u00f6":18,"\u00f5":18,"\u00f4":18,"\u00f3":18,"\u00f2":18,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\u00dd":11,"\u00d8":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d3":3,"\u00d2":3,"\u00c7":5,"\u00c6":86,"q":8,"C":5,"T":16,"V":6,"W":5,"Y":11,"d":8,"y":13,"e":10,"o":18,"\u00f8":18,"-":14,"\u2212":14,"O":3,"Q":3,"X":3,"x":15}},"S":{"d":"52,-504v-55,-108,26,-212,151,-206v65,3,114,7,126,44v0,12,-5,23,-15,33v-57,-42,-225,-41,-221,57v2,50,28,77,55,108v55,64,142,129,176,207v11,26,15,55,15,88v-1,116,-56,183,-174,183v-61,0,-117,-9,-132,-53v0,-16,7,-30,16,-39v25,22,60,36,112,36v132,0,145,-155,83,-234v-58,-74,-149,-140,-192,-224","w":369,"k":{"\ufb04":30,"\ufb03":30,"\ufb02":30,"\ufb01":30,"\ufb00":30,"\u2019":-8,"\u2018":-8,"\u00ff":36,"\u00fd":36,"\u00c6":42,"_":11,"'":-8,"f":30,"v":34,"w":33,"y":36,"\"":-8,"\u201c":-8,"\u201d":-8,"J":6,"x":21}},"T":{"d":"209,-13v1,22,-34,10,-55,13r0,-648r-147,0v2,-19,-8,-52,13,-52r340,0v-3,19,9,52,-13,52r-138,0r0,635","w":367,"k":{"\ufb04":42,"\ufb03":42,"\ufb02":42,"\ufb01":42,"\ufb00":42,"\u203a":94,"\u2039":71,"\u2026":87,"\u201a":87,"\u2019":-16,"\u2018":-16,"\u2014":107,"\u2013":107,"\u017e":90,"\u017d":65,"\u0161":86,"\u0160":65,"\u0153":96,"\u0152":26,"\u0131":8,"\u00ff":101,"\u00fd":101,"\u00fc":98,"\u00fb":98,"\u00fa":98,"\u00f9":98,"\u00f8":96,"\u00f6":96,"\u00f5":96,"\u00f4":96,"\u00f3":96,"\u00f2":96,"\u00f1":84,"\u00ef":8,"\u00ee":8,"\u00ed":8,"\u00ec":8,"\u00eb":94,"\u00ea":94,"\u00e9":94,"\u00e8":94,"\u00e7":89,"\u00e6":92,"\u00e5":92,"\u00e4":92,"\u00e3":92,"\u00e2":92,"\u00e1":92,"\u00e0":92,"\u00dc":65,"\u00db":65,"\u00d8":26,"\u00d6":26,"\u00d5":26,"\u00d4":26,"\u00d3":26,"\u00d2":26,"\u00d1":65,"\u00cb":65,"\u00ca":65,"\u00c7":44,"\u00c6":65,"\u00c5":65,"\u00c4":65,"\u00c3":65,"\u00c2":65,"\u00c1":65,"\u00c0":65,"r":84,"q":99,"m":84,"_":78,"Q":26,"@":47,";":70,"0":75,"\/":55,",":87,"*":13,"'":-16,"C":44,"G":41,"d":99,"f":42,"t":52,"u":98,"v":89,"w":84,"y":101,"c":89,"e":94,"o":96,"\"":-16,"-":107,"\u2212":107,"\u201c":-16,"\u201d":-16,"\u00ab":71,"O":26,"A":65,".":87,"J":78,"x":104,"\u201e":87,"a":92,"z":90,"g":91,"\u00bb":94,":":70,"n":84,"p":104,"s":86,"h":32,"k":32,"i":8,"j":8}},"U":{"d":"55,-686v-2,-23,35,-11,56,-14r0,487v-1,101,22,171,125,171v39,0,89,-9,112,-21r0,-624v-1,-22,35,-10,56,-13r0,675v-33,20,-107,35,-168,35v-142,0,-181,-85,-181,-225r0,-471","w":458},"V":{"d":"7,-681v-3,-13,-4,-19,11,-19r44,0r111,438r42,212v38,-225,92,-435,145,-645v10,-10,38,-3,56,-5r-171,706v-24,1,-55,12,-64,-14v-67,-214,-116,-450,-174,-673","w":421,"k":{"\ufb04":6,"\ufb03":6,"\ufb02":6,"\ufb01":6,"\ufb00":6,"\u203a":11,"\u2039":37,"\u2026":48,"\u201a":48,"\u2019":-13,"\u2018":-13,"\u2014":52,"\u2013":52,"\u017e":31,"\u017d":63,"\u0161":34,"\u0160":63,"\u0153":41,"\u0152":5,"\u0131":16,"\u00ff":21,"\u00fd":21,"\u00fc":39,"\u00fb":39,"\u00fa":39,"\u00f9":39,"\u00f8":41,"\u00f6":41,"\u00f5":41,"\u00f4":41,"\u00f3":41,"\u00f2":41,"\u00f1":31,"\u00ef":16,"\u00ee":16,"\u00ed":16,"\u00ec":16,"\u00eb":52,"\u00ea":52,"\u00e9":52,"\u00e8":52,"\u00e7":47,"\u00e6":39,"\u00e5":39,"\u00e4":39,"\u00e3":39,"\u00e2":39,"\u00e1":39,"\u00e0":39,"\u00dc":63,"\u00db":63,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00d1":63,"\u00cb":63,"\u00ca":63,"\u00c7":24,"\u00c6":63,"\u00c5":63,"\u00c4":63,"\u00c3":63,"\u00c2":63,"\u00c1":63,"\u00c0":63,"r":31,"q":52,"m":31,"_":95,"Q":5,"@":26,"0":37,"\/":55,",":48,"'":-13,"C":24,"G":16,"d":52,"f":6,"t":6,"u":39,"v":26,"w":25,"y":21,"c":47,"e":52,"o":41,"\"":-13,"-":52,"\u2212":52,"\u201c":-13,"\u201d":-13,"\u00ab":37,"O":5,"A":63,".":48,"J":83,"x":29,"\u201e":48,"a":39,"z":31,"g":57,"\u00bb":11,":":26,";":26,"n":31,"p":39,"s":34,"i":16,"j":26}},"W":{"d":"6,-681v-10,-30,34,-16,56,-19r102,496r20,137r4,0v22,-211,68,-398,108,-591v8,-10,35,-3,51,-5r99,459r19,136r4,0v28,-219,70,-423,113,-627v10,-10,39,-3,57,-5r-141,706v-23,2,-54,12,-61,-11v-51,-173,-90,-356,-117,-551v-25,198,-68,377,-106,562v-26,-2,-55,13,-63,-14v-38,-132,-62,-283,-93,-422","w":643,"k":{"\u203a":5,"\u2039":28,"\u2026":33,"\u201a":33,"\u2019":-20,"\u2018":-20,"\u2014":37,"\u2013":37,"\u017e":25,"\u017d":28,"\u0161":11,"\u0160":52,"\u0153":34,"\u0152":16,"\u00ff":23,"\u00fd":23,"\u00fc":26,"\u00fb":26,"\u00fa":26,"\u00f9":26,"\u00f8":34,"\u00f6":34,"\u00f5":34,"\u00f4":34,"\u00f3":34,"\u00f2":34,"\u00f1":39,"\u00ef":39,"\u00ee":39,"\u00ec":-65,"\u00eb":32,"\u00ea":32,"\u00e9":32,"\u00e8":32,"\u00e7":34,"\u00e6":39,"\u00e5":39,"\u00e4":39,"\u00e3":39,"\u00e2":39,"\u00e1":39,"\u00e0":39,"\u00dc":52,"\u00db":52,"\u00d8":16,"\u00d6":16,"\u00d5":16,"\u00d4":16,"\u00d3":16,"\u00d2":16,"\u00d1":52,"\u00cb":52,"\u00ca":52,"\u00c7":23,"\u00c6":52,"\u00c5":52,"\u00c4":52,"\u00c3":52,"\u00c2":52,"\u00c1":52,"\u00c0":52,"r":39,"q":34,"m":39,"_":71,"Q":16,"@":6,"0":16,"\/":44,",":33,"'":-20,"C":23,"G":16,"d":34,"u":26,"v":6,"w":18,"y":23,"c":34,"e":32,"o":34,"\"":-20,"-":37,"\u2212":37,"\u201c":-20,"\u201d":-20,"\u00ab":28,"O":16,"A":52,".":33,"J":76,"x":26,"\u201e":33,"a":39,"z":25,"g":29,"\u00bb":5,"Z":28,":":26,";":26,"n":39,"p":38,"s":11}},"X":{"d":"252,-363r162,352v3,7,1,11,-8,11r-57,0r-138,-315r-71,164r-68,144v-10,14,-41,4,-62,7r168,-363r-142,-333v11,-8,44,-3,64,-4r118,290r120,-286v12,-7,40,-3,59,-4","w":426,"k":{"\ufb04":30,"\ufb03":30,"\ufb02":30,"\ufb01":30,"\ufb00":30,"\u2039":8,"\u2019":-10,"\u2018":-10,"\u2014":62,"\u2013":62,"\u017e":8,"\u0161":8,"\u0153":21,"\u0152":18,"\u00ff":53,"\u00fd":53,"\u00fc":27,"\u00fb":27,"\u00fa":27,"\u00f9":27,"\u00f6":21,"\u00f5":21,"\u00f4":21,"\u00f3":21,"\u00f2":21,"\u00f1":8,"\u00ef":8,"\u00ee":8,"\u00eb":21,"\u00ea":21,"\u00e9":21,"\u00e8":21,"\u00e7":20,"\u00e6":8,"\u00e5":8,"\u00e4":8,"\u00e3":8,"\u00e2":8,"\u00e1":8,"\u00e0":8,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":24,"\u00c6":71,"q":28,"Q":18,"@":3,"0":24,"*":13,"'":-10,"C":24,"G":18,"d":28,"f":30,"t":27,"u":27,"v":49,"w":44,"y":53,"c":20,"e":21,"o":21,"\u00f8":21,"\"":-10,"-":62,"\u2212":62,"\u201c":-10,"\u201d":-10,"\u00ab":8,"O":18,"a":8,"p":17}},"Y":{"d":"210,-13v2,22,-34,10,-55,13r0,-284r-149,-412v11,-8,42,-3,62,-4r90,274r26,91v31,-124,75,-244,114,-361v11,-7,40,-3,58,-4r-146,414r0,273","w":361,"k":{"\ufb04":24,"\ufb03":24,"\ufb02":24,"\ufb01":24,"\ufb00":24,"\u203a":42,"\u2039":60,"\u2026":54,"\u201a":54,"\u2019":-20,"\u2018":-20,"\u2014":67,"\u2013":67,"\u017e":53,"\u017d":74,"\u0161":68,"\u0160":4,"\u0153":62,"\u0152":19,"\u0131":7,"\u00ff":49,"\u00fd":49,"\u00fc":63,"\u00fb":63,"\u00fa":63,"\u00f9":63,"\u00f6":62,"\u00f5":62,"\u00f4":62,"\u00f3":62,"\u00f2":62,"\u00f1":71,"\u00ef":7,"\u00ee":7,"\u00ed":7,"\u00ec":7,"\u00eb":73,"\u00ea":73,"\u00e9":73,"\u00e8":73,"\u00e7":62,"\u00e6":61,"\u00e5":61,"\u00e4":61,"\u00e3":61,"\u00e2":61,"\u00e1":61,"\u00e0":61,"\u00dc":74,"\u00db":74,"\u00d8":19,"\u00d6":19,"\u00d5":19,"\u00d4":19,"\u00d3":19,"\u00d2":19,"\u00d1":74,"\u00cb":74,"\u00ca":74,"\u00c7":24,"\u00c5":74,"\u00c4":74,"\u00c3":74,"\u00c2":74,"\u00c1":74,"\u00c0":74,"r":71,"q":78,"m":71,"_":75,"Q":19,"@":8,"0":47,"\/":73,",":54,"'":-20,"C":24,"G":26,"d":78,"f":24,"t":32,"u":63,"v":40,"w":41,"y":49,"c":62,"e":73,"o":62,"\u00f8":62,"\"":-20,"-":67,"\u2212":67,"\u201c":-20,"\u201d":-20,"\u00ab":60,"O":19,"A":74,"\u00c6":74,".":54,"J":78,"x":43,"\u201e":54,"S":4,"a":61,"z":53,"g":65,"\u00bb":42,":":50,";":50,"n":71,"p":70,"s":68,"i":7,"j":24}},"Z":{"d":"84,-50v91,-3,197,7,278,-6v-3,20,10,56,-13,56r-317,0v-13,-9,-10,-33,-4,-49r275,-601r-253,2v2,-20,-8,-52,14,-52r298,0v10,13,8,31,0,47","w":393,"k":{"\ufb04":33,"\ufb03":33,"\ufb02":33,"\ufb01":33,"\ufb00":33,"\u2039":16,"\u2019":-7,"\u2018":-7,"\u2014":103,"\u2013":103,"\u017e":15,"\u0161":15,"\u0153":20,"\u00ff":39,"\u00fd":39,"\u00fc":24,"\u00fb":24,"\u00fa":24,"\u00f9":24,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":15,"\u00ef":15,"\u00ee":15,"\u00eb":29,"\u00ea":29,"\u00e9":29,"\u00e8":29,"\u00e7":21,"\u00e6":15,"\u00e5":15,"\u00e4":15,"\u00e3":15,"\u00e2":15,"\u00e1":15,"\u00e0":15,"r":24,"q":28,"0":13,"'":-7,"d":28,"f":33,"t":23,"u":24,"w":40,"y":39,"c":21,"e":29,"o":20,"\u00f8":20,"\"":-7,"-":103,"\u2212":103,"\u201c":-7,"\u201d":-7,"\u00ab":16,")":17,"]":17,"x":20,"a":15,"g":15,"p":7}},"[":{"d":"149,-801v2,-24,12,-20,43,-20r213,0v-3,36,7,50,-23,50r-178,0r0,917r200,0v-1,29,5,52,-24,52r-231,0r0,-999","w":415,"k":{"j":-131,")":-49,"\ufb02":14,"\ufb01":14,"\ufb00":27,"\u20ac":67,"\u2044":39,"\u2039":24,"\u2019":-20,"\u2018":-20,"\u2014":43,"\u2013":43,"\u017e":28,"\u0153":37,"\u0152":20,"\u00ff":-13,"\u00fd":-13,"\u00fc":40,"\u00fb":40,"\u00fa":40,"\u00f9":40,"\u00f8":37,"\u00f6":37,"\u00f5":37,"\u00f4":37,"\u00f3":37,"\u00f2":37,"\u00f1":33,"\u00ef":-7,"\u00ed":23,"\u00ec":-23,"\u00eb":30,"\u00ea":30,"\u00e9":30,"\u00e8":30,"\u00e7":30,"\u00e6":27,"\u00e4":27,"\u00e3":27,"\u00e2":27,"\u00e1":27,"\u00e0":27,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00cf":-19,"\u00ce":-55,"\u00c7":24,"\u00c6":27,"\u00c5":27,"\u00c4":27,"\u00c3":27,"\u00c2":27,"\u00c1":27,"\u00c0":27,"\u00a2":60,"r":33,"q":30,"m":33,"]":-57,"\\":-31,"[":59,"Q":20,"0":72,"\/":54,"+":62,"*":21,"'":-20,"C":24,"G":20,"d":30,"t":17,"u":40,"v":39,"w":43,"y":-13,"c":30,"e":30,"o":37,"\"":-20,"-":43,"\u2212":43,"\u201c":-20,"\u201d":-20,"\u00ab":24,"O":20,"A":27,"x":22,"a":27,"\u00e5":27,"z":28,"Z":17,"\u017d":17,"n":33}},"\\":{"d":"292,15v1,23,-19,12,-53,15r-228,-778v-1,-25,17,-13,53,-17","w":303,"k":{"\"":123,"\u201e":-37,"\u201d":123,"\u201c":123,"\u00c6":-44,"]":21,"A":-44,".":-37,")":21,"\u2026":-37,"\u201a":-37,"\u2019":123,"\u2018":123,"\u017d":-44,"\u0160":-44,"\u00dc":-44,"\u00db":-44,"\u00d6":-44,"\u00d5":-44,"\u00d4":-44,"\u00d1":-44,"\u00cb":-44,"\u00ca":-44,"\u00c5":-44,"\u00c4":-44,"\u00c3":-44,"\u00c2":-44,"\u00c1":-44,"\u00c0":-44,"\/":-25,",":-37,"'":123}},"]":{"d":"266,180v-2,24,-12,20,-44,20r-212,0v3,-36,-7,-50,23,-50r178,0r0,-920r-200,0v1,-28,-5,-52,24,-52r231,0r0,1002","w":415,"k":{"]":59,")":59,"\u2019":74,"\u2018":74,"'":74,"\"":74,"\u201c":74,"\u201d":74}},"_":{"d":"366,44v-2,28,5,46,-13,50r-337,0v2,-29,-6,-50,14,-50r336,0","w":383,"k":{"\ufb02":34,"\ufb01":34,"\u0178":78,"\u0153":31,"\u0152":44,"\u00ff":24,"\u00fd":24,"\u00fc":32,"\u00fb":32,"\u00fa":32,"\u00f9":32,"\u00f8":31,"\u00f6":31,"\u00f5":31,"\u00f4":31,"\u00f3":31,"\u00f2":31,"\u00eb":26,"\u00ea":26,"\u00e9":26,"\u00e8":26,"\u00e7":34,"\u00dd":78,"\u00d8":44,"\u00d6":44,"\u00d5":44,"\u00d4":44,"\u00d3":44,"\u00d2":44,"\u00c7":64,"y":24,"w":52,"v":73,"u":32,"t":60,"o":31,"j":-41,"g":-5,"f":34,"e":26,"d":20,"c":34,"Y":78,"W":65,"V":88,"T":75,"O":44,"G":11,"C":64,"q":41,"Q":14,"9":-8,"8":34,"6":27,"5":-6,"4":145,"0":46,"\/":-45}},"`":{"d":"148,-629v24,13,7,36,-7,46v-42,-28,-104,-74,-141,-106v4,-19,13,-55,36,-35","w":162},"a":{"d":"267,-378v14,-118,-161,-77,-223,-54v-8,-16,-13,-41,0,-52v31,-16,101,-27,157,-26v84,1,120,33,120,121r-5,363v-31,18,-77,36,-136,36v-101,0,-144,-45,-144,-149v0,-109,44,-164,149,-163v28,0,62,3,82,12r0,-88xm93,-141v0,108,100,125,169,81r5,-189v-16,-6,-44,-10,-65,-10v-78,-2,-109,37,-109,118","w":367,"k":{"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":84,"\u2018":84,"\u00ff":8,"\u00fd":8,"'":84,"f":9,"t":23,"y":8,"\"":84,"\u201c":84,"\u201d":84,")":27,"]":27,"x":7}},"b":{"d":"237,-510v105,2,131,81,131,192v1,125,-23,211,-67,274v-45,64,-184,68,-243,24r0,-688v2,-33,17,-24,55,-27r0,266v31,-25,67,-41,124,-41xm213,-459v-45,1,-75,14,-100,39r0,362v22,18,73,28,107,10v72,-37,88,-134,88,-255v0,-87,-11,-156,-95,-156","w":401,"k":{"\u2026":20,"\u201a":20,"\u2019":78,"\u2018":78,"\u017e":7,"_":39,"\/":6,",":20,"'":78,"t":13,"w":2,"\"":78,"\u201c":78,"\u201d":78,")":24,"]":24,".":20,"\u201e":20,"z":7}},"c":{"d":"220,-510v50,-2,104,22,77,73v-39,-29,-130,-35,-160,13v-27,44,-42,104,-41,188v2,107,8,194,109,196v38,1,73,-14,92,-30v30,61,-46,80,-107,80v-136,1,-150,-108,-150,-249v0,-158,35,-268,180,-271","w":331,"k":{"\u2039":33,"\u2019":49,"\u2018":49,"\u2014":44,"\u2013":44,"\u0153":9,"\u00ff":-2,"\u00fd":-2,"\u00f6":9,"\u00f5":9,"\u00f4":9,"\u00f3":9,"\u00f2":9,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":16,"q":16,"\/":-20,"'":49,"d":16,"t":-3,"w":-2,"y":-2,"c":16,"e":15,"o":9,"\u00f8":9,"\"":49,"-":44,"\u2212":44,"\u201c":49,"\u201d":49,"\u00ab":33,")":4,"]":4}},"d":{"d":"208,-40v33,0,61,-6,82,-20r-1,-381v-19,-14,-34,-20,-66,-20v-103,0,-123,105,-123,220v0,109,5,200,108,201xm41,-236v0,-146,34,-274,166,-274v34,0,61,7,82,22r0,-220v2,-33,19,-25,56,-27r0,715v-36,18,-86,30,-142,30v-138,0,-162,-101,-162,-246","w":402,"k":{"\u00ef":-7,"\u00ee":-7,"\u00ec":-7,"\/":-10}},"e":{"d":"202,10v-136,4,-164,-93,-164,-233v0,-163,27,-281,179,-287v136,-5,138,154,116,278v-71,14,-157,18,-239,18v0,102,18,172,117,170v48,0,92,-13,120,-34v5,11,7,26,7,39v-16,41,-80,47,-136,49xm285,-274v6,-83,16,-190,-73,-186v-99,5,-110,94,-117,200r89,-2v34,-2,72,-5,101,-12","w":375,"k":{"\u2019":60,"\u2018":60,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\/":-10,"'":60,"t":7,"w":2,"e":10,"\"":60,"\u201c":60,"\u201d":60,")":20,"]":20,"x":4}},"f":{"d":"146,-13v0,20,-35,11,-55,13r0,-452r-76,0v2,-20,-8,-48,15,-48r61,0v-10,-145,27,-239,163,-239v57,0,102,10,80,62v-24,-9,-44,-10,-74,-12v-106,-6,-121,79,-114,189r104,0v-2,22,6,48,-14,48r-90,0r0,439","w":248,"k":{"!":-78,"\ufb04":31,"\ufb03":31,"\ufb02":31,"\ufb01":31,"\ufb00":31,"\u2122":-101,"\u2039":19,"\u2030":-24,"\u2026":44,"\u201a":44,"\u2019":-127,"\u2018":-127,"\u2014":48,"\u2013":48,"\u0153":14,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f8":14,"\u00f6":14,"\u00f5":14,"\u00f4":14,"\u00f3":14,"\u00f2":14,"\u00eb":18,"\u00ea":18,"\u00e9":18,"\u00e8":18,"\u00e7":15,"\u00ae":-62,"\u00a9":-63,"r":4,"q":18,"m":2,"_":52,"]":-114,"\\":-111,"?":-115,"8":-10,",":44,"*":-32,"'":-127,"&":-19,"d":18,"u":4,"w":-9,"c":15,"e":18,"o":14,"\"":-127,"-":48,"\u2212":48,"\u201c":-127,"\u201d":-127,"\u00ab":19,"b":-5,")":-114,".":44,"\u201e":44,"g":20,"p":18,"h":-6,"k":-6}},"g":{"d":"49,-329v-3,-128,82,-200,210,-175r124,0v9,15,11,50,-17,48v-17,-1,-38,-3,-54,-6v35,23,55,64,55,124v0,133,-85,208,-219,177v-15,15,-63,54,-31,71v86,46,268,-3,268,137v0,104,-82,150,-194,150v-92,0,-158,-21,-158,-106v0,-56,47,-100,82,-126v-32,-10,-66,-21,-66,-53v0,-36,37,-68,63,-88v-47,-27,-62,-84,-63,-153xm312,-349v1,-77,-30,-118,-100,-118v-69,0,-106,54,-106,137v0,80,22,134,103,131v79,-3,102,-69,103,-150xm196,146v73,0,130,-27,133,-92v4,-82,-95,-65,-168,-80v-29,21,-72,61,-72,106v0,57,46,66,107,66","w":403,"k":{"\u2019":26,"\u2018":26,"\u017e":-6,"\u0153":4,"\u00ff":-3,"\u00fd":-3,"\u00f8":4,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00eb":3,"\u00ea":3,"\u00e9":3,"\u00e8":3,"\u00e7":4,"q":2,"\/":-15,"'":26,"d":2,"y":-3,"c":4,"e":3,"o":4,"\"":26,"\u201c":26,"\u201d":26,"x":4,"z":-6,"j":-108,"\u00df":4,"\u017f":4}},"h":{"d":"109,-13v1,22,-34,10,-55,13r0,-708v2,-33,17,-24,55,-27r0,268v32,-27,76,-42,127,-43v87,-2,115,48,115,134r0,363v0,21,-35,10,-56,13r0,-364v1,-60,-20,-95,-80,-94v-41,1,-82,14,-106,40r0,405","w":396,"k":{"\"":91,"\u201d":91,"\u201c":91,"y":10,"w":3,"t":13,"\u2019":91,"\u2018":91,"\u00ff":10,"\u00fd":10,"\/":-8,"'":91,")":33,"]":33,"x":7}},"i":{"d":"114,-13v1,22,-35,10,-57,13r0,-473v2,-33,20,-25,57,-27r0,487xm85,-623v-24,-1,-30,-17,-30,-46v0,-31,11,-46,33,-46v25,1,31,17,31,45v0,31,-13,47,-34,47","w":171,"k":{"\/":-23}},"j":{"d":"-8,144v67,0,72,-52,72,-118r0,-499v2,-33,17,-24,55,-27r0,537v1,95,-27,158,-123,158v-66,0,-131,-21,-100,-77v24,15,55,26,96,26xm92,-623v-24,-1,-30,-17,-30,-46v0,-31,11,-46,33,-46v25,1,31,17,31,45v0,31,-13,47,-34,47","w":182,"k":{"\/":-24,"j":-63}},"k":{"d":"112,-13v2,22,-34,10,-55,13r0,-708v2,-33,17,-24,55,-27r0,286v31,-33,87,-59,141,-61v62,-1,88,31,88,88v0,81,-56,126,-105,157v98,21,141,133,120,259v-9,11,-41,4,-60,6v18,-123,-16,-260,-143,-224r-41,16r0,195xm112,-251v77,-31,169,-59,169,-157v0,-34,-17,-51,-51,-51v-53,0,-88,27,-118,64r0,144","w":392,"k":{"\u2019":74,"\u2018":74,"\u2014":20,"\u2013":20,"\u0153":4,"\u00ff":20,"\u00fd":20,"\u00f6":4,"\u00f5":4,"\u00f4":4,"\u00f3":4,"\u00f2":4,"\u00eb":4,"\u00ea":4,"\u00e9":4,"\u00e8":4,"\u00e7":4,"q":4,"\/":-25,"'":74,"w":10,"y":20,"c":4,"e":4,"o":4,"\u00f8":4,"\"":74,"-":20,"\u2212":20,"\u201c":74,"\u201d":74,")":13,"]":13,"p":4}},"l":{"d":"112,-13v1,22,-34,10,-55,13r0,-708v2,-33,17,-24,55,-27r0,722","w":170},"m":{"d":"57,-477v64,-31,197,-57,244,3v31,-20,79,-35,127,-36v92,-2,112,54,112,145r0,352v1,22,-34,10,-55,13r0,-368v-2,-62,-5,-92,-66,-92v-38,0,-65,9,-92,27r0,420v0,22,-34,10,-55,13r0,-391v10,-92,-106,-77,-160,-48r0,426v0,21,-35,10,-55,13r0,-477","w":592,"k":{"\"":91,"\u201d":91,"\u201c":91,"y":5,"x":7,"w":3,"f":7,"]":33,")":33,"\ufb04":7,"\ufb03":7,"\ufb02":7,"\ufb01":7,"\ufb00":7,"\u2019":91,"\u2018":91,"\u00ff":5,"\u00fd":5,"\/":-26,"'":91}},"n":{"d":"110,-13v1,22,-34,10,-55,13r0,-475v43,-18,103,-35,162,-35v97,0,137,40,137,137r0,360v1,22,-35,10,-56,13r0,-358v1,-66,-16,-106,-83,-103v-34,0,-81,9,-105,23r0,425","w":401,"k":{"\u2019":91,"\u2018":91,"\/":-31,"'":91,"\"":91,"\u201c":91,"\u201d":91,")":33,"]":33,"x":7}},"o":{"d":"187,10v-143,5,-154,-111,-156,-259v-1,-156,39,-261,167,-261v139,0,154,115,155,260v1,153,-38,256,-166,260xm196,-461v-100,0,-106,106,-106,216v0,107,0,207,99,207v96,0,105,-107,105,-214v0,-107,1,-209,-98,-209","w":383,"k":{"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":73,"\u2018":73,"\u017e":4,"\u0161":10,"\u00ff":20,"\u00fd":20,"\u00fc":10,"\u00fb":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":10,"\u00ea":10,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"_":42,"\/":-15,",":20,"*":10,"'":73,"f":10,"t":17,"v":10,"w":10,"y":20,"\"":73,"\u201c":73,"\u201d":73,")":37,"]":37,".":20,"x":27,"\u201e":20,"z":4}},"p":{"d":"112,193v-20,5,-55,12,-55,-19r0,-644v43,-27,91,-40,144,-40v126,-1,165,81,165,211v0,115,-20,196,-58,257v-38,61,-154,68,-196,16r0,219xm293,-155v19,-100,44,-306,-95,-306v-33,0,-61,8,-86,25r0,350v25,54,116,62,150,6v11,-18,25,-42,31,-75","w":400,"k":{"\ufb04":4,"\ufb03":4,"\ufb02":4,"\ufb01":4,"\ufb00":4,"\u2026":20,"\u201a":20,"\u2019":94,"\u2018":94,"\u017e":10,"\u0161":13,"\u00ff":17,"\u00fd":17,"\u00fc":13,"\u00fb":13,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":13,"\u00ea":13,"\u00e6":4,"\u00e5":4,"\u00e4":4,"\u00e3":4,"\u00e2":4,"\u00e1":4,"\u00e0":4,"_":57,"?":10,"\/":-10,",":20,"*":10,"'":94,"f":4,"t":10,"v":10,"w":10,"y":17,"\"":94,"\u201c":94,"\u201d":94,")":37,"]":37,".":20,"x":17,"\u201e":20,"a":4,"z":10,"j":2}},"q":{"d":"242,-510v49,0,79,10,109,31r0,653v5,33,-28,22,-56,23r0,-240v-24,35,-61,53,-112,53v-117,0,-143,-102,-143,-231v0,-164,47,-289,202,-289xm100,-220v0,98,15,180,102,180v43,0,80,-25,93,-63r0,-340v-13,-11,-40,-20,-65,-18v-107,8,-130,103,-130,241","w":408,"k":{"\"":63,"\u201d":63,"\u201c":63,"\u2019":63,"\u2018":63,"\/":-16,"'":63}},"r":{"d":"111,-13v1,22,-35,10,-56,13r0,-466v36,-25,80,-41,134,-44v54,-3,87,23,64,68v-40,-24,-106,-17,-142,13r0,416","w":275,"k":{"\u2039":55,"\u2026":80,"\u201a":80,"\u2019":24,"\u2018":24,"\u2014":78,"\u2013":78,"\u0153":20,"\u00f8":20,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":22,"\u00ea":22,"\u00e9":22,"\u00e8":22,"\u00e7":20,"r":7,"q":23,"_":106,"\/":20,",":80,"'":24,"d":23,"c":20,"e":22,"o":20,"\"":24,"-":78,"\u2212":78,"\u201c":24,"\u201d":24,"\u00ab":55,")":27,"]":27,".":80,"x":17,"\u201e":80,"g":25,"p":13}},"s":{"d":"54,-344v-50,-97,41,-172,150,-166v59,3,112,9,127,50v0,10,-4,20,-13,31v-58,-54,-256,-44,-205,66v61,80,213,102,216,238v2,92,-68,135,-164,135v-69,0,-156,-16,-114,-77v59,38,221,46,217,-51v-2,-49,-23,-70,-56,-97v-49,-40,-131,-77,-158,-129","w":368,"k":{"\u2019":55,"\u2018":55,"\u2014":44,"\u2013":44,"\u00ff":7,"\u00fd":7,"\/":-15,"'":55,"y":7,"\"":55,"-":44,"\u2212":44,"\u201c":55,"\u201d":55,")":4,"]":4,"x":4}},"t":{"d":"190,10v-84,0,-90,-71,-89,-155r0,-306r-74,0v2,-32,-6,-44,13,-49r61,0r0,-158v2,-30,18,-19,55,-22r0,180r121,0v-2,31,5,44,-12,49r-109,0r0,307v1,50,-3,104,46,105v31,0,43,-6,65,-16v19,51,-29,65,-77,65","w":298,"k":{"\u2039":29,"\u2026":-3,"\u201a":-3,"\u2019":36,"\u2018":36,"\u2014":75,"\u2013":75,"\u0153":14,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":14,"\u00f5":14,"\u00f4":14,"\u00f3":14,"\u00f2":14,"\u00eb":17,"\u00ea":17,"\u00e9":17,"\u00e8":17,"\u00e7":17,"q":14,"0":3,"\/":-25,",":-3,"'":36,"d":14,"t":57,"u":4,"c":17,"e":17,"o":14,"\u00f8":14,"\"":36,"-":75,"\u2212":75,"\u201c":36,"\u201d":36,"\u00ab":29,")":13,"]":13,".":-3,"\u201e":-3,"g":10}},"u":{"d":"302,-486v-2,-23,34,-11,55,-14r0,475v-39,21,-96,34,-152,35v-117,3,-147,-63,-147,-179r0,-317v-3,-24,34,-11,56,-14r0,338v-2,80,16,127,96,123v32,-1,69,-7,92,-23r0,-424","w":416,"k":{"\u2019":63,"\u2018":63,"\/":-21,"'":63,"\"":63,"\u201c":63,"\u201d":63,")":40,"]":40}},"v":{"d":"154,-6r-130,-486v9,-12,34,-6,58,-8r83,351r18,87r53,-265r42,-167v8,-10,36,-5,54,-6r-128,506v-21,-1,-44,11,-50,-12","w":356,"k":{"\u2039":23,"\u2026":51,"\u201a":51,"\u2019":54,"\u2018":54,"\u2014":27,"\u2013":27,"\u017e":13,"\u0161":10,"\u0153":20,"\u00ff":13,"\u00fc":17,"\u00fb":17,"\u00fa":17,"\u00f9":17,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":23,"\u00ea":23,"\u00e9":23,"\u00e8":23,"\u00e7":15,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"r":20,"q":24,"m":17,"k":4,"_":81,"@":5,"0":8,"\/":24,",":51,"'":54,"d":24,"t":13,"u":17,"c":15,"e":23,"o":20,"\u00f8":20,"\"":54,"-":27,"\u2212":27,"\u201c":54,"\u201d":54,")":33,"]":33,".":51,"\u201e":51,"a":13,"g":27,":":10,";":10,"p":17,"s":10}},"w":{"d":"129,-41r-105,-453v8,-11,39,-4,58,-6r87,431r3,0r78,-400v0,-23,34,-11,55,-14r88,414r4,0r42,-249r37,-176v8,-10,35,-5,53,-6r-114,506v-21,1,-41,11,-49,-12v-42,-115,-63,-258,-89,-389r-35,198r-46,203v-23,-2,-48,12,-56,-12v-3,-9,-8,-20,-11,-35","w":553,"k":{"\u2039":21,"\u2026":42,"\u201a":42,"\u2019":65,"\u2018":65,"\u2014":25,"\u2013":25,"\u017e":17,"\u0161":10,"\u0153":20,"\u00ff":12,"\u00fc":17,"\u00fb":17,"\u00fa":17,"\u00f9":17,"\u00f8":20,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":12,"\u00ef":12,"\u00ee":12,"\u00eb":23,"\u00ea":23,"\u00e9":23,"\u00e8":23,"\u00e7":24,"\u00e6":12,"\u00e5":12,"\u00e4":12,"\u00e3":12,"\u00e2":12,"\u00e1":12,"\u00e0":12,"r":20,"q":21,"m":12,"k":17,"_":60,"@":10,"\/":3,",":42,"'":65,"d":21,"t":13,"u":17,"c":24,"e":23,"o":20,"\"":65,"-":25,"\u2212":25,"\u201c":65,"\u201d":65,")":41,"]":41,".":42,"x":20,"\u201e":42,"a":12,"z":17,"g":27,":":16,";":16,"p":17,"s":10}},"x":{"d":"255,-266r159,260v-7,11,-43,4,-63,6r-136,-224r-83,145r-50,75v-12,8,-40,3,-60,4r162,-262r-140,-233v13,-7,34,-4,59,-5r119,199r70,-121r48,-74v11,-7,41,-3,60,-4","w":437,"k":{"\ufb04":20,"\ufb03":20,"\ufb02":20,"\ufb01":20,"\ufb00":20,"\u2039":39,"\u2019":42,"\u2018":42,"\u2014":88,"\u2013":88,"\u017e":13,"\u0161":17,"\u0153":27,"\u00ff":20,"\u00fd":20,"\u00fc":13,"\u00fb":13,"\u00fa":13,"\u00f9":13,"\u00f8":27,"\u00f6":27,"\u00f5":27,"\u00f4":27,"\u00f3":27,"\u00f2":27,"\u00f1":5,"\u00ef":5,"\u00ee":5,"\u00eb":19,"\u00ea":19,"\u00e9":19,"\u00e8":19,"\u00e7":7,"\u00e6":5,"\u00e5":5,"\u00e4":5,"\u00e3":5,"\u00e2":5,"\u00e1":5,"\u00e0":5,"r":14,"q":23,"m":13,"k":17,"@":10,"0":3,"\/":-8,"'":42,"d":23,"f":20,"t":17,"u":13,"w":27,"y":20,"c":7,"e":19,"o":27,"\"":42,"-":88,"\u2212":88,"\u201c":42,"\u201d":42,")":17,"]":17,"x":13,"a":5,"z":13,"g":17,"p":10,"s":17}},"y":{"d":"11,131v37,16,86,23,113,-14v14,-20,28,-52,39,-101r-131,-508v9,-12,30,-6,54,-8r86,346r18,103v23,-156,61,-297,96,-441v10,-11,33,-6,57,-8r-132,531v-23,83,-41,162,-137,162v-43,0,-83,-6,-70,-47v2,-6,4,-12,7,-15","w":370,"k":{"\u2039":25,"\u2026":55,"\u201a":55,"\u2019":61,"\u2018":61,"\u2014":36,"\u2013":36,"\u017e":13,"\u0161":10,"\u0153":20,"\u00ff":8,"\u00fc":17,"\u00fb":17,"\u00fa":17,"\u00f9":17,"\u00f8":20,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":8,"\u00ef":13,"\u00ee":13,"\u00eb":23,"\u00ea":23,"\u00e9":23,"\u00e8":23,"\u00e7":20,"\u00e6":15,"\u00e5":15,"\u00e4":15,"\u00e3":15,"\u00e2":15,"\u00e1":15,"\u00e0":15,"r":20,"q":21,"m":12,"k":17,"_":57,"\/":24,",":55,"'":61,"d":21,"t":13,"u":17,"c":20,"e":23,"o":20,"\"":61,"-":36,"\u2212":36,"\u201c":61,"\u201d":61,")":41,"]":41,".":55,"x":13,"\u201e":55,"a":15,"z":13,"g":27,":":16,";":16,"p":17,"s":10}},"z":{"d":"149,-452r-113,5v-4,-20,-5,-53,16,-53r276,0v9,11,7,34,-1,47r-233,401v78,-1,176,5,237,-8v0,25,8,60,-20,60r-272,0v-11,-11,-14,-34,-4,-50r235,-402r-121,0","w":364,"k":{"\u2039":6,"\u2019":46,"\u2018":46,"\u2014":49,"\u2013":49,"\u017e":13,"\u0161":13,"\u0153":10,"\u00ff":13,"\u00fd":13,"\u00fc":17,"\u00fb":17,"\u00fa":17,"\u00f9":17,"\u00f8":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f3":10,"\u00f2":10,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":17,"\u00ea":17,"\u00e9":17,"\u00e8":17,"\u00e7":15,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"q":18,"'":46,"d":18,"t":13,"u":17,"w":13,"y":13,"c":15,"e":17,"o":10,"\"":46,"-":49,"\u2212":49,"\u201c":46,"\u201d":46,")":27,"]":27,"x":17,"g":10,"p":13}},"|":{"d":"204,185v2,24,-34,12,-55,15r1,-1008v9,-11,31,-5,54,-7r0,1000","w":354},"\u00a1":{"d":"98,-508v30,0,42,16,42,45v0,24,-16,45,-42,45v-30,0,-44,-17,-44,-45v0,-26,18,-45,44,-45xm131,182v-8,22,-31,13,-71,16r9,-489v3,-27,21,-25,54,-26","w":189,"k":{"j":-94,"\/":-34}},"\u00a2":{"d":"91,-225v0,-147,28,-256,142,-281r0,-106v1,-26,21,-25,50,-26r0,130v32,5,81,9,71,49v-2,8,-3,16,-6,23v-20,-12,-38,-22,-72,-22v-115,5,-129,106,-129,233v0,109,6,184,114,184v35,0,67,-16,87,-31v5,8,7,25,7,36v-11,31,-54,42,-94,46r0,106v-2,24,-20,23,-49,24r0,-132v-110,-10,-121,-107,-121,-233","k":{"\"":14,"\u201d":14,"\u201c":14,"]":32,")":32,"\u2019":14,"\u2018":14,"'":14}},"\u00a5":{"d":"242,-13v1,22,-34,10,-55,13r0,-180r-136,0v1,-29,-2,-46,23,-46r113,0r0,-58r-21,-57r-115,0v1,-29,-2,-46,23,-46r75,0r-111,-309v11,-8,42,-3,62,-4r108,326v5,15,7,25,7,29v32,-120,75,-237,115,-351v11,-7,40,-3,58,-4r-111,313r98,0v-1,29,2,46,-23,46r-92,0r-18,53r0,62r134,0v-1,29,2,46,-23,46r-111,0r0,167","k":{"\/":8}},"\u00a8":{"d":"39,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm180,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":220},"\u00a9":{"d":"246,-674v18,0,55,6,42,30v-2,6,-3,10,-4,13v-10,-5,-18,-10,-33,-10v-56,3,-62,52,-62,114v0,50,4,87,52,85v16,0,33,-7,43,-13v2,4,7,19,7,24v-3,11,-35,22,-54,22v-73,0,-86,-44,-85,-119v1,-84,17,-146,94,-146xm232,-320v-142,2,-194,-75,-194,-220v0,-144,67,-218,200,-220v140,-2,189,77,189,219v0,137,-64,220,-195,221xm239,-719v-111,0,-157,67,-157,182v0,112,38,176,146,174v107,-2,154,-69,155,-180v1,-119,-39,-176,-144,-176","w":464,"k":{"\/":86}},"\u00ab":{"d":"177,-500v21,5,40,21,27,45v-37,70,-81,135,-123,200r111,177v24,28,27,69,-10,78r-106,-162v-15,-30,-38,-59,-48,-93v38,-90,99,-166,149,-245xm338,-479v20,5,41,20,28,43v-35,65,-82,126,-122,186r110,156v24,25,24,65,-11,72r-129,-181v-10,-23,-32,-36,-17,-63v41,-75,93,-144,141,-213","w":417,"k":{"T":67,"V":28,"W":29,"Y":47,"\u00dd":47,"\u0178":47}},"\u00ae":{"d":"232,-320v-142,2,-194,-75,-194,-220v0,-144,67,-218,200,-220v140,-2,189,77,189,219v0,137,-64,220,-195,221xm239,-719v-111,0,-157,67,-157,182v0,112,38,176,146,174v107,-2,154,-69,155,-180v1,-119,-39,-176,-144,-176xm316,-420v0,13,-21,8,-33,8v-7,-47,-20,-86,-47,-110r-33,0r0,102v-2,12,-14,6,-31,8r0,-259v9,-11,37,-2,55,-5v94,-14,107,118,42,146v21,23,44,60,47,110xm277,-604v0,-40,-30,-47,-74,-44r0,97v46,3,74,-8,74,-53","w":464,"k":{"\/":74}},"\u00b4":{"d":"22,-578v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":162},"\u00b7":{"d":"101,-224v-30,0,-42,-17,-42,-45v0,-24,16,-45,42,-45v30,0,44,17,44,45v0,25,-18,45,-44,45","w":208},"\u00b8":{"d":"88,123v4,-42,-42,-38,-72,-29r19,-97r36,0r-13,63v39,-8,67,14,67,56v0,71,-66,91,-125,67v5,-16,2,-44,26,-31v25,14,66,7,62,-29","w":125},"\u00bb":{"d":"233,0v-21,-6,-41,-22,-27,-49v38,-71,85,-139,128,-206r-88,-136v-13,-26,-33,-51,-41,-81v2,-18,18,-22,33,-28r126,196v10,25,31,40,16,68v-44,82,-98,159,-147,236xm73,-21v-20,-6,-39,-23,-25,-48v36,-63,83,-122,125,-181r-93,-138v-20,-30,-57,-79,-3,-92r125,183v10,23,34,38,18,65v-45,76,-93,138,-147,211","w":415,"k":{"\u2014":-20,"\u2013":-20,"T":67,"V":39,"W":31,"Y":55,"\u00dd":55,"\u0178":55,"v":16,"w":5,"y":5,"\u00fd":5,"\u00ff":5,"-":-20,"\u2212":-20,")":17,"]":17,"J":37,"X":29,"x":25,"z":31,"\u017e":31,"Z":16,"\u017d":16}},"\u00bf":{"d":"168,-507v30,0,42,17,42,45v0,24,-16,45,-42,45v-30,0,-44,-17,-44,-45v0,-25,18,-45,44,-45xm272,153v-16,33,-70,42,-118,42v-90,0,-140,-48,-140,-142v0,-133,99,-176,132,-275v10,-29,-2,-67,-2,-90v6,-10,35,-8,50,-6v5,18,11,36,11,61v-3,136,-130,165,-133,300v-2,66,35,97,97,97v41,1,73,-14,96,-30v4,12,7,26,7,43","w":302,"k":{"\"":55,"\u201d":55,"\u201c":55,"\u00c6":20,"j":-119,"]":-6,"A":20,")":-6,"\u2019":55,"\u2018":55,"\u017d":20,"\u0160":20,"\u00dc":20,"\u00db":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d1":20,"\u00cb":20,"\u00ca":20,"\u00c5":20,"\u00c4":20,"\u00c3":20,"\u00c2":20,"\u00c1":20,"\u00c0":20,"'":55}},"\u00c0":{"d":"322,-193r-208,0r-46,182v-3,20,-38,11,-61,10r189,-694v0,-12,34,-10,43,-6r189,688v5,22,-32,12,-56,13xm127,-244r181,0r-76,-299r-14,-82r-28,137xm250,-829v24,13,7,36,-7,46v-42,-28,-104,-74,-141,-106v4,-19,13,-55,36,-35","w":436,"k":{"\"":104,"\u2212":43,"\u201d":104,"\u201c":104,"\u00f8":12,"\u00ab":21,"y":48,"w":44,"v":52,"u":11,"t":41,"s":10,"o":12,"f":21,"e":16,"d":11,"c":10,"b":10,"]":20,"Y":74,"W":52,"V":63,"T":58,"O":21,"G":15,"C":21,"-":43,")":20,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2019":104,"\u2018":104,"\u2014":43,"\u2013":43,"\u0178":74,"\u0161":10,"\u0153":26,"\u0152":21,"\u00ff":48,"\u00fd":48,"\u00fc":18,"\u00fb":18,"\u00fa":18,"\u00f9":18,"\u00f6":26,"\u00f5":26,"\u00f4":26,"\u00f3":26,"\u00f2":26,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"q":16,"\\":63,"Q":21,"7":11,"\/":-23,"*":49,"'":104}},"\u00c1":{"d":"322,-193r-208,0r-46,182v-3,20,-38,11,-61,10r189,-694v0,-12,34,-10,43,-6r189,688v5,22,-32,12,-56,13xm127,-244r181,0r-76,-299r-14,-82r-28,137xm199,-778v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":436,"k":{"\"":104,"\u2212":43,"\u201d":104,"\u201c":104,"\u00f8":12,"\u00ab":21,"y":48,"w":44,"v":52,"u":11,"t":41,"s":10,"o":12,"f":21,"e":16,"d":11,"c":10,"b":10,"]":20,"Y":74,"W":52,"V":63,"T":58,"O":21,"G":15,"C":21,"-":43,")":20,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2019":104,"\u2018":104,"\u2014":43,"\u2013":43,"\u0178":74,"\u0161":10,"\u0153":26,"\u0152":21,"\u00ff":48,"\u00fd":48,"\u00fc":18,"\u00fb":18,"\u00fa":18,"\u00f9":18,"\u00f6":26,"\u00f5":26,"\u00f4":26,"\u00f3":26,"\u00f2":26,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"q":16,"\\":63,"Q":21,"7":11,"\/":-20,"*":49,"'":104}},"\u00c2":{"d":"322,-193r-208,0r-46,182v-3,20,-38,11,-61,10r189,-694v0,-12,34,-10,43,-6r189,688v5,22,-32,12,-56,13xm127,-244r181,0r-76,-299r-14,-82r-28,137xm218,-865v-27,31,-53,65,-85,85v-18,1,-31,-11,-38,-19r111,-114v13,-4,26,-1,33,7r82,87v17,21,22,19,2,33v-8,5,-17,7,-28,7v-24,-27,-56,-57,-77,-86","w":436,"k":{"\"":104,"\u2212":43,"\u201d":104,"\u201c":104,"\u00f8":12,"\u00ab":21,"y":48,"w":44,"v":52,"u":11,"t":41,"s":10,"o":12,"f":21,"e":16,"d":11,"c":10,"b":10,"]":20,"Y":74,"W":52,"V":63,"T":58,"O":21,"G":15,"C":21,"-":43,")":20,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2019":104,"\u2018":104,"\u2014":43,"\u2013":43,"\u0178":74,"\u0161":10,"\u0153":26,"\u0152":21,"\u00ff":48,"\u00fd":48,"\u00fc":18,"\u00fb":18,"\u00fa":18,"\u00f9":18,"\u00f6":26,"\u00f5":26,"\u00f4":26,"\u00f3":26,"\u00f2":26,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"q":16,"\\":63,"Q":21,"7":11,"\/":-23,"*":49,"'":104}},"\u00c3":{"d":"322,-193r-208,0r-46,182v-3,20,-38,11,-61,10r189,-694v0,-12,34,-10,43,-6r189,688v5,22,-32,12,-56,13xm127,-244r181,0r-76,-299r-14,-82r-28,137xm187,-832v-35,-28,-65,20,-84,36v-16,-2,-21,-17,-29,-28v25,-44,50,-66,102,-68v46,-2,46,50,91,51v33,0,47,-20,61,-38v14,-18,27,9,31,25v-16,50,-110,95,-155,40","w":436,"k":{"\"":104,"\u2212":43,"\u201d":104,"\u201c":104,"\u00f8":12,"\u00ab":21,"y":48,"w":44,"v":52,"u":11,"t":41,"s":10,"o":12,"f":21,"e":16,"d":11,"c":10,"b":10,"]":20,"Y":74,"W":52,"V":63,"T":58,"O":21,"G":15,"C":21,"-":43,")":20,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2019":104,"\u2018":104,"\u2014":43,"\u2013":43,"\u0178":74,"\u0161":10,"\u0153":26,"\u0152":21,"\u00ff":48,"\u00fd":48,"\u00fc":18,"\u00fb":18,"\u00fa":18,"\u00f9":18,"\u00f6":26,"\u00f5":26,"\u00f4":26,"\u00f3":26,"\u00f2":26,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"q":16,"\\":63,"Q":21,"7":11,"\/":-28,"*":49,"'":104}},"\u00c4":{"d":"322,-193r-208,0r-46,182v-3,20,-38,11,-61,10r189,-694v0,-12,34,-10,43,-6r189,688v5,22,-32,12,-56,13xm127,-244r181,0r-76,-299r-14,-82r-28,137xm148,-808v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm289,-808v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":436,"k":{"\"":104,"\u2212":43,"\u201d":104,"\u201c":104,"\u00f8":12,"\u00ab":21,"y":48,"w":44,"v":52,"u":11,"t":41,"s":10,"o":12,"f":21,"e":16,"d":11,"c":10,"b":10,"]":20,"Y":74,"W":52,"V":63,"T":58,"O":21,"G":15,"C":21,"-":43,")":20,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2019":104,"\u2018":104,"\u2014":43,"\u2013":43,"\u0178":74,"\u0161":10,"\u0153":26,"\u0152":21,"\u00ff":48,"\u00fd":48,"\u00fc":18,"\u00fb":18,"\u00fa":18,"\u00f9":18,"\u00f6":26,"\u00f5":26,"\u00f4":26,"\u00f3":26,"\u00f2":26,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"q":16,"\\":63,"Q":21,"7":11,"\/":-20,"*":49,"'":104}},"\u00c5":{"d":"322,-193r-208,0r-46,182v-3,20,-38,11,-61,10r189,-694v0,-12,34,-10,43,-6r189,688v5,22,-32,12,-56,13xm127,-244r181,0r-76,-299r-14,-82r-28,137xm214,-774v-59,0,-87,-25,-87,-90v0,-63,34,-91,94,-91v62,0,86,24,86,90v0,61,-33,91,-93,91xm221,-914v-35,0,-51,15,-51,52v0,30,14,48,45,48v32,0,51,-17,50,-51v0,-35,-13,-49,-44,-49","w":436,"k":{"\"":104,"\u2212":43,"\u201d":104,"\u201c":104,"\u00f8":12,"\u00ab":21,"y":48,"w":44,"v":52,"u":11,"t":41,"s":10,"o":12,"f":21,"e":16,"d":11,"c":10,"b":10,"]":20,"Y":74,"W":52,"V":63,"T":58,"O":21,"G":15,"C":21,"-":43,")":20,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2019":104,"\u2018":104,"\u2014":43,"\u2013":43,"\u0178":74,"\u0161":10,"\u0153":26,"\u0152":21,"\u00ff":48,"\u00fd":48,"\u00fc":18,"\u00fb":18,"\u00fa":18,"\u00f9":18,"\u00f6":26,"\u00f5":26,"\u00f4":26,"\u00f3":26,"\u00f2":26,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"q":16,"\\":63,"Q":21,"7":11,"\/":-23,"*":49,"'":104}},"\u00c6":{"d":"592,-408v-2,30,5,45,-11,51r-164,0r0,306r197,0v-3,33,7,46,-12,51r-240,0r0,-193r-196,0r-87,182v-6,18,-39,12,-61,10r328,-688v2,-6,10,-11,18,-11r251,0v-2,32,6,45,-11,51r-187,0r0,241r175,0xm190,-244r172,0r0,-391r-85,210","w":642,"k":{"\"":-10,"\u2212":33,"\u201d":-10,"\u201c":-10,"\u00f8":20,"z":7,"y":17,"x":13,"w":17,"u":4,"o":20,"g":17,"e":16,"d":16,"c":10,"a":13,"-":33,"\u2019":-10,"\u2018":-10,"\u2014":33,"\u2013":33,"\u017e":7,"\u0161":13,"\u0153":20,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"r":4,"q":16,"0":10,"\/":-13,"'":-10}},"\u00c7":{"d":"239,123v4,-42,-42,-38,-72,-29r16,-84v-137,-19,-141,-162,-144,-327v-3,-147,16,-251,64,-329v29,-46,69,-63,130,-65v63,-3,113,33,83,84v-26,-26,-82,-43,-127,-20v-47,25,-69,79,-80,151v-20,129,-37,388,61,438v52,27,124,-5,149,-35v33,62,-35,101,-100,103r-10,50v39,-8,67,14,67,56v0,71,-66,91,-125,67v5,-16,2,-44,26,-31v25,14,66,7,62,-29","w":353,"k":{"\"":-3,"\u2212":85,"\u201e":-3,"\u201d":-3,"\u201c":-3,"\u00f8":23,"z":7,"y":71,"x":17,"w":61,"v":67,"u":21,"t":20,"o":23,"f":27,"e":21,"d":13,"c":13,"a":13,"S":10,"O":26,"G":18,"C":6,".":-3,"-":85,"\ufb04":27,"\ufb03":27,"\ufb02":27,"\ufb01":27,"\ufb00":27,"\u2039":31,"\u2026":-3,"\u201a":-3,"\u2019":-3,"\u2018":-3,"\u2014":85,"\u2013":85,"\u017e":7,"\u0161":13,"\u0160":10,"\u0153":23,"\u0152":26,"\u00ff":71,"\u00fd":71,"\u00fc":21,"\u00fb":21,"\u00fa":21,"\u00f9":21,"\u00f6":23,"\u00f5":23,"\u00f4":23,"\u00f3":23,"\u00f2":23,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":21,"\u00ea":21,"\u00e9":21,"\u00e8":21,"\u00e7":13,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"\u00d8":26,"\u00d6":26,"\u00d5":26,"\u00d4":26,"\u00d3":26,"\u00d2":26,"\u00c7":6,"q":13,"Q":26,"@":10,"0":28,"\/":-21,",":-3,"*":20,"'":-3,"\u00ab":31}},"\u00c8":{"d":"287,-408v-2,31,6,46,-12,51r-164,0r0,306r197,0v-3,33,7,46,-12,51r-239,0r0,-686v1,-7,5,-14,13,-14r239,0v-3,32,7,45,-10,51r-188,0r0,241r176,0xm227,-829v24,13,7,36,-7,46v-42,-28,-104,-74,-141,-106v4,-19,13,-55,36,-35","w":337,"k":{"\"":-10,"\u2212":33,"\u201d":-10,"\u201c":-10,"\u00f8":20,"z":7,"y":17,"x":13,"w":17,"u":4,"o":20,"e":16,"d":16,"c":10,"a":13,"-":33,"\u2019":-10,"\u2018":-10,"\u2014":33,"\u2013":33,"\u017e":7,"\u0161":13,"\u0153":20,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"r":4,"q":16,"0":10,"\/":-13,"'":-10}},"\u00c9":{"d":"287,-408v-2,31,6,46,-12,51r-164,0r0,306r197,0v-3,33,7,46,-12,51r-239,0r0,-686v1,-7,5,-14,13,-14r239,0v-3,32,7,45,-10,51r-188,0r0,241r176,0xm175,-778v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":337,"k":{"\"":-10,"\u2212":33,"\u201d":-10,"\u201c":-10,"\u00f8":20,"z":7,"y":17,"x":13,"w":17,"u":4,"o":20,"e":16,"d":16,"c":10,"a":13,"-":33,"\u2019":-10,"\u2018":-10,"\u2014":33,"\u2013":33,"\u017e":7,"\u0161":13,"\u0153":20,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"r":4,"q":16,"0":10,"\/":-13,"'":-10}},"\u00ca":{"d":"287,-408v-2,31,6,46,-12,51r-164,0r0,306r197,0v-3,33,7,46,-12,51r-239,0r0,-686v1,-7,5,-14,13,-14r239,0v-3,32,7,45,-10,51r-188,0r0,241r176,0xm194,-865v-27,31,-53,65,-85,85v-18,1,-31,-11,-38,-19r111,-114v13,-4,26,-1,33,7r82,87v17,21,22,19,2,33v-8,5,-17,7,-28,7v-24,-27,-56,-57,-77,-86","w":337,"k":{"\"":-10,"\u2212":33,"\u201d":-10,"\u201c":-10,"\u00f8":20,"\u00ab":21,"z":7,"y":17,"x":13,"w":17,"v":52,"u":4,"t":41,"s":10,"o":20,"f":21,"e":16,"d":16,"c":10,"b":10,"a":13,"Y":74,"W":52,"V":63,"T":58,"O":21,"G":15,"C":21,"-":33,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2019":-10,"\u2018":-10,"\u2014":33,"\u2013":33,"\u017e":7,"\u0178":74,"\u0161":13,"\u0153":20,"\u0152":21,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"r":4,"q":16,"\\":63,"Q":21,"7":11,"0":10,"\/":-26,"'":-10}},"\u00cb":{"d":"287,-408v-2,31,6,46,-12,51r-164,0r0,306r197,0v-3,33,7,46,-12,51r-239,0r0,-686v1,-7,5,-14,13,-14r239,0v-3,32,7,45,-10,51r-188,0r0,241r176,0xm124,-808v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm265,-808v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":337,"k":{"\"":-10,"\u2212":33,"\u201d":-10,"\u201c":-10,"\u00f8":20,"\u00ab":21,"z":7,"y":17,"x":13,"w":17,"v":52,"u":4,"t":41,"s":10,"o":20,"f":21,"e":16,"d":16,"c":10,"b":10,"a":13,"Y":74,"W":52,"V":63,"T":58,"O":21,"G":15,"C":21,"-":33,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2019":-10,"\u2018":-10,"\u2014":33,"\u2013":33,"\u017e":7,"\u0178":74,"\u0161":13,"\u0153":20,"\u0152":21,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"r":4,"q":16,"\\":63,"Q":21,"7":11,"0":10,"\/":-34,"'":-10}},"\u00cc":{"d":"110,-13v1,22,-35,10,-56,13r1,-688v6,-17,30,-10,55,-12r0,687xm116,-829v24,13,7,36,-7,46v-42,-28,-104,-74,-141,-106v4,-19,13,-55,36,-35","w":165,"k":{"\/":-20}},"\u00cd":{"d":"110,-13v1,22,-35,10,-56,13r1,-688v6,-17,30,-10,55,-12r0,687xm63,-778v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":165,"k":{"]":-6,")":-6,"\/":-20}},"\u00ce":{"d":"110,-13v1,22,-35,10,-56,13r1,-688v6,-17,30,-10,55,-12r0,687xm84,-865v-27,31,-53,65,-85,85v-18,1,-31,-11,-38,-19r111,-114v13,-4,26,-1,33,7r82,87v17,21,22,19,2,33v-8,5,-17,7,-28,7v-24,-27,-56,-57,-77,-86","w":165,"k":{"\"":-49,"\u201d":-49,"\u201c":-49,"]":-56,")":-56,"\u2019":-49,"\u2018":-49,"\/":-20,"'":-49}},"\u00cf":{"d":"110,-13v1,22,-35,10,-56,13r1,-688v6,-17,30,-10,55,-12r0,687xm14,-808v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm155,-808v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":165,"k":{"\"":-10,"\u201d":-10,"\u201c":-10,"]":-19,")":-19,"\u2019":-10,"\u2018":-10,"\/":-20,"'":-10}},"\u00d1":{"d":"346,-686v-2,-23,34,-11,55,-14r0,687v0,22,-32,10,-51,13r-152,-355r-93,-239r4,581v1,22,-34,10,-54,13r0,-686v-1,-23,33,-11,52,-14r244,592r-5,-341r0,-237xm206,-832v-35,-28,-65,20,-84,36v-16,-2,-21,-17,-29,-28v25,-44,50,-66,102,-68v46,-2,46,50,91,51v33,0,47,-20,61,-38v14,-18,27,9,31,25v-16,50,-110,95,-155,40","w":456,"k":{"\"":4,"\u201d":4,"\u201c":4,"\u00f8":12,"\u00ab":21,"y":48,"w":44,"v":52,"u":11,"t":41,"s":10,"o":12,"f":21,"e":16,"d":11,"c":10,"b":10,"Y":74,"W":52,"V":63,"T":58,"O":21,"G":15,"C":21,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2019":4,"\u2018":4,"\u2014":11,"\u2013":11,"\u0178":74,"\u0161":10,"\u0153":12,"\u0152":21,"\u00ff":48,"\u00fd":48,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"q":16,"\\":63,"Q":21,"7":11,"\/":-34,"'":4}},"\u00d2":{"d":"408,-356v0,190,-10,366,-189,366v-180,0,-181,-178,-181,-365v0,-186,17,-355,192,-355v175,0,178,171,178,354xm170,-638v-87,66,-77,287,-64,435v8,85,28,156,115,156v134,0,128,-163,128,-310v0,-122,-1,-231,-65,-281v-29,-23,-84,-23,-114,0xm265,-829v24,13,7,36,-7,46v-42,-28,-104,-74,-141,-106v4,-19,13,-55,36,-35","w":446,"k":{"\"":10,"\u201e":39,"\u201d":10,"\u201c":10,"x":22,"c":10,"]":20,"Y":19,"X":23,"W":16,"V":5,"T":26,"Q":5,"O":5,"J":31,"A":24,".":39,")":20,"\u2026":39,"\u201a":39,"\u2019":10,"\u2018":10,"\u017d":24,"\u0178":19,"\u0160":24,"\u0152":5,"\u00e7":10,"\u00dd":19,"\u00dc":24,"\u00db":24,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"_":50,",":39,"*":13,"'":10}},"\u00d3":{"d":"408,-356v0,190,-10,366,-189,366v-180,0,-181,-178,-181,-365v0,-186,17,-355,192,-355v175,0,178,171,178,354xm170,-638v-87,66,-77,287,-64,435v8,85,28,156,115,156v134,0,128,-163,128,-310v0,-122,-1,-231,-65,-281v-29,-23,-84,-23,-114,0xm213,-778v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":446,"k":{"\"":10,"\u201e":39,"\u201d":10,"\u201c":10,"x":22,"c":10,"]":20,"Y":19,"X":23,"W":16,"V":5,"T":26,"Q":5,"O":5,"J":31,"A":24,".":39,")":20,"\u2026":39,"\u201a":39,"\u2019":10,"\u2018":10,"\u017d":24,"\u0178":19,"\u0160":24,"\u0152":5,"\u00e7":10,"\u00dd":19,"\u00dc":24,"\u00db":24,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"_":50,",":39,"*":13,"'":10}},"\u00d4":{"d":"408,-356v0,190,-10,366,-189,366v-180,0,-181,-178,-181,-365v0,-186,17,-355,192,-355v175,0,178,171,178,354xm170,-638v-87,66,-77,287,-64,435v8,85,28,156,115,156v134,0,128,-163,128,-310v0,-122,-1,-231,-65,-281v-29,-23,-84,-23,-114,0xm232,-865v-27,31,-53,65,-85,85v-18,1,-31,-11,-38,-19r111,-114v13,-4,26,-1,33,7r82,87v17,21,22,19,2,33v-8,5,-17,7,-28,7v-24,-27,-56,-57,-77,-86","w":446,"k":{"\"":10,"\u201e":39,"\u201d":10,"\u201c":10,"\u00f8":12,"\u00ab":21,"y":48,"x":22,"w":44,"v":52,"u":11,"t":41,"s":10,"o":12,"f":21,"e":16,"d":11,"c":10,"b":10,"]":20,"Y":19,"X":23,"W":16,"V":5,"T":26,"O":5,"J":31,"G":15,"C":21,"A":24,".":39,")":20,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2026":39,"\u201a":39,"\u2019":10,"\u2018":10,"\u2014":11,"\u2013":11,"\u017d":24,"\u0178":19,"\u0161":10,"\u0160":24,"\u0153":12,"\u0152":5,"\u00ff":48,"\u00fd":48,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":19,"\u00dc":24,"\u00db":24,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c7":21,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"q":16,"_":50,"\\":63,"Q":5,"7":11,"\/":8,",":39,"*":13,"'":10}},"\u00d5":{"d":"408,-356v0,190,-10,366,-189,366v-180,0,-181,-178,-181,-365v0,-186,17,-355,192,-355v175,0,178,171,178,354xm170,-638v-87,66,-77,287,-64,435v8,85,28,156,115,156v134,0,128,-163,128,-310v0,-122,-1,-231,-65,-281v-29,-23,-84,-23,-114,0xm201,-832v-35,-28,-65,20,-84,36v-16,-2,-21,-17,-29,-28v25,-44,50,-66,102,-68v46,-2,46,50,91,51v33,0,47,-20,61,-38v14,-18,27,9,31,25v-16,50,-110,95,-155,40","w":446,"k":{"\"":10,"\u201e":39,"\u201d":10,"\u201c":10,"\u00f8":12,"\u00ab":21,"y":48,"x":22,"w":44,"v":52,"u":11,"t":41,"s":10,"o":12,"f":21,"e":16,"d":11,"c":10,"b":10,"]":20,"Y":19,"X":23,"W":16,"V":5,"T":26,"O":5,"J":31,"G":15,"C":21,"A":24,".":39,")":20,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2026":39,"\u201a":39,"\u2019":10,"\u2018":10,"\u2014":11,"\u2013":11,"\u017d":24,"\u0178":19,"\u0161":10,"\u0160":24,"\u0153":12,"\u0152":5,"\u00ff":48,"\u00fd":48,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":19,"\u00dc":24,"\u00db":24,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c7":21,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"q":16,"_":50,"\\":63,"Q":5,"7":11,"\/":13,",":39,"*":13,"'":10}},"\u00d6":{"d":"408,-356v0,190,-10,366,-189,366v-180,0,-181,-178,-181,-365v0,-186,17,-355,192,-355v175,0,178,171,178,354xm170,-638v-87,66,-77,287,-64,435v8,85,28,156,115,156v134,0,128,-163,128,-310v0,-122,-1,-231,-65,-281v-29,-23,-84,-23,-114,0xm162,-808v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm303,-808v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":446,"k":{"\"":10,"\u201e":39,"\u201d":10,"\u201c":10,"\u00f8":12,"\u00ab":21,"y":48,"x":22,"w":44,"v":52,"u":11,"t":41,"s":10,"o":12,"f":21,"e":16,"d":11,"c":10,"b":10,"]":20,"Y":19,"X":23,"W":16,"V":5,"T":26,"O":5,"J":31,"G":15,"C":21,"A":24,".":39,")":20,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2026":39,"\u201a":39,"\u2019":10,"\u2018":10,"\u2014":11,"\u2013":11,"\u017d":24,"\u0178":19,"\u0161":10,"\u0160":24,"\u0153":12,"\u0152":5,"\u00ff":48,"\u00fd":48,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":19,"\u00dc":24,"\u00db":24,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c7":21,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"q":16,"_":50,"\\":63,"Q":5,"7":11,"\/":3,",":39,"*":13,"'":10}},"\u00d7":{"d":"343,-176v-21,15,-22,37,-45,26r-83,-93r-82,93v-22,11,-24,-11,-45,-26r93,-105r-94,-107v20,-16,23,-34,45,-26r83,94r84,-94v23,-10,24,11,45,26r-95,107","k":{"\/":31}},"\u00d8":{"d":"229,10v-54,0,-92,-15,-119,-45r-21,51v-14,1,-48,-8,-33,-28r27,-67v-30,-71,-36,-163,-36,-276v0,-186,15,-355,190,-355v54,0,89,15,116,44r21,-53v19,3,42,5,34,29r-25,73v26,68,34,156,34,261v0,189,-10,366,-188,366xm284,-60v93,-59,76,-275,69,-424v-2,-35,-9,-65,-16,-88r-186,491v25,38,92,47,133,21xm314,-619v-22,-38,-95,-48,-134,-19v-87,65,-75,275,-67,424v2,35,9,64,16,87","w":464,"k":{"\"":10,"\u2212":11,"\u201e":39,"\u201d":10,"\u201c":10,"z":11,"y":11,"x":22,"w":11,"u":7,"t":7,"s":7,"p":7,"h":4,"g":11,"e":11,"d":11,"c":10,"a":19,"]":20,"Y":19,"X":23,"W":16,"V":5,"T":26,"Q":5,"O":5,"J":31,"A":24,".":39,"-":11,")":20,"\u2026":39,"\u201a":39,"\u2019":10,"\u2018":10,"\u2014":11,"\u2013":11,"\u017e":21,"\u017d":24,"\u0178":19,"\u0161":17,"\u0160":24,"\u0152":5,"\u00ff":21,"\u00fd":11,"\u00fc":17,"\u00fb":17,"\u00fa":7,"\u00f9":7,"\u00f6":19,"\u00f5":19,"\u00f4":19,"\u00f1":19,"\u00ef":19,"\u00ee":19,"\u00eb":21,"\u00ea":21,"\u00e9":11,"\u00e8":11,"\u00e7":10,"\u00e6":19,"\u00e5":19,"\u00e4":19,"\u00e3":19,"\u00e2":19,"\u00e1":19,"\u00e0":19,"\u00dd":19,"\u00dc":24,"\u00db":24,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"r":11,"q":7,"k":4,"_":50,"0":8,",":39,"*":13,"'":10}},"\u00d9":{"d":"55,-686v-2,-23,35,-11,56,-14r0,487v-1,101,22,171,125,171v39,0,89,-9,112,-21r0,-624v-1,-22,35,-10,56,-13r0,675v-33,20,-107,35,-168,35v-142,0,-181,-85,-181,-225r0,-471xm268,-829v24,13,7,36,-7,46v-42,-28,-104,-74,-141,-106v4,-19,13,-55,36,-35","w":458},"\u00da":{"d":"55,-686v-2,-23,35,-11,56,-14r0,487v-1,101,22,171,125,171v39,0,89,-9,112,-21r0,-624v-1,-22,35,-10,56,-13r0,675v-33,20,-107,35,-168,35v-142,0,-181,-85,-181,-225r0,-471xm216,-778v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":458},"\u00db":{"d":"55,-686v-2,-23,35,-11,56,-14r0,487v-1,101,22,171,125,171v39,0,89,-9,112,-21r0,-624v-1,-22,35,-10,56,-13r0,675v-33,20,-107,35,-168,35v-142,0,-181,-85,-181,-225r0,-471xm235,-865v-27,31,-53,65,-85,85v-18,1,-31,-11,-38,-19r111,-114v13,-4,26,-1,33,7r82,87v17,21,22,19,2,33v-8,5,-17,7,-28,7v-24,-27,-56,-57,-77,-86","w":458,"k":{"\"":11,"\u201d":11,"\u201c":11,"\u00f8":12,"\u00ab":21,"y":48,"w":44,"v":52,"u":11,"t":41,"s":10,"o":12,"f":21,"e":16,"d":11,"c":10,"b":10,"Y":74,"W":52,"V":63,"T":58,"O":21,"G":15,"C":21,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2019":11,"\u2018":11,"\u2014":11,"\u2013":11,"\u0178":74,"\u0161":10,"\u0153":12,"\u0152":21,"\u00ff":48,"\u00fd":48,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"q":16,"\\":63,"Q":21,"7":11,"\/":-25,"'":11}},"\u00dc":{"d":"55,-686v-2,-23,35,-11,56,-14r0,487v-1,101,22,171,125,171v39,0,89,-9,112,-21r0,-624v-1,-22,35,-10,56,-13r0,675v-33,20,-107,35,-168,35v-142,0,-181,-85,-181,-225r0,-471xm165,-808v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm306,-808v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":458,"k":{"\"":18,"\u201d":18,"\u201c":18,"\u00f8":12,"\u00ab":21,"y":48,"w":44,"v":52,"u":11,"t":41,"s":10,"o":12,"f":21,"e":16,"d":11,"c":10,"b":10,"Y":74,"W":52,"V":63,"T":58,"O":21,"G":15,"C":21,"\ufb04":21,"\ufb03":21,"\ufb02":21,"\ufb01":21,"\ufb00":21,"\u2122":41,"\u2039":20,"\u2019":18,"\u2018":18,"\u2014":11,"\u2013":11,"\u0178":74,"\u0161":10,"\u0153":12,"\u0152":21,"\u00ff":48,"\u00fd":48,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"q":16,"\\":63,"Q":21,"7":11,"\/":-20,"'":18}},"\u00dd":{"d":"210,-13v2,22,-34,10,-55,13r0,-284r-149,-412v11,-8,42,-3,62,-4r90,274r26,91v31,-124,75,-244,114,-361v11,-7,40,-3,58,-4r-146,414r0,273xm165,-778v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":361,"k":{"\"":-20,"\u2212":67,"\u201e":54,"\u201d":-20,"\u201c":-20,"\u00f8":62,"\u00c6":74,"z":53,"y":49,"x":43,"w":41,"v":40,"u":63,"t":32,"s":68,"p":70,"o":62,"n":71,"j":24,"i":7,"g":65,"f":24,"e":73,"d":78,"c":62,"a":61,"S":4,"O":19,"J":78,"G":26,"C":24,"A":74,";":50,":":50,".":54,"-":67,"\ufb04":24,"\ufb03":24,"\ufb02":24,"\ufb01":24,"\ufb00":24,"\u203a":42,"\u2039":60,"\u2026":54,"\u201a":54,"\u2019":-20,"\u2018":-20,"\u2014":67,"\u2013":67,"\u017e":53,"\u017d":74,"\u0161":68,"\u0160":4,"\u0153":62,"\u0152":19,"\u0131":7,"\u00ff":49,"\u00fd":49,"\u00fc":63,"\u00fb":63,"\u00fa":63,"\u00f9":63,"\u00f6":62,"\u00f5":62,"\u00f4":62,"\u00f3":62,"\u00f2":62,"\u00f1":71,"\u00ef":7,"\u00ee":7,"\u00ed":7,"\u00ec":7,"\u00eb":73,"\u00ea":73,"\u00e9":73,"\u00e8":73,"\u00e7":62,"\u00e6":61,"\u00e5":61,"\u00e4":61,"\u00e3":61,"\u00e2":61,"\u00e1":61,"\u00e0":61,"\u00dc":74,"\u00db":74,"\u00d8":19,"\u00d6":19,"\u00d5":19,"\u00d4":19,"\u00d3":19,"\u00d2":19,"\u00d1":74,"\u00cb":74,"\u00ca":74,"\u00c7":24,"\u00c5":74,"\u00c4":74,"\u00c3":74,"\u00c2":74,"\u00c1":74,"\u00c0":74,"r":71,"q":78,"m":71,"_":75,"Q":19,"@":8,"0":47,"\/":45,",":54,"'":-20,"\u00ab":60,"\u00bb":42}},"\u00df":{"d":"49,-1v5,-15,9,-31,9,-53r-1,-495v-2,-107,57,-155,157,-155v110,0,194,43,194,142v0,95,-115,83,-128,166v15,71,92,91,130,142v22,31,46,66,46,118v1,92,-59,145,-150,145v-55,0,-106,-15,-118,-43v-1,-15,10,-31,15,-38v52,51,203,42,194,-62v-10,-114,-118,-136,-163,-214v-9,-14,-13,-28,-13,-45v0,-94,118,-87,129,-169v-6,-64,-60,-91,-132,-91v-83,0,-105,45,-106,136r1,489v8,41,-42,44,-64,27","w":470,"k":{"]":4,")":4,"\/":-15}},"\u00e0":{"d":"267,-378v14,-118,-161,-77,-223,-54v-8,-16,-13,-41,0,-52v31,-16,101,-27,157,-26v84,1,120,33,120,121r-5,363v-31,18,-77,36,-136,36v-101,0,-144,-45,-144,-149v0,-109,44,-164,149,-163v28,0,62,3,82,12r0,-88xm93,-141v0,108,100,125,169,81r5,-189v-16,-6,-44,-10,-65,-10v-78,-2,-109,37,-109,118xm218,-629v24,13,7,36,-7,46v-42,-28,-104,-74,-141,-106v4,-19,13,-55,36,-35","w":367,"k":{"\"":84,"\u201d":84,"\u201c":84,"y":8,"x":7,"t":23,"f":9,"]":27,")":27,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":84,"\u2018":84,"\u00ff":8,"\u00fd":8,"'":84}},"\u00e1":{"d":"267,-378v14,-118,-161,-77,-223,-54v-8,-16,-13,-41,0,-52v31,-16,101,-27,157,-26v84,1,120,33,120,121r-5,363v-31,18,-77,36,-136,36v-101,0,-144,-45,-144,-149v0,-109,44,-164,149,-163v28,0,62,3,82,12r0,-88xm93,-141v0,108,100,125,169,81r5,-189v-16,-6,-44,-10,-65,-10v-78,-2,-109,37,-109,118xm167,-578v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":367,"k":{"\"":84,"\u201d":84,"\u201c":84,"y":8,"x":7,"t":23,"f":9,"]":27,")":27,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":84,"\u2018":84,"\u00ff":8,"\u00fd":8,"'":84}},"\u00e2":{"d":"267,-378v14,-118,-161,-77,-223,-54v-8,-16,-13,-41,0,-52v31,-16,101,-27,157,-26v84,1,120,33,120,121r-5,363v-31,18,-77,36,-136,36v-101,0,-144,-45,-144,-149v0,-109,44,-164,149,-163v28,0,62,3,82,12r0,-88xm93,-141v0,108,100,125,169,81r5,-189v-16,-6,-44,-10,-65,-10v-78,-2,-109,37,-109,118xm186,-665v-27,31,-53,65,-85,85v-18,1,-31,-11,-38,-19r111,-114v13,-4,26,-1,33,7r82,87v17,21,22,19,2,33v-8,5,-17,7,-28,7v-24,-27,-56,-57,-77,-86","w":367,"k":{"\"":84,"\u201d":84,"\u201c":84,"y":8,"x":7,"t":23,"f":9,"]":27,")":27,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":84,"\u2018":84,"\u00ff":8,"\u00fd":8,"'":84}},"\u00e3":{"d":"267,-378v14,-118,-161,-77,-223,-54v-8,-16,-13,-41,0,-52v31,-16,101,-27,157,-26v84,1,120,33,120,121r-5,363v-31,18,-77,36,-136,36v-101,0,-144,-45,-144,-149v0,-109,44,-164,149,-163v28,0,62,3,82,12r0,-88xm93,-141v0,108,100,125,169,81r5,-189v-16,-6,-44,-10,-65,-10v-78,-2,-109,37,-109,118xm155,-632v-35,-28,-65,20,-84,36v-16,-2,-21,-17,-29,-28v25,-44,50,-66,102,-68v46,-2,46,50,91,51v33,0,47,-20,61,-38v14,-18,27,9,31,25v-16,50,-110,95,-155,40","w":367,"k":{"\"":84,"\u201d":84,"\u201c":84,"y":8,"x":7,"f":9,"]":27,")":27,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":84,"\u2018":84,"\u00ff":8,"\u00fd":8,"'":84,"t":23}},"\u00e4":{"d":"267,-378v14,-118,-161,-77,-223,-54v-8,-16,-13,-41,0,-52v31,-16,101,-27,157,-26v84,1,120,33,120,121r-5,363v-31,18,-77,36,-136,36v-101,0,-144,-45,-144,-149v0,-109,44,-164,149,-163v28,0,62,3,82,12r0,-88xm93,-141v0,108,100,125,169,81r5,-189v-16,-6,-44,-10,-65,-10v-78,-2,-109,37,-109,118xm116,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm257,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":367,"k":{"\"":84,"\u201d":84,"\u201c":84,"y":8,"x":7,"t":23,"f":9,"]":27,")":27,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":84,"\u2018":84,"\u00ff":8,"\u00fd":8,"'":84}},"\u00e5":{"d":"267,-378v14,-118,-161,-77,-223,-54v-8,-16,-13,-41,0,-52v31,-16,101,-27,157,-26v84,1,120,33,120,121r-5,363v-31,18,-77,36,-136,36v-101,0,-144,-45,-144,-149v0,-109,44,-164,149,-163v28,0,62,3,82,12r0,-88xm93,-141v0,108,100,125,169,81r5,-189v-16,-6,-44,-10,-65,-10v-78,-2,-109,37,-109,118xm182,-574v-59,0,-87,-25,-87,-90v0,-63,34,-91,94,-91v62,0,86,24,86,90v0,61,-33,91,-93,91xm189,-714v-35,0,-51,15,-51,52v0,30,14,48,45,48v32,0,51,-17,50,-51v0,-35,-13,-49,-44,-49","w":367,"k":{"\"":84,"\u201d":84,"\u201c":84,"y":8,"x":7,"t":23,"f":9,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":84,"\u2018":84,"\u00ff":8,"\u00fd":8,"'":84,")":27,"]":27}},"\u00e6":{"d":"47,-431v-9,-13,-11,-44,2,-52v32,-19,88,-28,152,-27v66,1,98,21,109,79v24,-52,65,-79,139,-79v138,0,137,154,116,278v-74,13,-177,6,-239,-8v0,110,5,198,113,195v50,-2,94,-12,124,-34v3,16,17,51,-4,61v-64,29,-207,46,-245,-20r0,17v-32,17,-75,30,-134,30v-103,0,-144,-46,-144,-151v0,-109,44,-167,148,-167v29,0,62,3,83,12r0,-84v11,-114,-161,-82,-220,-50xm187,-38v28,0,67,-8,80,-21r0,-197v-16,-6,-44,-10,-65,-10v-79,-2,-109,43,-109,125v0,71,24,103,94,103xm517,-274v6,-83,17,-190,-73,-186v-91,4,-107,81,-116,174v48,11,129,23,189,12","w":620,"k":{"\"":60,"\u201d":60,"\u201c":60,"z":7,"y":8,"x":4,"t":7,"f":9,"]":20,")":20,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":60,"\u2018":60,"\u017e":7,"\u00ff":8,"\u00fd":8,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\/":-10,"'":60,"w":2,"e":10}},"\u00e7":{"d":"220,-510v50,-2,104,22,77,73v-39,-29,-130,-35,-160,13v-27,44,-42,104,-41,188v2,107,8,194,109,196v38,1,73,-14,92,-30v28,57,-37,75,-90,79r-10,51v39,-8,67,14,67,56v0,71,-66,91,-125,67v5,-16,2,-44,26,-31v25,14,66,7,62,-29v4,-42,-42,-38,-72,-29r16,-85v-118,-9,-131,-115,-131,-248v0,-158,35,-268,180,-271","w":331,"k":{"\"":49,"\u2212":44,"\u201d":49,"\u201c":49,"\u00f8":9,"y":-2,"w":-2,"t":-3,"o":9,"e":15,"d":16,"c":16,"]":4,"-":44,")":4,"\u2039":33,"\u2019":49,"\u2018":49,"\u2014":44,"\u2013":44,"\u0153":9,"\u00ff":-2,"\u00fd":-2,"\u00f6":9,"\u00f5":9,"\u00f4":9,"\u00f3":9,"\u00f2":9,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":16,"q":16,"\/":-20,"'":49,"\u00ab":33}},"\u00e8":{"d":"202,10v-136,4,-164,-93,-164,-233v0,-163,27,-281,179,-287v136,-5,138,154,116,278v-71,14,-157,18,-239,18v0,102,18,172,117,170v48,0,92,-13,120,-34v5,11,7,26,7,39v-16,41,-80,47,-136,49xm285,-274v6,-83,16,-190,-73,-186v-99,5,-110,94,-117,200r89,-2v34,-2,72,-5,101,-12xm242,-629v24,13,7,36,-7,46v-42,-28,-104,-74,-141,-106v4,-19,13,-55,36,-35","w":375,"k":{"\"":60,"\u201d":60,"\u201c":60,"e":10,"]":20,")":20,"\u2019":60,"\u2018":60,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\/":-20,"'":60,"t":7,"w":2,"x":4}},"\u00e9":{"d":"202,10v-136,4,-164,-93,-164,-233v0,-163,27,-281,179,-287v136,-5,138,154,116,278v-71,14,-157,18,-239,18v0,102,18,172,117,170v48,0,92,-13,120,-34v5,11,7,26,7,39v-16,41,-80,47,-136,49xm285,-274v6,-83,16,-190,-73,-186v-99,5,-110,94,-117,200r89,-2v34,-2,72,-5,101,-12xm191,-578v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":375,"k":{"\"":60,"\u201d":60,"\u201c":60,"x":4,"w":2,"t":7,"e":10,"]":20,")":20,"\u2019":60,"\u2018":60,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\/":-20,"'":60}},"\u00ea":{"d":"202,10v-136,4,-164,-93,-164,-233v0,-163,27,-281,179,-287v136,-5,138,154,116,278v-71,14,-157,18,-239,18v0,102,18,172,117,170v48,0,92,-13,120,-34v5,11,7,26,7,39v-16,41,-80,47,-136,49xm285,-274v6,-83,16,-190,-73,-186v-99,5,-110,94,-117,200r89,-2v34,-2,72,-5,101,-12xm210,-665v-27,31,-53,65,-85,85v-18,1,-31,-11,-38,-19r111,-114v13,-4,26,-1,33,7r82,87v17,21,22,19,2,33v-8,5,-17,7,-28,7v-24,-27,-56,-57,-77,-86","w":375,"k":{"\"":60,"\u201d":60,"\u201c":60,"y":8,"x":4,"w":2,"t":7,"e":10,"]":20,")":20,"\u2019":60,"\u2018":60,"\u00ff":8,"\u00fd":8,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\/":-20,"'":60}},"\u00eb":{"d":"202,10v-136,4,-164,-93,-164,-233v0,-163,27,-281,179,-287v136,-5,138,154,116,278v-71,14,-157,18,-239,18v0,102,18,172,117,170v48,0,92,-13,120,-34v5,11,7,26,7,39v-16,41,-80,47,-136,49xm285,-274v6,-83,16,-190,-73,-186v-99,5,-110,94,-117,200r89,-2v34,-2,72,-5,101,-12xm140,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm281,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":375,"k":{"\"":60,"\u201d":60,"\u201c":60,"y":8,"x":4,"w":2,"t":7,"e":10,"]":20,")":20,"\u2019":60,"\u2018":60,"\u00ff":8,"\u00fd":8,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\/":-20,"'":60}},"\u00ec":{"d":"114,-13v1,22,-35,10,-57,13r0,-473v2,-33,20,-25,57,-27r0,487xm120,-629v24,13,7,36,-7,46v-42,-28,-104,-74,-141,-106v4,-19,13,-55,36,-35","w":171,"k":{"\"":8,"\u201d":8,"\u201c":8,"]":23,")":23,"\u2019":8,"\u2018":8,"\/":-23,"'":8}},"\u00ed":{"d":"114,-13v1,22,-35,10,-57,13r0,-473v2,-33,20,-25,57,-27r0,487xm67,-578v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":171,"k":{"\"":-41,"\u201d":-41,"\u201c":-41,"k":-3,"h":-3,"]":-7,")":-7,"\u2019":-41,"\u2018":-41,"\/":-23,"'":-41}},"\u00ee":{"d":"114,-13v1,22,-35,10,-57,13r0,-473v2,-33,20,-25,57,-27r0,487xm87,-665v-27,31,-53,65,-85,85v-18,1,-31,-11,-38,-19r111,-114v13,-4,26,-1,33,7r82,87v17,21,22,19,2,33v-8,5,-17,7,-28,7v-24,-27,-56,-57,-77,-86","w":171,"k":{"\"":-44,"\u201d":-44,"\u201c":-44,"y":8,"x":7,"k":-7,"h":-7,"\u2019":-44,"\u2018":-44,"\u00ff":8,"\u00fd":8,"\/":-23,"'":-44}},"\u00ef":{"d":"114,-13v1,22,-35,10,-57,13r0,-473v2,-33,20,-25,57,-27r0,487xm17,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm158,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":171,"k":{"\"":-53,"\u201d":-53,"\u201c":-53,"y":8,"x":7,"k":-10,"h":-10,"]":-7,")":-7,"\u2019":-53,"\u2018":-53,"\u00ff":8,"\u00fd":8,"\/":-23,"'":-53}},"\u00f1":{"d":"110,-13v1,22,-34,10,-55,13r0,-475v43,-18,103,-35,162,-35v97,0,137,40,137,137r0,360v1,22,-35,10,-56,13r0,-358v1,-66,-16,-106,-83,-103v-34,0,-81,9,-105,23r0,425xm182,-632v-35,-28,-65,20,-84,36v-16,-2,-21,-17,-29,-28v25,-44,50,-66,102,-68v46,-2,46,50,91,51v33,0,47,-20,61,-38v14,-18,27,9,31,25v-16,50,-110,95,-155,40","w":401,"k":{"\"":91,"\u201d":91,"\u201c":91,"y":8,"x":7,"]":33,")":33,"\u2019":91,"\u2018":91,"\u00ff":8,"\u00fd":8,"\/":-31,"'":91}},"\u00f2":{"d":"187,10v-143,5,-154,-111,-156,-259v-1,-156,39,-261,167,-261v139,0,154,115,155,260v1,153,-38,256,-166,260xm196,-461v-100,0,-106,106,-106,216v0,107,0,207,99,207v96,0,105,-107,105,-214v0,-107,1,-209,-98,-209xm230,-629v24,13,7,36,-7,46v-42,-28,-104,-74,-141,-106v4,-19,13,-55,36,-35","w":383,"k":{"\"":73,"\u201e":20,"\u201d":73,"\u201c":73,"z":4,"y":20,"x":27,"w":10,"v":10,"t":17,"f":10,"a":10,"]":37,".":20,")":37,"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":73,"\u2018":73,"\u017e":4,"\u0161":10,"\u00ff":20,"\u00fd":20,"\u00fc":10,"\u00fb":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":10,"\u00ea":10,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"k":17,"_":42,"\/":-15,",":20,"*":10,"'":73}},"\u00f3":{"d":"187,10v-143,5,-154,-111,-156,-259v-1,-156,39,-261,167,-261v139,0,154,115,155,260v1,153,-38,256,-166,260xm196,-461v-100,0,-106,106,-106,216v0,107,0,207,99,207v96,0,105,-107,105,-214v0,-107,1,-209,-98,-209xm178,-578v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":383,"k":{"\"":73,"\u201e":20,"\u201d":73,"\u201c":73,"z":4,"y":20,"x":27,"w":10,"v":10,"t":17,"f":10,"a":10,"]":37,".":20,")":37,"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":73,"\u2018":73,"\u017e":4,"\u0161":10,"\u00ff":20,"\u00fd":20,"\u00fc":10,"\u00fb":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":10,"\u00ea":10,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"k":17,"_":42,"\/":-15,",":20,"*":10,"'":73}},"\u00f4":{"d":"187,10v-143,5,-154,-111,-156,-259v-1,-156,39,-261,167,-261v139,0,154,115,155,260v1,153,-38,256,-166,260xm196,-461v-100,0,-106,106,-106,216v0,107,0,207,99,207v96,0,105,-107,105,-214v0,-107,1,-209,-98,-209xm197,-665v-27,31,-53,65,-85,85v-18,1,-31,-11,-38,-19r111,-114v13,-4,26,-1,33,7r82,87v17,21,22,19,2,33v-8,5,-17,7,-28,7v-24,-27,-56,-57,-77,-86","w":383,"k":{"\"":73,"\u201e":20,"\u201d":73,"\u201c":73,"z":4,"y":20,"x":27,"w":10,"v":10,"t":17,"f":10,"a":10,"]":37,".":20,")":37,"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":73,"\u2018":73,"\u017e":4,"\u0161":10,"\u00ff":20,"\u00fd":20,"\u00fc":10,"\u00fb":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":10,"\u00ea":10,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"k":17,"_":42,"\/":-15,",":20,"*":10,"'":73}},"\u00f5":{"d":"187,10v-143,5,-154,-111,-156,-259v-1,-156,39,-261,167,-261v139,0,154,115,155,260v1,153,-38,256,-166,260xm196,-461v-100,0,-106,106,-106,216v0,107,0,207,99,207v96,0,105,-107,105,-214v0,-107,1,-209,-98,-209xm166,-632v-35,-28,-65,20,-84,36v-16,-2,-21,-17,-29,-28v25,-44,50,-66,102,-68v46,-2,46,50,91,51v33,0,47,-20,61,-38v14,-18,27,9,31,25v-16,50,-110,95,-155,40","w":383,"k":{"\"":73,"\u201e":20,"\u201d":73,"\u201c":73,"z":4,"y":20,"x":27,"w":10,"v":10,"t":17,"f":10,"a":10,"]":37,".":20,")":37,"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":73,"\u2018":73,"\u017e":4,"\u0161":10,"\u00ff":20,"\u00fd":20,"\u00fc":10,"\u00fb":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":10,"\u00ea":10,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"k":17,"_":42,"\/":-15,",":20,"*":10,"'":73}},"\u00f6":{"d":"187,10v-143,5,-154,-111,-156,-259v-1,-156,39,-261,167,-261v139,0,154,115,155,260v1,153,-38,256,-166,260xm196,-461v-100,0,-106,106,-106,216v0,107,0,207,99,207v96,0,105,-107,105,-214v0,-107,1,-209,-98,-209xm127,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm268,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":383,"k":{"\"":73,"\u201e":20,"\u201d":73,"\u201c":73,"z":4,"y":20,"x":27,"w":10,"v":10,"t":17,"f":10,"a":10,"]":37,".":20,")":37,"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":73,"\u2018":73,"\u017e":4,"\u0161":10,"\u00ff":20,"\u00fd":20,"\u00fc":10,"\u00fb":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":10,"\u00ea":10,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"k":17,"_":42,"\/":-15,",":20,"*":10,"'":73}},"\u00f7":{"d":"392,-307v-2,29,6,50,-14,50r-336,0v2,-28,-5,-46,13,-50r337,0xm214,-99v-27,0,-39,-15,-39,-41v0,-23,15,-42,39,-42v26,0,40,18,40,42v0,22,-17,41,-40,41xm214,-376v-28,0,-39,-15,-39,-42v0,-23,15,-41,39,-41v26,0,40,17,40,41v0,23,-16,43,-40,42"},"\u00f8":{"d":"216,10v-58,0,-95,-11,-120,-48r-36,60v-12,-3,-46,-15,-27,-34r41,-71v-14,-47,-18,-99,-18,-166v0,-156,37,-261,165,-261v53,0,87,13,111,46v10,-18,27,-46,36,-58v16,5,40,13,28,34r-40,70v16,46,21,101,21,168v0,151,-37,260,-161,260xm213,-38v128,0,110,-212,95,-337r-172,290v15,33,35,47,77,47xm220,-461v-117,0,-107,155,-104,279v0,19,3,35,6,50r170,-289v-14,-27,-36,-40,-72,-40","w":424,"k":{"\"":73,"\u201d":73,"\u201c":73,"y":20,"x":27,"w":10,"t":17,"g":7,"f":10,"a":10,"]":37,")":37,"\ufb04":-7,"\ufb03":-7,"\ufb02":10,"\ufb01":10,"\ufb00":-7,"\u2026":20,"\u201a":20,"\u2019":73,"\u2018":73,"\u017e":4,"\u0161":10,"\u00ff":20,"\u00fd":20,"\u00fc":10,"\u00fb":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":10,"\u00ea":10,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"_":42,"\/":-15,",":20,"*":10,"'":73,"v":10,".":20,"\u201e":20,"z":4}},"\u00f9":{"d":"302,-486v-2,-23,34,-11,55,-14r0,475v-39,21,-96,34,-152,35v-117,3,-147,-63,-147,-179r0,-317v-3,-24,34,-11,56,-14r0,338v-2,80,16,127,96,123v32,-1,69,-7,92,-23r0,-424xm244,-629v24,13,7,36,-7,46v-42,-28,-104,-74,-141,-106v4,-19,13,-55,36,-35","w":416,"k":{"\"":63,"\u201d":63,"\u201c":63,"]":40,")":40,"\u2019":63,"\u2018":63,"\/":-21,"'":63}},"\u00fa":{"d":"302,-486v-2,-23,34,-11,55,-14r0,475v-39,21,-96,34,-152,35v-117,3,-147,-63,-147,-179r0,-317v-3,-24,34,-11,56,-14r0,338v-2,80,16,127,96,123v32,-1,69,-7,92,-23r0,-424xm192,-578v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":416,"k":{"\"":63,"\u201d":63,"\u201c":63,"]":40,")":40,"\u2019":63,"\u2018":63,"\/":-21,"'":63}},"\u00fb":{"d":"302,-486v-2,-23,34,-11,55,-14r0,475v-39,21,-96,34,-152,35v-117,3,-147,-63,-147,-179r0,-317v-3,-24,34,-11,56,-14r0,338v-2,80,16,127,96,123v32,-1,69,-7,92,-23r0,-424xm211,-665v-27,31,-53,65,-85,85v-18,1,-31,-11,-38,-19r111,-114v13,-4,26,-1,33,7r82,87v17,21,22,19,2,33v-8,5,-17,7,-28,7v-24,-27,-56,-57,-77,-86","w":416,"k":{"\"":63,"\u201d":63,"\u201c":63,"y":8,"x":7,"]":40,")":40,"\u2019":63,"\u2018":63,"\u00ff":8,"\u00fd":8,"\/":-21,"'":63}},"\u00fc":{"d":"302,-486v-2,-23,34,-11,55,-14r0,475v-39,21,-96,34,-152,35v-117,3,-147,-63,-147,-179r0,-317v-3,-24,34,-11,56,-14r0,338v-2,80,16,127,96,123v32,-1,69,-7,92,-23r0,-424xm141,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm282,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":416,"k":{"\"":63,"\u201d":63,"\u201c":63,"y":8,"x":7,"]":40,")":40,"\u2019":63,"\u2018":63,"\u00ff":8,"\u00fd":8,"\/":-21,"'":63}},"\u00fd":{"d":"11,131v37,16,86,23,113,-14v14,-20,28,-52,39,-101r-131,-508v9,-12,30,-6,54,-8r86,346r18,103v23,-156,61,-297,96,-441v10,-11,33,-6,57,-8r-132,531v-23,83,-41,162,-137,162v-43,0,-83,-6,-70,-47v2,-6,4,-12,7,-15xm173,-578v-13,-4,-16,-20,-22,-32r87,-80v20,-11,51,-60,67,-21v25,37,-28,51,-46,71","w":370,"k":{"\"":61,"\u2212":36,"\u201e":55,"\u201d":61,"\u201c":61,"z":13,"x":13,"u":17,"t":13,"s":10,"p":17,"o":20,"g":27,"e":23,"d":21,"c":20,"a":15,".":55,"-":36,"\u2039":25,"\u2026":55,"\u201a":55,"\u2019":61,"\u2018":61,"\u2014":36,"\u2013":36,"\u017e":13,"\u0161":10,"\u0153":20,"\u00ff":8,"\u00fc":17,"\u00fb":17,"\u00fa":17,"\u00f9":17,"\u00f8":20,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":8,"\u00ef":13,"\u00ee":13,"\u00eb":23,"\u00ea":23,"\u00e9":23,"\u00e8":23,"\u00e7":20,"\u00e6":15,"\u00e5":15,"\u00e4":15,"\u00e3":15,"\u00e2":15,"\u00e1":15,"\u00e0":15,"r":20,"q":21,"m":12,"k":17,"_":57,"\/":24,",":55,"'":61,")":41,"]":41,":":16,";":16}},"\u00ff":{"d":"11,131v37,16,86,23,113,-14v14,-20,28,-52,39,-101r-131,-508v9,-12,30,-6,54,-8r86,346r18,103v23,-156,61,-297,96,-441v10,-11,33,-6,57,-8r-132,531v-23,83,-41,162,-137,162v-43,0,-83,-6,-70,-47v2,-6,4,-12,7,-15xm122,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm263,-608v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":370,"k":{"\"":61,"\u2212":36,"\u201e":55,"\u201d":61,"\u201c":61,"z":13,"y":8,"x":13,"u":17,"t":13,"s":10,"p":17,"o":20,"g":27,"e":23,"d":21,"c":20,"a":15,"]":41,".":55,"-":36,")":41,"\u2039":25,"\u2026":55,"\u201a":55,"\u2019":61,"\u2018":61,"\u2014":36,"\u2013":36,"\u017e":13,"\u0161":10,"\u0153":20,"\u00ff":9,"\u00fd":8,"\u00fc":17,"\u00fb":17,"\u00fa":17,"\u00f9":17,"\u00f8":20,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":8,"\u00ef":13,"\u00ee":13,"\u00eb":23,"\u00ea":23,"\u00e9":23,"\u00e8":23,"\u00e7":20,"\u00e6":15,"\u00e5":15,"\u00e4":15,"\u00e3":15,"\u00e2":15,"\u00e1":15,"\u00e0":15,"r":20,"q":21,"m":12,"k":17,"_":57,"\/":24,",":55,"'":61,":":16,";":16}},"\u0131":{"d":"114,-13v1,22,-35,10,-57,13r0,-473v2,-33,20,-25,57,-27r0,487","w":171,"k":{"\/":-23}},"\u0152":{"d":"577,-408v-2,31,6,46,-12,51r-163,0r0,306r197,0v-3,34,7,46,-13,51r-232,0r0,-65v-27,48,-67,74,-136,74v-178,0,-182,-175,-182,-363v0,-186,16,-356,190,-356v65,0,102,21,128,65v2,-21,-8,-55,13,-55r233,0v-2,32,6,45,-11,51r-187,0r0,241r175,0xm170,-640v-87,68,-80,288,-66,438v8,86,28,158,115,158v133,0,122,-167,122,-313v0,-122,2,-231,-59,-284v-28,-24,-83,-21,-112,1","w":627,"k":{"\"":-10,"\u2212":33,"\u201e":39,"\u201d":-10,"\u201c":-10,"\u00f8":20,"z":7,"y":17,"x":13,"w":17,"u":4,"o":20,"g":10,"e":16,"d":16,"c":10,"a":13,"Y":19,"X":23,"W":16,"V":15,"T":26,"Q":5,"O":5,"J":31,"A":24,".":39,"-":33,"\u2026":39,"\u201a":39,"\u2019":-10,"\u2018":-10,"\u2014":33,"\u2013":33,"\u017e":7,"\u017d":24,"\u0178":19,"\u0161":13,"\u0160":24,"\u0153":20,"\u0152":5,"\u00ff":17,"\u00fd":17,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"\u00dd":19,"\u00dc":24,"\u00db":24,"\u00d8":5,"\u00d6":13,"\u00d5":13,"\u00d4":13,"\u00d3":5,"\u00d2":5,"\u00d1":24,"\u00cb":24,"\u00ca":24,"\u00c6":57,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"r":4,"q":16,"0":10,"\/":-13,",":39,"'":-10}},"\u0153":{"d":"198,10v-146,0,-160,-109,-161,-259v-1,-156,38,-261,166,-261v72,0,109,26,132,83v24,-56,70,-83,147,-83v138,0,137,154,116,278v-71,14,-157,18,-239,18v1,102,14,170,113,170v51,0,92,-11,124,-34v3,17,18,52,-4,62v-31,14,-77,26,-125,26v-75,1,-120,-23,-141,-78v-27,52,-70,78,-128,78xm202,-460v-100,0,-106,105,-106,215v0,107,0,207,99,207v96,0,105,-107,105,-214v0,-107,1,-208,-98,-208xm550,-274v6,-83,17,-190,-73,-186v-102,5,-110,93,-118,200r89,-2v34,-2,74,-5,102,-12","w":643,"k":{"\"":60,"\u201e":20,"\u201d":60,"\u201c":60,"z":17,"y":20,"x":4,"f":10,"a":10,"]":20,".":20,")":20,"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":60,"\u2018":60,"\u017e":17,"\u0161":10,"\u00ff":20,"\u00fd":20,"\u00fc":10,"\u00fb":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"k":4,"\/":-10,",":20,"'":60,"t":7,"w":2,"e":10}},"\u0160":{"d":"52,-504v-55,-108,26,-212,151,-206v65,3,114,7,126,44v0,12,-5,23,-15,33v-57,-42,-225,-41,-221,57v2,50,28,77,55,108v55,64,142,129,176,207v11,26,15,55,15,88v-1,116,-56,183,-174,183v-61,0,-117,-9,-132,-53v0,-16,7,-30,16,-39v25,22,60,36,112,36v132,0,145,-155,83,-234v-58,-74,-149,-140,-192,-224xm313,-902v-21,40,-71,98,-109,122v-43,-22,-90,-80,-123,-113v3,-9,16,-34,28,-34v34,21,67,65,96,94v27,-35,55,-65,85,-96v15,9,23,18,23,27","w":369,"k":{"\"":-8,"\u2212":-6,"\u201d":-8,"\u201c":-8,"\u00f8":12,"\u00ab":21,"y":36,"x":21,"w":33,"v":34,"u":11,"t":41,"s":10,"o":12,"f":30,"e":16,"d":11,"c":10,"b":10,"Y":74,"W":52,"V":63,"T":58,"O":21,"J":6,"G":15,"C":21,"-":-6,"\ufb04":30,"\ufb03":30,"\ufb02":30,"\ufb01":30,"\ufb00":30,"\u2122":41,"\u2039":20,"\u2019":-8,"\u2018":-8,"\u2014":-6,"\u2013":-6,"\u0178":74,"\u0161":10,"\u0153":12,"\u0152":21,"\u00ff":36,"\u00fd":36,"\u00fc":11,"\u00fb":11,"\u00fa":11,"\u00f9":11,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":10,"\u00e6":10,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"\u00c6":42,"q":16,"_":11,"\\":63,"Q":21,"7":11,"\/":-20,"'":-8}},"\u0161":{"d":"54,-344v-50,-97,41,-172,150,-166v59,3,112,9,127,50v0,10,-4,20,-13,31v-58,-54,-256,-44,-205,66v61,80,213,102,216,238v2,92,-68,135,-164,135v-69,0,-156,-16,-114,-77v59,38,221,46,217,-51v-2,-49,-23,-70,-56,-97v-49,-40,-131,-77,-158,-129xm315,-702v-21,40,-71,98,-109,122v-43,-22,-90,-80,-123,-113v3,-9,16,-34,28,-34v34,21,67,65,96,94v27,-35,55,-65,85,-96v15,9,23,18,23,27","w":368,"k":{"\"":55,"\u2212":44,"\u201d":55,"\u201c":55,"y":7,"x":4,"-":44,"\u2019":55,"\u2018":55,"\u2014":44,"\u2013":44,"\u00ff":7,"\u00fd":7,"\/":-15,"'":55,")":4,"]":4}},"\u0178":{"d":"210,-13v2,22,-34,10,-55,13r0,-284r-149,-412v11,-8,42,-3,62,-4r90,274r26,91v31,-124,75,-244,114,-361v11,-7,40,-3,58,-4r-146,414r0,273xm115,-808v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41xm256,-808v-27,0,-39,-15,-39,-41v0,-23,15,-41,39,-41v25,0,40,18,40,41v0,24,-16,41,-40,41","w":361,"k":{"\"":-20,"\u2212":67,"\u201e":54,"\u201d":-20,"\u201c":-20,"\u00f8":62,"\u00c6":74,"z":53,"y":49,"x":43,"w":41,"v":40,"u":63,"t":32,"s":68,"p":70,"o":62,"n":71,"j":24,"i":7,"g":65,"f":24,"e":73,"d":78,"c":62,"a":61,"S":4,"O":19,"J":78,"G":26,"C":24,"A":74,";":50,":":50,".":54,"-":67,"\ufb04":24,"\ufb03":24,"\ufb02":24,"\ufb01":24,"\ufb00":24,"\u203a":42,"\u2039":60,"\u2026":54,"\u201a":54,"\u2019":-20,"\u2018":-20,"\u2014":67,"\u2013":67,"\u017e":53,"\u017d":74,"\u0161":68,"\u0160":4,"\u0153":62,"\u0152":19,"\u0131":7,"\u00ff":49,"\u00fd":49,"\u00fc":63,"\u00fb":63,"\u00fa":63,"\u00f9":63,"\u00f6":62,"\u00f5":62,"\u00f4":62,"\u00f3":62,"\u00f2":62,"\u00f1":71,"\u00ef":7,"\u00ee":7,"\u00ed":7,"\u00ec":7,"\u00eb":73,"\u00ea":73,"\u00e9":73,"\u00e8":73,"\u00e7":62,"\u00e6":61,"\u00e5":61,"\u00e4":61,"\u00e3":61,"\u00e2":61,"\u00e1":61,"\u00e0":61,"\u00dc":74,"\u00db":74,"\u00d8":19,"\u00d6":19,"\u00d5":19,"\u00d4":19,"\u00d3":19,"\u00d2":19,"\u00d1":74,"\u00cb":74,"\u00ca":74,"\u00c7":24,"\u00c5":74,"\u00c4":74,"\u00c3":74,"\u00c2":74,"\u00c1":74,"\u00c0":74,"r":71,"q":78,"m":71,"_":75,"Q":19,"@":8,"0":47,"\/":44,",":54,"'":-20,"\u00ab":60,"\u00bb":42}},"\u017d":{"d":"84,-50v91,-3,197,7,278,-6v-3,20,10,56,-13,56r-317,0v-13,-9,-10,-33,-4,-49r275,-601r-253,2v2,-20,-8,-52,14,-52r298,0v10,13,8,31,0,47xm327,-902v-21,40,-71,98,-109,122v-43,-22,-90,-80,-123,-113v3,-9,16,-34,28,-34v34,21,67,65,96,94v27,-35,55,-65,85,-96v15,9,23,18,23,27","w":393,"k":{"\"":-7,"\u2212":103,"\u201d":-7,"\u201c":-7,"\u00f8":20,"\u00ab":16,"y":39,"x":20,"w":40,"v":52,"u":24,"t":23,"s":10,"p":7,"o":20,"g":15,"f":33,"e":29,"d":28,"c":21,"b":10,"a":15,"Y":74,"W":52,"V":63,"T":58,"O":21,"G":15,"C":21,"-":103,"\ufb04":33,"\ufb03":33,"\ufb02":33,"\ufb01":33,"\ufb00":33,"\u2122":41,"\u2039":16,"\u2019":-7,"\u2018":-7,"\u2014":103,"\u2013":103,"\u017e":15,"\u0178":74,"\u0161":16,"\u0153":20,"\u0152":21,"\u00ff":39,"\u00fd":39,"\u00fc":24,"\u00fb":24,"\u00fa":24,"\u00f9":24,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":15,"\u00ef":15,"\u00ee":15,"\u00eb":29,"\u00ea":29,"\u00e9":29,"\u00e8":29,"\u00e7":21,"\u00e6":15,"\u00e5":15,"\u00e4":15,"\u00e3":15,"\u00e2":15,"\u00e1":15,"\u00e0":15,"\u00dd":74,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":21,"r":24,"q":28,"\\":63,"Q":21,"7":11,"0":13,"\/":-19,"'":-7,")":17,"]":17}},"\u017e":{"d":"149,-452r-113,5v-4,-20,-5,-53,16,-53r276,0v9,11,7,34,-1,47r-233,401v78,-1,176,5,237,-8v0,25,8,60,-20,60r-272,0v-11,-11,-14,-34,-4,-50r235,-402r-121,0xm300,-702v-21,40,-71,98,-109,122v-43,-22,-90,-80,-123,-113v3,-9,16,-34,28,-34v34,21,67,65,96,94v27,-35,55,-65,85,-96v15,9,23,18,23,27","w":364,"k":{"\"":46,"\u2212":49,"\u201d":46,"\u201c":46,"y":13,"x":17,"w":13,"u":17,"t":13,"p":13,"o":10,"g":10,"e":17,"d":18,"c":15,"a":13,"]":27,"-":49,")":27,"\u2039":6,"\u2019":46,"\u2018":46,"\u2014":49,"\u2013":49,"\u017e":13,"\u0161":13,"\u0153":10,"\u00ff":13,"\u00fd":13,"\u00fc":17,"\u00fb":17,"\u00fa":17,"\u00f9":17,"\u00f8":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f3":10,"\u00f2":10,"\u00f1":13,"\u00ef":13,"\u00ee":13,"\u00eb":17,"\u00ea":17,"\u00e9":17,"\u00e8":17,"\u00e7":15,"\u00e6":13,"\u00e5":13,"\u00e4":13,"\u00e3":13,"\u00e2":13,"\u00e1":13,"\u00e0":13,"q":18,"m":17,"k":20,"'":46}},"\u017f":{"d":"52,-1v3,-18,8,-35,7,-58r0,-528v-1,-111,59,-149,165,-151v64,-2,147,24,102,82v-25,-19,-58,-34,-103,-33v-82,2,-109,35,-109,123r0,548v6,35,-44,30,-62,17","w":174,"k":{"!":-78,"\ufb04":31,"\ufb03":31,"\ufb02":31,"\ufb01":31,"\ufb00":31,"\u2122":-101,"\u2039":19,"\u2030":-24,"\u2026":44,"\u201a":44,"\u2019":-127,"\u2018":-127,"\u2014":48,"\u2013":48,"\u0153":14,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f8":14,"\u00f6":14,"\u00f5":14,"\u00f4":14,"\u00f3":14,"\u00f2":14,"\u00eb":18,"\u00ea":18,"\u00e9":18,"\u00e8":18,"\u00e7":15,"\u00ae":-62,"\u00a9":-63,"r":4,"q":18,"m":2,"_":52,"]":-114,"\\":-111,"?":-115,"8":-10,",":44,"*":-32,"'":-127,"&":-19,"d":18,"u":4,"w":-9,"c":15,"e":18,"o":14,"\"":-127,"-":48,"\u2212":48,"\u201c":-127,"\u201d":-127,"\u00ab":19,"b":-5,")":-114,".":44,"\u201e":44,"g":20,"p":18,"h":-6,"k":-6}},"\u02c6":{"d":"123,-665v-27,31,-53,65,-85,85v-18,1,-31,-11,-38,-19r111,-114v13,-4,26,-1,33,7r82,87v17,21,22,19,2,33v-8,5,-17,7,-28,7v-24,-27,-56,-57,-77,-86","w":241},"\u02c7":{"d":"232,-702v-21,40,-71,98,-109,122v-43,-22,-90,-80,-123,-113v3,-9,16,-34,28,-34v34,21,67,65,96,94v27,-35,55,-65,85,-96v15,9,23,18,23,27","w":232},"\u02d9":{"d":"31,-623v-24,-1,-30,-17,-30,-46v0,-31,11,-46,33,-46v25,1,31,17,31,45v0,31,-13,47,-34,47","w":65},"\u02da":{"d":"87,-574v-59,0,-87,-25,-87,-90v0,-63,34,-91,94,-91v62,0,86,24,86,90v0,61,-33,91,-93,91xm94,-714v-35,0,-51,15,-51,52v0,30,14,48,45,48v32,0,51,-17,50,-51v0,-35,-13,-49,-44,-49","w":180},"\u02dc":{"d":"113,-632v-35,-28,-65,20,-84,36v-16,-2,-21,-17,-29,-28v25,-44,50,-66,102,-68v46,-2,46,50,91,51v33,0,47,-20,61,-38v14,-18,27,9,31,25v-16,50,-110,95,-155,40","w":285},"\u2013":{"d":"393,-307v-2,29,6,50,-14,50r-336,0v2,-28,-5,-46,13,-50r337,0","w":436,"k":{"\u203a":55,"\u00bb":55,"z":84,"y":39,"x":90,"w":25,"v":28,"t":34,"f":34,"]":39,"Z":46,"Y":67,"X":67,"W":34,"V":43,"T":108,"S":107,"J":120,"A":36,")":39,"\ufb04":34,"\ufb03":34,"\ufb02":34,"\ufb01":34,"\ufb00":34,"\u017e":84,"\u017d":46,"\u0178":67,"\u0160":107,"\u00ff":39,"\u00fd":39,"\u00dd":67,"\u00dc":14,"\u00db":14,"\u00d6":14,"\u00d5":14,"\u00d4":14,"\u00d1":14,"\u00cb":14,"\u00ca":14,"\u00c6":36,"\u00c5":36,"\u00c4":36,"\u00c3":36,"\u00c2":36,"\u00c1":36,"\u00c0":36,"\\":81}},"\u2014":{"d":"694,-307v-2,29,6,50,-14,50r-674,0v2,-28,-5,-46,13,-50r675,0","w":700,"k":{"\u203a":55,"\u00bb":55,"z":84,"y":39,"x":90,"w":25,"v":28,"t":34,"f":34,"]":39,"Z":46,"Y":67,"X":67,"W":34,"V":43,"T":108,"S":107,"J":120,"A":36,")":39,"\ufb04":34,"\ufb03":34,"\ufb02":34,"\ufb01":34,"\ufb00":34,"\u017e":84,"\u017d":46,"\u0178":67,"\u0160":107,"\u00ff":39,"\u00fd":39,"\u00dd":67,"\u00dc":14,"\u00db":14,"\u00d6":14,"\u00d5":14,"\u00d4":14,"\u00d1":14,"\u00cb":14,"\u00ca":14,"\u00c6":36,"\u00c5":36,"\u00c4":36,"\u00c3":36,"\u00c2":36,"\u00c1":36,"\u00c0":36,"\\":81}},"\u2018":{"d":"121,-773v-17,30,-21,74,-23,113v33,17,24,83,-19,81v-73,-3,-34,-113,-17,-154v10,-25,20,-69,50,-53v4,3,8,7,9,13","w":159,"k":{"z":70,"y":73,"x":65,"w":68,"v":67,"u":76,"t":21,"s":96,"p":104,"o":92,"n":99,"g":112,"f":42,"e":100,"d":118,"c":102,"a":74,"]":-20,"[":78,"Y":-20,"W":-13,"V":-13,"T":-16,"O":20,"J":125,"G":34,"C":47,"A":115,")":-20,"(":78,"\ufb04":42,"\ufb03":42,"\ufb02":42,"\ufb01":42,"\ufb00":42,"\u20ac":112,"\u017e":70,"\u017d":8,"\u0178":-20,"\u0161":96,"\u0160":13,"\u0153":92,"\u0152":20,"\u00ff":73,"\u00fd":73,"\u00fc":76,"\u00fb":76,"\u00fa":76,"\u00f9":76,"\u00f8":92,"\u00f6":92,"\u00f5":92,"\u00f4":92,"\u00f3":92,"\u00f2":92,"\u00f1":99,"\u00ef":-45,"\u00ee":-43,"\u00ec":-50,"\u00eb":100,"\u00ea":100,"\u00e9":100,"\u00e8":100,"\u00e7":102,"\u00e6":74,"\u00e5":74,"\u00e4":74,"\u00e3":74,"\u00e2":74,"\u00e1":74,"\u00e0":74,"\u00dd":-20,"\u00dc":13,"\u00db":13,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00d1":9,"\u00cf":-10,"\u00ce":-37,"\u00cb":8,"\u00ca":3,"\u00c7":47,"\u00c6":115,"\u00c5":115,"\u00c4":115,"\u00c3":115,"\u00c2":115,"\u00c1":115,"\u00c0":115,"\u00bf":99,"\u00a2":30,"r":99,"q":118,"m":99,"\\":-34,"Q":20,"@":73,"?":-20,"9":39,"6":32,"4":94,"3":7,"2":15,"1":39,"0":46,"\/":105,"+":39}},"\u2019":{"d":"38,-592v17,-30,21,-74,23,-113v-33,-17,-23,-84,20,-81v71,4,34,114,17,154v-10,25,-22,70,-52,54v-4,-3,-7,-8,-8,-14","w":159,"k":{"z":70,"y":73,"x":65,"w":68,"v":67,"u":76,"t":21,"s":96,"p":104,"o":92,"n":99,"g":112,"f":42,"e":100,"d":118,"c":102,"a":74,"]":-20,"[":78,"Y":-20,"W":-13,"V":-13,"T":-16,"O":20,"J":125,"G":34,"C":47,"A":115,")":-20,"(":78,"\ufb04":42,"\ufb03":42,"\ufb02":42,"\ufb01":42,"\ufb00":42,"\u20ac":112,"\u017e":70,"\u017d":8,"\u0178":-20,"\u0161":96,"\u0160":13,"\u0153":92,"\u0152":20,"\u00ff":73,"\u00fd":73,"\u00fc":76,"\u00fb":76,"\u00fa":76,"\u00f9":76,"\u00f8":92,"\u00f6":92,"\u00f5":92,"\u00f4":92,"\u00f3":92,"\u00f2":92,"\u00f1":99,"\u00ef":-45,"\u00ee":-43,"\u00ec":-50,"\u00eb":100,"\u00ea":100,"\u00e9":100,"\u00e8":100,"\u00e7":102,"\u00e6":74,"\u00e5":74,"\u00e4":74,"\u00e3":74,"\u00e2":74,"\u00e1":74,"\u00e0":74,"\u00dd":-20,"\u00dc":13,"\u00db":13,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00d1":9,"\u00cf":-10,"\u00ce":-37,"\u00cb":8,"\u00ca":3,"\u00c7":47,"\u00c6":115,"\u00c5":115,"\u00c4":115,"\u00c3":115,"\u00c2":115,"\u00c1":115,"\u00c0":115,"\u00bf":99,"\u00a2":30,"r":99,"q":118,"m":99,"\\":-34,"Q":20,"@":73,"?":-20,"9":39,"6":32,"4":94,"3":7,"2":15,"1":39,"0":46,"\/":105,"+":39}},"\u201a":{"d":"38,94v17,-31,21,-74,23,-113v-33,-17,-24,-83,20,-81v71,4,34,114,17,154v-10,24,-22,70,-52,54v-4,-3,-7,-8,-8,-14","w":157,"k":{"\u00f8":20,"y":56,"w":40,"v":44,"u":27,"t":49,"o":20,"j":-98,"f":40,"e":20,"d":20,"c":13,"Y":54,"W":30,"V":48,"U":4,"T":86,"O":36,"G":11,"C":34,"\ufb04":40,"\ufb03":40,"\ufb02":40,"\ufb01":40,"\ufb00":40,"\u0178":54,"\u0153":20,"\u0152":36,"\u00ff":56,"\u00fd":56,"\u00fc":27,"\u00fb":27,"\u00fa":27,"\u00f9":27,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":13,"\u00dd":54,"\u00dc":4,"\u00db":4,"\u00da":4,"\u00d9":4,"\u00d8":36,"\u00d6":36,"\u00d5":36,"\u00d4":36,"\u00d3":36,"\u00d2":36,"\u00c7":34,"q":20,"\\":123,"Q":36}},"\u201c":{"d":"121,-773v-17,30,-21,74,-23,113v33,17,24,83,-19,81v-73,-3,-34,-113,-17,-154v10,-25,20,-69,50,-53v4,3,8,7,9,13xm260,-773v-17,30,-21,74,-23,113v31,17,23,83,-20,81v-72,-4,-35,-113,-17,-154v11,-25,22,-69,52,-53v4,3,7,7,8,13","w":298,"k":{"\ufb04":42,"\ufb03":42,"\ufb02":42,"\ufb01":42,"\ufb00":42,"\u20ac":112,"\u017e":70,"\u017d":8,"\u0178":-20,"\u0161":96,"\u0160":13,"\u0153":92,"\u0152":20,"\u00ff":73,"\u00fd":73,"\u00fc":76,"\u00fb":76,"\u00fa":76,"\u00f9":76,"\u00f8":92,"\u00f6":92,"\u00f5":92,"\u00f4":92,"\u00f3":92,"\u00f2":92,"\u00f1":99,"\u00ef":-45,"\u00ee":-43,"\u00ec":-50,"\u00eb":100,"\u00ea":100,"\u00e9":100,"\u00e8":100,"\u00e7":102,"\u00e6":74,"\u00e5":74,"\u00e4":74,"\u00e3":74,"\u00e2":74,"\u00e1":74,"\u00e0":74,"\u00dd":-20,"\u00dc":13,"\u00db":13,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00d1":9,"\u00cf":-10,"\u00ce":-37,"\u00cb":8,"\u00ca":3,"\u00c7":47,"\u00c6":115,"\u00c5":115,"\u00c4":115,"\u00c3":115,"\u00c2":115,"\u00c1":115,"\u00c0":115,"\u00bf":99,"\u00a2":30,"r":99,"q":118,"m":99,"\\":-34,"Q":20,"@":73,"?":-20,"9":39,"6":32,"4":94,"3":7,"2":15,"1":39,"0":46,"\/":105,"+":39,"C":47,"G":34,"T":-16,"V":-13,"W":-13,"Y":-20,"d":118,"f":42,"t":21,"u":76,"v":67,"w":68,"y":73,"c":102,"e":100,"o":92,"O":20,")":-20,"]":-20,"A":115,"J":125,"x":65,"a":74,"z":70,"g":112,"n":99,"p":104,"s":96,"(":78,"[":78}},"\u201d":{"d":"176,-592v17,-30,22,-74,24,-113v-33,-17,-23,-83,19,-81v71,3,35,114,17,154v-11,25,-20,70,-51,54v-5,-3,-8,-8,-9,-14xm38,-592v17,-30,21,-74,23,-113v-33,-17,-23,-84,20,-81v71,4,34,114,17,154v-10,25,-22,70,-52,54v-4,-3,-7,-8,-8,-14","w":298,"k":{"\ufb04":42,"\ufb03":42,"\ufb02":42,"\ufb01":42,"\ufb00":42,"\u20ac":112,"\u017e":70,"\u017d":8,"\u0178":-20,"\u0161":96,"\u0160":13,"\u0153":92,"\u0152":20,"\u00ff":73,"\u00fd":73,"\u00fc":76,"\u00fb":76,"\u00fa":76,"\u00f9":76,"\u00f8":92,"\u00f6":92,"\u00f5":92,"\u00f4":92,"\u00f3":92,"\u00f2":92,"\u00f1":99,"\u00ef":-45,"\u00ee":-43,"\u00ec":-50,"\u00eb":100,"\u00ea":100,"\u00e9":100,"\u00e8":100,"\u00e7":102,"\u00e6":74,"\u00e5":74,"\u00e4":74,"\u00e3":74,"\u00e2":74,"\u00e1":74,"\u00e0":74,"\u00dd":-20,"\u00dc":13,"\u00db":13,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00d1":9,"\u00cf":-10,"\u00ce":-37,"\u00cb":8,"\u00ca":3,"\u00c7":47,"\u00c6":115,"\u00c5":115,"\u00c4":115,"\u00c3":115,"\u00c2":115,"\u00c1":115,"\u00c0":115,"\u00bf":99,"\u00a2":30,"r":99,"q":118,"m":99,"\\":-34,"Q":20,"@":73,"?":-20,"9":39,"6":32,"4":94,"3":7,"2":15,"1":39,"0":46,"\/":105,"+":39,"C":47,"G":34,"T":-16,"V":-13,"W":-13,"Y":-20,"d":118,"f":42,"t":21,"u":76,"v":67,"w":68,"y":73,"c":102,"e":100,"o":92,"O":20,")":-20,"]":-20,"A":115,"J":125,"x":65,"a":74,"z":70,"g":112,"n":99,"p":104,"s":96,"(":78,"[":78}},"\u201e":{"d":"176,94v16,-31,22,-74,24,-113v-33,-17,-24,-83,19,-81v71,3,35,114,17,154v-11,24,-20,70,-51,54v-5,-3,-8,-8,-9,-14xm38,94v17,-31,21,-74,23,-113v-33,-17,-24,-83,20,-81v71,4,34,114,17,154v-10,24,-22,70,-52,54v-4,-3,-7,-8,-8,-14","w":296,"k":{"\ufb04":40,"\ufb03":40,"\ufb02":40,"\ufb01":40,"\ufb00":40,"\u0178":54,"\u0153":20,"\u0152":36,"\u00ff":56,"\u00fd":56,"\u00fc":27,"\u00fb":27,"\u00fa":27,"\u00f9":27,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":13,"\u00dd":54,"\u00dc":4,"\u00db":4,"\u00da":4,"\u00d9":4,"\u00d8":36,"\u00d6":36,"\u00d5":36,"\u00d4":36,"\u00d3":36,"\u00d2":36,"\u00c7":34,"q":20,"\\":123,"Q":36,"C":34,"G":11,"T":86,"V":48,"W":30,"Y":54,"d":20,"f":40,"t":49,"u":27,"v":44,"w":40,"y":56,"c":13,"e":20,"o":20,"\u00f8":20,"O":36,"j":-98,"U":4}},"\u2022":{"d":"111,-217v-42,0,-60,-26,-60,-65v0,-34,24,-65,60,-65v41,0,63,27,63,65v0,37,-25,65,-63,65","w":214},"\u2026":{"d":"87,5v-30,0,-42,-16,-42,-45v0,-24,16,-45,42,-45v30,0,44,17,44,45v0,25,-18,45,-44,45xm243,5v-30,0,-42,-16,-42,-45v0,-24,16,-45,42,-45v30,0,44,17,44,45v0,25,-18,45,-44,45xm400,5v-30,0,-42,-16,-42,-45v0,-24,16,-45,42,-45v30,0,44,17,44,45v0,25,-18,45,-44,45","w":488,"k":{"\u00f8":20,"y":56,"w":40,"v":44,"u":27,"t":49,"o":20,"f":40,"e":20,"d":20,"c":13,"Y":54,"W":30,"V":48,"U":4,"T":86,"O":36,"G":11,"C":34,"\ufb04":40,"\ufb03":40,"\ufb02":40,"\ufb01":40,"\ufb00":40,"\u0178":54,"\u0153":20,"\u0152":36,"\u00ff":56,"\u00fd":56,"\u00fc":27,"\u00fb":27,"\u00fa":27,"\u00f9":27,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":13,"\u00dd":54,"\u00dc":4,"\u00db":4,"\u00da":4,"\u00d9":4,"\u00d8":36,"\u00d6":36,"\u00d5":36,"\u00d4":36,"\u00d3":36,"\u00d2":36,"\u00c7":34,"q":20,"\\":123,"Q":36,"\/":-13}},"\u2030":{"d":"534,-709v30,13,39,16,14,57r-402,662v-15,-3,-31,-8,-34,-22xm197,-341v-112,4,-136,-69,-136,-184v0,-115,40,-181,141,-184v108,-3,133,73,133,183v1,112,-39,182,-138,185xm202,-664v-69,0,-88,54,-88,143v1,77,8,136,82,136v67,0,88,-58,87,-141v-1,-77,-7,-138,-81,-138xm502,9v-114,4,-137,-70,-137,-185v0,-114,41,-182,141,-184v109,-3,133,73,133,184v1,112,-37,182,-137,185xm507,-315v-70,0,-90,54,-89,143v1,77,8,137,82,137v67,0,89,-58,88,-141v-1,-77,-8,-139,-81,-139xm803,9v-113,4,-137,-70,-137,-185v0,-115,41,-182,142,-184v109,-2,133,73,133,184v0,112,-39,182,-138,185xm808,-315v-70,0,-89,54,-89,143v1,77,9,140,83,137v66,-2,88,-58,87,-141v-1,-77,-8,-139,-81,-139","w":1002,"k":{"\"":76,"\u201d":76,"\u201c":76,"\u2019":76,"\u2018":76,"'":76}},"\u2039":{"d":"177,-500v21,5,40,22,27,46v-37,71,-82,137,-123,204r111,172v24,28,27,69,-10,78r-106,-158v-15,-30,-38,-59,-48,-92v38,-92,99,-169,149,-250","w":256,"k":{"\u0178":47,"\u00dd":47,"Y":47,"V":28,"T":67,"W":29}},"\u203a":{"d":"75,0v-21,-6,-41,-22,-27,-49v38,-70,85,-136,128,-201r-110,-176v-12,-22,-34,-54,-3,-67v5,-3,10,-5,17,-7r124,200v10,25,34,40,18,68v-46,82,-92,151,-147,232","w":256,"k":{"\ufb02":31,"\ufb01":31,"\u017e":31,"\u0178":55,"\u00ff":5,"\u00fd":5,"\u00dd":55,"\u00c6":15,"z":31,"y":5,"x":25,"w":5,"t":26,"f":31,"]":17,"Y":55,"X":29,"W":31,"V":39,"T":67,"J":37,"A":15,")":17,"\u2014":-20,"\u2013":-20,"\u017d":16,"\u0160":15,"\u00dc":15,"\u00db":15,"\u00d6":15,"\u00d5":15,"\u00d4":15,"\u00d1":15,"\u00cb":15,"\u00ca":15,"\u00c5":15,"\u00c4":15,"\u00c3":15,"\u00c2":15,"\u00c1":15,"\u00c0":15,"v":16,"-":-20,"\u2212":-20,"Z":16}},"\u2044":{"d":"-68,0v-13,20,-47,2,-54,-13r399,-684v11,-24,41,-11,55,8","w":196},"\u20ac":{"d":"119,-399v19,-118,58,-207,184,-207v43,0,82,10,95,39v0,14,-4,30,-11,37v-30,-27,-116,-34,-151,2v-29,30,-48,70,-58,129r163,0v-1,29,2,46,-23,46r-146,0v-2,29,-3,63,-3,97r135,0v-1,29,2,46,-23,46r-110,0v8,95,26,165,121,166v37,1,79,-18,97,-36v4,8,9,24,9,37v-15,36,-64,52,-115,53v-132,2,-162,-90,-170,-220r-91,0v1,-29,-2,-46,23,-46r66,0r3,-97r-92,0v1,-29,-2,-46,23,-46r74,0","k":{"\u2212":20,"\u2014":20,"\u2013":20,"]":24,"-":20,")":24}},"\u2122":{"d":"299,-611r5,218v-2,16,-10,7,-34,10r0,-307v-1,-14,18,-9,31,-10r74,200r71,-196v4,-8,20,-3,31,-4r0,307v-2,16,-10,7,-34,10r4,-230r-60,162v-3,9,-16,3,-26,5xm246,-700v-1,13,4,32,-9,32r-76,0r0,276v-2,15,-10,7,-34,9r0,-285r-93,0v1,-13,-5,-33,10,-32r202,0","w":530,"k":{"\/":70}},"\u2212":{"d":"392,-307v-2,29,6,50,-14,50r-336,0v2,-28,-5,-46,13,-50r337,0","k":{"\ufb04":34,"\ufb03":34,"\ufb02":34,"\ufb01":34,"\ufb00":34,"\u017e":84,"\u017d":46,"\u0178":67,"\u0160":107,"\u00ff":39,"\u00fd":39,"\u00dd":67,"\u00c6":36,"\u00c5":36,"\u00c4":36,"\u00c3":36,"\u00c2":36,"\u00c1":36,"\u00c0":36,"\\":81,"T":108,"V":43,"W":34,"Y":67,"f":34,"t":34,"v":28,"w":25,"y":39,")":39,"]":39,"A":36,"J":120,"X":67,"x":90,"S":107,"z":84,"\u00bb":55,"\u203a":55,"Z":46}},"\ufb00":{"d":"359,-13v-1,21,-35,10,-55,13r0,-452r-158,0r0,439v-1,21,-35,10,-55,13r0,-452r-76,0v2,-20,-8,-48,15,-48r61,0r0,-74v-1,-109,54,-161,156,-161v41,0,79,15,104,32v28,-27,70,-36,116,-36v73,0,99,14,80,62v-22,-9,-45,-10,-74,-12v-106,-6,-121,79,-114,189r104,0v-2,19,7,48,-13,48r-91,0r0,439xm243,-686v-67,0,-97,38,-97,110r0,76r158,0v-1,-61,-1,-124,18,-164v-23,-14,-43,-22,-79,-22","w":460,"k":{"\"":-127,"\u201e":44,"\u201d":-127,"\u201c":-127,"w":-9,"u":4,"p":18,"o":14,"k":-6,"h":-6,"g":20,"f":31,"e":18,"d":18,"c":15,"b":-5,".":44,")":-114,"!":-78,"\ufb04":31,"\ufb03":31,"\ufb02":31,"\ufb01":31,"\ufb00":31,"\u2122":-101,"\u2030":-24,"\u2026":44,"\u201a":44,"\u2019":-127,"\u2018":-127,"\u017e":7,"\u0153":20,"\u00fc":4,"\u00fb":4,"\u00fa":4,"\u00f9":4,"\u00f8":24,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":18,"\u00ea":18,"\u00e9":18,"\u00e8":18,"\u00e7":15,"\u00ae":-62,"\u00a9":-63,"r":4,"q":24,"m":2,"]":-28,"\\":-111,"?":-91,"8":-10,",":44,"*":-29,"'":-127,"&":-19}},"\ufb03":{"d":"145,-13v-1,22,-35,10,-55,13r0,-452r-76,0v2,-20,-8,-48,16,-48r60,0r0,-74v-1,-109,54,-160,156,-161v41,0,79,15,104,32v29,-28,72,-35,123,-36v61,-1,120,9,95,69v-27,-13,-59,-19,-94,-19v-107,0,-122,78,-115,189r84,0v-2,22,6,48,-14,48r-70,0r0,439v-1,21,-35,10,-55,13r0,-452r-159,0r0,439xm243,-686v-96,-4,-104,86,-98,186r159,0v0,-60,-2,-127,18,-164v-21,-14,-43,-20,-79,-22xm557,-13v2,22,-34,10,-55,13r0,-473v2,-32,18,-25,55,-27r0,487","w":615},"\ufb04":{"d":"347,-705v45,-52,170,-37,220,-7r0,699v2,22,-33,10,-54,13r0,-679v-16,-5,-33,-9,-57,-9v-102,0,-100,87,-97,188r84,0v-2,22,6,48,-14,48r-70,0r0,439v-1,21,-35,10,-55,13r0,-452r-159,0r0,439v-1,22,-35,10,-55,13r0,-452r-76,0v2,-20,-8,-48,16,-48r60,0r0,-74v-1,-109,54,-160,156,-161v40,0,76,14,101,30xm243,-686v-96,-4,-104,86,-98,186r159,0v0,-60,-2,-126,17,-164v-22,-14,-42,-20,-78,-22","w":625},"\u00d0":{"d":"56,-683v1,-14,8,-17,25,-17r100,0v165,2,193,138,194,309v1,136,-17,237,-57,315v-42,82,-143,78,-262,76r0,-344r-44,0v2,-28,-6,-45,13,-49r31,0r0,-290xm215,-393v-2,28,6,49,-14,49r-90,0r0,291v77,2,135,3,162,-58v31,-70,43,-159,42,-280v-2,-135,-10,-252,-135,-258r-69,0r0,256r104,0","w":414},"\u0141":{"d":"309,-52v-2,20,8,52,-14,52r-240,0r0,-327r-41,13v-6,-27,-18,-41,0,-53r41,-13r1,-312v8,-13,31,-6,55,-8r0,301r102,-33v5,26,19,41,1,52r-103,34r0,294r198,0","w":329},"\u0142":{"d":"112,-13v2,22,-34,10,-55,13r0,-318r-50,16v-6,-25,-18,-41,0,-52r50,-16r0,-338v2,-33,17,-24,55,-27r0,346r51,-17v5,26,18,41,0,52r-51,17r0,324","w":170},"\u00b9":{"d":"64,-289v-4,-21,-9,-52,16,-52r113,0r0,-308r-122,25v-11,-16,-11,-48,12,-52r147,-34v5,0,15,1,19,3r0,366r95,0v3,21,10,52,-15,52r-265,0","w":408},"\u00b3":{"d":"277,-605v0,-87,-158,-55,-197,-16v-30,-39,10,-62,46,-75v23,-8,53,-14,89,-14v71,1,121,24,121,90v0,41,-19,76,-56,105v42,14,69,46,73,97v10,137,-184,171,-284,111v-14,-14,-9,-40,7,-52v55,48,225,42,221,-54v-3,-69,-77,-74,-150,-72v-7,-13,-13,-45,12,-45v22,0,46,1,66,4v31,-21,52,-38,52,-79","w":414},"\u00b2":{"d":"191,-654v-53,0,-86,24,-115,44v-41,-69,61,-98,135,-100v79,-3,126,32,121,108v-9,131,-134,179,-200,261r214,0v7,18,6,52,-15,52r-275,0v-8,-15,-4,-41,5,-52v58,-66,137,-117,187,-187v37,-52,23,-126,-57,-126","w":401},"\u2074":{"d":"181,-634v32,-37,50,-86,118,-73r0,291r70,0v7,17,9,53,-12,53r-58,0v-4,35,16,83,-30,79v-7,0,-14,-1,-22,-3r0,-76r-187,0v-22,-44,11,-87,28,-125v23,-52,57,-104,93,-146xm248,-413r2,-228v-59,57,-116,139,-144,228r142,0","w":410},"\u00bd":{"d":"64,-289v-4,-21,-9,-52,16,-52r113,0r0,-308r-122,25v-11,-16,-11,-48,12,-52r147,-34v5,0,15,1,19,3r0,366r95,0v3,21,10,52,-15,52r-265,0xm291,-1v-13,20,-47,2,-54,-13r399,-684v11,-24,41,-11,55,8xm692,-365v-53,0,-86,24,-115,44v-41,-69,61,-98,135,-100v79,-3,126,32,121,108v-9,131,-134,179,-200,261r214,0v7,18,6,52,-15,52r-275,0v-8,-15,-4,-41,5,-52v58,-66,138,-116,188,-186v37,-52,22,-127,-58,-127","w":911},"\u00bc":{"d":"64,-289v-4,-21,-9,-52,16,-52r113,0r0,-308r-122,25v-11,-16,-11,-48,12,-52r147,-34v5,0,15,1,19,3r0,366r95,0v3,21,10,52,-15,52r-265,0xm623,-346v32,-37,50,-86,118,-73r0,291r70,0v7,17,9,53,-12,53r-58,0v-4,35,16,83,-30,79v-7,0,-14,-1,-22,-3r0,-76r-187,0v-22,-44,11,-87,28,-125v23,-52,57,-104,93,-146xm690,-125r2,-228v-59,57,-116,139,-144,228r142,0xm291,-1v-13,20,-47,2,-54,-13r399,-684v11,-24,41,-11,55,8","w":877},"\u00be":{"d":"277,-605v0,-87,-158,-55,-197,-16v-30,-39,10,-62,46,-75v23,-8,53,-14,89,-14v71,1,121,24,121,90v0,41,-19,76,-56,105v42,14,69,46,73,97v10,137,-184,171,-284,111v-14,-14,-9,-40,7,-52v55,48,225,42,221,-54v-3,-69,-77,-74,-150,-72v-7,-13,-13,-45,12,-45v22,0,46,1,66,4v31,-21,52,-38,52,-79xm620,-346v32,-37,50,-86,118,-73r0,291r70,0v7,17,9,53,-12,53r-58,0v-4,35,16,83,-30,79v-7,0,-14,-1,-22,-3r0,-76r-187,0v-22,-44,11,-87,28,-125v23,-52,57,-104,93,-146xm687,-125r2,-228v-59,57,-116,139,-144,228r142,0xm297,-1v-13,20,-47,2,-54,-13r399,-684v11,-24,41,-11,55,8","w":874},"\u00a6":{"d":"85,-720v-3,-29,34,-25,55,-19r0,390v3,28,-36,20,-55,16r0,-387xm85,-201v-3,-28,34,-23,55,-18r0,397v3,28,-35,19,-55,16r0,-395","w":226},"<":{"d":"331,-422v14,10,30,44,9,54r-224,110r238,104v0,31,-19,50,-49,37r-251,-110v-14,-20,-15,-52,9,-64","w":400},">":{"d":"70,-103v-14,-12,-30,-45,-9,-55r224,-110r-237,-104v2,-32,14,-52,49,-37r251,110v13,20,12,53,-10,64","w":400},"^":{"d":"105,-223v-18,21,-48,6,-48,-18r161,-146r142,130v22,17,2,45,-18,46r-129,-105","w":430},"{":{"d":"102,-355v61,-127,-107,-396,155,-389v12,15,19,52,-3,54v-59,6,-96,22,-96,87v0,98,49,271,-47,302v38,16,59,36,59,94v0,92,-26,176,-5,256v10,40,48,48,96,51v6,23,3,51,-18,50v-100,-1,-140,-35,-141,-134v-1,-74,14,-130,14,-207v0,-52,-21,-71,-60,-80v-7,-20,-5,-47,11,-55v14,-7,28,-15,35,-29","w":285},"}":{"d":"183,-238v-59,128,107,396,-155,388v-10,-11,-18,-51,3,-53v60,-5,98,-21,97,-87v0,-99,-48,-271,47,-303v-39,-14,-59,-37,-59,-94v0,-92,26,-175,5,-255v-11,-40,-50,-47,-97,-52v-3,-21,-4,-50,18,-50v99,1,140,36,141,134v0,74,-14,133,-14,208v0,52,21,71,60,80v21,46,-26,60,-46,84","w":285},"~":{"d":"268,-223v-74,3,-94,-67,-170,-44v-23,8,-39,24,-57,36v-16,5,-28,-13,-29,-30v24,-33,64,-61,121,-62v65,-2,77,49,140,49v36,0,59,-21,78,-40v19,-18,36,7,38,26v-25,35,-61,63,-121,65","w":400},"\u2020":{"d":"186,-681v-4,-29,48,-34,61,-13r-14,179v-3,16,-21,16,-32,8xm368,-511v24,-7,31,26,23,47v-2,6,-5,11,-10,14r-126,-14v-15,-1,-13,-22,-7,-32xm63,-451v-29,3,-34,-46,-13,-61r127,15v16,3,15,21,7,32xm246,-21v5,31,-48,34,-60,13r14,-434v1,-19,22,-17,32,-8","w":431},"\u00b0":{"d":"184,-562v-62,0,-87,-27,-87,-90v0,-63,34,-91,94,-91v62,0,86,24,86,90v0,60,-33,91,-93,91xm191,-704v-36,0,-53,15,-53,54v0,34,15,49,47,49v33,0,53,-16,52,-52v0,-36,-12,-51,-46,-51","w":371},"\u00a3":{"d":"290,-328v-2,28,6,50,-14,50r-133,0v0,38,0,76,1,113v1,37,3,74,6,110r183,4v3,11,5,20,5,26v1,24,-33,24,-55,25r-186,0v-3,-51,-6,-99,-7,-144v-1,-45,-2,-90,-2,-134r-73,0v2,-29,-6,-46,13,-50r60,0v2,-147,21,-263,158,-267v58,-1,124,24,90,82v-23,-18,-43,-27,-82,-27v-104,0,-108,100,-111,212r147,0","w":383},"\u00a7":{"d":"66,-550v-37,-90,41,-154,138,-154v66,0,138,31,99,88v-42,-40,-185,-48,-185,29v0,61,60,82,95,119r35,32v35,38,72,63,72,130v0,45,-27,80,-62,101v27,31,52,50,52,101v-1,71,-68,108,-146,108v-66,0,-140,-29,-100,-88v41,41,185,48,185,-29v0,-61,-62,-82,-95,-119v-42,-47,-107,-76,-107,-161v0,-46,25,-82,62,-102v-15,-17,-36,-40,-43,-55xm149,-459v-38,12,-63,67,-41,109v23,44,71,78,110,110v37,-14,65,-65,42,-109v-23,-44,-72,-78,-111,-110","w":367},"\u00b6":{"d":"241,-709v51,-2,83,9,116,26r0,666v2,27,-37,21,-54,16r0,-206v-20,12,-61,17,-91,17v-127,0,-168,-96,-169,-232v-1,-168,53,-283,198,-287xm99,-427v0,122,42,207,164,187v15,-3,28,-7,39,-14r0,-393v-15,-9,-40,-15,-68,-14v-105,6,-135,107,-135,234xm432,-667v-2,-28,32,-26,55,-18r0,668v3,27,-35,19,-55,16r0,-666","w":546},"\u2260":{"d":"374,-187v-2,29,6,50,-14,50r-176,0r-48,132v-13,20,-40,10,-55,-8r45,-124r-102,0v2,-28,-5,-46,13,-50r108,0r46,-124r-167,0v2,-28,-5,-46,13,-50r172,0r49,-132v11,-25,35,-13,55,5r-47,127r108,0v-2,29,6,50,-14,50r-112,0r-45,124r171,0","w":400},"\u221e":{"d":"180,-125v-87,-1,-128,-57,-128,-142v0,-87,43,-142,133,-142v73,0,106,44,132,90v28,-44,59,-91,129,-90v81,1,125,55,125,142v0,104,-59,161,-158,143v-50,-10,-84,-48,-105,-91v-28,40,-64,90,-128,90xm517,-267v-2,-53,-26,-91,-82,-87v-60,4,-71,52,-97,89v19,42,40,92,97,92v52,0,83,-35,82,-94xm156,-347v-76,26,-63,174,27,170v58,-3,79,-49,104,-89v-13,-54,-63,-105,-131,-81","w":623},"\u00b1":{"d":"393,-330v-2,29,6,50,-14,50r-136,0r0,137v-4,19,-22,11,-50,13r0,-150r-150,0v2,-28,-5,-46,13,-50r137,0r0,-136v3,-20,22,-12,50,-14r0,150r150,0xm392,-63v-2,29,6,50,-14,50r-336,0v2,-28,-5,-46,13,-50r337,0","w":433},"\u00b5":{"d":"305,-480v-4,-30,32,-27,54,-21r0,478v-60,29,-202,58,-247,-3r0,199v2,26,-35,24,-54,18r0,-672v-3,-27,33,-27,54,-20r0,371v-10,104,127,99,193,68r0,-418","w":419},"\u03bc":{"d":"305,-480v-4,-30,32,-27,54,-21r0,478v-60,29,-202,58,-247,-3r0,199v2,26,-35,24,-54,18r0,-672v-3,-27,33,-27,54,-20r0,371v-10,104,127,99,193,68r0,-418","w":419},"\u2202":{"d":"46,-257v-1,-145,46,-252,171,-252v46,0,83,15,110,45v-30,-115,-87,-185,-174,-252v6,-22,39,-35,60,-18v123,99,187,228,187,445v0,155,-21,299,-174,299v-142,0,-180,-101,-180,-267xm225,-38v145,0,120,-207,115,-350v-28,-47,-65,-70,-111,-70v-97,0,-128,98,-128,209v0,124,25,211,124,211","w":437},"\u2211":{"d":"330,-700v5,19,5,52,-16,52r-176,0r140,441r-143,345r200,0v6,20,5,52,-16,52r-261,0r163,-401r-162,-489r271,0","w":406},"\u220f":{"d":"401,-700v8,19,9,54,-16,53r-40,0r0,820v-1,23,-35,22,-55,16r0,-836r-144,0r0,820v0,24,-36,22,-55,16r0,-836r-52,0v-9,-17,-8,-53,15,-53r347,0","w":442},"\u03c0":{"d":"401,-500v8,19,9,54,-16,53r-40,0r0,431v-1,23,-35,23,-55,16r0,-447r-144,0r0,431v0,24,-36,22,-55,16r0,-447r-52,0v-9,-17,-8,-53,15,-53r347,0","w":442},"\u222b":{"d":"97,145v80,3,114,-34,114,-117r0,-596v-2,-117,50,-169,163,-169v55,0,103,12,80,62v-24,-9,-44,-11,-74,-12v-81,-3,-114,35,-114,118r0,595v2,118,-50,170,-163,170v-56,0,-104,-13,-80,-63v22,9,45,12,74,12","w":477},"\u00aa":{"d":"237,-597v6,-91,-126,-64,-173,-39v-10,-7,-14,-33,-4,-42v25,-21,67,-33,121,-32v65,1,104,30,104,96r0,297v-25,13,-78,28,-123,28v-80,0,-113,-38,-113,-120v0,-112,95,-140,188,-110r0,-78xm95,-406v-11,82,90,87,142,60r0,-131v-63,-22,-155,-14,-142,71","w":335},"\u00ba":{"d":"170,-290v-113,0,-126,-91,-128,-208v-1,-126,36,-212,138,-212v113,0,125,93,126,211v1,123,-32,209,-136,209xm181,-660v-75,0,-91,67,-91,166v0,82,3,157,80,157v72,0,89,-70,89,-163v0,-83,-2,-160,-78,-160","w":348},"\u03a9":{"d":"409,-52v8,17,9,53,-16,52r-133,0v90,-124,127,-402,67,-588v-19,-58,-92,-86,-149,-51v-70,43,-74,154,-74,276v0,145,36,275,93,363r-147,0v-6,-17,-8,-52,15,-52r65,0v-52,-79,-82,-190,-82,-325v0,-117,16,-201,47,-254v31,-53,80,-79,146,-79v164,0,171,159,171,329v0,137,-30,252,-85,329r82,0","w":461},"\u2126":{"d":"409,-52v8,17,9,53,-16,52r-133,0v90,-124,127,-402,67,-588v-19,-58,-92,-86,-149,-51v-70,43,-74,154,-74,276v0,145,36,275,93,363r-147,0v-6,-17,-8,-52,15,-52r65,0v-52,-79,-82,-190,-82,-325v0,-117,16,-201,47,-254v31,-53,80,-79,146,-79v164,0,171,159,171,329v0,137,-30,252,-85,329r82,0","w":461},"\u00ac":{"d":"38,-244v-9,-19,-7,-53,15,-53r304,0r0,186v-17,6,-53,8,-53,-15r0,-118r-266,0","w":400},"\u221a":{"d":"441,-700v6,17,8,53,-15,52r-85,0r-110,813v-1,32,-42,31,-67,23r-109,-409v10,-14,51,-21,56,2r79,295r102,-776r149,0","w":466},"\u0192":{"d":"425,-500v-2,29,6,50,-14,50r-145,0r0,476v2,118,-50,170,-163,170v-56,0,-104,-13,-80,-63v22,9,45,12,74,12v80,3,114,-34,114,-117r0,-478r-136,0v2,-28,-5,-46,13,-50r123,0r0,-68v-2,-117,50,-169,163,-169v55,0,103,12,80,62v-24,-9,-44,-11,-74,-12v-81,-3,-116,35,-114,118r0,69r159,0","w":477},"\u2248":{"d":"268,-283v-74,0,-93,-65,-170,-43v-23,7,-41,21,-58,33v-15,5,-24,-13,-25,-28v25,-32,61,-61,118,-62v65,-2,74,49,137,49v35,0,61,-20,78,-40v10,-12,25,-5,31,7v7,38,-19,50,-43,67v-18,12,-41,17,-68,17xm266,-152v-66,2,-77,-47,-136,-50v-35,-2,-63,24,-78,40v-20,13,-36,-12,-37,-30v23,-32,60,-59,115,-60v65,-1,77,48,140,48v38,1,68,-23,89,-39v16,-5,26,11,27,26v-25,35,-60,63,-120,65","w":400},"\u0394":{"d":"188,-667v3,-35,41,-44,67,-29r165,696r-392,0xm92,-52r266,0r-132,-568r-3,0","w":440},"\u2206":{"d":"188,-667v3,-35,41,-44,67,-29r165,696r-392,0xm92,-52r266,0r-132,-568r-3,0","w":440},"\u00a0":{"w":172},"\u25ca":{"d":"236,5r-200,-355r200,-355r200,355xm236,-597r-140,247r140,246r139,-246","w":469},"\u2021":{"d":"197,-438v0,-20,21,-21,38,-13r0,191v0,19,-19,21,-38,14r0,-192xm186,-681v-4,-29,48,-34,61,-13r-14,179v-3,16,-21,16,-32,8xm368,-511v24,-7,31,26,23,47v-2,6,-5,11,-10,14r-126,-14v-15,-1,-13,-22,-7,-32xm63,-451v-29,3,-34,-46,-13,-61r127,15v16,3,15,21,7,32xm245,-24v5,31,-46,35,-61,14r15,-174v1,-16,21,-16,31,-8xm63,-188v-24,7,-31,-27,-23,-48v2,-6,5,-10,10,-13r126,14v15,3,14,21,7,32xm368,-247v30,-3,34,45,13,61r-126,-15v-17,-4,-16,-20,-8,-32","w":431},"\u00af":{"d":"3,-615v-6,-22,-5,-53,20,-53r228,0v10,18,5,53,-17,53r-231,0","w":256},"\u02d8":{"d":"119,-580v-66,0,-108,-52,-119,-110v1,-20,13,-24,31,-30v9,59,90,123,144,62v21,-14,17,-68,51,-56v8,3,17,14,18,24v-20,56,-50,110,-125,110","w":244},"\u02dd":{"d":"93,-574v-13,17,-41,-1,-41,-18r100,-148v4,-10,20,-14,32,-8v20,-16,52,4,52,27r-112,145v-6,11,-22,10,-31,2","w":296},"\u02db":{"d":"77,195v-89,8,-92,-112,-47,-163v20,-23,45,-50,79,-52v9,2,15,11,18,20v-36,22,-72,54,-77,108v-4,43,38,53,70,36v3,6,6,13,7,20v3,30,-23,29,-50,31","w":128},"\u2264":{"d":"338,-445v14,13,32,44,9,55r-224,110r238,103v-1,31,-16,51,-49,37r-251,-110v-14,-20,-14,-52,9,-63xm366,-50v-2,29,6,50,-14,50r-294,0v2,-28,-6,-50,14,-50r294,0","w":417},"\u2265":{"d":"73,-129v-13,-12,-29,-45,-8,-55r224,-110r-238,-104v0,-31,19,-50,49,-37r251,110v15,19,13,53,-9,64xm358,-50v-2,29,6,50,-14,50r-286,0v2,-28,-6,-50,14,-50r286,0","w":412},"\u00f0":{"d":"190,-744v35,9,54,39,78,60r77,-31v7,26,23,38,5,51r-48,19v67,88,98,202,98,356v0,155,-21,299,-174,299v-142,0,-180,-101,-180,-267v-1,-145,46,-252,171,-252v46,0,83,15,110,45v-15,-60,-40,-113,-77,-160r-96,38v-7,-26,-23,-38,-5,-51r66,-26v-19,-19,-42,-36,-63,-54v6,-13,21,-27,38,-27xm225,-38v145,0,120,-207,115,-350v-28,-47,-65,-70,-111,-70v-97,0,-128,98,-128,209v0,124,25,211,124,211","w":437},"\u00fe":{"d":"112,196v-17,3,-61,14,-55,-18r0,-886v2,-33,17,-24,55,-27r0,239v26,-9,56,-13,89,-13v127,-1,166,83,165,215v0,146,-27,251,-118,293v-49,23,-110,7,-136,-21r0,218xm292,-157v21,-99,44,-303,-92,-303v-34,0,-63,9,-88,26r0,357v27,53,117,45,148,-5v11,-18,25,-42,32,-75","w":400},"\u00de":{"d":"109,-13v1,21,-33,10,-54,13r0,-685v0,-23,29,-12,54,-15r0,129r63,0v122,0,175,69,175,191v0,154,-75,227,-238,213r0,154xm109,-220v123,13,177,-24,178,-165v0,-82,-28,-136,-110,-136r-68,1r0,300","w":370},"!":{"d":"94,5v-30,0,-43,-16,-43,-45v0,-24,17,-45,43,-45v29,0,44,18,44,45v0,26,-18,45,-44,45xm61,-691v8,-22,31,-13,71,-16r-9,491v-3,28,-21,23,-55,25","w":189},"\u0237":{"d":"-8,144v67,0,72,-52,72,-118r0,-499v2,-33,17,-24,55,-27r0,537v1,95,-27,158,-123,158v-66,0,-131,-21,-100,-77v24,15,55,26,96,26","w":182},"\"":{"d":"35,-754v-8,-47,23,-27,57,-30v1,63,-5,146,-16,199v-7,2,-21,0,-31,1xm150,-754v-8,-47,23,-27,57,-30v1,63,-5,146,-16,199v-7,2,-21,0,-31,1","w":243,"k":{"\ufb04":42,"\ufb03":42,"\ufb02":42,"\ufb01":42,"\ufb00":42,"\u20ac":112,"\u017e":70,"\u017d":8,"\u0178":-20,"\u0161":96,"\u0160":13,"\u0153":92,"\u0152":20,"\u00ff":73,"\u00fd":73,"\u00fc":76,"\u00fb":76,"\u00fa":76,"\u00f9":76,"\u00f8":92,"\u00f6":92,"\u00f5":92,"\u00f4":92,"\u00f3":92,"\u00f2":92,"\u00f1":99,"\u00ef":-45,"\u00ee":-43,"\u00ec":-50,"\u00eb":100,"\u00ea":100,"\u00e9":100,"\u00e8":100,"\u00e7":102,"\u00e6":74,"\u00e5":74,"\u00e4":74,"\u00e3":74,"\u00e2":74,"\u00e1":74,"\u00e0":74,"\u00dd":-20,"\u00dc":13,"\u00db":13,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00d1":9,"\u00cf":-10,"\u00ce":-37,"\u00cb":8,"\u00ca":3,"\u00c7":47,"\u00c6":115,"\u00c5":115,"\u00c4":115,"\u00c3":115,"\u00c2":115,"\u00c1":115,"\u00c0":115,"\u00bf":99,"\u00a2":30,"r":99,"q":118,"m":99,"\\":-34,"Q":20,"@":73,"?":-20,"9":39,"6":32,"4":94,"3":7,"2":15,"1":39,"0":46,"\/":120,"+":39,"C":47,"G":34,"T":-16,"V":-13,"W":-13,"Y":-20,"d":118,"f":42,"t":21,"u":76,"v":67,"w":68,"y":73,"c":102,"e":100,"o":92,"O":20,")":-20,"]":-20,"A":115,"J":125,"x":65,"a":74,"z":70,"g":112,"n":99,"p":104,"s":96,"(":78,"[":78}}}});
/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright (c) 2010, Yanone (http://yanone.de/typedesign/). All rights reserved.
 * This Font Software is licensed under the SIL Open Font License, Version 1.1.
 * This license is available with a FAQ at: http://scripts.sil.org/OFL
 * 
 * Trademark:
 * Yanone Kaffeesatz is a trademark of Yanone
 * 
 * Description:
 * Yanone Kaffeesatz was first published in 2004 and is Yanone's first ever
 * finished typeface. Its Bold is reminiscent of 1920s coffee house typography,
 * while the rather thin fonts bridge the gap to present times. Lacking self
 * confidence and knowledge about the type scene Yanone decided to publish the
 * family for free under a Creative Commons License. A decision that should turn
 * out one of the best he ever made. It has been downloaded over 100,000 times to
 * date from this website alone, and you can witness Kaffeesatz use on German
 * fresh-water gyms, Dubai mall promos and New Zealand McDonald's ads. And of
 * course on coffee and foodstuff packaging and cafe design around the globe. In
 * 2009 he reworked much of the typeface and it got published in FontShop's
 * FontFont Library under the new name FF Kava. You can read more about it in an
 * extensive article by Yves Peters on the FontFeed.
 * 
 * Manufacturer:
 * Yanone
 * 
 * Designer:
 * Yanone
 * 
 * Vendor URL:
 * http://yanone.de/typedesign/
 * 
 * License information:
 * http://scripts.sil.org/OFL
 */
Cufon.registerFont({"w":417,"face":{"font-family":"YanoneKaffeesatz","font-weight":400,"font-stretch":"normal","units-per-em":"1000","panose-1":"2 0 0 0 0 0 0 0 0 0","ascent":"800","descent":"-200","x-height":"10","bbox":"-107 -957 937 205.976","underline-thickness":"71","underline-position":"-4","unicode-range":"U+0020-U+FB04"},"glyphs":{" ":{"w":157},"\ufb01":{"d":"357,-16v0,29,-52,11,-82,16r0,-463v-2,-45,38,-36,82,-37r0,484xm160,-16v-3,29,-53,11,-81,16r0,-431r-69,0v3,-32,-10,-68,21,-69r48,0r0,-60v-2,-125,60,-181,180,-179v66,1,126,7,113,72v-1,9,-3,17,-6,24v-25,-13,-66,-22,-104,-22v-71,0,-104,30,-102,103r0,62r70,0v-3,31,9,69,-17,69r-53,0r0,415","w":402,"k":{"y":10,"x":7,"\u00ff":10,"\u00fd":10,"\/":-23}},"\ufb02":{"d":"160,-16v-3,29,-53,11,-81,16r0,-431r-69,0v3,-32,-10,-68,21,-69r48,0v-10,-142,27,-238,157,-238v51,0,99,15,130,34r0,688v-3,29,-53,11,-81,16r0,-664v-71,-23,-133,9,-125,91r0,73r80,0v-3,31,10,69,-17,69r-63,0r0,415","w":412},"#":{"d":"390,-254v-3,37,7,58,-16,64r-55,0v-6,29,11,77,-21,81v-11,1,-29,2,-54,2r4,-83r-95,0v-6,29,11,77,-21,81v-11,1,-29,2,-54,2r4,-83r-55,0v3,-37,-8,-58,17,-64r42,0r5,-106r-64,0v3,-37,-8,-58,17,-64r51,0v6,-28,-10,-73,21,-77v11,-1,29,-2,54,-2r-4,79r95,0v6,-28,-10,-73,21,-77v11,-1,29,-2,54,-2r-4,79r58,0v-3,37,7,58,-16,64r-46,0r-5,106r67,0xm157,-254r95,0r5,-106r-95,0"},"$":{"d":"363,-157v0,94,-44,145,-126,160v-5,39,15,101,-18,113v-12,4,-31,6,-56,6r0,-115v-54,-2,-98,-16,-111,-44v2,-23,10,-50,22,-65v24,18,60,29,106,29v81,0,116,-72,81,-135v-44,-80,-154,-141,-195,-226v-44,-91,21,-176,114,-181v5,-41,-16,-104,19,-116v13,-4,31,-6,55,-6r0,121v52,3,87,12,103,35v-1,19,-8,44,-20,57v-45,-25,-197,-45,-195,35v1,38,20,54,43,80v53,59,128,110,165,182v10,20,13,44,13,70"},"%":{"d":"180,-339v-113,3,-136,-70,-136,-186v0,-114,40,-181,142,-183v108,-2,133,72,133,182v0,116,-36,184,-139,187xm186,-645v-59,0,-64,58,-64,122v0,63,0,121,60,121v56,0,62,-60,62,-123v0,-63,0,-120,-58,-120xm508,9v-113,3,-136,-70,-136,-186v0,-114,40,-181,142,-183v108,-2,133,72,133,182v0,116,-36,184,-139,187xm513,-295v-59,0,-64,58,-64,122v0,63,0,121,60,121v52,0,64,-50,63,-123v-1,-63,0,-120,-59,-120xm166,8v-20,-7,-44,-11,-50,-31r403,-686v18,8,42,14,46,35v-35,70,-86,153,-127,222","w":691},"&":{"d":"394,-435v46,70,44,217,10,307v26,29,53,57,83,73v-5,31,-23,59,-53,65v-25,-9,-50,-38,-73,-63v-34,36,-79,64,-149,63v-124,1,-186,-61,-186,-180v0,-94,54,-149,112,-188v-36,-63,-76,-132,-78,-210v-2,-95,68,-139,167,-138v45,0,81,7,109,14v60,15,41,60,21,93v-54,-43,-225,-67,-211,41v18,145,123,254,196,357v21,-112,1,-239,-52,-295v56,-10,132,-10,192,-5v6,32,7,66,-39,66r-49,0xm110,-168v0,115,150,129,198,53v-46,-55,-94,-121,-134,-184v-37,28,-64,67,-64,131","w":502},"'":{"d":"65,-786v15,0,34,0,46,3v-3,62,-7,147,-21,197r-45,3r-14,-183v-3,-26,14,-20,34,-20","w":141,"k":{"z":70,"y":71,"x":63,"Y":-20,"W":-16,"V":-16,"T":-13,"O":20,"w":69,"v":69,"u":73,"t":18,"s":91,"p":100,"o":93,"n":96,"g":107,"f":44,"e":103,"d":111,"c":94,"a":72,"]":-20,"[":79,"J":132,"G":37,"C":55,"A":119,")":-20,"(":79,"\ufb04":44,"\ufb03":44,"\ufb02":44,"\ufb01":44,"\ufb00":44,"\u20ac":122,"\u017e":70,"\u0178":-20,"\u0161":91,"\u0160":11,"\u0153":93,"\u0152":20,"\u00ff":71,"\u00fd":71,"\u00fc":73,"\u00fb":73,"\u00fa":73,"\u00f9":73,"\u00f8":93,"\u00f6":93,"\u00f5":93,"\u00f4":93,"\u00f3":93,"\u00f2":93,"\u00f1":96,"\u00ef":-54,"\u00ee":-41,"\u00ec":-52,"\u00eb":103,"\u00ea":103,"\u00e9":103,"\u00e8":103,"\u00e7":94,"\u00e6":72,"\u00e5":72,"\u00e4":72,"\u00e3":72,"\u00e2":72,"\u00e1":72,"\u00e0":72,"\u00dd":-20,"\u00dc":10,"\u00db":11,"\u00da":1,"\u00d9":1,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00d1":9,"\u00cf":-19,"\u00ce":-41,"\u00cb":16,"\u00ca":5,"\u00c7":55,"\u00c6":119,"\u00c5":119,"\u00c4":119,"\u00c3":119,"\u00c2":119,"\u00c1":119,"\u00c0":119,"\u00bf":104,"\u00a2":56,"r":96,"q":111,"m":96,"\\":-37,"Q":20,"@":75,"?":-20,"9":46,"6":31,"4":101,"3":4,"2":19,"1":39,"0":43,"\/":122,"+":21}},"(":{"d":"271,-751v-77,102,-123,245,-123,428v0,190,42,354,123,458v-7,31,-13,59,-45,60v-70,-53,-110,-165,-138,-283v-28,-119,-31,-329,0,-448v30,-114,68,-212,138,-267v34,2,36,19,45,52","w":292,"k":{"\ufb02":17,"\ufb01":17,"\ufb00":24,"\u20ac":58,"\u2044":39,"\u2039":18,"\u2019":-20,"\u2018":-20,"\u2014":34,"\u2013":34,"\u017e":24,"\u0153":34,"\u0152":20,"\u00ff":-16,"\u00fd":-16,"\u00fc":31,"\u00fb":31,"\u00fa":31,"\u00f9":31,"\u00f8":34,"\u00f6":34,"\u00f5":34,"\u00f4":34,"\u00f3":34,"\u00f2":34,"\u00f1":27,"\u00ef":-13,"\u00ed":17,"\u00ec":-26,"\u00eb":30,"\u00ea":30,"\u00e9":30,"\u00e8":30,"\u00e7":30,"\u00e6":24,"\u00e4":24,"\u00e3":24,"\u00e2":24,"\u00e1":24,"\u00e0":24,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00cf":-10,"\u00ce":-58,"\u00c7":27,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"\u00a2":57,"r":27,"q":30,"m":27,"]":-53,"\\":-24,"[":50,"Q":20,"\/":16,"+":47,"*":23,"'":-20,"C":27,"G":20,"d":30,"t":14,"u":31,"v":37,"w":37,"y":-16,"c":30,"e":30,"o":34,"\"":-20,"-":34,"\u2212":34,"\u201c":-20,"\u201d":-20,"\u00ab":18,"O":20,"A":24,"x":21,"a":24,"\u00e5":24,"z":24,"Z":14,"\u017d":14,"n":27,"j":-122}},")":{"d":"21,135v78,-108,123,-265,123,-458v-1,-180,-45,-328,-123,-428v9,-51,41,-72,77,-25v77,101,129,260,129,456v0,203,-54,366,-128,482v-39,61,-71,22,-78,-27","w":292,"k":{"\u2019":76,"\u2018":76,"'":76,"\"":76,"\u201c":76,"\u201d":76}},"*":{"d":"258,-519v-4,18,-11,21,-37,15r-23,-163v0,-36,59,-20,80,-10xm430,-575v19,13,39,67,9,82r-159,38v-15,-20,-16,-30,2,-40xm199,-487v3,20,-6,33,-24,28r-159,-44v2,-36,15,-70,53,-66xm249,-403v-8,-22,2,-21,22,-31r115,135v15,32,-30,46,-59,54xm187,-423v12,-12,24,-9,37,8r-88,156v-28,27,-58,-19,-70,-41","w":470,"k":{"\u0153":10,"\u0152":7,"\u00f8":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f3":10,"\u00f2":10,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00d8":7,"\u00d6":7,"\u00d5":7,"\u00d4":7,"\u00d3":7,"\u00d2":7,"o":10,"g":30,"e":20,"d":20,"c":20,"]":22,"Z":18,"X":7,"T":7,"Q":7,"O":7,"J":129,"A":48,")":22,"\u20ac":22,"\u017d":30,"\u00e7":27,"\u00c6":112,"\u00c5":48,"\u00c4":48,"\u00c3":48,"\u00c2":48,"\u00c1":48,"\u00c0":48,"q":10,"4":27,"\/":55}},"+":{"d":"384,-317v-3,37,7,64,-16,71r-123,0r0,123v-6,23,-35,13,-71,16r0,-139r-140,0v3,-37,-7,-65,17,-71r123,0r0,-123v6,-24,34,-14,71,-17r0,140r139,0","k":{"\"":21,"\u201d":21,"\u201c":21,"]":42,")":42,"\u2019":21,"\u2018":21,"'":21}},",":{"d":"38,80v16,-26,26,-48,28,-86v-39,-22,-26,-101,28,-101v37,0,55,20,55,60v0,65,-36,126,-79,150v-17,0,-29,-7,-32,-23","w":183,"k":{"\u00f8":20,"y":48,"w":33,"v":45,"u":24,"t":48,"o":20,"j":-46,"f":39,"e":20,"d":20,"c":7,"Y":61,"W":31,"V":48,"U":7,"T":89,"O":27,"G":13,"C":31,"\ufb04":39,"\ufb03":39,"\ufb02":39,"\ufb01":39,"\ufb00":39,"\u0178":61,"\u0153":20,"\u0152":27,"\u00ff":48,"\u00fd":48,"\u00fc":24,"\u00fb":24,"\u00fa":24,"\u00f9":24,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":7,"\u00dd":61,"\u00dc":7,"\u00db":7,"\u00da":7,"\u00d9":7,"\u00d8":27,"\u00d6":27,"\u00d5":27,"\u00d4":27,"\u00d3":27,"\u00d2":27,"\u00c7":31,"q":20,"\\":128,"Q":27,"\/":-7}},"-":{"d":"241,-317v-3,37,7,65,-17,71r-187,0v3,-37,-7,-64,16,-71r188,0","w":278,"k":{"\ufb04":30,"\ufb03":30,"\ufb02":30,"\ufb01":30,"\ufb00":30,"\u017e":62,"\u017d":47,"\u0178":64,"\u0160":93,"\u00ff":32,"\u00fd":32,"\u00dd":64,"\u00c8":1,"\u00c6":33,"\u00c5":33,"\u00c4":33,"\u00c3":33,"\u00c2":33,"\u00c1":33,"\u00c0":33,"\\":83,"T":105,"V":37,"W":29,"Y":64,"f":30,"t":29,"v":25,"w":20,"y":32,")":31,"]":31,"A":33,"J":122,"X":65,"x":74,"S":93,"z":62,"\u00bb":30,"\u203a":30,"Z":47,"B":1,"D":1,"E":1,"F":1,"H":1,"K":1,"L":1,"N":1,"P":1,"R":1,"\u00c9":1,"\u00ca":1,"\u00cb":1,"\u00d1":1}},".":{"d":"93,6v-41,0,-55,-19,-56,-57v0,-31,22,-58,56,-58v40,0,55,21,56,58v0,32,-23,57,-56,57","w":183,"k":{"\ufb04":39,"\ufb03":39,"\ufb02":39,"\ufb01":39,"\ufb00":39,"\u0178":61,"\u0153":20,"\u0152":27,"\u00ff":48,"\u00fd":48,"\u00fc":24,"\u00fb":24,"\u00fa":24,"\u00f9":24,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":7,"\u00dd":61,"\u00dc":7,"\u00db":7,"\u00da":7,"\u00d9":7,"\u00d8":27,"\u00d6":27,"\u00d5":27,"\u00d4":27,"\u00d3":27,"\u00d2":27,"\u00c7":31,"q":20,"\\":128,"Q":27,"\/":-7,"C":31,"G":13,"T":89,"V":48,"W":31,"Y":61,"d":20,"f":39,"t":48,"u":24,"v":45,"w":33,"y":48,"c":7,"e":20,"o":20,"\u00f8":20,"O":27,"U":7}},"\/":{"d":"325,-765r-230,776v-18,13,-49,7,-85,9r230,-774v17,-15,49,-9,85,-11","w":335,"k":{"\"":-32,"\u201e":174,"\u201d":-32,"\u201c":-32,"\u017f":19,"\u00ff":24,"\u00df":19,"\u00d3":21,"\u00bb":39,"\u00ab":62,"z":34,"y":24,"x":44,"w":20,"v":15,"u":39,"t":16,"s":57,"p":54,"o":62,"n":49,"j":10,"i":5,"g":57,"f":16,"e":67,"d":68,"c":70,"a":39,"Z":21,"Y":-14,"X":16,"W":-16,"V":-11,"T":-16,"O":21,"J":78,"G":26,"C":39,"A":61,":":60,".":168,")":-36,"\ufb02":25,"\ufb01":15,"\ufb00":15,"\u2212":34,"\u20ac":52,"\u203a":54,"\u2039":67,"\u2026":174,"\u2022":50,"\u201a":174,"\u2019":-40,"\u2018":-32,"\u2014":31,"\u2013":60,"\u017e":6,"\u017d":13,"\u0178":-23,"\u0161":34,"\u0160":13,"\u0153":59,"\u0152":26,"\u0131":63,"\u00fd":15,"\u00fc":41,"\u00fb":44,"\u00fa":44,"\u00f9":50,"\u00f8":73,"\u00f7":60,"\u00f6":44,"\u00f5":42,"\u00f4":39,"\u00f3":52,"\u00f2":42,"\u00f1":18,"\u00ef":-52,"\u00ee":-11,"\u00ed":15,"\u00ec":-45,"\u00eb":49,"\u00ea":52,"\u00e9":49,"\u00e8":55,"\u00e7":73,"\u00e6":52,"\u00e5":37,"\u00e4":26,"\u00e3":15,"\u00e2":36,"\u00e1":47,"\u00e0":36,"\u00dd":-14,"\u00dc":-3,"\u00d8":33,"\u00d7":60,"\u00d6":13,"\u00d5":29,"\u00d4":15,"\u00d2":16,"\u00d1":18,"\u00cf":-8,"\u00ce":-25,"\u00cb":8,"\u00ca":11,"\u00c7":33,"\u00c6":156,"\u00c5":61,"\u00c4":55,"\u00c3":61,"\u00c2":55,"\u00c1":76,"\u00c0":51,"\u00bf":49,"\u00b7":57,"\u00a2":86,"\u00a1":36,"r":49,"q":72,"m":50,"_":141,"]":-10,"\\":-14,"[":45,"Q":12,"B":5,"@":39,"?":-31,"=":63,";":57,"9":39,"8":23,"7":10,"6":36,"5":23,"4":86,"3":43,"2":41,"1":41,"0":49,"\/":133,",":168,"'":-32,"%":29}},"0":{"d":"206,9v-159,0,-177,-142,-177,-305v0,-172,31,-304,182,-304v148,0,178,115,178,280v0,173,-17,329,-183,329xm116,-290v0,108,-7,225,92,225v34,0,57,-21,74,-61v25,-59,31,-279,4,-350v-13,-34,-36,-52,-71,-52v-38,0,-64,21,-78,63v-14,42,-21,100,-21,175","k":{"\"":45,"\u201d":45,"\u201c":45,"\u0178":39,"\u00dd":39,"Y":39,"X":31,"W":21,"V":21,"T":60,"J":31,"\u2019":45,"\u2018":45,"_":65,"]":66,"\\":36,"'":45}},"1":{"d":"30,0v4,-25,-15,-59,12,-66v34,-9,86,-10,130,-11r11,-439r-114,18v-6,-23,-31,-59,13,-67v53,-10,130,-43,188,-30r-13,518r96,0r36,-3v0,28,-1,48,-2,61v-1,13,-6,19,-15,19r-342,0","k":{"\"":89,"\u201d":89,"\u201c":89,"\u2019":89,"\u2018":89,"\/":-2,"*":58,"'":89}},"2":{"d":"282,-453v0,-109,-170,-65,-223,-34v-8,-24,-21,-64,4,-79v38,-22,100,-33,163,-34v99,-1,152,39,148,136v-6,132,-94,199,-160,282v-27,33,-54,67,-78,105r213,-3r39,-4v0,31,-1,52,-2,65v-1,13,-6,19,-15,19r-339,0v-10,-39,6,-71,21,-96v59,-99,148,-177,205,-275v16,-27,24,-54,24,-82","k":{"\"":23,"\u201d":23,"\u201c":23,"\u2019":23,"\u2018":23,"\/":-8,"'":23}},"3":{"d":"354,-481v0,91,-55,139,-109,180v82,10,132,57,132,149v0,155,-75,248,-226,252v-71,2,-122,-19,-103,-84r7,-25v24,21,57,31,98,31v91,1,138,-78,137,-172v-1,-85,-73,-102,-159,-103r-2,-52v67,-32,129,-76,133,-152v6,-102,-163,-64,-209,-29v-16,-44,-24,-80,35,-97v32,-9,74,-17,127,-17v87,0,139,36,139,119","k":{"\"":29,"\u201d":29,"\u201c":29,"\u2019":29,"\u2018":29,"_":29,"\/":-6,"'":29}},"4":{"d":"236,-592v21,-21,61,-15,83,-2r-3,388v26,1,50,-1,74,-3v8,26,5,79,-23,79r-51,0r-2,119v-13,17,-45,9,-79,11r0,-130r-181,0v-49,-48,-15,-126,11,-180v11,-25,25,-52,39,-81v37,-72,79,-150,132,-201xm235,-206r11,-288v-59,75,-118,182,-148,288r137,0","k":{"\"":29,"\u201d":29,"\u201c":29,"\u2019":29,"\u2018":29,"*":27,"'":29}},"5":{"d":"138,-318v-35,0,-72,7,-96,13r29,-295r306,0v0,43,1,74,-43,73r-194,-4r-15,150v144,-23,259,32,254,187v-6,172,-61,294,-231,294v-51,0,-99,-7,-114,-41v0,-30,2,-44,9,-66v23,21,55,31,97,31v111,0,150,-90,153,-201v2,-103,-54,-141,-155,-141","k":{"_":30}},"6":{"d":"359,-610v-43,-15,-113,-24,-155,0v-70,40,-89,132,-95,243v29,-45,67,-72,137,-72v101,0,145,74,145,194v0,155,-50,251,-190,253v-166,3,-170,-151,-170,-316v0,-178,28,-315,137,-374v27,-15,58,-20,90,-20v53,0,122,-5,108,62v-2,10,-4,21,-7,30xm311,-228v1,-77,-22,-136,-89,-136v-44,0,-82,25,-113,74v-1,77,5,140,22,174v16,34,41,52,74,52v81,0,105,-79,106,-164","k":{"\"":-2,"\u201d":-2,"\u201c":-2,"\u2019":-2,"\u2018":-2,"_":36,"'":-2}},"7":{"d":"293,-530r-226,3v-23,-2,-22,-45,-23,-73r360,0v-104,208,-205,418,-241,688v-45,-3,-75,5,-83,-22v33,-225,117,-435,213,-596","k":{"\u00c6":76,"q":60,"g":61,"e":46,"d":60,"a":37,"]":21,"X":24,"J":104,"A":76,";":47,":":47,")":21,"\u017e":37,"\u017d":76,"\u0161":37,"\u0160":76,"\u00ff":37,"\u00fc":37,"\u00fb":37,"\u00f6":37,"\u00f5":37,"\u00f4":37,"\u00f1":37,"\u00ef":37,"\u00ee":37,"\u00eb":46,"\u00ea":46,"\u00e9":46,"\u00e8":46,"\u00e6":37,"\u00e5":37,"\u00e4":37,"\u00e3":37,"\u00e2":37,"\u00e1":37,"\u00e0":37,"\u00dc":76,"\u00db":76,"\u00d6":76,"\u00d5":76,"\u00d4":76,"\u00d1":76,"\u00cb":76,"\u00ca":76,"\u00c5":76,"\u00c4":76,"\u00c3":76,"\u00c2":76,"\u00c1":76,"\u00c0":76,"_":163,"@":31,"\/":59}},"8":{"d":"38,-534v0,-109,63,-171,171,-172v111,-2,179,48,178,162v-1,91,-54,136,-108,175v56,45,113,90,112,187v-2,115,-58,190,-174,190v-124,0,-184,-71,-186,-192v-1,-91,56,-156,114,-192v-52,-36,-107,-74,-107,-158xm212,-70v110,0,127,-162,55,-215v-19,-14,-37,-32,-57,-46v-51,27,-103,70,-103,143v-1,69,38,118,105,118xm312,-541v0,-57,-35,-88,-92,-88v-56,0,-100,30,-100,90v0,65,57,98,99,128v42,-30,93,-65,93,-130","k":{"_":23}},"9":{"d":"138,104v-50,-1,-105,-4,-88,-61v3,-10,4,-20,5,-27v86,26,176,-2,207,-61v26,-49,40,-110,46,-182v-29,44,-66,70,-135,70v-106,0,-145,-89,-146,-201v-1,-156,50,-247,190,-251v171,-4,172,144,172,312v0,136,-21,237,-61,303v-40,66,-103,98,-190,98xm107,-368v0,76,25,136,90,136v56,0,87,-31,114,-72v-4,-109,9,-233,-93,-233v-81,0,-111,73,-111,169","k":{"\"":23,"\u201d":23,"\u201c":23,"\u2019":23,"\u2018":23,"_":25,"'":23}},":":{"d":"93,-329v-41,0,-55,-19,-56,-57v0,-31,23,-58,56,-58v40,0,55,21,56,58v0,32,-23,57,-56,57xm93,6v-41,0,-55,-19,-56,-57v0,-31,23,-58,56,-58v40,0,55,21,56,58v0,32,-23,57,-56,57","w":183,"k":{"\/":-8,"T":54,"V":5}},";":{"d":"91,-329v-41,0,-55,-19,-56,-57v0,-31,23,-58,56,-58v40,0,55,21,56,58v0,32,-23,57,-56,57xm34,80v15,-27,25,-49,28,-86v-39,-22,-26,-101,27,-101v37,0,55,20,55,60v0,65,-34,126,-78,150v-17,0,-29,-7,-32,-23","w":183,"k":{"j":-64,"T":54,"\/":-11,"V":5}},"=":{"d":"384,-410v-3,37,7,64,-16,71r-334,0v3,-37,-7,-65,17,-71r333,0xm384,-224v-3,37,7,64,-16,71r-334,0v3,-37,-7,-65,17,-71r333,0","k":{"\/":-6}},"?":{"d":"130,6v-41,0,-55,-19,-56,-57v0,-31,23,-58,56,-58v40,0,55,21,56,58v0,32,-23,57,-56,57xm196,-551v8,-93,-121,-89,-165,-52v-6,-19,-12,-39,-12,-64v15,-36,75,-43,125,-43v86,0,139,49,139,139v0,129,-86,172,-121,264v-11,29,10,66,4,90v-13,12,-50,11,-73,8v-19,-37,-17,-105,3,-143v36,-67,92,-106,100,-199","w":295,"k":{"\"":-23,"\u201d":-23,"\u201c":-23,"\u00c6":52,"J":25,"A":52,"\u2019":-23,"\u2018":-23,"\u017d":52,"\u0160":52,"\u00dc":52,"\u00db":52,"\u00d6":52,"\u00d5":52,"\u00d4":52,"\u00d1":52,"\u00cb":52,"\u00ca":52,"\u00c5":52,"\u00c4":52,"\u00c3":52,"\u00c2":52,"\u00c1":52,"\u00c0":52,"'":-23}},"@":{"d":"391,-494v79,2,113,31,110,116r-10,300v80,24,96,-59,110,-134v6,-34,8,-76,8,-126v0,-175,-43,-272,-217,-272v-209,0,-263,142,-262,357v1,213,31,364,238,364v100,0,166,-16,233,-43v14,21,40,63,5,80v-117,58,-381,68,-464,-32v-69,-83,-96,-206,-95,-380v1,-256,99,-415,347,-418v211,-2,301,109,299,323v-2,150,-16,272,-94,337v-33,27,-101,26,-128,-3v-22,16,-63,24,-109,24v-98,0,-127,-55,-125,-154v2,-97,33,-161,127,-163v21,0,44,2,58,11v3,-59,13,-123,-58,-119v-45,3,-70,8,-100,25v-8,-18,-15,-54,0,-67v29,-15,72,-28,127,-26xm422,-258v-76,-16,-108,28,-108,106v0,77,36,107,88,79v30,-35,12,-126,20,-185","w":738,"k":{"\"":39,"\u201d":39,"\u201c":39,"\u0178":16,"\u00dd":16,"x":8,"j":-50,"Y":16,"X":10,"V":13,"T":29,"J":21,"\u2019":39,"\u2018":39,"7":10,"\/":-6,"'":39}},"A":{"d":"305,-178r-172,0r-39,164v-5,26,-58,14,-89,13r178,-688v1,-19,51,-15,69,-11r179,685v2,27,-52,15,-83,15xm150,-252r138,0r-56,-244r-13,-90r-35,192","w":437,"k":{"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2019":106,"\u2018":106,"\u2014":38,"\u2013":38,"\u0178":77,"\u0161":6,"\u0153":21,"\u0152":18,"\u00ff":48,"\u00fd":48,"\u00fc":13,"\u00fb":13,"\u00fa":13,"\u00f9":13,"\u00f6":21,"\u00f5":21,"\u00f4":21,"\u00f3":21,"\u00f2":21,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"q":16,"\\":70,"Q":11,"7":20,"\/":-26,"*":57,"'":106}},"B":{"d":"359,-238v-1,141,-56,233,-190,238r-126,0r0,-681v1,-15,9,-19,27,-19r99,0v105,0,169,46,168,155v-1,84,-29,146,-96,161v78,7,119,57,118,146xm248,-529v0,-81,-38,-108,-122,-99r0,214v88,10,122,-27,122,-115xm264,-231v1,-74,-19,-116,-92,-113r-46,0r0,273v111,13,137,-59,138,-160","w":376,"k":{"\u2026":21,"\u201a":21,"\u2019":15,"\u2018":15,"\u017e":11,"\u017d":16,"\u0178":16,"\u0160":16,"\u00ff":16,"\u00fd":16,"\u00f6":8,"\u00f5":8,"\u00f4":8,"\u00f3":8,"\u00f2":8,"\u00e7":6,"\u00dd":16,"\u00dc":16,"\u00db":16,"\u00d6":16,"\u00d5":16,"\u00d4":16,"\u00d1":16,"\u00cb":16,"\u00ca":16,"\u00c6":16,"\u00c5":16,"\u00c4":16,"\u00c3":16,"\u00c2":16,"\u00c1":16,"\u00c0":16,"_":40,",":21,"'":15,"T":16,"V":8,"Y":16,"t":18,"v":16,"w":8,"y":16,"\"":15,"\u201c":15,"\u201d":15,")":7,"]":7,"A":16,".":21,"J":20,"X":31,"x":31,"\u201e":21}},"C":{"d":"321,-62v-3,67,-122,94,-190,64v-93,-42,-98,-172,-100,-323v-2,-143,18,-249,65,-325v30,-47,71,-62,132,-64v61,-2,107,22,90,82v-3,9,-6,16,-9,22v-21,-21,-75,-36,-111,-14v-93,56,-91,275,-74,420v8,67,24,119,93,120v36,1,73,-16,92,-31v6,12,13,31,12,49","w":339,"k":{"\ufb04":24,"\ufb03":24,"\ufb02":24,"\ufb01":24,"\ufb00":24,"\u2039":23,"\u2026":-5,"\u201a":-5,"\u2019":-6,"\u2018":-6,"\u2014":82,"\u2013":82,"\u017e":4,"\u0161":11,"\u0160":6,"\u0153":15,"\u0152":21,"\u00ff":64,"\u00fd":64,"\u00fc":19,"\u00fb":19,"\u00fa":19,"\u00f9":19,"\u00f6":15,"\u00f5":15,"\u00f4":15,"\u00f3":15,"\u00f2":15,"\u00f1":11,"\u00ef":11,"\u00ee":11,"\u00eb":18,"\u00ea":18,"\u00e9":18,"\u00e8":18,"\u00e7":11,"\u00e6":11,"\u00e5":11,"\u00e4":11,"\u00e3":11,"\u00e2":11,"\u00e1":11,"\u00e0":11,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":10,"q":11,"Q":21,"@":5,"0":26,"\/":-18,",":-5,"*":11,"'":-6,"C":10,"G":13,"d":11,"f":24,"t":20,"u":19,"v":58,"w":52,"y":64,"c":11,"e":18,"o":15,"\u00f8":15,"\"":-6,"-":82,"\u2212":82,"\u201c":-6,"\u201d":-6,"\u00ab":23,"O":21,".":-5,"x":14,"\u201e":-5,"S":6,"a":11,"z":4}},"D":{"d":"44,-681v1,-15,8,-19,27,-19r97,0v171,0,196,136,196,314v0,168,-14,307,-112,367v-51,31,-133,16,-208,19r0,-681xm271,-394v-2,-132,3,-250,-146,-231r0,548v61,3,97,-3,115,-55v24,-67,33,-151,31,-262","w":393,"k":{"\u2026":37,"\u201a":37,"\u2019":34,"\u2018":34,"\u017e":5,"\u017d":36,"\u0178":28,"\u0161":5,"\u0160":36,"\u0153":6,"\u00ff":5,"\u00fc":5,"\u00fb":5,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f3":6,"\u00f2":6,"\u00f1":5,"\u00ef":5,"\u00ee":5,"\u00eb":5,"\u00ea":5,"\u00e6":5,"\u00e5":5,"\u00e4":5,"\u00e3":5,"\u00e2":5,"\u00e1":5,"\u00e0":5,"\u00dd":28,"\u00dc":36,"\u00db":36,"\u00d6":36,"\u00d5":36,"\u00d4":36,"\u00d1":36,"\u00cb":36,"\u00ca":36,"\u00c6":36,"\u00c5":36,"\u00c4":36,"\u00c3":36,"\u00c2":36,"\u00c1":36,"\u00c0":36,"q":5,"_":73,",":37,"'":34,"T":26,"V":15,"W":19,"Y":28,"o":6,"\u00f8":6,"\"":34,"\u201c":34,"\u201d":34,")":20,"]":20,"A":36,".":37,"J":49,"x":7,"\u201e":37,"a":5}},"E":{"d":"276,-418v-3,28,10,75,-15,75r-135,0r0,270r171,0v-3,23,2,55,-7,71v-76,6,-166,0,-246,2r0,-683v1,-9,7,-17,17,-17r239,0v-3,27,10,73,-15,73r-159,0r0,209r150,0","w":320,"k":{"\u2019":-10,"\u2018":-10,"\u2014":27,"\u2013":27,"\u017e":4,"\u0161":10,"\u0153":20,"\u00ff":14,"\u00fd":14,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":5,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"r":7,"q":16,"0":5,"\/":-7,"'":-10,"d":16,"u":7,"w":14,"y":14,"c":5,"e":15,"o":20,"\u00f8":20,"\"":-10,"-":27,"\u2212":27,"\u201c":-10,"\u201d":-10,"x":7,"a":10,"z":4}},"F":{"d":"126,-16v-3,29,-54,11,-82,16r0,-683v1,-9,7,-17,17,-17r239,0v-3,27,10,70,-15,70r-159,0r0,212r150,0v0,31,-1,51,-2,60v-1,9,-6,14,-13,14r-135,0r0,328","w":312,"k":{"\u2039":27,"\u2026":123,"\u201a":123,"\u2019":-10,"\u2018":-10,"\u2014":27,"\u2013":27,"\u017e":14,"\u017d":66,"\u0161":16,"\u0160":66,"\u0153":28,"\u00ff":19,"\u00fd":19,"\u00fc":20,"\u00fb":20,"\u00fa":20,"\u00f9":20,"\u00f8":28,"\u00f6":28,"\u00f5":28,"\u00f4":28,"\u00f3":28,"\u00f2":28,"\u00f1":16,"\u00ef":16,"\u00ee":16,"\u00eb":28,"\u00ea":28,"\u00e9":28,"\u00e8":28,"\u00e7":21,"\u00e6":16,"\u00e5":16,"\u00e4":16,"\u00e3":16,"\u00e2":16,"\u00e1":16,"\u00e0":16,"\u00dc":66,"\u00db":66,"\u00d6":66,"\u00d5":66,"\u00d4":66,"\u00d1":66,"\u00cb":66,"\u00ca":66,"\u00c6":66,"\u00c5":66,"\u00c4":66,"\u00c3":66,"\u00c2":66,"\u00c1":66,"\u00c0":66,"r":17,"q":29,"_":133,"@":10,"0":16,"\/":47,",":123,"'":-10,"d":29,"t":7,"u":20,"v":15,"w":14,"y":19,"c":21,"e":28,"o":28,"\"":-10,"-":27,"\u2212":27,"\u201c":-10,"\u201d":-10,"\u00ab":27,"A":66,".":123,"J":99,"x":45,"\u201e":123,"a":16,"z":14,"g":18,"\u00bb":23,"\u203a":23}},"G":{"d":"141,-116v16,52,106,58,134,22r0,-248r-73,0v4,-26,-12,-70,19,-69r131,0r-1,376v-38,40,-153,61,-222,30v-98,-44,-100,-176,-102,-329v-1,-133,12,-233,57,-305v32,-51,81,-70,157,-70v62,0,121,16,104,77v-2,9,-5,17,-8,24v-17,-15,-46,-24,-79,-24v-142,5,-144,142,-144,293v0,96,8,164,27,223","w":385,"k":{"\u0178":7,"\u00ff":16,"\u00fd":16,"\u00dd":7,"\/":-6,"Y":7,"v":11,"y":16,")":4,"]":4,"x":8}},"H":{"d":"365,-16v1,29,-51,11,-81,16r0,-340r-159,0r0,324v1,29,-51,11,-81,16r1,-692v16,-12,46,-6,80,-8r0,285r159,0r1,-277v16,-12,46,-6,80,-8r0,684","w":409,"k":{"\/":-6}},"I":{"d":"125,-16v0,29,-52,11,-82,16r1,-684v10,-23,45,-13,81,-16r0,684","w":168,"k":{"\/":-11}},"J":{"d":"115,-63v64,1,64,-56,65,-120r2,-501v10,-23,44,-13,81,-16r0,535v0,104,-32,174,-137,174v-76,0,-131,-39,-93,-105v18,16,48,33,82,33","w":306,"k":{"\u2026":14,"\u201a":14,"\u017d":23,"\u0160":23,"\u00dc":23,"\u00db":23,"\u00d6":23,"\u00d5":23,"\u00d4":23,"\u00d1":23,"\u00cb":23,"\u00ca":23,"\u00c6":23,"\u00c5":23,"\u00c4":23,"\u00c3":23,"\u00c2":23,"\u00c1":23,"\u00c0":23,"_":36,"\/":-6,",":14,")":4,"]":4,"A":23,".":14,"J":16,"x":10,"\u201e":14}},"K":{"d":"124,-16v0,29,-52,11,-82,16r2,-692v17,-12,45,-6,80,-8r0,302r159,-297v26,-7,103,-14,85,18r-161,279v94,75,160,213,160,380v0,35,-59,16,-90,17v-28,-135,-44,-240,-112,-317v-11,-12,-26,-20,-41,-27r0,329","w":393,"k":{"\ufb04":33,"\ufb03":33,"\ufb02":33,"\ufb01":33,"\ufb00":33,"\u2039":8,"\u2019":-3,"\u2018":-3,"\u2014":37,"\u2013":37,"\u017e":16,"\u0161":16,"\u0153":18,"\u0152":18,"\u00ff":35,"\u00fd":35,"\u00fc":16,"\u00fb":16,"\u00fa":16,"\u00f9":16,"\u00f6":18,"\u00f5":18,"\u00f4":18,"\u00f3":18,"\u00f2":18,"\u00f1":16,"\u00ef":16,"\u00ee":16,"\u00eb":21,"\u00ea":21,"\u00e9":21,"\u00e8":21,"\u00e7":15,"\u00e6":16,"\u00e5":16,"\u00e4":16,"\u00e3":16,"\u00e2":16,"\u00e1":16,"\u00e0":16,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":21,"q":13,"Q":18,"\/":-14,"*":36,"'":-3,"C":21,"d":13,"f":33,"t":28,"u":16,"v":42,"w":31,"y":35,"c":15,"e":21,"o":18,"\u00f8":18,"\"":-3,"-":37,"\u2212":37,"\u201c":-3,"\u201d":-3,"\u00ab":8,"O":18,"J":10,"a":16}},"L":{"d":"297,-76v-5,26,13,76,-17,76r-237,0r1,-690v15,-15,47,-8,81,-10r0,624r172,0","w":317,"k":{"\ufb04":45,"\ufb03":45,"\ufb02":45,"\ufb01":45,"\ufb00":45,"\u2039":52,"\u2019":136,"\u2018":136,"\u2014":105,"\u2013":105,"\u017e":19,"\u0178":76,"\u0161":19,"\u0160":8,"\u0153":27,"\u0152":32,"\u00ff":54,"\u00fd":54,"\u00fc":18,"\u00fb":18,"\u00fa":18,"\u00f9":18,"\u00f6":27,"\u00f5":27,"\u00f4":27,"\u00f3":27,"\u00f2":27,"\u00f1":19,"\u00ef":19,"\u00ee":19,"\u00eb":26,"\u00ea":26,"\u00e9":26,"\u00e8":26,"\u00e7":23,"\u00e6":19,"\u00e5":19,"\u00e4":19,"\u00e3":19,"\u00e2":19,"\u00e1":19,"\u00e0":19,"\u00dd":76,"\u00d8":32,"\u00d6":32,"\u00d5":32,"\u00d4":32,"\u00d3":32,"\u00d2":32,"\u00c7":28,"r":25,"q":26,"Q":32,"?":34,"0":21,"\/":-8,"*":133,"'":136,"C":28,"G":29,"T":75,"V":76,"W":68,"Y":76,"d":26,"f":45,"t":24,"u":18,"v":34,"w":52,"y":54,"c":23,"e":26,"o":27,"\u00f8":27,"\"":136,"-":105,"\u2212":105,"\u201c":136,"\u201d":136,"\u00ab":52,"O":32,")":17,"]":17,"S":8,"a":19}},"M":{"d":"124,-16v-1,28,-51,12,-81,16r0,-683v0,-32,50,-11,76,-17r127,414r29,-109r93,-301v16,-11,53,-1,77,-4r0,684v0,29,-53,11,-83,16r6,-325r15,-213r-64,224v-20,52,-34,110,-58,158v-11,4,-28,1,-41,2r-117,-385r15,201","w":489},"N":{"d":"124,-16v0,29,-51,11,-81,16r0,-683v1,-31,52,-12,79,-17r112,270r95,282r-10,-300r1,-244v17,-12,47,-6,81,-8r0,684v-2,29,-52,11,-78,16r-114,-275r-95,-283r10,299r0,243","w":444},"O":{"d":"399,-357v0,191,-9,366,-189,366v-181,0,-180,-175,-180,-363v0,-188,15,-355,191,-355v176,0,178,169,178,352xm174,-610v-69,68,-57,262,-48,395v5,73,16,141,88,141v75,0,86,-74,92,-151v9,-124,24,-322,-42,-387v-21,-21,-68,-19,-90,2","w":428,"k":{"\u2026":32,"\u201a":32,"\u2019":10,"\u2018":10,"\u017d":23,"\u0178":21,"\u0160":23,"\u0152":3,"\u00e7":6,"\u00dd":21,"\u00dc":23,"\u00db":23,"\u00d8":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d3":3,"\u00d2":3,"\u00d1":23,"\u00cb":23,"\u00ca":23,"\u00c6":23,"\u00c5":23,"\u00c4":23,"\u00c3":23,"\u00c2":23,"\u00c1":23,"\u00c0":23,"_":52,",":32,"*":7,"'":10,"T":21,"V":10,"W":15,"Y":21,"c":6,"\"":10,"\u201c":10,"\u201d":10,"O":3,"Q":3,")":20,"]":20,"A":23,".":32,"J":32,"X":23,"x":19,"\u201e":32}},"P":{"d":"124,-16v0,29,-51,11,-81,16r0,-683v0,-11,6,-17,17,-17r99,0v132,1,184,62,184,198v0,148,-66,227,-219,218r0,268xm124,-359v106,10,130,-43,129,-152v-1,-65,-16,-118,-79,-118r-50,0r0,270","w":360,"k":{"\u2039":31,"\u2026":144,"\u201a":144,"\u2014":47,"\u2013":47,"\u017e":11,"\u017d":34,"\u0178":13,"\u0161":11,"\u0160":73,"\u0153":23,"\u00ff":11,"\u00fc":11,"\u00fb":11,"\u00f8":23,"\u00f6":23,"\u00f5":23,"\u00f4":23,"\u00f3":23,"\u00f2":23,"\u00f1":11,"\u00ef":11,"\u00ee":11,"\u00eb":23,"\u00ea":23,"\u00e9":23,"\u00e8":23,"\u00e7":21,"\u00e6":11,"\u00e5":11,"\u00e4":11,"\u00e3":11,"\u00e2":11,"\u00e1":11,"\u00e0":11,"\u00dd":13,"\u00dc":73,"\u00db":73,"\u00d6":73,"\u00d5":73,"\u00d4":73,"\u00d1":73,"\u00cb":73,"\u00ca":73,"\u00c6":73,"\u00c5":73,"\u00c4":73,"\u00c3":73,"\u00c2":73,"\u00c1":73,"\u00c0":73,"\u00b7":20,"q":23,"_":194,"@":23,"\/":25,",":144,"Y":13,"d":23,"c":21,"e":23,"o":23,"-":47,"\u2212":47,"\u00ab":31,")":30,"]":30,"A":73,".":144,"J":112,"X":44,"x":8,"\u201e":144,"a":11,"Z":34}},"Q":{"d":"410,97v0,36,-51,40,-90,40v-84,0,-111,-52,-131,-129v-160,-15,-159,-183,-159,-362v0,-188,15,-355,191,-355v176,0,178,169,178,352v0,160,-9,305,-117,354v9,43,14,73,54,73v24,0,47,-5,62,-17v7,9,12,30,12,44xm174,-610v-69,68,-57,262,-48,395v5,73,16,141,88,141v75,0,86,-74,92,-151v9,-124,24,-322,-42,-387v-21,-21,-68,-19,-90,2","w":428,"k":{"\"":10,"\u201e":31,"\u201d":10,"\u201c":10,"x":26,"]":7,"Y":30,"X":26,"V":8,"T":18,"J":32,"A":8,".":31,")":7,"\u2026":31,"\u201a":31,"\u2019":10,"\u2018":10,"\u017d":8,"\u0178":30,"\u0160":8,"\u00dd":30,"\u00dc":8,"\u00db":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c6":52,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"_":-25,",":31,"'":10}},"R":{"d":"124,-16v0,29,-51,11,-81,16r0,-683v1,-9,6,-17,17,-17r99,0v132,1,184,62,184,198v1,100,-30,161,-87,196v53,70,87,167,94,288v2,33,-53,17,-89,18v-8,-118,-33,-214,-82,-285r-55,1r0,268xm124,-359v104,10,131,-40,129,-147v-1,-69,-13,-122,-79,-123r-50,0r0,270","w":373,"k":{"\u2014":25,"\u2013":25,"\u0178":21,"\u0153":13,"\u0152":5,"\u00ff":11,"\u00fd":11,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f3":13,"\u00f2":13,"\u00eb":13,"\u00ea":13,"\u00e9":13,"\u00e8":13,"\u00dd":21,"\u00d8":5,"\u00d6":5,"\u00d5":5,"\u00d4":5,"\u00d3":5,"\u00d2":5,"\u00c7":10,"\u00c6":86,"q":8,"C":10,"T":16,"V":10,"W":10,"Y":21,"d":8,"y":11,"e":13,"o":13,"\u00f8":13,"-":25,"\u2212":25,"O":5,"Q":5,"X":5,"x":8}},"S":{"d":"40,-498v-48,-115,29,-218,158,-212v71,3,120,6,131,50v-1,19,-8,35,-20,47v-48,-35,-198,-42,-195,44v1,48,22,67,46,99v67,89,175,142,175,292v0,119,-56,188,-179,188v-77,0,-147,-19,-126,-88v3,-11,9,-21,16,-30v23,19,58,35,103,35v95,0,118,-92,85,-165v-41,-91,-155,-166,-194,-260","w":358,"k":{"\ufb04":30,"\ufb03":30,"\ufb02":30,"\ufb01":30,"\ufb00":30,"\u2019":-16,"\u2018":-16,"\u00ff":34,"\u00fd":34,"\u00c6":44,"_":20,"'":-16,"f":30,"v":29,"w":34,"y":34,"\"":-16,"\u201c":-16,"\u201d":-16,"J":10,"x":25}},"T":{"d":"225,-16v0,29,-51,11,-81,16r0,-624r-136,0v4,-27,-13,-76,17,-76r340,0v-4,27,13,76,-17,76r-123,0r0,608","w":373,"k":{"\ufb04":44,"\ufb03":44,"\ufb02":44,"\ufb01":44,"\ufb00":44,"\u203a":94,"\u2039":70,"\u2026":94,"\u201a":94,"\u2019":-13,"\u2018":-13,"\u2014":105,"\u2013":105,"\u017e":93,"\u017d":67,"\u0161":93,"\u0160":67,"\u0153":99,"\u0152":22,"\u0131":16,"\u00ff":102,"\u00fd":102,"\u00fc":96,"\u00fb":96,"\u00fa":96,"\u00f9":96,"\u00f8":99,"\u00f6":99,"\u00f5":99,"\u00f4":99,"\u00f3":99,"\u00f2":99,"\u00f1":88,"\u00ef":16,"\u00ee":16,"\u00ed":16,"\u00ec":16,"\u00eb":101,"\u00ea":101,"\u00e9":101,"\u00e8":101,"\u00e7":91,"\u00e6":96,"\u00e5":96,"\u00e4":96,"\u00e3":96,"\u00e2":96,"\u00e1":96,"\u00e0":96,"\u00dc":67,"\u00db":67,"\u00d8":22,"\u00d6":22,"\u00d5":22,"\u00d4":22,"\u00d3":22,"\u00d2":22,"\u00d1":67,"\u00cb":67,"\u00ca":67,"\u00c7":42,"\u00c6":67,"\u00c5":67,"\u00c4":67,"\u00c3":67,"\u00c2":67,"\u00c1":67,"\u00c0":67,"r":88,"q":96,"m":88,"_":86,"Q":22,"@":47,";":70,"0":66,"\/":62,",":94,"*":7,"'":-13,"C":42,"G":36,"d":96,"f":44,"t":43,"u":96,"v":91,"w":90,"y":102,"c":91,"e":101,"o":99,"\"":-13,"-":105,"\u2212":105,"\u201c":-13,"\u201d":-13,"\u00ab":70,"O":22,"A":67,".":94,"J":86,"x":99,"\u201e":94,"a":96,"z":93,"g":96,"\u00bb":94,":":70,"n":88,"p":107,"s":93,"h":24,"k":24,"i":16,"j":16}},"U":{"d":"223,10v-138,0,-180,-78,-180,-214r1,-488v17,-12,47,-6,83,-8r0,498v-1,80,15,137,96,137v31,0,69,-8,88,-18r1,-609v16,-12,47,-6,81,-8r0,674v-34,20,-106,36,-170,36","w":437},"V":{"d":"7,-676v-4,-19,-4,-24,18,-24r66,0r83,387r40,244v27,-212,69,-409,110,-607v0,-40,57,-19,92,-24r-154,703v-34,2,-81,15,-99,-12v-48,-120,-73,-280,-102,-416","w":420,"k":{"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u203a":21,"\u2039":34,"\u2026":47,"\u201a":47,"\u2019":-16,"\u2018":-16,"\u2014":50,"\u2013":50,"\u017e":31,"\u017d":67,"\u0161":36,"\u0160":67,"\u0153":42,"\u0152":10,"\u0131":15,"\u00ff":18,"\u00fd":18,"\u00fc":39,"\u00fb":39,"\u00fa":39,"\u00f9":39,"\u00f8":42,"\u00f6":42,"\u00f5":42,"\u00f4":42,"\u00f3":42,"\u00f2":42,"\u00f1":31,"\u00ef":15,"\u00ee":15,"\u00ed":15,"\u00ec":15,"\u00eb":50,"\u00ea":50,"\u00e9":50,"\u00e8":50,"\u00e7":47,"\u00e6":39,"\u00e5":39,"\u00e4":39,"\u00e3":39,"\u00e2":39,"\u00e1":39,"\u00e0":39,"\u00dc":67,"\u00db":67,"\u00d8":10,"\u00d6":10,"\u00d5":10,"\u00d4":10,"\u00d3":10,"\u00d2":10,"\u00d1":67,"\u00cb":67,"\u00ca":67,"\u00c7":23,"\u00c6":67,"\u00c5":67,"\u00c4":67,"\u00c3":67,"\u00c2":67,"\u00c1":67,"\u00c0":67,"r":31,"q":49,"m":31,"_":84,"Q":10,"@":29,"0":34,"\/":54,",":47,"'":-16,"C":23,"G":16,"d":49,"f":10,"t":10,"u":39,"v":29,"w":21,"y":18,"c":47,"e":50,"o":42,"\"":-16,"-":50,"\u2212":50,"\u201c":-16,"\u201d":-16,"\u00ab":34,"O":10,"A":67,".":47,"J":88,"x":26,"\u201e":47,"a":39,"z":31,"g":53,"\u00bb":21,":":29,";":29,"n":31,"p":39,"s":36,"i":15,"j":21}},"W":{"d":"7,-676v-9,-42,54,-18,84,-24r72,387v8,45,15,85,19,122v4,37,8,71,11,103r6,0v12,-209,57,-386,93,-572v14,-11,50,-4,73,-6r70,353v16,81,21,143,30,224r6,0v3,-32,6,-67,10,-107v18,-168,58,-319,79,-480v5,-39,56,-19,90,-24r-131,703v-35,-1,-80,17,-97,-11v-7,-10,-12,-24,-15,-41r-51,-224r-31,-228r-29,227r-55,277v-37,-2,-89,20,-100,-13v-65,-202,-87,-447,-134,-666","w":655,"k":{"\u203a":10,"\u2039":26,"\u2026":36,"\u201a":36,"\u2019":-20,"\u2018":-20,"\u2014":34,"\u2013":34,"\u017e":28,"\u017d":26,"\u0161":20,"\u0160":54,"\u0153":36,"\u0152":15,"\u00ff":23,"\u00fd":23,"\u00fc":29,"\u00fb":29,"\u00fa":29,"\u00f9":29,"\u00f8":36,"\u00f6":36,"\u00f5":36,"\u00f4":36,"\u00f3":36,"\u00f2":36,"\u00f1":39,"\u00ef":39,"\u00ee":39,"\u00ec":-60,"\u00eb":39,"\u00ea":39,"\u00e9":39,"\u00e8":39,"\u00e7":36,"\u00e6":39,"\u00e5":39,"\u00e4":39,"\u00e3":39,"\u00e2":39,"\u00e1":39,"\u00e0":39,"\u00dc":54,"\u00db":54,"\u00d8":15,"\u00d6":15,"\u00d5":15,"\u00d4":15,"\u00d3":15,"\u00d2":15,"\u00d1":54,"\u00cb":54,"\u00ca":54,"\u00c7":24,"\u00c6":54,"\u00c5":54,"\u00c4":54,"\u00c3":54,"\u00c2":54,"\u00c1":54,"\u00c0":54,"r":39,"q":36,"m":39,"_":70,"Q":15,"@":10,"0":16,"\/":42,",":36,"'":-20,"C":24,"G":16,"d":36,"u":29,"v":10,"w":20,"y":23,"c":36,"e":39,"o":36,"\"":-20,"-":34,"\u2212":34,"\u201c":-20,"\u201d":-20,"\u00ab":26,"O":15,"A":54,".":36,"J":81,"x":29,"\u201e":36,"a":39,"z":28,"g":34,"\u00bb":10,"Z":26,":":28,";":28,"n":39,"p":35,"s":20}},"X":{"d":"268,-368r143,354v5,9,3,14,-8,14r-89,0r-84,-214r-23,-67r-55,146r-54,125v-14,20,-59,6,-89,10r152,-362r-125,-324v-4,-18,19,-14,40,-14r56,0r68,196r21,67r50,-150r41,-107v17,-10,58,-4,85,-6","w":424,"k":{"\ufb04":30,"\ufb03":30,"\ufb02":30,"\ufb01":30,"\ufb00":30,"\u2039":16,"\u2019":-10,"\u2018":-10,"\u2014":55,"\u2013":55,"\u017e":15,"\u0161":15,"\u0153":19,"\u0152":21,"\u00ff":57,"\u00fd":57,"\u00fc":33,"\u00fb":33,"\u00fa":33,"\u00f9":33,"\u00f6":19,"\u00f5":19,"\u00f4":19,"\u00f3":19,"\u00f2":19,"\u00f1":15,"\u00ef":15,"\u00ee":15,"\u00eb":25,"\u00ea":25,"\u00e9":25,"\u00e8":25,"\u00e7":18,"\u00e6":15,"\u00e5":15,"\u00e4":15,"\u00e3":15,"\u00e2":15,"\u00e1":15,"\u00e0":15,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":23,"\u00c6":85,"q":26,"Q":21,"@":5,"0":24,"*":7,"'":-10,"C":23,"G":20,"d":26,"f":30,"t":24,"u":33,"v":45,"w":47,"y":57,"c":18,"e":25,"o":19,"\u00f8":19,"\"":-10,"-":55,"\u2212":55,"\u201c":-10,"\u201d":-10,"\u00ab":16,"O":21,"a":15,"p":23}},"Y":{"d":"225,-16v1,29,-51,11,-81,16r0,-283r-139,-411v18,-10,64,-4,93,-6r71,254r18,92v22,-118,55,-233,89,-340v16,-11,57,-4,84,-6r-135,411r0,273","w":364,"k":{"\ufb04":27,"\ufb03":27,"\ufb02":27,"\ufb01":27,"\ufb00":27,"\u203a":44,"\u2039":58,"\u2026":61,"\u201a":61,"\u2019":-20,"\u2018":-20,"\u2014":65,"\u2013":65,"\u017e":51,"\u017d":77,"\u0161":66,"\u0160":7,"\u0153":70,"\u0152":21,"\u0131":13,"\u00ff":45,"\u00fd":45,"\u00fc":57,"\u00fb":57,"\u00fa":57,"\u00f9":57,"\u00f6":70,"\u00f5":70,"\u00f4":70,"\u00f3":70,"\u00f2":70,"\u00f1":64,"\u00ef":13,"\u00ee":13,"\u00ed":13,"\u00ec":13,"\u00eb":75,"\u00ea":75,"\u00e9":75,"\u00e8":75,"\u00e7":70,"\u00e6":61,"\u00e5":61,"\u00e4":61,"\u00e3":61,"\u00e2":61,"\u00e1":61,"\u00e0":61,"\u00dc":77,"\u00db":77,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00d1":77,"\u00cb":77,"\u00ca":77,"\u00c7":32,"\u00c5":77,"\u00c4":77,"\u00c3":77,"\u00c2":77,"\u00c1":77,"\u00c0":77,"r":64,"q":78,"m":64,"_":73,"Q":21,"@":15,"0":47,"\/":69,",":61,"'":-20,"C":32,"G":29,"d":78,"f":27,"t":33,"u":57,"v":40,"w":42,"y":45,"c":70,"e":75,"o":70,"\u00f8":70,"\"":-20,"-":65,"\u2212":65,"\u201c":-20,"\u201d":-20,"\u00ab":58,"O":21,"A":77,"\u00c6":77,".":61,"J":85,"x":44,"\u201e":61,"S":7,"a":61,"z":51,"g":68,"\u00bb":44,":":52,";":52,"n":64,"p":71,"s":66,"i":13,"j":27}},"Z":{"d":"88,-627v-16,0,-33,0,-44,3v4,-27,-13,-76,17,-76r299,0v12,15,8,45,0,63r-255,564v83,-3,181,8,252,-7v-5,28,15,80,-17,80r-312,0v-16,-14,-16,-44,-5,-68r251,-559r-186,0","w":385,"k":{"\ufb04":27,"\ufb03":27,"\ufb02":27,"\ufb01":27,"\ufb00":27,"\u2039":8,"\u2019":-13,"\u2018":-13,"\u2014":99,"\u2013":99,"\u017e":16,"\u0161":16,"\u0153":20,"\u00ff":36,"\u00fd":36,"\u00fc":27,"\u00fb":27,"\u00fa":27,"\u00f9":27,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":16,"\u00ef":16,"\u00ee":16,"\u00eb":27,"\u00ea":27,"\u00e9":27,"\u00e8":27,"\u00e7":19,"\u00e6":16,"\u00e5":16,"\u00e4":16,"\u00e3":16,"\u00e2":16,"\u00e1":16,"\u00e0":16,"r":27,"q":26,"0":11,"'":-13,"d":26,"f":27,"t":17,"u":27,"w":31,"y":36,"c":19,"e":27,"o":20,"\u00f8":20,"\"":-13,"-":99,"\u2212":99,"\u201c":-13,"\u201d":-13,"\u00ab":8,")":14,"]":14,"x":20,"a":16,"g":15,"p":13}},"[":{"d":"121,-796v-2,-33,30,-25,62,-25r193,0v-3,37,10,75,-27,75r-146,0r0,869r172,0v-3,38,10,76,-27,76r-227,0r0,-995","w":385,"k":{"j":-122,")":-44,"\ufb02":17,"\ufb01":17,"\ufb00":24,"\u20ac":58,"\u2044":39,"\u2039":18,"\u2019":-20,"\u2018":-20,"\u2014":34,"\u2013":34,"\u017e":24,"\u0153":34,"\u0152":20,"\u00ff":-16,"\u00fd":-16,"\u00fc":31,"\u00fb":31,"\u00fa":31,"\u00f9":31,"\u00f8":34,"\u00f6":34,"\u00f5":34,"\u00f4":34,"\u00f3":34,"\u00f2":34,"\u00f1":27,"\u00ef":-13,"\u00ed":17,"\u00ec":-26,"\u00eb":30,"\u00ea":30,"\u00e9":30,"\u00e8":30,"\u00e7":30,"\u00e6":24,"\u00e4":24,"\u00e3":24,"\u00e2":24,"\u00e1":24,"\u00e0":24,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00cf":-10,"\u00ce":-58,"\u00c7":27,"\u00c6":24,"\u00c5":24,"\u00c4":24,"\u00c3":24,"\u00c2":24,"\u00c1":24,"\u00c0":24,"\u00a2":57,"r":27,"q":30,"m":27,"]":-53,"\\":-24,"[":50,"Q":20,"0":68,"\/":39,"+":47,"*":23,"'":-20,"C":27,"G":20,"d":30,"t":14,"u":31,"v":37,"w":37,"y":-16,"c":30,"e":30,"o":34,"\"":-20,"-":34,"\u2212":34,"\u201c":-20,"\u201d":-20,"\u00ab":18,"O":20,"A":24,"x":21,"a":24,"\u00e5":24,"z":24,"Z":14,"\u017d":14,"n":27}},"\\":{"d":"318,10v4,32,-42,16,-81,20r-227,-784v14,-16,47,-9,81,-11","w":330,"k":{"\"":127,"\u201e":-34,"\u201d":127,"\u201c":127,"\u00c6":-42,"]":18,"A":-42,".":-34,")":18,"\u2026":-34,"\u201a":-34,"\u2019":127,"\u2018":127,"\u017d":-42,"\u0160":-42,"\u00dc":-42,"\u00db":-42,"\u00d6":-42,"\u00d5":-42,"\u00d4":-42,"\u00d1":-42,"\u00cb":-42,"\u00ca":-42,"\u00c5":-42,"\u00c4":-42,"\u00c3":-42,"\u00c2":-42,"\u00c1":-42,"\u00c0":-42,"\/":-14,",":-34,"'":127}},"]":{"d":"264,175v2,33,-31,25,-63,25r-192,0v3,-37,-10,-75,27,-75r146,0r0,-871r-172,0v3,-38,-10,-76,27,-76r227,0r0,997","w":385,"k":{"]":42,")":42,"\u2019":76,"\u2018":76,"'":76,"\"":76,"\u201c":76,"\u201d":76}},"_":{"d":"363,38v-3,37,7,64,-16,71r-334,0v3,-37,-7,-65,17,-71r333,0","w":377,"k":{"\ufb02":29,"\ufb01":29,"\u0178":78,"\u0153":31,"\u0152":42,"\u00ff":-1,"\u00fd":-1,"\u00fc":31,"\u00fb":31,"\u00fa":31,"\u00f9":31,"\u00f8":31,"\u00f6":31,"\u00f5":31,"\u00f4":31,"\u00f3":31,"\u00f2":31,"\u00eb":21,"\u00ea":21,"\u00e9":21,"\u00e8":21,"\u00e7":37,"\u00dd":78,"\u00d8":42,"\u00d6":42,"\u00d5":42,"\u00d4":42,"\u00d3":42,"\u00d2":42,"\u00c7":53,"y":-1,"w":50,"v":68,"u":31,"t":57,"o":31,"j":-76,"g":-10,"f":29,"e":21,"d":18,"c":37,"Y":78,"W":60,"V":77,"T":73,"O":42,"G":20,"C":53,"q":36,"Q":25,"9":-15,"8":36,"6":36,"5":-10,"4":136,"0":47,"\/":-49}},"`":{"d":"171,-616v-9,28,-19,60,-54,32v-33,-27,-87,-60,-117,-88v6,-32,22,-83,59,-48v32,31,84,71,112,104","w":171},"a":{"d":"235,-372v6,-98,-143,-51,-194,-37v-12,-19,-18,-58,0,-74v30,-15,95,-27,152,-27v172,0,115,185,123,346r-5,140v-32,18,-82,34,-139,34v-102,0,-143,-48,-143,-152v0,-103,35,-164,133,-164v25,0,56,3,73,13r0,-79xm114,-144v-8,80,64,108,118,69r3,-161v-11,-6,-31,-9,-47,-9v-59,0,-68,40,-74,101","w":354,"k":{"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":83,"\u2018":83,"\u00ff":8,"\u00fd":8,"'":83,"f":9,"t":17,"y":8,"\"":83,"\u201c":83,"\u201d":83,")":24,"]":24,"x":8}},"b":{"d":"235,-510v161,0,130,254,103,369v-22,93,-70,151,-174,151v-53,0,-92,-10,-117,-30r0,-677v-3,-46,37,-37,81,-38r0,260v26,-22,59,-35,107,-35xm256,-173v11,-77,36,-267,-58,-264v-26,0,-49,9,-70,28r0,334v34,23,91,12,106,-27v7,-17,17,-40,22,-71","w":383,"k":{"\u2026":20,"\u201a":20,"\u2019":78,"\u2018":78,"\u017e":4,"_":39,"\/":10,",":20,"'":78,"t":7,"w":3,"\"":78,"\u201c":78,"\u201d":78,")":27,"]":27,".":20,"\u201e":20,"z":4}},"c":{"d":"211,-510v45,0,95,16,81,65v-1,8,-4,16,-7,25v-16,-9,-44,-19,-70,-18v-93,5,-99,95,-99,199v0,93,2,174,89,177v30,1,61,-12,79,-23v31,68,-34,95,-104,95v-137,0,-149,-108,-149,-249v0,-158,34,-271,180,-271","w":313,"k":{"\u2039":29,"\u2019":45,"\u2018":45,"\u2014":35,"\u2013":35,"\u0153":12,"\u00ff":-3,"\u00fd":-3,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":15,"q":16,"\/":-18,"'":45,"d":16,"t":-6,"w":-3,"y":-3,"c":15,"e":16,"o":12,"\u00f8":12,"\"":45,"-":35,"\u2212":35,"\u201c":45,"\u201d":45,"\u00ab":29,")":7,"]":7}},"d":{"d":"198,-63v24,0,44,-5,59,-15r0,-348v-13,-11,-23,-13,-46,-13v-84,0,-88,100,-88,198v0,88,-4,178,75,178xm32,-232v0,-144,25,-278,154,-278v30,0,54,7,71,20r0,-208v-2,-44,37,-36,81,-37r0,715v-37,17,-85,30,-143,30v-137,0,-163,-98,-163,-242","w":386,"k":{"\u00ef":-13,"\u00ee":-13,"\u00ec":-13,"\/":-6}},"e":{"d":"31,-224v0,-162,27,-277,177,-286v131,-8,143,162,116,291v-62,11,-137,16,-209,16v3,77,15,135,93,134v44,0,83,-14,114,-31v5,13,7,38,7,55v-13,47,-78,54,-138,55v-133,3,-160,-96,-160,-234xm251,-280v7,-64,17,-165,-52,-159v-73,7,-76,88,-83,170v45,-4,98,-1,135,-11","w":361,"k":{"\u2019":60,"\u2018":60,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\/":-5,"'":60,"t":4,"w":3,"e":10,"\"":60,"\u201c":60,"\u201d":60,")":20,"]":20,"x":7}},"f":{"d":"162,-16v-1,27,-53,12,-81,16r0,-431r-69,0v3,-32,-10,-68,21,-69r48,0v-10,-147,31,-243,168,-239v56,2,103,8,91,63v-1,8,-4,16,-7,23v-21,-10,-44,-12,-71,-12v-68,-2,-101,29,-100,98r0,67r90,0v-3,31,10,69,-17,69r-73,0r0,415","w":255,"k":{"!":-86,"\ufb04":40,"\ufb03":40,"\ufb02":40,"\ufb01":40,"\ufb00":40,"\u2122":-94,"\u2039":21,"\u2030":-45,"\u2026":48,"\u201a":48,"\u2019":-123,"\u2018":-123,"\u2014":48,"\u2013":48,"\u0153":17,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f8":17,"\u00f6":17,"\u00f5":17,"\u00f4":17,"\u00f3":17,"\u00f2":17,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":15,"\u00ae":-63,"\u00a9":-62,"r":7,"q":21,"m":3,"_":50,"]":-112,"\\":-100,"?":-112,"8":-19,",":48,"*":-33,"'":-123,"&":-36,"d":21,"u":7,"c":15,"e":20,"o":17,"\"":-123,"-":48,"\u2212":48,"\u201c":-123,"\u201d":-123,"\u00ab":21,"b":-3,")":-112,".":48,"\u201e":48,"g":20,"p":33,"h":-3,"k":-3}},"g":{"d":"39,-327v-5,-136,86,-206,216,-175r120,0v11,19,16,70,-20,70v-9,0,-21,-2,-36,-5v23,23,38,60,38,108v0,125,-76,194,-207,171v-11,12,-41,41,-17,56v92,31,244,4,241,136v-3,110,-77,163,-192,163v-93,0,-160,-23,-160,-109v0,-56,40,-94,76,-120v-51,-9,-80,-53,-43,-98v12,-15,27,-32,46,-47v-45,-28,-59,-82,-62,-150xm275,-348v0,-65,-17,-102,-73,-102v-55,0,-77,49,-77,121v0,64,10,115,74,113v64,-2,75,-58,76,-132xm190,122v67,2,116,-41,96,-105v-19,-34,-75,-32,-126,-38v-24,19,-54,51,-54,90v0,45,36,52,84,53","w":393,"k":{"\u2019":43,"\u2018":43,"\u017e":-3,"\u0153":7,"\u00ff":-6,"\u00fd":-6,"\u00f8":7,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":5,"\u00ea":5,"\u00e9":5,"\u00e8":5,"\u00e7":7,"q":5,"\/":-8,"'":43,"d":5,"y":-6,"c":7,"e":5,"o":7,"\"":43,"\u201c":43,"\u201d":43,"x":7,"z":-3,"j":-93,"\u00df":7,"\u017f":7}},"h":{"d":"126,-16v0,29,-51,11,-81,16r0,-698v-3,-45,38,-35,81,-37r0,264v26,-24,67,-38,112,-39v82,-2,104,50,104,132r0,362v-1,29,-54,11,-84,16r0,-355v1,-46,-11,-81,-57,-80v-30,1,-56,10,-75,28r0,391","w":380,"k":{"\"":88,"\u201d":88,"\u201c":88,"y":10,"w":2,"t":7,"\u2019":88,"\u2018":88,"\u00ff":10,"\u00fd":10,"\/":-15,"'":88,")":27,"]":27,"x":4}},"i":{"d":"129,-16v0,29,-53,11,-83,16r0,-463v-2,-45,39,-35,83,-37r0,484xm88,-596v-33,0,-41,-23,-41,-63v0,-34,13,-60,47,-60v35,1,41,19,40,58v0,37,-12,65,-46,65","w":175,"k":{"\/":-23}},"j":{"d":"-6,121v58,-2,60,-35,60,-98r0,-486v-2,-44,37,-36,81,-37r0,536v0,97,-32,160,-131,160v-67,0,-116,-14,-104,-75v2,-7,5,-14,10,-20v23,13,51,20,84,20xm93,-596v-33,0,-41,-23,-41,-63v0,-34,13,-60,47,-60v35,1,41,19,40,58v0,37,-12,65,-46,65","w":184,"k":{"\/":-24,"j":-57}},"k":{"d":"128,-16v1,29,-52,11,-82,16r0,-698v-2,-45,38,-36,82,-37r0,271v28,-25,77,-46,125,-46v58,0,85,31,85,86v0,75,-42,122,-83,155v75,32,118,146,95,263v-16,12,-61,4,-90,6v16,-108,-8,-267,-117,-215v-5,3,-10,5,-15,8r0,191xm128,-265v58,-25,118,-58,120,-131v0,-27,-12,-41,-37,-41v-37,0,-62,23,-83,48r0,124","w":381,"k":{"\u2019":76,"\u2018":76,"\u2014":20,"\u2013":20,"\u0153":7,"\u00ff":20,"\u00fd":20,"\u00f6":7,"\u00f5":7,"\u00f4":7,"\u00f3":7,"\u00f2":7,"\u00eb":7,"\u00ea":7,"\u00e9":7,"\u00e8":7,"\u00e7":7,"q":7,"\/":-14,"'":76,"w":10,"y":20,"c":7,"e":7,"o":7,"\u00f8":7,"\"":76,"-":20,"\u2212":20,"\u201c":76,"\u201d":76,")":7,"]":7,"p":7}},"l":{"d":"127,-16v0,29,-51,11,-81,16r0,-698v-3,-44,38,-36,81,-37r0,719","w":173},"m":{"d":"325,-16v1,29,-51,11,-81,16r0,-389v6,-68,-76,-54,-117,-33r0,406v0,29,-51,11,-81,16r0,-477v60,-30,190,-56,241,-2v31,-17,78,-30,123,-31v91,-2,112,51,112,141r0,353v0,29,-51,11,-81,16r0,-370v-1,-45,-5,-67,-49,-68v-28,0,-48,6,-67,19r0,403","w":563,"k":{"\"":88,"\u201d":88,"\u201c":88,"y":5,"x":4,"w":2,"f":4,"]":27,")":27,"\ufb04":4,"\ufb03":4,"\ufb02":4,"\ufb01":4,"\ufb00":4,"\u2019":88,"\u2018":88,"\u00ff":5,"\u00fd":5,"\/":-22,"'":88}},"n":{"d":"126,-16v0,29,-51,11,-81,16r0,-476v44,-18,98,-34,158,-34v104,0,141,33,141,134r0,360v0,29,-53,11,-84,16r0,-352v-2,-60,-4,-86,-60,-87v-25,0,-56,8,-74,18r0,405","w":382,"k":{"\u2019":88,"\u2018":88,"\/":-31,"'":88,"\"":88,"\u201c":88,"\u201d":88,")":27,"]":27,"x":4}},"o":{"d":"181,10v-145,6,-156,-111,-157,-260v-1,-155,38,-256,166,-260v139,-4,155,113,155,257v0,158,-33,258,-164,263xm218,-432v-131,-40,-107,168,-102,283v2,63,37,108,96,82v56,-41,48,-190,40,-281v-3,-40,-11,-69,-34,-84","w":368,"k":{"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":82,"\u2018":82,"\u017e":7,"\u0161":6,"\u00ff":20,"\u00fd":20,"\u00fc":6,"\u00fb":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":6,"\u00ea":6,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"_":44,"\/":-16,",":20,"*":10,"'":82,"f":10,"t":14,"v":10,"w":10,"y":20,"\"":82,"\u201c":82,"\u201d":82,")":34,"]":34,".":20,"x":24,"\u201e":20,"z":7}},"p":{"d":"127,190v-29,10,-81,17,-81,-28r0,-632v42,-27,91,-40,146,-40v124,-1,163,79,163,208v0,113,-16,194,-49,257v-31,59,-133,71,-179,27r0,208xm265,-293v-1,-78,-3,-144,-77,-146v-23,0,-43,6,-61,19r0,324v20,41,87,45,107,-4v20,-48,32,-109,31,-193","w":383,"k":{"\ufb04":7,"\ufb03":7,"\ufb02":7,"\ufb01":7,"\ufb00":7,"\u2026":20,"\u201a":20,"\u2019":97,"\u2018":97,"\u017e":10,"\u0161":12,"\u00ff":23,"\u00fd":23,"\u00fc":12,"\u00fb":12,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f1":12,"\u00ef":12,"\u00ee":12,"\u00eb":12,"\u00ea":12,"\u00e6":7,"\u00e5":7,"\u00e4":7,"\u00e3":7,"\u00e2":7,"\u00e1":7,"\u00e0":7,"_":59,"?":6,"\/":-6,",":20,"*":10,"'":97,"f":7,"t":10,"v":10,"w":10,"y":23,"\"":97,"\u201c":97,"\u201d":97,")":34,"]":34,".":20,"x":14,"\u201e":20,"a":7,"z":10,"j":3}},"q":{"d":"236,-510v49,0,77,10,107,31r0,642v7,45,-47,35,-82,32r0,-229v-20,29,-52,44,-95,44v-114,0,-135,-101,-135,-228v0,-169,47,-292,205,-292xm196,-61v33,0,55,-22,65,-51r0,-313v-11,-9,-26,-14,-46,-14v-93,0,-92,114,-92,219v0,81,4,159,73,159","w":390,"k":{"\"":64,"\u201d":64,"\u201c":64,"\u2019":64,"\u2018":64,"\/":-16,"'":64}},"r":{"d":"127,-16v0,29,-52,11,-82,16r0,-465v35,-24,81,-42,136,-45v66,-4,82,38,61,90v-36,-21,-89,-12,-114,11","w":263,"k":{"\u2039":47,"\u2026":76,"\u201a":76,"\u2019":39,"\u2018":39,"\u2014":71,"\u2013":71,"\u0153":20,"\u00f8":20,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":21,"\u00ea":21,"\u00e9":21,"\u00e8":21,"\u00e7":20,"r":4,"q":22,"_":89,"\/":11,",":76,"'":39,"d":22,"c":20,"e":21,"o":20,"\"":39,"-":71,"\u2212":71,"\u201c":39,"\u201d":39,"\u00ab":47,")":24,"]":24,".":76,"x":14,"\u201e":76,"g":21,"p":7}},"s":{"d":"42,-340v-44,-100,36,-170,152,-170v79,0,160,33,108,97v-29,-17,-61,-26,-98,-26v-51,0,-101,30,-72,75v50,79,185,106,185,235v0,93,-68,140,-165,139v-63,-1,-136,-9,-119,-72v2,-8,6,-17,11,-26v52,33,181,45,181,-37v0,-37,-16,-56,-40,-78v-45,-42,-118,-82,-143,-137","w":345,"k":{"\u2019":55,"\u2018":55,"\u2014":34,"\u2013":34,"\u00ff":4,"\u00fd":4,"\/":-8,"'":55,"y":4,"\"":55,"-":34,"\u2212":34,"\u201c":55,"\u201d":55,")":7,"]":7,"x":7}},"t":{"d":"182,10v-85,2,-97,-64,-96,-149r0,-291r-68,0v3,-30,-10,-70,18,-70r50,0v2,-55,-4,-119,4,-168v14,-17,45,-10,78,-12r0,180r102,0v-3,22,2,53,-7,68v-27,5,-64,1,-95,2r0,291v1,38,-2,79,36,79v26,0,39,-5,58,-15v3,11,6,25,6,40v-3,39,-45,43,-86,45","w":291,"k":{"\u2039":33,"\u2026":-6,"\u201a":-6,"\u2019":34,"\u2018":34,"\u2014":65,"\u2013":65,"\u0153":17,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":17,"\u00f5":17,"\u00f4":17,"\u00f3":17,"\u00f2":17,"\u00eb":23,"\u00ea":23,"\u00e9":23,"\u00e8":23,"\u00e7":23,"q":17,"0":5,"\/":-14,",":-6,"'":34,"d":17,"t":54,"u":7,"c":23,"e":23,"o":17,"\u00f8":17,"\"":34,"-":65,"\u2212":65,"\u201c":34,"\u201d":34,"\u00ab":33,")":7,"]":7,".":-6,"\u201e":-6,"g":10}},"u":{"d":"195,-61v25,0,51,-5,67,-18r2,-413v16,-12,45,-6,79,-8r0,474v-37,20,-93,36,-149,36v-112,0,-150,-55,-150,-166r2,-336v17,-12,46,-6,82,-8r0,351v2,62,7,88,67,88","w":390,"k":{"\u2019":63,"\u2018":63,"\/":-18,"'":63,"\"":63,"\u201c":63,"\u201d":63,")":31,"]":31}},"v":{"d":"18,-475v-7,-39,45,-20,87,-25r47,244r24,169r2,0r22,-170r45,-235v18,-11,47,-6,83,-8r-115,503v-25,1,-68,12,-79,-11v-5,-10,-11,-21,-14,-35","w":344,"k":{"\u2039":16,"\u2026":51,"\u201a":51,"\u2019":58,"\u2018":58,"\u2014":24,"\u2013":24,"\u017e":11,"\u0161":10,"\u0153":20,"\u00ff":11,"\u00fc":14,"\u00fb":14,"\u00fa":14,"\u00f9":14,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":11,"\u00ef":11,"\u00ee":11,"\u00eb":24,"\u00ea":24,"\u00e9":24,"\u00e8":24,"\u00e7":16,"\u00e6":11,"\u00e5":11,"\u00e4":11,"\u00e3":11,"\u00e2":11,"\u00e1":11,"\u00e0":11,"r":20,"q":23,"m":14,"k":7,"_":76,"@":10,"0":8,"\/":23,",":51,"'":58,"d":23,"t":7,"u":14,"c":16,"e":24,"o":20,"\u00f8":20,"\"":58,"-":24,"\u2212":24,"\u201c":58,"\u201d":58,")":27,"]":27,".":51,"\u201e":51,"a":11,"g":24,":":5,";":5,"p":14,"s":10}},"w":{"d":"424,-18v-2,38,-23,19,-58,24v-45,-6,-49,-74,-56,-119r-30,-195v-2,-20,-5,-38,-6,-53r-24,183r-35,181v-32,-3,-80,17,-90,-11v-51,-145,-74,-318,-110,-475v-4,-19,18,-15,39,-17v12,-1,29,0,50,0r44,248r21,158r6,0r59,-375v2,-30,52,-12,80,-17r61,329r9,63r5,0r31,-243r29,-155v16,-12,45,-6,77,-8","w":540,"k":{"\u2039":18,"\u2026":39,"\u201a":39,"\u2019":64,"\u2018":64,"\u2014":20,"\u2013":20,"\u017e":14,"\u0161":10,"\u0153":20,"\u00ff":10,"\u00fc":14,"\u00fb":14,"\u00fa":14,"\u00f9":14,"\u00f8":20,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":24,"\u00ea":24,"\u00e9":24,"\u00e8":24,"\u00e7":22,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"r":20,"q":18,"m":9,"k":14,"_":58,"@":5,"\/":5,",":39,"'":64,"d":18,"t":7,"u":14,"c":22,"e":24,"o":20,"\"":64,"-":20,"\u2212":20,"\u201c":64,"\u201d":64,")":36,"]":36,".":39,"x":11,"\u201e":39,"a":10,"z":14,"g":24,":":8,";":8,"p":14,"s":10}},"x":{"d":"258,-266r133,247v11,20,-9,18,-33,19r-57,0r-89,-170v-5,-11,-10,-21,-13,-29r-63,134v-21,27,-21,72,-76,65r-45,0r141,-261r-124,-233v16,-10,61,-4,88,-6r90,182r55,-114r35,-62v17,-11,59,-4,86,-6","w":410,"k":{"\ufb04":11,"\ufb03":11,"\ufb02":11,"\ufb01":11,"\ufb00":11,"\u2039":39,"\u2019":48,"\u2018":48,"\u2014":76,"\u2013":76,"\u017e":7,"\u0161":14,"\u0153":24,"\u00ff":11,"\u00fd":11,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f8":24,"\u00f6":24,"\u00f5":24,"\u00f4":24,"\u00f3":24,"\u00f2":24,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":21,"\u00ea":21,"\u00e9":21,"\u00e8":21,"\u00e7":13,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"r":17,"q":24,"m":7,"k":14,"@":5,"0":5,"\/":-15,"'":48,"d":24,"f":11,"t":14,"u":7,"w":24,"y":11,"c":13,"e":21,"o":24,"\"":48,"-":76,"\u2212":76,"\u201c":48,"\u201d":48,")":19,"]":19,"x":7,"a":10,"z":7,"g":14,"p":10,"s":14}},"y":{"d":"8,108v29,16,82,27,106,-7v11,-16,23,-44,30,-85r-122,-506v13,-16,46,-7,81,-10r65,295r16,120v17,-142,42,-276,72,-405v16,-15,48,-8,84,-10r-123,527v-23,86,-39,163,-140,166v-56,1,-91,-12,-78,-63v2,-9,5,-17,9,-22","w":356,"k":{"\u2039":14,"\u2026":55,"\u201a":55,"\u2019":62,"\u2018":62,"\u2014":27,"\u2013":27,"\u017e":7,"\u0161":10,"\u0153":20,"\u00ff":7,"\u00fc":14,"\u00fb":14,"\u00fa":14,"\u00f9":14,"\u00f8":20,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":7,"\u00ef":11,"\u00ee":11,"\u00eb":23,"\u00ea":23,"\u00e9":23,"\u00e8":23,"\u00e7":25,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"r":20,"q":18,"m":9,"k":14,"_":53,"\/":31,",":55,"'":62,"d":18,"t":7,"u":14,"c":25,"e":23,"o":20,"\"":62,"-":27,"\u2212":27,"\u201c":62,"\u201d":62,")":36,"]":36,".":55,"x":7,"\u201e":55,"a":10,"z":7,"g":24,":":8,";":8,"p":14,"s":10}},"z":{"d":"28,-426v-5,-30,-8,-74,23,-74r254,0v14,15,9,45,-1,65r-188,360v66,0,146,3,193,-11v4,34,11,86,-30,86r-245,0v-16,-12,-18,-49,-7,-71r194,-360r-102,0v-33,0,-65,2,-91,5","w":334,"k":{"\u2039":10,"\u2019":47,"\u2018":47,"\u2014":37,"\u2013":37,"\u017e":11,"\u0161":11,"\u0153":10,"\u00ff":7,"\u00fd":7,"\u00fc":14,"\u00fb":14,"\u00fa":14,"\u00f9":14,"\u00f8":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f3":10,"\u00f2":10,"\u00f1":11,"\u00ef":11,"\u00ee":11,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":14,"\u00e6":11,"\u00e5":11,"\u00e4":11,"\u00e3":11,"\u00e2":11,"\u00e1":11,"\u00e0":11,"q":16,"'":47,"d":16,"t":7,"u":14,"w":7,"y":7,"c":14,"e":16,"o":10,"\"":47,"-":37,"\u2212":37,"\u201c":47,"\u201d":47,")":24,"]":24,"x":14,"g":10,"p":7}},"|":{"d":"203,-815r-1,1007v-16,13,-47,6,-81,8r1,-1006v14,-15,47,-7,81,-9","w":323},"\u00a1":{"d":"102,-508v41,0,55,20,56,57v0,31,-22,58,-56,58v-40,0,-55,-21,-56,-58v0,-31,23,-57,56,-57xm155,173v-7,38,-63,19,-111,24r16,-452v0,-41,40,-36,82,-37","w":195,"k":{"j":-93,"\/":-30}},"\u00a2":{"d":"83,-228v0,-140,26,-245,129,-276v5,-40,-15,-102,19,-114v13,-4,31,-7,55,-7r0,117v30,8,69,14,58,56v-1,11,-4,27,-8,36v-17,-10,-39,-19,-67,-18v-97,4,-105,95,-105,203v0,95,-1,166,93,166v27,0,61,-12,78,-23v5,11,8,37,8,51v0,25,-48,45,-80,46v-6,41,15,106,-19,119v-12,4,-30,5,-55,5r0,-127v-99,-16,-106,-114,-106,-234","k":{"\"":25,"\u201d":25,"\u201c":25,"]":31,")":31,"\u2019":25,"\u2018":25,"'":25}},"\u00a5":{"d":"249,-16v1,29,-51,11,-81,16r0,-176r-130,0v2,-41,-3,-68,32,-68r98,0v4,-43,-10,-68,-20,-97r-110,0v2,-41,-3,-68,32,-68r55,0r-96,-285v18,-10,64,-4,93,-6r70,245r17,82v21,-112,59,-219,91,-321v16,-11,57,-4,84,-6r-95,291r89,0v-2,41,4,68,-31,68r-81,0v-10,28,-21,55,-17,97r130,0v-2,41,3,68,-32,68r-98,0r0,160","k":{"\/":15}},"\u00a8":{"d":"49,-588v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm191,-588v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":241},"\u00a9":{"d":"249,-668v20,0,56,4,43,32v-1,7,-3,13,-4,16v-11,-3,-19,-7,-34,-7v-47,1,-50,46,-50,97v0,42,2,75,44,73v13,0,28,-7,38,-10v3,5,7,23,7,29v-1,13,-32,21,-50,21v-73,0,-86,-41,-86,-114v0,-81,19,-137,92,-137xm234,-320v-143,0,-199,-76,-199,-221v0,-145,70,-217,207,-219v141,-2,194,75,194,217v0,139,-66,223,-202,223xm241,-704v-101,0,-144,58,-144,163v0,103,35,164,135,162v98,-2,142,-63,142,-165v0,-106,-35,-160,-133,-160","w":472,"k":{"\/":93}},"\u00ab":{"d":"163,-500v27,2,38,23,49,41v-24,82,-78,140,-118,207r82,124v15,25,32,50,38,81v-9,22,-21,45,-48,47r-101,-156v-15,-31,-38,-60,-47,-96v33,-94,96,-168,145,-248xm334,-477v42,9,58,38,29,83v-31,47,-63,97,-96,143r58,78v19,29,52,72,58,104v-9,20,-20,41,-46,44r-101,-139v-13,-34,-60,-64,-40,-106v36,-75,91,-140,138,-207","w":416,"k":{"T":65,"V":26,"W":27,"Y":39,"\u00dd":39,"\u0178":39}},"\u00ae":{"d":"234,-320v-143,0,-199,-76,-199,-221v0,-145,70,-217,207,-219v141,-2,194,75,194,217v0,139,-66,223,-202,223xm241,-704v-101,0,-144,58,-144,163v0,103,35,164,135,162v98,-2,142,-63,142,-165v0,-106,-35,-160,-133,-160xm176,-665v8,-11,35,-4,51,-5v53,-2,80,23,81,73v0,34,-14,54,-34,68v21,21,38,55,41,103v1,16,-26,9,-41,9v-3,-50,-15,-80,-36,-100r-24,0r0,92v-4,13,-14,6,-38,8r0,-248xm214,-551v38,3,54,-11,54,-49v0,-31,-20,-40,-54,-37r0,86","w":472,"k":{"\/":83}},"\u00b4":{"d":"0,-615v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":171},"\u00b7":{"d":"109,-212v-41,0,-55,-19,-56,-57v0,-31,23,-58,56,-58v40,0,55,21,56,58v0,32,-23,57,-56,57","w":221},"\u00b8":{"d":"89,129v4,-41,-41,-35,-71,-28r19,-103r45,0r-12,60v45,-3,66,18,66,64v0,72,-73,103,-136,72v7,-16,4,-55,30,-38v23,15,63,8,59,-27","w":136},"\u00bb":{"d":"248,0v-27,-8,-60,-30,-43,-66v33,-69,71,-122,115,-186r-81,-125v-18,-32,-62,-88,-13,-113v7,-4,16,-7,25,-10r122,195v11,27,32,44,17,75v-41,81,-94,156,-142,230xm76,-22v-39,-12,-57,-46,-26,-90v31,-45,65,-94,98,-138v-34,-60,-91,-116,-113,-189v2,-25,24,-33,44,-41r122,180v11,24,33,41,17,70v-42,76,-89,138,-142,208","w":414,"k":{"\u2014":-11,"\u2013":-11,"T":65,"V":31,"W":31,"Y":55,"\u00dd":55,"\u0178":55,"v":8,"w":2,"y":3,"\u00fd":3,"\u00ff":3,"-":-11,"\u2212":-11,")":14,"]":14,"J":41,"X":27,"x":14,"z":24,"\u017e":24,"Z":8,"\u017d":8}},"\u00bf":{"d":"167,-506v41,0,55,19,56,57v0,31,-22,58,-56,58v-40,0,-55,-21,-56,-58v0,-32,23,-57,56,-57xm266,88v7,24,25,65,1,82v-25,18,-71,24,-114,25v-86,0,-139,-49,-139,-139v0,-129,86,-172,120,-264v11,-29,-8,-65,-3,-89v14,-12,49,-12,73,-9v8,21,16,42,15,71v-4,122,-108,152,-117,272v-7,93,121,87,164,51","w":306,"k":{"\"":62,"\u201d":62,"\u201c":62,"\u00c6":11,"j":-108,"]":-3,"A":11,")":-3,"\u2019":62,"\u2018":62,"\u017d":11,"\u0160":11,"\u00dc":11,"\u00db":11,"\u00d6":11,"\u00d5":11,"\u00d4":11,"\u00d1":11,"\u00cb":11,"\u00ca":11,"\u00c5":11,"\u00c4":11,"\u00c3":11,"\u00c2":11,"\u00c1":11,"\u00c0":11,"'":62}},"\u00c0":{"d":"305,-178r-172,0r-39,164v-5,26,-58,14,-89,13r178,-688v1,-19,51,-15,69,-11r179,685v2,27,-52,15,-83,15xm150,-252r138,0r-56,-244r-13,-90r-35,192xm272,-816v-9,28,-19,60,-54,32v-33,-27,-87,-60,-117,-88v6,-32,22,-83,59,-48v32,31,84,71,112,104","w":437,"k":{"\"":106,"\u2212":38,"\u201d":106,"\u201c":106,"\u00f8":13,"\u00ab":11,"y":48,"w":42,"v":50,"u":10,"t":40,"s":6,"o":13,"f":22,"e":15,"d":13,"c":6,"b":6,"]":20,"Y":77,"W":54,"V":67,"T":60,"O":18,"G":16,"C":26,"-":38,")":20,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2019":106,"\u2018":106,"\u2014":38,"\u2013":38,"\u0178":77,"\u0161":6,"\u0153":21,"\u0152":18,"\u00ff":48,"\u00fd":48,"\u00fc":13,"\u00fb":13,"\u00fa":13,"\u00f9":13,"\u00f6":21,"\u00f5":21,"\u00f4":21,"\u00f3":21,"\u00f2":21,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"q":16,"\\":70,"Q":11,"7":20,"\/":-16,"*":48,"'":106}},"\u00c1":{"d":"305,-178r-172,0r-39,164v-5,26,-58,14,-89,13r178,-688v1,-19,51,-15,69,-11r179,685v2,27,-52,15,-83,15xm150,-252r138,0r-56,-244r-13,-90r-35,192xm171,-815v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":437,"k":{"\"":106,"\u2212":38,"\u201d":106,"\u201c":106,"\u00f8":13,"\u00ab":11,"y":48,"w":42,"v":50,"u":10,"t":40,"s":6,"o":13,"f":22,"e":15,"d":13,"c":6,"b":6,"]":20,"Y":77,"W":54,"V":67,"T":60,"O":18,"G":16,"C":26,"-":38,")":20,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2019":106,"\u2018":106,"\u2014":38,"\u2013":38,"\u0178":77,"\u0161":6,"\u0153":21,"\u0152":18,"\u00ff":48,"\u00fd":48,"\u00fc":13,"\u00fb":13,"\u00fa":13,"\u00f9":13,"\u00f6":21,"\u00f5":21,"\u00f4":21,"\u00f3":21,"\u00f2":21,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"q":16,"\\":70,"Q":11,"7":20,"\/":-11,"*":48,"'":106}},"\u00c2":{"d":"305,-178r-172,0r-39,164v-5,26,-58,14,-89,13r178,-688v1,-19,51,-15,69,-11r179,685v2,27,-52,15,-83,15xm150,-252r138,0r-56,-244r-13,-90r-35,192xm204,-918v45,-13,67,42,90,60v14,24,77,62,31,82v-12,4,-25,6,-40,6v-21,-25,-49,-49,-65,-78r-31,39v-18,32,-72,56,-98,14","w":437,"k":{"\"":106,"\u2212":38,"\u201d":106,"\u201c":106,"\u00f8":13,"\u00ab":11,"y":48,"w":42,"v":50,"u":10,"t":40,"s":6,"o":13,"f":22,"e":15,"d":13,"c":6,"b":6,"]":20,"Y":77,"W":54,"V":67,"T":60,"O":18,"G":16,"C":26,"-":38,")":20,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2019":106,"\u2018":106,"\u2014":38,"\u2013":38,"\u0178":77,"\u0161":6,"\u0153":21,"\u0152":18,"\u00ff":48,"\u00fd":48,"\u00fc":13,"\u00fb":13,"\u00fa":13,"\u00f9":13,"\u00f6":21,"\u00f5":21,"\u00f4":21,"\u00f3":21,"\u00f2":21,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"q":16,"\\":70,"Q":11,"7":20,"\/":-16,"*":48,"'":106}},"\u00c3":{"d":"305,-178r-172,0r-39,164v-5,26,-58,14,-89,13r178,-688v1,-19,51,-15,69,-11r179,685v2,27,-52,15,-83,15xm150,-252r138,0r-56,-244r-13,-90r-35,192xm256,-774v-54,3,-53,-68,-109,-42v-18,8,-27,46,-52,27v-11,-9,-18,-21,-24,-35v27,-44,60,-75,113,-75v43,0,45,45,87,47v38,2,42,-28,65,-38v17,5,23,28,29,45v-21,32,-56,68,-109,71","w":437,"k":{"\"":106,"\u2212":38,"\u201d":106,"\u201c":106,"\u00f8":13,"\u00ab":11,"y":48,"w":42,"v":50,"u":10,"t":40,"s":6,"o":13,"f":22,"e":15,"d":13,"c":6,"b":6,"]":20,"Y":77,"W":54,"V":67,"T":60,"O":18,"G":16,"C":26,"-":38,")":20,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2019":106,"\u2018":106,"\u2014":38,"\u2013":38,"\u0178":77,"\u0161":6,"\u0153":21,"\u0152":18,"\u00ff":48,"\u00fd":48,"\u00fc":13,"\u00fb":13,"\u00fa":13,"\u00f9":13,"\u00f6":21,"\u00f5":21,"\u00f4":21,"\u00f3":21,"\u00f2":21,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"q":16,"\\":70,"Q":11,"7":20,"\/":-26,"*":48,"'":106}},"\u00c4":{"d":"305,-178r-172,0r-39,164v-5,26,-58,14,-89,13r178,-688v1,-19,51,-15,69,-11r179,685v2,27,-52,15,-83,15xm150,-252r138,0r-56,-244r-13,-90r-35,192xm149,-788v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm291,-788v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":437,"k":{"\"":106,"\u2212":38,"\u201d":106,"\u201c":106,"\u00f8":13,"\u00ab":11,"y":48,"w":42,"v":50,"u":10,"t":40,"s":6,"o":13,"f":22,"e":15,"d":13,"c":6,"b":6,"]":20,"Y":77,"W":54,"V":67,"T":60,"O":18,"G":16,"C":26,"-":38,")":20,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2019":106,"\u2018":106,"\u2014":38,"\u2013":38,"\u0178":77,"\u0161":6,"\u0153":21,"\u0152":18,"\u00ff":48,"\u00fd":48,"\u00fc":13,"\u00fb":13,"\u00fa":13,"\u00f9":13,"\u00f6":21,"\u00f5":21,"\u00f4":21,"\u00f3":21,"\u00f2":21,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"q":16,"\\":70,"Q":11,"7":20,"\/":-11,"*":48,"'":106}},"\u00c5":{"d":"305,-178r-172,0r-39,164v-5,26,-58,14,-89,13r178,-688v1,-19,51,-15,69,-11r179,685v2,27,-52,15,-83,15xm150,-252r138,0r-56,-244r-13,-90r-35,192xm214,-762v-66,0,-94,-26,-94,-97v0,-67,36,-98,100,-98v68,0,93,25,93,97v0,65,-35,98,-99,98xm221,-901v-28,0,-43,13,-43,43v0,27,12,41,37,41v27,0,41,-14,41,-43v0,-27,-12,-41,-35,-41","w":437,"k":{"\"":106,"\u2212":38,"\u201d":106,"\u201c":106,"\u00f8":13,"\u00ab":11,"y":48,"w":42,"v":50,"u":10,"t":40,"s":6,"o":13,"f":22,"e":15,"d":13,"c":6,"b":6,"]":20,"Y":77,"W":54,"V":67,"T":60,"O":18,"G":16,"C":26,"-":38,")":20,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2019":106,"\u2018":106,"\u2014":38,"\u2013":38,"\u0178":77,"\u0161":6,"\u0153":21,"\u0152":18,"\u00ff":48,"\u00fd":48,"\u00fc":13,"\u00fb":13,"\u00fa":13,"\u00f9":13,"\u00f6":21,"\u00f5":21,"\u00f4":21,"\u00f3":21,"\u00f2":21,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"q":16,"\\":70,"Q":11,"7":20,"\/":-16,"*":48,"'":106}},"\u00c6":{"d":"571,-418v-3,31,9,69,-16,75r-135,0r0,270r171,0v-3,23,2,55,-7,71v-76,6,-165,0,-245,2r0,-178r-165,0r-68,164v-8,25,-58,15,-89,13r293,-685v4,-9,13,-14,26,-14r259,0v-3,27,10,73,-15,73r-160,0r0,209r151,0xm205,-252r134,0r0,-362r-55,171","w":615,"k":{"\"":-10,"\u2212":27,"\u201d":-10,"\u201c":-10,"\u00f8":20,"z":4,"y":14,"x":7,"w":14,"u":7,"o":20,"g":14,"e":15,"d":16,"c":5,"a":10,"-":27,"\u2019":-10,"\u2018":-10,"\u2014":27,"\u2013":27,"\u017e":4,"\u0161":10,"\u0153":20,"\u00ff":14,"\u00fd":14,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":5,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"r":7,"q":16,"0":5,"\/":-7,"'":-10}},"\u00c7":{"d":"229,129v4,-41,-41,-35,-71,-28r16,-89v-138,-20,-140,-168,-143,-333v-3,-143,18,-249,65,-325v30,-46,71,-65,132,-67v61,-2,107,22,90,82v-3,9,-6,16,-9,22v-21,-21,-75,-36,-111,-14v-92,58,-91,277,-74,423v8,68,25,119,93,123v36,1,73,-16,92,-31v15,32,20,73,-15,95v-19,12,-44,22,-75,25r-9,46v45,-3,66,18,66,64v0,72,-73,103,-136,72v7,-16,4,-55,30,-38v23,15,63,8,59,-27","w":339,"k":{"\"":-6,"\u2212":82,"\u201e":-5,"\u201d":-6,"\u201c":-6,"\u00f8":15,"z":4,"y":64,"x":14,"w":52,"v":58,"u":19,"t":20,"o":15,"f":24,"e":18,"d":11,"c":11,"a":11,"S":6,"O":21,"G":13,"C":10,".":-5,"-":82,"\ufb04":24,"\ufb03":24,"\ufb02":24,"\ufb01":24,"\ufb00":24,"\u2039":23,"\u2026":-5,"\u201a":-5,"\u2019":-6,"\u2018":-6,"\u2014":82,"\u2013":82,"\u017e":4,"\u0161":11,"\u0160":6,"\u0153":15,"\u0152":21,"\u00ff":64,"\u00fd":64,"\u00fc":19,"\u00fb":19,"\u00fa":19,"\u00f9":19,"\u00f6":15,"\u00f5":15,"\u00f4":15,"\u00f3":15,"\u00f2":15,"\u00f1":11,"\u00ef":11,"\u00ee":11,"\u00eb":18,"\u00ea":18,"\u00e9":18,"\u00e8":18,"\u00e7":11,"\u00e6":11,"\u00e5":11,"\u00e4":11,"\u00e3":11,"\u00e2":11,"\u00e1":11,"\u00e0":11,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00c7":10,"q":11,"Q":21,"@":5,"0":26,"\/":-18,",":-5,"*":11,"'":-6,"\u00ab":23}},"\u00c8":{"d":"276,-418v-3,28,10,75,-15,75r-135,0r0,270r171,0v-3,23,2,55,-7,71v-76,6,-166,0,-246,2r0,-683v1,-9,7,-17,17,-17r239,0v-3,27,10,73,-15,73r-159,0r0,209r150,0xm236,-816v-9,28,-19,60,-54,32v-33,-27,-87,-60,-117,-88v6,-32,22,-83,59,-48v32,31,84,71,112,104","w":320,"k":{"\"":-10,"\u2212":27,"\u201d":-10,"\u201c":-10,"\u00f8":20,"z":4,"y":14,"x":7,"w":14,"u":7,"o":20,"e":15,"d":16,"c":5,"a":10,"-":27,"\u2019":-10,"\u2018":-10,"\u2014":27,"\u2013":27,"\u017e":4,"\u0161":10,"\u0153":20,"\u00ff":14,"\u00fd":14,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":5,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"r":7,"q":16,"0":5,"\/":-7,"'":-10}},"\u00c9":{"d":"276,-418v-3,28,10,75,-15,75r-135,0r0,270r171,0v-3,23,2,55,-7,71v-76,6,-166,0,-246,2r0,-683v1,-9,7,-17,17,-17r239,0v-3,27,10,73,-15,73r-159,0r0,209r150,0xm136,-815v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":320,"k":{"\"":-10,"\u2212":27,"\u201d":-10,"\u201c":-10,"\u00f8":20,"z":4,"y":14,"x":7,"w":14,"u":7,"o":20,"e":15,"d":16,"c":5,"a":10,"-":27,"\u2019":-10,"\u2018":-10,"\u2014":27,"\u2013":27,"\u017e":4,"\u0161":10,"\u0153":20,"\u00ff":14,"\u00fd":14,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":5,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"r":7,"q":16,"0":5,"\/":-7,"'":-10}},"\u00ca":{"d":"276,-418v-3,28,10,75,-15,75r-135,0r0,270r171,0v-3,23,2,55,-7,71v-76,6,-166,0,-246,2r0,-683v1,-9,7,-17,17,-17r239,0v-3,27,10,73,-15,73r-159,0r0,209r150,0xm169,-918v45,-13,67,42,90,60v14,24,77,62,31,82v-12,4,-25,6,-40,6v-21,-25,-49,-49,-65,-78r-31,39v-18,32,-72,56,-98,14","w":320,"k":{"\"":-10,"\u2212":27,"\u201d":-10,"\u201c":-10,"\u00f8":20,"\u00ab":11,"z":4,"y":14,"x":7,"w":14,"v":50,"u":7,"t":40,"s":6,"o":20,"f":22,"e":15,"d":16,"c":5,"b":6,"a":10,"Y":77,"W":54,"V":67,"T":60,"O":18,"G":16,"C":26,"-":27,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2019":-10,"\u2018":-10,"\u2014":27,"\u2013":27,"\u017e":4,"\u0178":77,"\u0161":11,"\u0153":20,"\u0152":18,"\u00ff":14,"\u00fd":14,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":5,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"r":7,"q":16,"\\":70,"Q":11,"7":20,"0":5,"\/":-21,"'":-10}},"\u00cb":{"d":"276,-418v-3,28,10,75,-15,75r-135,0r0,270r171,0v-3,23,2,55,-7,71v-76,6,-166,0,-246,2r0,-683v1,-9,7,-17,17,-17r239,0v-3,27,10,73,-15,73r-159,0r0,209r150,0xm113,-788v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm255,-788v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":320,"k":{"\"":-10,"\u2212":27,"\u201d":-10,"\u201c":-10,"\u00f8":20,"\u00ab":11,"z":4,"y":14,"x":7,"w":14,"v":50,"u":7,"t":40,"s":6,"o":20,"f":22,"e":15,"d":16,"c":5,"b":6,"a":10,"Y":77,"W":54,"V":67,"T":60,"O":18,"G":16,"C":26,"-":27,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2019":-10,"\u2018":-10,"\u2014":27,"\u2013":27,"\u017e":4,"\u0178":77,"\u0161":11,"\u0153":20,"\u0152":18,"\u00ff":14,"\u00fd":14,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":5,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"r":7,"q":16,"\\":70,"Q":11,"7":20,"0":5,"\/":-36,"'":-10}},"\u00cc":{"d":"125,-16v0,29,-52,11,-82,16r1,-684v10,-23,45,-13,81,-16r0,684xm139,-816v-9,28,-19,60,-54,32v-33,-27,-87,-60,-117,-88v6,-32,22,-83,59,-48v32,31,84,71,112,104","w":168,"k":{"\/":-11}},"\u00cd":{"d":"125,-16v0,29,-52,11,-82,16r1,-684v10,-23,45,-13,81,-16r0,684xm38,-815v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":168,"k":{"]":-3,")":-3,"\/":-11}},"\u00ce":{"d":"125,-16v0,29,-52,11,-82,16r1,-684v10,-23,45,-13,81,-16r0,684xm71,-918v45,-13,67,42,90,60v14,24,77,62,31,82v-12,4,-25,6,-40,6v-21,-25,-49,-49,-65,-78r-31,39v-18,32,-72,56,-98,14","w":168,"k":{"\"":-52,"\u201d":-52,"\u201c":-52,"]":-60,")":-60,"\u2019":-52,"\u2018":-52,"\/":-11,"'":-52}},"\u00cf":{"d":"125,-16v0,29,-52,11,-82,16r1,-684v10,-23,45,-13,81,-16r0,684xm16,-788v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm158,-788v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":168,"k":{"\"":-19,"\u201d":-19,"\u201c":-19,"]":-10,")":-10,"\u2019":-19,"\u2018":-19,"\/":-11,"'":-19}},"\u00d1":{"d":"124,-16v0,29,-51,11,-81,16r0,-683v1,-31,52,-12,79,-17r112,270r95,282r-10,-300r1,-244v17,-12,47,-6,81,-8r0,684v-2,29,-52,11,-78,16r-114,-275r-95,-283r10,299r0,243xm267,-774v-54,3,-53,-68,-109,-42v-18,8,-27,46,-52,27v-11,-9,-18,-21,-24,-35v27,-44,60,-75,113,-75v43,0,45,45,87,47v38,2,42,-28,65,-38v17,5,23,28,29,45v-21,32,-56,68,-109,71","w":444,"k":{"\"":-2,"\u201d":-2,"\u201c":-2,"\u00f8":13,"\u00ab":11,"y":48,"w":42,"v":50,"u":10,"t":40,"s":6,"o":13,"f":22,"e":15,"d":13,"c":6,"b":6,"Y":77,"W":54,"V":67,"T":60,"O":18,"G":16,"C":26,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2019":-2,"\u2018":-2,"\u2014":20,"\u2013":20,"\u0178":77,"\u0161":6,"\u0153":13,"\u0152":18,"\u00ff":48,"\u00fd":48,"\u00fc":10,"\u00fb":10,"\u00fa":10,"\u00f9":10,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f3":13,"\u00f2":13,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"q":16,"\\":70,"Q":11,"7":20,"\/":-36,"'":-2}},"\u00d2":{"d":"399,-357v0,191,-9,366,-189,366v-181,0,-180,-175,-180,-363v0,-188,15,-355,191,-355v176,0,178,169,178,352xm174,-610v-69,68,-57,262,-48,395v5,73,16,141,88,141v75,0,86,-74,92,-151v9,-124,24,-322,-42,-387v-21,-21,-68,-19,-90,2xm274,-816v-9,28,-19,60,-54,32v-33,-27,-87,-60,-117,-88v6,-32,22,-83,59,-48v32,31,84,71,112,104","w":428,"k":{"\"":10,"\u201e":32,"\u201d":10,"\u201c":10,"x":19,"c":6,"]":20,"Y":21,"X":23,"W":15,"V":10,"T":21,"Q":3,"O":3,"J":32,"A":23,".":32,")":20,"\u2026":32,"\u201a":32,"\u2019":10,"\u2018":10,"\u017d":23,"\u0178":21,"\u0160":23,"\u0152":3,"\u00e7":6,"\u00dd":21,"\u00dc":23,"\u00db":23,"\u00d8":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d3":3,"\u00d2":3,"\u00d1":23,"\u00cb":23,"\u00ca":23,"\u00c6":23,"\u00c5":23,"\u00c4":23,"\u00c3":23,"\u00c2":23,"\u00c1":23,"\u00c0":23,"_":52,",":32,"*":7,"'":10}},"\u00d3":{"d":"399,-357v0,191,-9,366,-189,366v-181,0,-180,-175,-180,-363v0,-188,15,-355,191,-355v176,0,178,169,178,352xm174,-610v-69,68,-57,262,-48,395v5,73,16,141,88,141v75,0,86,-74,92,-151v9,-124,24,-322,-42,-387v-21,-21,-68,-19,-90,2xm174,-815v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":428,"k":{"\"":10,"\u201e":32,"\u201d":10,"\u201c":10,"x":19,"c":6,"]":20,"Y":21,"X":23,"W":15,"V":10,"T":21,"Q":3,"O":3,"J":32,"A":23,".":32,")":20,"\u2026":32,"\u201a":32,"\u2019":10,"\u2018":10,"\u017d":23,"\u0178":21,"\u0160":23,"\u0152":3,"\u00e7":6,"\u00dd":21,"\u00dc":23,"\u00db":23,"\u00d8":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d3":3,"\u00d2":3,"\u00d1":23,"\u00cb":23,"\u00ca":23,"\u00c6":23,"\u00c5":23,"\u00c4":23,"\u00c3":23,"\u00c2":23,"\u00c1":23,"\u00c0":23,"_":52,",":32,"*":7,"'":10}},"\u00d4":{"d":"399,-357v0,191,-9,366,-189,366v-181,0,-180,-175,-180,-363v0,-188,15,-355,191,-355v176,0,178,169,178,352xm174,-610v-69,68,-57,262,-48,395v5,73,16,141,88,141v75,0,86,-74,92,-151v9,-124,24,-322,-42,-387v-21,-21,-68,-19,-90,2xm207,-918v45,-13,67,42,90,60v14,24,77,62,31,82v-12,4,-25,6,-40,6v-21,-25,-49,-49,-65,-78r-31,39v-18,32,-72,56,-98,14","w":428,"k":{"\"":10,"\u201e":32,"\u201d":10,"\u201c":10,"\u00f8":13,"\u00ab":11,"y":48,"x":19,"w":42,"v":50,"u":10,"t":40,"s":6,"o":13,"f":22,"e":15,"d":13,"c":6,"b":6,"]":20,"Y":21,"X":23,"W":15,"V":10,"T":21,"O":3,"J":32,"G":16,"C":26,"A":23,".":32,")":20,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2026":32,"\u201a":32,"\u2019":10,"\u2018":10,"\u2014":20,"\u2013":20,"\u017d":23,"\u0178":21,"\u0161":6,"\u0160":23,"\u0153":13,"\u0152":3,"\u00ff":48,"\u00fd":48,"\u00fc":10,"\u00fb":10,"\u00fa":10,"\u00f9":10,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f3":13,"\u00f2":13,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":21,"\u00dc":23,"\u00db":23,"\u00d8":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d3":3,"\u00d2":3,"\u00d1":23,"\u00cb":23,"\u00ca":23,"\u00c7":26,"\u00c6":23,"\u00c5":23,"\u00c4":23,"\u00c3":23,"\u00c2":23,"\u00c1":23,"\u00c0":23,"q":16,"_":52,"\\":70,"Q":3,"7":20,"\/":8,",":32,"*":7,"'":10}},"\u00d5":{"d":"399,-357v0,191,-9,366,-189,366v-181,0,-180,-175,-180,-363v0,-188,15,-355,191,-355v176,0,178,169,178,352xm174,-610v-69,68,-57,262,-48,395v5,73,16,141,88,141v75,0,86,-74,92,-151v9,-124,24,-322,-42,-387v-21,-21,-68,-19,-90,2xm259,-774v-54,3,-53,-68,-109,-42v-18,8,-27,46,-52,27v-11,-9,-18,-21,-24,-35v27,-44,60,-75,113,-75v43,0,45,45,87,47v38,2,42,-28,65,-38v17,5,23,28,29,45v-21,32,-56,68,-109,71","w":428,"k":{"\"":10,"\u201e":32,"\u201d":10,"\u201c":10,"\u00f8":13,"\u00ab":11,"y":48,"x":19,"w":42,"v":50,"u":10,"t":40,"s":6,"o":13,"f":22,"e":15,"d":13,"c":6,"b":6,"]":20,"Y":21,"X":23,"W":15,"V":10,"T":21,"O":3,"J":32,"G":16,"C":26,"A":23,".":32,")":20,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2026":32,"\u201a":32,"\u2019":10,"\u2018":10,"\u2014":20,"\u2013":20,"\u017d":23,"\u0178":21,"\u0161":6,"\u0160":23,"\u0153":13,"\u0152":3,"\u00ff":48,"\u00fd":48,"\u00fc":10,"\u00fb":10,"\u00fa":10,"\u00f9":10,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f3":13,"\u00f2":13,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":21,"\u00dc":23,"\u00db":23,"\u00d8":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d3":3,"\u00d2":3,"\u00d1":23,"\u00cb":23,"\u00ca":23,"\u00c7":26,"\u00c6":23,"\u00c5":23,"\u00c4":23,"\u00c3":23,"\u00c2":23,"\u00c1":23,"\u00c0":23,"q":16,"_":52,"\\":70,"Q":3,"7":20,"\/":11,",":32,"*":7,"'":10}},"\u00d6":{"d":"399,-357v0,191,-9,366,-189,366v-181,0,-180,-175,-180,-363v0,-188,15,-355,191,-355v176,0,178,169,178,352xm174,-610v-69,68,-57,262,-48,395v5,73,16,141,88,141v75,0,86,-74,92,-151v9,-124,24,-322,-42,-387v-21,-21,-68,-19,-90,2xm152,-788v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm294,-788v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":428,"k":{"\"":10,"\u201e":32,"\u201d":10,"\u201c":10,"\u00f8":13,"\u00ab":11,"y":48,"x":19,"w":42,"v":50,"u":10,"t":40,"s":6,"o":13,"f":22,"e":15,"d":13,"c":6,"b":6,"]":20,"Y":21,"X":23,"W":15,"V":10,"T":21,"O":3,"J":32,"G":16,"C":26,"A":23,".":32,")":20,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2026":32,"\u201a":32,"\u2019":10,"\u2018":10,"\u2014":20,"\u2013":20,"\u017d":23,"\u0178":21,"\u0161":6,"\u0160":23,"\u0153":13,"\u0152":3,"\u00ff":48,"\u00fd":48,"\u00fc":10,"\u00fb":10,"\u00fa":10,"\u00f9":10,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f3":13,"\u00f2":13,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":21,"\u00dc":23,"\u00db":23,"\u00d8":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d3":3,"\u00d2":3,"\u00d1":23,"\u00cb":23,"\u00ca":23,"\u00c7":26,"\u00c6":23,"\u00c5":23,"\u00c4":23,"\u00c3":23,"\u00c2":23,"\u00c1":23,"\u00c0":23,"q":16,"_":52,"\\":70,"Q":3,"7":20,"\/":5,",":32,"*":7,"'":10}},"\u00d7":{"d":"208,-227r-75,83v-28,8,-35,-20,-62,-39r89,-98r-89,-100v18,-17,31,-30,40,-37v9,-7,16,-7,22,-1r75,84r76,-84v5,-6,13,-6,22,1v9,7,22,20,40,37r-89,99r89,99v-18,17,-31,30,-40,37v-9,7,-18,8,-23,2","k":{"\/":16}},"\u00d8":{"d":"227,10v-55,0,-93,-13,-119,-45r-21,51v-24,-2,-58,-9,-47,-38r32,-82v-20,-69,-25,-151,-25,-250v0,-187,12,-356,189,-356v54,0,92,14,118,46r23,-55v25,5,58,7,47,41r-30,96v15,53,22,128,22,225v0,191,-9,367,-189,367xm190,-612v-74,76,-53,290,-45,434r148,-420v-20,-32,-76,-42,-103,-14xm268,-84v86,-63,60,-286,52,-431r-149,417v19,27,68,35,97,14","w":463,"k":{"\"":10,"\u2212":20,"\u201e":32,"\u201d":10,"\u201c":10,"z":20,"y":20,"x":19,"w":20,"u":13,"t":13,"s":13,"p":13,"h":7,"g":20,"e":20,"d":20,"c":6,"a":21,"]":20,"Y":21,"X":23,"W":15,"V":10,"T":21,"Q":3,"O":3,"J":32,"A":23,".":32,"-":20,")":20,"\u2026":32,"\u201a":32,"\u2019":10,"\u2018":10,"\u2014":20,"\u2013":20,"\u017e":25,"\u017d":23,"\u0178":21,"\u0161":19,"\u0160":23,"\u0152":3,"\u00ff":25,"\u00fd":20,"\u00fc":19,"\u00fb":19,"\u00fa":13,"\u00f9":13,"\u00f6":21,"\u00f5":21,"\u00f4":21,"\u00f1":21,"\u00ef":21,"\u00ee":21,"\u00eb":26,"\u00ea":26,"\u00e9":20,"\u00e8":20,"\u00e7":6,"\u00e6":21,"\u00e5":21,"\u00e4":21,"\u00e3":21,"\u00e2":21,"\u00e1":21,"\u00e0":21,"\u00dd":21,"\u00dc":23,"\u00db":23,"\u00d8":3,"\u00d6":3,"\u00d5":3,"\u00d4":3,"\u00d3":3,"\u00d2":3,"\u00d1":23,"\u00cb":23,"\u00ca":23,"\u00c6":23,"\u00c5":23,"\u00c4":23,"\u00c3":23,"\u00c2":23,"\u00c1":23,"\u00c0":23,"r":20,"q":13,"k":7,"_":52,"0":16,",":32,"*":7,"'":10}},"\u00d9":{"d":"223,10v-138,0,-180,-78,-180,-214r1,-488v17,-12,47,-6,83,-8r0,498v-1,80,15,137,96,137v31,0,69,-8,88,-18r1,-609v16,-12,47,-6,81,-8r0,674v-34,20,-106,36,-170,36xm274,-816v-9,28,-19,60,-54,32v-33,-27,-87,-60,-117,-88v6,-32,22,-83,59,-48v32,31,84,71,112,104","w":437,"k":{"\"":1,"\u201d":1,"\u201c":1,"\u2019":1,"\u2018":1,"'":1}},"\u00da":{"d":"223,10v-138,0,-180,-78,-180,-214r1,-488v17,-12,47,-6,83,-8r0,498v-1,80,15,137,96,137v31,0,69,-8,88,-18r1,-609v16,-12,47,-6,81,-8r0,674v-34,20,-106,36,-170,36xm174,-815v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":437,"k":{"\"":1,"\u201d":1,"\u201c":1,"\u2019":1,"\u2018":1,"'":1}},"\u00db":{"d":"223,10v-138,0,-180,-78,-180,-214r1,-488v17,-12,47,-6,83,-8r0,498v-1,80,15,137,96,137v31,0,69,-8,88,-18r1,-609v16,-12,47,-6,81,-8r0,674v-34,20,-106,36,-170,36xm207,-918v45,-13,67,42,90,60v14,24,77,62,31,82v-12,4,-25,6,-40,6v-21,-25,-49,-49,-65,-78r-31,39v-18,32,-72,56,-98,14","w":437,"k":{"\"":6,"\u201d":6,"\u201c":6,"\u00f8":13,"\u00ab":11,"y":48,"w":42,"v":50,"u":10,"t":40,"s":6,"o":13,"f":22,"e":15,"d":13,"c":6,"b":6,"Y":77,"W":54,"V":67,"T":60,"O":18,"G":16,"C":26,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2019":6,"\u2018":6,"\u2014":20,"\u2013":20,"\u0178":77,"\u0161":6,"\u0153":13,"\u0152":18,"\u00ff":48,"\u00fd":48,"\u00fc":10,"\u00fb":10,"\u00fa":10,"\u00f9":10,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f3":13,"\u00f2":13,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"q":16,"\\":70,"Q":11,"7":20,"\/":-21,"'":6}},"\u00dc":{"d":"223,10v-138,0,-180,-78,-180,-214r1,-488v17,-12,47,-6,83,-8r0,498v-1,80,15,137,96,137v31,0,69,-8,88,-18r1,-609v16,-12,47,-6,81,-8r0,674v-34,20,-106,36,-170,36xm152,-788v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm294,-788v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":437,"k":{"\"":14,"\u201d":14,"\u201c":14,"\u00f8":13,"\u00ab":11,"y":48,"w":42,"v":50,"u":10,"t":40,"s":6,"o":13,"f":22,"e":15,"d":13,"c":6,"b":6,"Y":77,"W":54,"V":67,"T":60,"O":18,"G":16,"C":26,"\ufb04":22,"\ufb03":22,"\ufb02":22,"\ufb01":22,"\ufb00":22,"\u2122":22,"\u2039":11,"\u2019":14,"\u2018":14,"\u2014":20,"\u2013":20,"\u0178":77,"\u0161":6,"\u0153":13,"\u0152":18,"\u00ff":48,"\u00fd":48,"\u00fc":10,"\u00fb":10,"\u00fa":10,"\u00f9":10,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f3":13,"\u00f2":13,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"q":16,"\\":70,"Q":11,"7":20,"\/":-11,"'":14}},"\u00dd":{"d":"225,-16v1,29,-51,11,-81,16r0,-283r-139,-411v18,-10,64,-4,93,-6r71,254r18,92v22,-118,55,-233,89,-340v16,-11,57,-4,84,-6r-135,411r0,273xm140,-815v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":364,"k":{"\"":-20,"\u2212":65,"\u201e":61,"\u201d":-20,"\u201c":-20,"\u00f8":70,"\u00c6":77,"z":51,"y":45,"x":44,"w":42,"v":40,"u":57,"t":33,"s":66,"p":71,"o":70,"n":64,"j":27,"i":13,"g":68,"f":27,"e":75,"d":78,"c":70,"a":61,"S":7,"O":21,"J":85,"G":29,"C":32,"A":77,";":52,":":52,".":61,"-":65,"\ufb04":27,"\ufb03":27,"\ufb02":27,"\ufb01":27,"\ufb00":27,"\u203a":44,"\u2039":58,"\u2026":61,"\u201a":61,"\u2019":-20,"\u2018":-20,"\u2014":65,"\u2013":65,"\u017e":51,"\u017d":77,"\u0161":66,"\u0160":7,"\u0153":70,"\u0152":21,"\u0131":13,"\u00ff":45,"\u00fd":45,"\u00fc":57,"\u00fb":57,"\u00fa":57,"\u00f9":57,"\u00f6":70,"\u00f5":70,"\u00f4":70,"\u00f3":70,"\u00f2":70,"\u00f1":64,"\u00ef":13,"\u00ee":13,"\u00ed":13,"\u00ec":13,"\u00eb":75,"\u00ea":75,"\u00e9":75,"\u00e8":75,"\u00e7":70,"\u00e6":61,"\u00e5":61,"\u00e4":61,"\u00e3":61,"\u00e2":61,"\u00e1":61,"\u00e0":61,"\u00dc":77,"\u00db":77,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00d1":77,"\u00cb":77,"\u00ca":77,"\u00c7":32,"\u00c5":77,"\u00c4":77,"\u00c3":77,"\u00c2":77,"\u00c1":77,"\u00c0":77,"r":64,"q":78,"m":64,"_":73,"Q":21,"@":15,"0":47,"\/":49,",":61,"'":-20,"\u00ab":58,"\u00bb":44}},"\u00df":{"d":"39,-2v5,-20,11,-44,11,-72r-3,-476v-2,-105,61,-155,161,-155v114,0,201,40,201,144v0,68,-60,83,-92,119v-51,56,29,106,61,140v39,40,77,87,78,164v1,92,-58,147,-150,147v-70,0,-139,-17,-112,-79v5,-8,9,-16,14,-21v37,39,165,42,157,-46v-11,-120,-154,-142,-154,-262v0,-68,59,-88,93,-123v49,-51,-15,-112,-90,-107v-74,5,-86,44,-85,125r3,460v-1,40,-7,53,-48,53v-22,0,-35,-3,-45,-11","w":465,"k":{"]":7,")":7,"\/":-8}},"\u00e0":{"d":"235,-372v6,-98,-143,-51,-194,-37v-12,-19,-18,-58,0,-74v30,-15,95,-27,152,-27v172,0,115,185,123,346r-5,140v-32,18,-82,34,-139,34v-102,0,-143,-48,-143,-152v0,-103,35,-164,133,-164v25,0,56,3,73,13r0,-79xm114,-144v-8,80,64,108,118,69r3,-161v-11,-6,-31,-9,-47,-9v-59,0,-68,40,-74,101xm232,-616v-9,28,-19,60,-54,32v-33,-27,-87,-60,-117,-88v6,-32,22,-83,59,-48v32,31,84,71,112,104","w":354,"k":{"\"":83,"\u201d":83,"\u201c":83,"y":8,"x":8,"t":17,"f":9,"]":24,")":24,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":83,"\u2018":83,"\u00ff":8,"\u00fd":8,"'":83}},"\u00e1":{"d":"235,-372v6,-98,-143,-51,-194,-37v-12,-19,-18,-58,0,-74v30,-15,95,-27,152,-27v172,0,115,185,123,346r-5,140v-32,18,-82,34,-139,34v-102,0,-143,-48,-143,-152v0,-103,35,-164,133,-164v25,0,56,3,73,13r0,-79xm114,-144v-8,80,64,108,118,69r3,-161v-11,-6,-31,-9,-47,-9v-59,0,-68,40,-74,101xm131,-615v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":354,"k":{"\"":83,"\u201d":83,"\u201c":83,"y":8,"x":8,"t":17,"f":9,"]":24,")":24,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":83,"\u2018":83,"\u00ff":8,"\u00fd":8,"'":83}},"\u00e2":{"d":"235,-372v6,-98,-143,-51,-194,-37v-12,-19,-18,-58,0,-74v30,-15,95,-27,152,-27v172,0,115,185,123,346r-5,140v-32,18,-82,34,-139,34v-102,0,-143,-48,-143,-152v0,-103,35,-164,133,-164v25,0,56,3,73,13r0,-79xm114,-144v-8,80,64,108,118,69r3,-161v-11,-6,-31,-9,-47,-9v-59,0,-68,40,-74,101xm164,-718v45,-13,67,42,90,60v14,24,77,62,31,82v-12,4,-25,6,-40,6v-21,-25,-49,-49,-65,-78r-31,39v-18,32,-72,56,-98,14","w":354,"k":{"\"":83,"\u201d":83,"\u201c":83,"y":8,"x":8,"t":17,"f":9,"]":24,")":24,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":83,"\u2018":83,"\u00ff":8,"\u00fd":8,"'":83}},"\u00e3":{"d":"235,-372v6,-98,-143,-51,-194,-37v-12,-19,-18,-58,0,-74v30,-15,95,-27,152,-27v172,0,115,185,123,346r-5,140v-32,18,-82,34,-139,34v-102,0,-143,-48,-143,-152v0,-103,35,-164,133,-164v25,0,56,3,73,13r0,-79xm114,-144v-8,80,64,108,118,69r3,-161v-11,-6,-31,-9,-47,-9v-59,0,-68,40,-74,101xm216,-574v-54,3,-53,-68,-109,-42v-18,8,-27,46,-52,27v-11,-9,-18,-21,-24,-35v27,-44,60,-75,113,-75v43,0,45,45,87,47v38,2,42,-28,65,-38v17,5,23,28,29,45v-21,32,-56,68,-109,71","w":354,"k":{"\"":83,"\u201d":83,"\u201c":83,"y":8,"x":8,"f":9,"]":24,")":24,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":83,"\u2018":83,"\u00ff":8,"\u00fd":8,"'":83,"t":17}},"\u00e4":{"d":"235,-372v6,-98,-143,-51,-194,-37v-12,-19,-18,-58,0,-74v30,-15,95,-27,152,-27v172,0,115,185,123,346r-5,140v-32,18,-82,34,-139,34v-102,0,-143,-48,-143,-152v0,-103,35,-164,133,-164v25,0,56,3,73,13r0,-79xm114,-144v-8,80,64,108,118,69r3,-161v-11,-6,-31,-9,-47,-9v-59,0,-68,40,-74,101xm109,-588v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm251,-588v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":354,"k":{"\"":83,"\u201d":83,"\u201c":83,"y":8,"x":8,"t":17,"f":9,"]":24,")":24,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":83,"\u2018":83,"\u00ff":8,"\u00fd":8,"'":83}},"\u00e5":{"d":"235,-372v6,-98,-143,-51,-194,-37v-12,-19,-18,-58,0,-74v30,-15,95,-27,152,-27v172,0,115,185,123,346r-5,140v-32,18,-82,34,-139,34v-102,0,-143,-48,-143,-152v0,-103,35,-164,133,-164v25,0,56,3,73,13r0,-79xm114,-144v-8,80,64,108,118,69r3,-161v-11,-6,-31,-9,-47,-9v-59,0,-68,40,-74,101xm174,-562v-66,0,-94,-26,-94,-97v0,-67,36,-98,100,-98v68,0,93,25,93,97v0,65,-35,98,-99,98xm181,-701v-28,0,-43,13,-43,43v0,27,12,41,37,41v27,0,41,-14,41,-43v0,-27,-12,-41,-35,-41","w":354,"k":{"\"":83,"\u201d":83,"\u201c":83,"y":8,"x":8,"t":17,"f":9,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":83,"\u2018":83,"\u00ff":8,"\u00fd":8,"'":83,")":24,"]":24}},"\u00e6":{"d":"42,-410v-12,-19,-19,-62,0,-73v52,-30,235,-57,253,29v26,-42,64,-51,122,-56v131,-11,143,162,116,291v-70,10,-149,7,-209,-5v2,86,1,154,85,154v50,0,89,-13,122,-31v2,20,19,74,-4,85v-54,26,-179,42,-225,-3v-34,18,-73,28,-130,28v-106,0,-145,-49,-143,-158v1,-102,34,-168,130,-170v27,0,58,3,76,13r0,-72v2,-94,-145,-56,-193,-32xm178,-58v18,0,50,-5,57,-16r0,-176v-13,-5,-31,-8,-47,-8v-60,1,-73,46,-74,109v0,56,9,93,64,91xm460,-280v6,-65,19,-164,-52,-159v-69,5,-74,76,-82,149v36,9,90,18,134,10","w":581,"k":{"\"":60,"\u201d":60,"\u201c":60,"z":4,"y":8,"x":7,"t":4,"f":9,"]":20,")":20,"\ufb04":9,"\ufb03":9,"\ufb02":9,"\ufb01":9,"\ufb00":9,"\u2019":60,"\u2018":60,"\u017e":4,"\u00ff":8,"\u00fd":8,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\/":-5,"'":60,"w":3,"e":10}},"\u00e7":{"d":"211,-510v45,0,95,16,81,65v-1,8,-4,16,-7,25v-16,-9,-44,-19,-70,-18v-93,5,-99,95,-99,199v0,93,2,174,89,177v30,1,61,-12,79,-23v9,31,16,59,-16,76v-16,8,-37,15,-64,18r-10,49v45,-3,66,18,66,64v0,72,-73,103,-136,72v7,-16,4,-55,30,-38v23,15,63,8,59,-27v4,-41,-41,-35,-71,-28r17,-92v-117,-9,-128,-117,-128,-248v0,-158,34,-271,180,-271","w":313,"k":{"\"":45,"\u2212":35,"\u201d":45,"\u201c":45,"\u00f8":12,"y":-3,"w":-3,"t":-6,"o":12,"e":16,"d":16,"c":15,"]":7,"-":35,")":7,"\u2039":29,"\u2019":45,"\u2018":45,"\u2014":35,"\u2013":35,"\u0153":12,"\u00ff":-3,"\u00fd":-3,"\u00f6":12,"\u00f5":12,"\u00f4":12,"\u00f3":12,"\u00f2":12,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":15,"q":16,"\/":-18,"'":45,"\u00ab":29}},"\u00e8":{"d":"31,-224v0,-162,27,-277,177,-286v131,-8,143,162,116,291v-62,11,-137,16,-209,16v3,77,15,135,93,134v44,0,83,-14,114,-31v5,13,7,38,7,55v-13,47,-78,54,-138,55v-133,3,-160,-96,-160,-234xm251,-280v7,-64,17,-165,-52,-159v-73,7,-76,88,-83,170v45,-4,98,-1,135,-11xm253,-616v-9,28,-19,60,-54,32v-33,-27,-87,-60,-117,-88v6,-32,22,-83,59,-48v32,31,84,71,112,104","w":361,"k":{"\"":60,"\u201d":60,"\u201c":60,"e":10,"]":20,")":20,"\u2019":60,"\u2018":60,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\/":-11,"'":60,"t":4,"w":3,"x":7}},"\u00e9":{"d":"31,-224v0,-162,27,-277,177,-286v131,-8,143,162,116,291v-62,11,-137,16,-209,16v3,77,15,135,93,134v44,0,83,-14,114,-31v5,13,7,38,7,55v-13,47,-78,54,-138,55v-133,3,-160,-96,-160,-234xm251,-280v7,-64,17,-165,-52,-159v-73,7,-76,88,-83,170v45,-4,98,-1,135,-11xm152,-615v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":361,"k":{"\"":60,"\u201d":60,"\u201c":60,"x":7,"w":3,"t":4,"e":10,"]":20,")":20,"\u2019":60,"\u2018":60,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\/":-11,"'":60}},"\u00ea":{"d":"31,-224v0,-162,27,-277,177,-286v131,-8,143,162,116,291v-62,11,-137,16,-209,16v3,77,15,135,93,134v44,0,83,-14,114,-31v5,13,7,38,7,55v-13,47,-78,54,-138,55v-133,3,-160,-96,-160,-234xm251,-280v7,-64,17,-165,-52,-159v-73,7,-76,88,-83,170v45,-4,98,-1,135,-11xm185,-718v45,-13,67,42,90,60v14,24,77,62,31,82v-12,4,-25,6,-40,6v-21,-25,-49,-49,-65,-78r-31,39v-18,32,-72,56,-98,14","w":361,"k":{"\"":60,"\u201d":60,"\u201c":60,"y":8,"x":7,"w":3,"t":4,"e":10,"]":20,")":20,"\u2019":60,"\u2018":60,"\u00ff":8,"\u00fd":8,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\/":-11,"'":60}},"\u00eb":{"d":"31,-224v0,-162,27,-277,177,-286v131,-8,143,162,116,291v-62,11,-137,16,-209,16v3,77,15,135,93,134v44,0,83,-14,114,-31v5,13,7,38,7,55v-13,47,-78,54,-138,55v-133,3,-160,-96,-160,-234xm251,-280v7,-64,17,-165,-52,-159v-73,7,-76,88,-83,170v45,-4,98,-1,135,-11xm130,-588v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm272,-588v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":361,"k":{"\"":60,"\u201d":60,"\u201c":60,"y":8,"x":7,"w":3,"t":4,"e":10,"]":20,")":20,"\u2019":60,"\u2018":60,"\u00ff":8,"\u00fd":8,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\/":-11,"'":60}},"\u00ec":{"d":"129,-16v0,29,-53,11,-83,16r0,-463v-2,-45,39,-35,83,-37r0,484xm143,-616v-9,28,-19,60,-54,32v-33,-27,-87,-60,-117,-88v6,-32,22,-83,59,-48v32,31,84,71,112,104","w":175,"k":{"\"":15,"\u201d":15,"\u201c":15,"]":17,")":17,"\u2019":15,"\u2018":15,"\/":-23,"'":15}},"\u00ed":{"d":"129,-16v0,29,-53,11,-83,16r0,-463v-2,-45,39,-35,83,-37r0,484xm42,-615v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":175,"k":{"\"":-37,"\u201d":-37,"\u201c":-37,"k":-6,"h":-6,"]":-13,")":-13,"\u2019":-37,"\u2018":-37,"\/":-23,"'":-37}},"\u00ee":{"d":"129,-16v0,29,-53,11,-83,16r0,-463v-2,-45,39,-35,83,-37r0,484xm76,-718v45,-13,67,42,90,60v14,24,77,62,31,82v-12,4,-25,6,-40,6v-21,-25,-49,-49,-65,-78r-31,39v-18,32,-72,56,-98,14","w":175,"k":{"\"":-42,"\u201d":-42,"\u201c":-42,"y":8,"x":8,"k":-13,"h":-13,"\u2019":-42,"\u2018":-42,"\u00ff":8,"\u00fd":8,"\/":-23,"'":-42}},"\u00ef":{"d":"129,-16v0,29,-53,11,-83,16r0,-463v-2,-45,39,-35,83,-37r0,484xm21,-588v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm163,-588v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":175,"k":{"\"":-57,"\u201d":-57,"\u201c":-57,"y":8,"x":8,"k":-19,"h":-19,"]":-13,")":-13,"\u2019":-57,"\u2018":-57,"\u00ff":8,"\u00fd":8,"\/":-23,"'":-57}},"\u00f1":{"d":"126,-16v0,29,-51,11,-81,16r0,-476v44,-18,98,-34,158,-34v104,0,141,33,141,134r0,360v0,29,-53,11,-84,16r0,-352v-2,-60,-4,-86,-60,-87v-25,0,-56,8,-74,18r0,405xm236,-574v-54,3,-53,-68,-109,-42v-18,8,-27,46,-52,27v-11,-9,-18,-21,-24,-35v27,-44,60,-75,113,-75v43,0,45,45,87,47v38,2,42,-28,65,-38v17,5,23,28,29,45v-21,32,-56,68,-109,71","w":382,"k":{"\"":88,"\u201d":88,"\u201c":88,"y":8,"x":4,"]":27,")":27,"\u2019":88,"\u2018":88,"\u00ff":8,"\u00fd":8,"\/":-31,"'":88}},"\u00f2":{"d":"181,10v-145,6,-156,-111,-157,-260v-1,-155,38,-256,166,-260v139,-4,155,113,155,257v0,158,-33,258,-164,263xm218,-432v-131,-40,-107,168,-102,283v2,63,37,108,96,82v56,-41,48,-190,40,-281v-3,-40,-11,-69,-34,-84xm241,-616v-9,28,-19,60,-54,32v-33,-27,-87,-60,-117,-88v6,-32,22,-83,59,-48v32,31,84,71,112,104","w":368,"k":{"\"":82,"\u201e":20,"\u201d":82,"\u201c":82,"z":7,"y":20,"x":24,"w":10,"v":10,"t":14,"f":10,"a":6,"]":34,".":20,")":34,"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":82,"\u2018":82,"\u017e":7,"\u0161":6,"\u00ff":20,"\u00fd":20,"\u00fc":6,"\u00fb":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":6,"\u00ea":6,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"k":14,"_":44,"\/":-16,",":20,"*":10,"'":82}},"\u00f3":{"d":"181,10v-145,6,-156,-111,-157,-260v-1,-155,38,-256,166,-260v139,-4,155,113,155,257v0,158,-33,258,-164,263xm218,-432v-131,-40,-107,168,-102,283v2,63,37,108,96,82v56,-41,48,-190,40,-281v-3,-40,-11,-69,-34,-84xm141,-615v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":368,"k":{"\"":82,"\u201e":20,"\u201d":82,"\u201c":82,"z":7,"y":20,"x":24,"w":10,"v":10,"t":14,"f":10,"a":6,"]":34,".":20,")":34,"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":82,"\u2018":82,"\u017e":7,"\u0161":6,"\u00ff":20,"\u00fd":20,"\u00fc":6,"\u00fb":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":6,"\u00ea":6,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"k":14,"_":44,"\/":-16,",":20,"*":10,"'":82}},"\u00f4":{"d":"181,10v-145,6,-156,-111,-157,-260v-1,-155,38,-256,166,-260v139,-4,155,113,155,257v0,158,-33,258,-164,263xm218,-432v-131,-40,-107,168,-102,283v2,63,37,108,96,82v56,-41,48,-190,40,-281v-3,-40,-11,-69,-34,-84xm174,-718v45,-13,67,42,90,60v14,24,77,62,31,82v-12,4,-25,6,-40,6v-21,-25,-49,-49,-65,-78r-31,39v-18,32,-72,56,-98,14","w":368,"k":{"\"":82,"\u201e":20,"\u201d":82,"\u201c":82,"z":7,"y":20,"x":24,"w":10,"v":10,"t":14,"f":10,"a":6,"]":34,".":20,")":34,"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":82,"\u2018":82,"\u017e":7,"\u0161":6,"\u00ff":20,"\u00fd":20,"\u00fc":6,"\u00fb":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":6,"\u00ea":6,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"k":14,"_":44,"\/":-16,",":20,"*":10,"'":82}},"\u00f5":{"d":"181,10v-145,6,-156,-111,-157,-260v-1,-155,38,-256,166,-260v139,-4,155,113,155,257v0,158,-33,258,-164,263xm218,-432v-131,-40,-107,168,-102,283v2,63,37,108,96,82v56,-41,48,-190,40,-281v-3,-40,-11,-69,-34,-84xm226,-574v-54,3,-53,-68,-109,-42v-18,8,-27,46,-52,27v-11,-9,-18,-21,-24,-35v27,-44,60,-75,113,-75v43,0,45,45,87,47v38,2,42,-28,65,-38v17,5,23,28,29,45v-21,32,-56,68,-109,71","w":368,"k":{"\"":82,"\u201e":20,"\u201d":82,"\u201c":82,"z":7,"y":20,"x":24,"w":10,"v":10,"t":14,"f":10,"a":6,"]":34,".":20,")":34,"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":82,"\u2018":82,"\u017e":7,"\u0161":6,"\u00ff":20,"\u00fd":20,"\u00fc":6,"\u00fb":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":6,"\u00ea":6,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"k":14,"_":44,"\/":-16,",":20,"*":10,"'":82}},"\u00f6":{"d":"181,10v-145,6,-156,-111,-157,-260v-1,-155,38,-256,166,-260v139,-4,155,113,155,257v0,158,-33,258,-164,263xm218,-432v-131,-40,-107,168,-102,283v2,63,37,108,96,82v56,-41,48,-190,40,-281v-3,-40,-11,-69,-34,-84xm119,-588v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm261,-588v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":368,"k":{"\"":82,"\u201e":20,"\u201d":82,"\u201c":82,"z":7,"y":20,"x":24,"w":10,"v":10,"t":14,"f":10,"a":6,"]":34,".":20,")":34,"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":82,"\u2018":82,"\u017e":7,"\u0161":6,"\u00ff":20,"\u00fd":20,"\u00fc":6,"\u00fb":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":6,"\u00ea":6,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"k":14,"_":44,"\/":-16,",":20,"*":10,"'":82}},"\u00f7":{"d":"384,-317v-3,37,7,64,-16,71r-334,0v3,-37,-7,-65,17,-71r333,0xm207,-80v-35,0,-48,-19,-49,-51v0,-28,19,-52,49,-52v36,0,50,19,51,52v0,29,-21,51,-51,51xm207,-376v-35,0,-48,-18,-49,-51v0,-28,19,-52,49,-52v36,0,50,19,51,52v0,29,-21,51,-51,51"},"\u00f8":{"d":"207,10v-52,0,-89,-8,-114,-38r-31,54v-17,-3,-55,-18,-40,-46r40,-71v-12,-46,-15,-96,-15,-159v0,-155,38,-260,166,-260v50,0,85,13,110,42v10,-19,24,-41,34,-54v20,8,57,17,41,46r-43,81v9,37,14,85,14,142v-2,144,-26,263,-162,263xm150,-101v10,55,91,53,110,4v20,-52,24,-155,18,-230xm211,-439v-96,0,-71,152,-73,261r126,-225v-9,-25,-24,-36,-53,-36","w":412,"k":{"\"":82,"\u201d":82,"\u201c":82,"y":20,"x":24,"w":10,"t":14,"g":13,"f":10,"a":6,"]":34,")":34,"\ufb04":-13,"\ufb03":-13,"\ufb02":10,"\ufb01":10,"\ufb00":-13,"\u2026":20,"\u201a":20,"\u2019":82,"\u2018":82,"\u017e":7,"\u0161":6,"\u00ff":20,"\u00fd":20,"\u00fc":6,"\u00fb":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":6,"\u00ea":6,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"_":44,"\/":-16,",":20,"*":10,"'":82,"v":10,".":20,"\u201e":20,"z":7}},"\u00f9":{"d":"195,-61v25,0,51,-5,67,-18r2,-413v16,-12,45,-6,79,-8r0,474v-37,20,-93,36,-149,36v-112,0,-150,-55,-150,-166r2,-336v17,-12,46,-6,82,-8r0,351v2,62,7,88,67,88xm250,-616v-9,28,-19,60,-54,32v-33,-27,-87,-60,-117,-88v6,-32,22,-83,59,-48v32,31,84,71,112,104","w":390,"k":{"\"":63,"\u201d":63,"\u201c":63,"]":31,")":31,"\u2019":63,"\u2018":63,"\/":-18,"'":63}},"\u00fa":{"d":"195,-61v25,0,51,-5,67,-18r2,-413v16,-12,45,-6,79,-8r0,474v-37,20,-93,36,-149,36v-112,0,-150,-55,-150,-166r2,-336v17,-12,46,-6,82,-8r0,351v2,62,7,88,67,88xm150,-615v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":390,"k":{"\"":63,"\u201d":63,"\u201c":63,"]":31,")":31,"\u2019":63,"\u2018":63,"\/":-18,"'":63}},"\u00fb":{"d":"195,-61v25,0,51,-5,67,-18r2,-413v16,-12,45,-6,79,-8r0,474v-37,20,-93,36,-149,36v-112,0,-150,-55,-150,-166r2,-336v17,-12,46,-6,82,-8r0,351v2,62,7,88,67,88xm183,-718v45,-13,67,42,90,60v14,24,77,62,31,82v-12,4,-25,6,-40,6v-21,-25,-49,-49,-65,-78r-31,39v-18,32,-72,56,-98,14","w":390,"k":{"\"":63,"\u201d":63,"\u201c":63,"y":8,"x":8,"]":31,")":31,"\u2019":63,"\u2018":63,"\u00ff":8,"\u00fd":8,"\/":-18,"'":63}},"\u00fc":{"d":"195,-61v25,0,51,-5,67,-18r2,-413v16,-12,45,-6,79,-8r0,474v-37,20,-93,36,-149,36v-112,0,-150,-55,-150,-166r2,-336v17,-12,46,-6,82,-8r0,351v2,62,7,88,67,88xm128,-588v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm270,-588v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":390,"k":{"\"":63,"\u201d":63,"\u201c":63,"y":8,"x":8,"]":31,")":31,"\u2019":63,"\u2018":63,"\u00ff":8,"\u00fd":8,"\/":-18,"'":63}},"\u00fd":{"d":"8,108v29,16,82,27,106,-7v11,-16,23,-44,30,-85r-122,-506v13,-16,46,-7,81,-10r65,295r16,120v17,-142,42,-276,72,-405v16,-15,48,-8,84,-10r-123,527v-23,86,-39,163,-140,166v-56,1,-91,-12,-78,-63v2,-9,5,-17,9,-22xm137,-615v37,-40,87,-90,134,-117v25,5,32,36,37,61v-38,34,-95,76,-140,102v-19,-4,-24,-28,-31,-46","w":356,"k":{"\"":62,"\u2212":27,"\u201e":55,"\u201d":62,"\u201c":62,"z":7,"x":7,"u":14,"t":7,"s":10,"p":14,"o":20,"g":24,"e":23,"d":18,"c":25,"a":10,".":55,"-":27,"\u2039":14,"\u2026":55,"\u201a":55,"\u2019":62,"\u2018":62,"\u2014":27,"\u2013":27,"\u017e":7,"\u0161":10,"\u0153":20,"\u00ff":7,"\u00fc":14,"\u00fb":14,"\u00fa":14,"\u00f9":14,"\u00f8":20,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":7,"\u00ef":11,"\u00ee":11,"\u00eb":23,"\u00ea":23,"\u00e9":23,"\u00e8":23,"\u00e7":25,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"r":20,"q":18,"m":9,"k":14,"_":53,"\/":31,",":55,"'":62,")":36,"]":36,":":8,";":8}},"\u00ff":{"d":"8,108v29,16,82,27,106,-7v11,-16,23,-44,30,-85r-122,-506v13,-16,46,-7,81,-10r65,295r16,120v17,-142,42,-276,72,-405v16,-15,48,-8,84,-10r-123,527v-23,86,-39,163,-140,166v-56,1,-91,-12,-78,-63v2,-9,5,-17,9,-22xm115,-588v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm257,-588v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":356,"k":{"\"":62,"\u2212":27,"\u201e":55,"\u201d":62,"\u201c":62,"z":7,"y":8,"x":7,"u":14,"t":7,"s":10,"p":14,"o":20,"g":24,"e":23,"d":18,"c":25,"a":10,"]":36,".":55,"-":27,")":36,"\u2039":14,"\u2026":55,"\u201a":55,"\u2019":62,"\u2018":62,"\u2014":27,"\u2013":27,"\u017e":7,"\u0161":10,"\u0153":20,"\u00ff":9,"\u00fd":8,"\u00fc":14,"\u00fb":14,"\u00fa":14,"\u00f9":14,"\u00f8":20,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":7,"\u00ef":11,"\u00ee":11,"\u00eb":23,"\u00ea":23,"\u00e9":23,"\u00e8":23,"\u00e7":25,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"r":20,"q":18,"m":9,"k":14,"_":53,"\/":31,",":55,"'":62,":":8,";":8}},"\u0131":{"d":"129,-16v0,29,-53,11,-83,16r0,-463v-2,-45,39,-35,83,-37r0,484","w":175,"k":{"\/":-23}},"\u0152":{"d":"547,-418v-3,28,10,75,-15,75r-136,0r0,270r171,0v-3,27,10,73,-15,73r-224,0r0,-40v-38,52,-140,66,-204,32v-94,-50,-97,-189,-97,-345v0,-187,14,-356,189,-356v51,0,87,13,112,41v-1,-17,1,-32,17,-32r226,0v-3,27,10,73,-15,73r-160,0r0,209r151,0xm170,-616v-68,71,-57,267,-48,402v5,74,17,143,89,143v75,0,84,-76,89,-153v8,-125,24,-325,-40,-393v-21,-22,-69,-21,-90,1","w":591,"k":{"\"":-10,"\u2212":27,"\u201e":32,"\u201d":-10,"\u201c":-10,"\u00f8":20,"z":4,"y":14,"x":7,"w":14,"u":7,"o":20,"g":10,"e":15,"d":16,"c":5,"a":10,"Y":21,"X":23,"W":15,"V":15,"T":21,"Q":3,"O":3,"J":32,"A":23,".":32,"-":27,"\u2026":32,"\u201a":32,"\u2019":-10,"\u2018":-10,"\u2014":27,"\u2013":27,"\u017e":4,"\u017d":23,"\u0178":21,"\u0161":10,"\u0160":23,"\u0153":20,"\u0152":3,"\u00ff":14,"\u00fd":14,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":10,"\u00ef":10,"\u00ee":10,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":5,"\u00e6":10,"\u00e5":10,"\u00e4":10,"\u00e3":10,"\u00e2":10,"\u00e1":10,"\u00e0":10,"\u00dd":21,"\u00dc":23,"\u00db":23,"\u00d8":3,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":3,"\u00d2":3,"\u00d1":23,"\u00cb":23,"\u00ca":23,"\u00c6":52,"\u00c5":23,"\u00c4":23,"\u00c3":23,"\u00c2":23,"\u00c1":23,"\u00c0":23,"r":7,"q":16,"0":5,"\/":-7,",":32,"'":-10}},"\u0153":{"d":"186,10v-147,0,-158,-110,-159,-260v0,-155,38,-259,165,-259v60,0,95,17,120,57v27,-44,70,-53,131,-58v131,-11,143,162,116,291v-61,12,-137,16,-209,16v3,77,7,134,85,134v50,0,89,-13,122,-31v3,19,18,73,-4,84v-68,33,-217,45,-252,-28v-26,36,-64,54,-115,54xm221,-432v-131,-40,-106,168,-101,283v2,63,37,108,96,82v56,-41,48,-190,40,-281v-3,-40,-12,-69,-35,-84xm486,-280v7,-64,18,-165,-52,-159v-75,6,-77,88,-84,170v45,-4,98,-1,136,-11","w":599,"k":{"\"":60,"\u201e":20,"\u201d":60,"\u201c":60,"z":14,"y":20,"x":7,"f":10,"a":6,"]":20,".":20,")":20,"\ufb04":10,"\ufb03":10,"\ufb02":10,"\ufb01":10,"\ufb00":10,"\u2026":20,"\u201a":20,"\u2019":60,"\u2018":60,"\u017e":14,"\u0161":6,"\u00ff":20,"\u00fd":20,"\u00fc":6,"\u00fb":6,"\u00f6":6,"\u00f5":6,"\u00f4":6,"\u00f1":6,"\u00ef":6,"\u00ee":6,"\u00eb":10,"\u00ea":10,"\u00e9":10,"\u00e8":10,"\u00e6":6,"\u00e5":6,"\u00e4":6,"\u00e3":6,"\u00e2":6,"\u00e1":6,"\u00e0":6,"k":7,"\/":-5,",":20,"'":60,"t":4,"w":3,"e":10}},"\u0160":{"d":"40,-498v-48,-115,29,-218,158,-212v71,3,120,6,131,50v-1,19,-8,35,-20,47v-48,-35,-198,-42,-195,44v1,48,22,67,46,99v67,89,175,142,175,292v0,119,-56,188,-179,188v-77,0,-147,-19,-126,-88v3,-11,9,-21,16,-30v23,19,58,35,103,35v95,0,118,-92,85,-165v-41,-91,-155,-166,-194,-260xm313,-890v-19,44,-72,99,-111,123v-46,-21,-93,-75,-124,-111v5,-16,21,-50,38,-51v35,17,61,56,89,86v23,-33,47,-58,75,-84v15,8,31,20,33,37","w":358,"k":{"\"":-16,"\u2212":-10,"\u201d":-16,"\u201c":-16,"\u00f8":13,"\u00ab":11,"y":34,"x":25,"w":34,"v":29,"u":10,"t":40,"s":6,"o":13,"f":30,"e":15,"d":13,"c":6,"b":6,"Y":77,"W":54,"V":67,"T":60,"O":18,"J":10,"G":16,"C":26,"-":-10,"\ufb04":30,"\ufb03":30,"\ufb02":30,"\ufb01":30,"\ufb00":30,"\u2122":22,"\u2039":11,"\u2019":-16,"\u2018":-16,"\u2014":-10,"\u2013":-10,"\u0178":77,"\u0161":6,"\u0153":13,"\u0152":18,"\u00ff":34,"\u00fd":34,"\u00fc":10,"\u00fb":10,"\u00fa":10,"\u00f9":10,"\u00f6":13,"\u00f5":13,"\u00f4":13,"\u00f3":13,"\u00f2":13,"\u00eb":15,"\u00ea":15,"\u00e9":15,"\u00e8":15,"\u00e7":6,"\u00e6":6,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"\u00c6":44,"q":16,"_":20,"\\":70,"Q":11,"7":20,"\/":-11,"'":-16}},"\u0161":{"d":"42,-340v-44,-100,36,-170,152,-170v79,0,160,33,108,97v-29,-17,-61,-26,-98,-26v-51,0,-101,30,-72,75v50,79,185,106,185,235v0,93,-68,140,-165,139v-63,-1,-136,-9,-119,-72v2,-8,6,-17,11,-26v52,33,181,45,181,-37v0,-37,-16,-56,-40,-78v-45,-42,-118,-82,-143,-137xm307,-690v-19,44,-72,99,-111,123v-46,-21,-93,-75,-124,-111v5,-16,21,-50,38,-51v35,17,61,56,89,86v23,-33,47,-58,75,-84v15,8,31,20,33,37","w":345,"k":{"\"":55,"\u2212":34,"\u201d":55,"\u201c":55,"y":4,"x":7,"-":34,"\u2019":55,"\u2018":55,"\u2014":34,"\u2013":34,"\u00ff":4,"\u00fd":4,"\/":-8,"'":55,")":7,"]":7}},"\u0178":{"d":"225,-16v1,29,-51,11,-81,16r0,-283r-139,-411v18,-10,64,-4,93,-6r71,254r18,92v22,-118,55,-233,89,-340v16,-11,57,-4,84,-6r-135,411r0,273xm117,-788v-35,0,-48,-18,-49,-51v0,-27,20,-51,49,-51v35,0,50,19,50,51v0,29,-20,51,-50,51xm259,-788v-35,0,-47,-18,-48,-51v0,-27,19,-51,48,-51v35,0,50,19,50,51v0,30,-19,51,-50,51","w":364,"k":{"\"":-20,"\u2212":65,"\u201e":61,"\u201d":-20,"\u201c":-20,"\u00f8":70,"\u00c6":77,"z":51,"y":45,"x":44,"w":42,"v":40,"u":57,"t":33,"s":66,"p":71,"o":70,"n":64,"j":27,"i":13,"g":68,"f":27,"e":75,"d":78,"c":70,"a":61,"S":7,"O":21,"J":85,"G":29,"C":32,"A":77,";":52,":":52,".":61,"-":65,"\ufb04":27,"\ufb03":27,"\ufb02":27,"\ufb01":27,"\ufb00":27,"\u203a":44,"\u2039":58,"\u2026":61,"\u201a":61,"\u2019":-20,"\u2018":-20,"\u2014":65,"\u2013":65,"\u017e":51,"\u017d":77,"\u0161":66,"\u0160":7,"\u0153":70,"\u0152":21,"\u0131":13,"\u00ff":45,"\u00fd":45,"\u00fc":57,"\u00fb":57,"\u00fa":57,"\u00f9":57,"\u00f6":70,"\u00f5":70,"\u00f4":70,"\u00f3":70,"\u00f2":70,"\u00f1":64,"\u00ef":13,"\u00ee":13,"\u00ed":13,"\u00ec":13,"\u00eb":75,"\u00ea":75,"\u00e9":75,"\u00e8":75,"\u00e7":70,"\u00e6":61,"\u00e5":61,"\u00e4":61,"\u00e3":61,"\u00e2":61,"\u00e1":61,"\u00e0":61,"\u00dc":77,"\u00db":77,"\u00d8":21,"\u00d6":21,"\u00d5":21,"\u00d4":21,"\u00d3":21,"\u00d2":21,"\u00d1":77,"\u00cb":77,"\u00ca":77,"\u00c7":32,"\u00c5":77,"\u00c4":77,"\u00c3":77,"\u00c2":77,"\u00c1":77,"\u00c0":77,"r":64,"q":78,"m":64,"_":73,"Q":21,"@":15,"0":47,"\/":49,",":61,"'":-20,"\u00ab":58,"\u00bb":44}},"\u017d":{"d":"88,-627v-16,0,-33,0,-44,3v4,-27,-13,-76,17,-76r299,0v12,15,8,45,0,63r-255,564v83,-3,181,8,252,-7v-5,28,15,80,-17,80r-312,0v-16,-14,-16,-44,-5,-68r251,-559r-186,0xm325,-890v-19,44,-72,99,-111,123v-46,-21,-93,-75,-124,-111v5,-16,21,-50,38,-51v35,17,61,56,89,86v23,-33,47,-58,75,-84v15,8,31,20,33,37","w":385,"k":{"\"":-13,"\u2212":99,"\u201d":-13,"\u201c":-13,"\u00f8":20,"\u00ab":8,"y":36,"x":20,"w":31,"v":50,"u":27,"t":17,"s":6,"p":13,"o":20,"g":15,"f":27,"e":27,"d":26,"c":19,"b":6,"a":16,"Y":77,"W":54,"V":67,"T":60,"O":18,"G":16,"C":26,"-":99,"\ufb04":27,"\ufb03":27,"\ufb02":27,"\ufb01":27,"\ufb00":27,"\u2122":22,"\u2039":8,"\u2019":-13,"\u2018":-13,"\u2014":99,"\u2013":99,"\u017e":16,"\u0178":77,"\u0161":16,"\u0153":20,"\u0152":18,"\u00ff":36,"\u00fd":36,"\u00fc":27,"\u00fb":27,"\u00fa":27,"\u00f9":27,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00f1":16,"\u00ef":16,"\u00ee":16,"\u00eb":27,"\u00ea":27,"\u00e9":27,"\u00e8":27,"\u00e7":19,"\u00e6":16,"\u00e5":16,"\u00e4":16,"\u00e3":16,"\u00e2":16,"\u00e1":16,"\u00e0":16,"\u00dd":77,"\u00d8":18,"\u00d6":18,"\u00d5":18,"\u00d4":18,"\u00d3":18,"\u00d2":18,"\u00c7":26,"r":27,"q":26,"\\":70,"Q":11,"7":20,"0":11,"\/":-28,"'":-13,")":14,"]":14}},"\u017e":{"d":"28,-426v-5,-30,-8,-74,23,-74r254,0v14,15,9,45,-1,65r-188,360v66,0,146,3,193,-11v4,34,11,86,-30,86r-245,0v-16,-12,-18,-49,-7,-71r194,-360r-102,0v-33,0,-65,2,-91,5xm288,-690v-19,44,-72,99,-111,123v-46,-21,-93,-75,-124,-111v5,-16,21,-50,38,-51v35,17,61,56,89,86v23,-33,47,-58,75,-84v15,8,31,20,33,37","w":334,"k":{"\"":47,"\u2212":37,"\u201d":47,"\u201c":47,"y":7,"x":14,"w":7,"u":14,"t":7,"p":7,"o":10,"g":10,"e":16,"d":16,"c":14,"a":11,"]":24,"-":37,")":24,"\u2039":10,"\u2019":47,"\u2018":47,"\u2014":37,"\u2013":37,"\u017e":11,"\u0161":11,"\u0153":10,"\u00ff":7,"\u00fd":7,"\u00fc":14,"\u00fb":14,"\u00fa":14,"\u00f9":14,"\u00f8":10,"\u00f6":10,"\u00f5":10,"\u00f4":10,"\u00f3":10,"\u00f2":10,"\u00f1":11,"\u00ef":11,"\u00ee":11,"\u00eb":16,"\u00ea":16,"\u00e9":16,"\u00e8":16,"\u00e7":14,"\u00e6":11,"\u00e5":11,"\u00e4":11,"\u00e3":11,"\u00e2":11,"\u00e1":11,"\u00e0":11,"q":16,"m":14,"k":20,"'":47}},"\u017f":{"d":"128,-30v8,50,-63,43,-90,26v3,-23,9,-42,8,-69r0,-515v0,-111,62,-149,173,-150v60,0,138,19,111,78v-4,10,-10,18,-15,25v-29,-21,-52,-32,-98,-32v-70,1,-88,38,-89,110r0,527","w":174,"k":{"!":-86,"\ufb04":40,"\ufb03":40,"\ufb02":40,"\ufb01":40,"\ufb00":40,"\u2122":-94,"\u2039":21,"\u2030":-45,"\u2026":48,"\u201a":48,"\u2019":-123,"\u2018":-123,"\u2014":48,"\u2013":48,"\u0153":17,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f8":17,"\u00f6":17,"\u00f5":17,"\u00f4":17,"\u00f3":17,"\u00f2":17,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":15,"\u00ae":-63,"\u00a9":-62,"r":7,"q":21,"m":3,"_":50,"]":-112,"\\":-100,"?":-112,"8":-19,",":48,"*":-33,"'":-123,"&":-36,"d":21,"u":7,"c":15,"e":20,"o":17,"\"":-123,"-":48,"\u2212":48,"\u201c":-123,"\u201d":-123,"\u00ab":21,"b":-3,")":-112,".":48,"\u201e":48,"g":20,"p":33,"h":-3,"k":-3}},"\u02c6":{"d":"113,-718v45,-13,67,42,90,60v14,24,77,62,31,82v-12,4,-25,6,-40,6v-21,-25,-49,-49,-65,-78r-31,39v-18,32,-72,56,-98,14","w":252},"\u02c7":{"d":"235,-690v-19,44,-72,99,-111,123v-46,-21,-93,-75,-124,-111v5,-16,21,-50,38,-51v35,17,61,56,89,86v23,-33,47,-58,75,-84v15,8,31,20,33,37","w":235},"\u02d9":{"d":"41,-596v-33,0,-41,-23,-41,-63v0,-34,13,-60,47,-60v35,1,41,19,40,58v0,37,-12,65,-46,65","w":88},"\u02da":{"d":"94,-562v-66,0,-94,-26,-94,-97v0,-67,36,-98,100,-98v68,0,93,25,93,97v0,65,-35,98,-99,98xm101,-701v-28,0,-43,13,-43,43v0,27,12,41,37,41v27,0,41,-14,41,-43v0,-27,-12,-41,-35,-41","w":193},"\u02dc":{"d":"185,-574v-54,3,-53,-68,-109,-42v-18,8,-27,46,-52,27v-11,-9,-18,-21,-24,-35v27,-44,60,-75,113,-75v43,0,45,45,87,47v38,2,42,-28,65,-38v17,5,23,28,29,45v-21,32,-56,68,-109,71","w":294},"\u2013":{"d":"387,-317v-3,37,7,65,-17,71r-333,0v3,-37,-7,-64,16,-71r334,0","w":424,"k":{"\u203a":30,"\u00bb":30,"z":62,"y":32,"x":74,"w":20,"v":25,"t":29,"f":30,"]":31,"Z":47,"Y":64,"X":65,"W":29,"V":37,"T":105,"S":93,"R":1,"P":1,"N":1,"L":1,"K":1,"J":122,"H":1,"F":1,"E":1,"D":1,"B":1,"A":33,")":31,"\ufb04":30,"\ufb03":30,"\ufb02":30,"\ufb01":30,"\ufb00":30,"\u017e":62,"\u017d":47,"\u0178":64,"\u0160":93,"\u00ff":32,"\u00fd":32,"\u00dd":64,"\u00dc":25,"\u00db":25,"\u00d6":25,"\u00d5":25,"\u00d4":25,"\u00d1":1,"\u00cb":1,"\u00ca":1,"\u00c9":1,"\u00c8":1,"\u00c6":33,"\u00c5":33,"\u00c4":33,"\u00c3":33,"\u00c2":33,"\u00c1":33,"\u00c0":33,"\\":83}},"\u2014":{"d":"694,-317v-3,37,7,65,-17,71r-671,0v3,-37,-7,-64,16,-71r672,0","w":700,"k":{"\u203a":30,"\u00bb":30,"z":62,"y":32,"x":74,"w":20,"v":25,"t":29,"f":30,"]":31,"Z":47,"Y":64,"X":65,"W":29,"V":37,"T":105,"S":93,"R":1,"P":1,"N":1,"L":1,"K":1,"J":122,"H":1,"F":1,"E":1,"D":1,"B":1,"A":33,")":31,"\ufb04":30,"\ufb03":30,"\ufb02":30,"\ufb01":30,"\ufb00":30,"\u017e":62,"\u017d":47,"\u0178":64,"\u0160":93,"\u00ff":32,"\u00fd":32,"\u00dd":64,"\u00dc":25,"\u00db":25,"\u00d6":25,"\u00d5":25,"\u00d4":25,"\u00d1":1,"\u00cb":1,"\u00ca":1,"\u00c9":1,"\u00c8":1,"\u00c6":33,"\u00c5":33,"\u00c4":33,"\u00c3":33,"\u00c2":33,"\u00c1":33,"\u00c0":33,"\\":83}},"\u2018":{"d":"141,-772v-19,33,-21,56,-25,96v39,22,26,101,-28,101v-84,0,-51,-124,-24,-167v16,-24,30,-66,64,-48v6,3,10,9,13,18","w":175,"k":{"z":70,"y":71,"x":63,"w":69,"v":69,"u":73,"t":18,"s":91,"p":100,"o":93,"n":96,"g":107,"f":44,"e":103,"d":111,"c":94,"a":72,"]":-20,"[":79,"Y":-20,"W":-16,"V":-16,"T":-13,"O":20,"J":132,"G":37,"C":55,"A":119,")":-20,"(":79,"\ufb04":44,"\ufb03":44,"\ufb02":44,"\ufb01":44,"\ufb00":44,"\u20ac":122,"\u017e":70,"\u0178":-20,"\u0161":91,"\u0160":11,"\u0153":93,"\u0152":20,"\u00ff":71,"\u00fd":71,"\u00fc":73,"\u00fb":73,"\u00fa":73,"\u00f9":73,"\u00f8":93,"\u00f6":93,"\u00f5":93,"\u00f4":93,"\u00f3":93,"\u00f2":93,"\u00f1":96,"\u00ef":-54,"\u00ee":-41,"\u00ec":-52,"\u00eb":103,"\u00ea":103,"\u00e9":103,"\u00e8":103,"\u00e7":94,"\u00e6":72,"\u00e5":72,"\u00e4":72,"\u00e3":72,"\u00e2":72,"\u00e1":72,"\u00e0":72,"\u00dd":-20,"\u00dc":10,"\u00db":11,"\u00da":1,"\u00d9":1,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00d1":9,"\u00cf":-19,"\u00ce":-41,"\u00cb":16,"\u00ca":5,"\u00c7":55,"\u00c6":119,"\u00c5":119,"\u00c4":119,"\u00c3":119,"\u00c2":119,"\u00c1":119,"\u00c0":119,"\u00bf":104,"\u00a2":56,"r":96,"q":111,"m":96,"\\":-37,"Q":20,"@":75,"?":-20,"9":46,"6":31,"4":101,"3":4,"2":19,"1":39,"0":43,"\/":122,"+":21}},"\u2019":{"d":"34,-595v19,-32,21,-57,25,-96v-39,-22,-26,-101,27,-101v86,0,51,124,24,167v-16,24,-29,66,-64,48v-6,-3,-10,-9,-12,-18","w":175,"k":{"z":70,"y":71,"x":63,"w":69,"v":69,"u":73,"t":18,"s":91,"p":100,"o":93,"n":96,"g":107,"f":44,"e":103,"d":111,"c":94,"a":72,"]":-20,"[":79,"Y":-20,"W":-16,"V":-16,"T":-13,"O":20,"J":132,"G":37,"C":55,"A":119,")":-20,"(":79,"\ufb04":44,"\ufb03":44,"\ufb02":44,"\ufb01":44,"\ufb00":44,"\u20ac":122,"\u017e":70,"\u0178":-20,"\u0161":91,"\u0160":11,"\u0153":93,"\u0152":20,"\u00ff":71,"\u00fd":71,"\u00fc":73,"\u00fb":73,"\u00fa":73,"\u00f9":73,"\u00f8":93,"\u00f6":93,"\u00f5":93,"\u00f4":93,"\u00f3":93,"\u00f2":93,"\u00f1":96,"\u00ef":-54,"\u00ee":-41,"\u00ec":-52,"\u00eb":103,"\u00ea":103,"\u00e9":103,"\u00e8":103,"\u00e7":94,"\u00e6":72,"\u00e5":72,"\u00e4":72,"\u00e3":72,"\u00e2":72,"\u00e1":72,"\u00e0":72,"\u00dd":-20,"\u00dc":10,"\u00db":11,"\u00da":1,"\u00d9":1,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00d1":9,"\u00cf":-19,"\u00ce":-41,"\u00cb":16,"\u00ca":5,"\u00c7":55,"\u00c6":119,"\u00c5":119,"\u00c4":119,"\u00c3":119,"\u00c2":119,"\u00c1":119,"\u00c0":119,"\u00bf":104,"\u00a2":56,"r":96,"q":111,"m":96,"\\":-37,"Q":20,"@":75,"?":-20,"9":46,"6":31,"4":101,"3":4,"2":19,"1":39,"0":43,"\/":122,"+":21}},"\u201a":{"d":"34,91v19,-33,21,-56,25,-96v-39,-22,-26,-101,27,-101v86,0,51,125,24,168v-16,25,-29,64,-64,47v-6,-3,-10,-9,-12,-18","w":171,"k":{"\u00f8":20,"y":48,"w":33,"v":45,"u":24,"t":48,"o":20,"j":-81,"f":39,"e":20,"d":20,"c":7,"Y":61,"W":31,"V":48,"U":7,"T":89,"O":27,"G":13,"C":31,"\ufb04":39,"\ufb03":39,"\ufb02":39,"\ufb01":39,"\ufb00":39,"\u0178":61,"\u0153":20,"\u0152":27,"\u00ff":48,"\u00fd":48,"\u00fc":24,"\u00fb":24,"\u00fa":24,"\u00f9":24,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":7,"\u00dd":61,"\u00dc":7,"\u00db":7,"\u00da":7,"\u00d9":7,"\u00d8":27,"\u00d6":27,"\u00d5":27,"\u00d4":27,"\u00d3":27,"\u00d2":27,"\u00c7":31,"q":20,"\\":128,"Q":27}},"\u201c":{"d":"141,-772v-19,33,-21,56,-25,96v39,22,26,101,-28,101v-84,0,-51,-124,-24,-167v16,-24,30,-66,64,-48v6,3,10,9,13,18xm291,-772v-19,33,-21,56,-25,96v39,22,26,101,-27,101v-86,0,-52,-124,-25,-167v16,-24,30,-66,65,-48v6,3,10,9,12,18","w":325,"k":{"\ufb04":44,"\ufb03":44,"\ufb02":44,"\ufb01":44,"\ufb00":44,"\u20ac":122,"\u017e":70,"\u0178":-20,"\u0161":91,"\u0160":11,"\u0153":93,"\u0152":20,"\u00ff":71,"\u00fd":71,"\u00fc":73,"\u00fb":73,"\u00fa":73,"\u00f9":73,"\u00f8":93,"\u00f6":93,"\u00f5":93,"\u00f4":93,"\u00f3":93,"\u00f2":93,"\u00f1":96,"\u00ef":-54,"\u00ee":-41,"\u00ec":-52,"\u00eb":103,"\u00ea":103,"\u00e9":103,"\u00e8":103,"\u00e7":94,"\u00e6":72,"\u00e5":72,"\u00e4":72,"\u00e3":72,"\u00e2":72,"\u00e1":72,"\u00e0":72,"\u00dd":-20,"\u00dc":10,"\u00db":11,"\u00da":1,"\u00d9":1,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00d1":9,"\u00cf":-19,"\u00ce":-41,"\u00cb":16,"\u00ca":5,"\u00c7":55,"\u00c6":119,"\u00c5":119,"\u00c4":119,"\u00c3":119,"\u00c2":119,"\u00c1":119,"\u00c0":119,"\u00bf":104,"\u00a2":56,"r":96,"q":111,"m":96,"\\":-37,"Q":20,"@":75,"?":-20,"9":46,"6":31,"4":101,"3":4,"2":19,"1":39,"0":43,"\/":122,"+":21,"C":55,"G":37,"T":-13,"V":-16,"W":-16,"Y":-20,"d":111,"f":44,"t":18,"u":73,"v":69,"w":69,"y":71,"c":94,"e":103,"o":93,"O":20,")":-20,"]":-20,"A":119,"J":132,"x":63,"a":72,"z":70,"g":107,"n":96,"p":100,"s":91,"(":79,"[":79}},"\u201d":{"d":"185,-595v18,-32,20,-58,24,-96v-39,-22,-27,-101,28,-101v86,0,52,124,25,167v-16,24,-32,66,-66,48v-6,-3,-9,-9,-11,-18xm34,-595v19,-32,21,-57,25,-96v-39,-22,-26,-101,27,-101v86,0,51,124,24,167v-16,24,-29,66,-64,48v-6,-3,-10,-9,-12,-18","w":325,"k":{"\ufb04":44,"\ufb03":44,"\ufb02":44,"\ufb01":44,"\ufb00":44,"\u20ac":122,"\u017e":70,"\u0178":-20,"\u0161":91,"\u0160":11,"\u0153":93,"\u0152":20,"\u00ff":71,"\u00fd":71,"\u00fc":73,"\u00fb":73,"\u00fa":73,"\u00f9":73,"\u00f8":93,"\u00f6":93,"\u00f5":93,"\u00f4":93,"\u00f3":93,"\u00f2":93,"\u00f1":96,"\u00ef":-54,"\u00ee":-41,"\u00ec":-52,"\u00eb":103,"\u00ea":103,"\u00e9":103,"\u00e8":103,"\u00e7":94,"\u00e6":72,"\u00e5":72,"\u00e4":72,"\u00e3":72,"\u00e2":72,"\u00e1":72,"\u00e0":72,"\u00dd":-20,"\u00dc":10,"\u00db":11,"\u00da":1,"\u00d9":1,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00d1":9,"\u00cf":-19,"\u00ce":-41,"\u00cb":16,"\u00ca":5,"\u00c7":55,"\u00c6":119,"\u00c5":119,"\u00c4":119,"\u00c3":119,"\u00c2":119,"\u00c1":119,"\u00c0":119,"\u00bf":104,"\u00a2":56,"r":96,"q":111,"m":96,"\\":-37,"Q":20,"@":75,"?":-20,"9":46,"6":31,"4":101,"3":4,"2":19,"1":39,"0":43,"\/":122,"+":21,"C":55,"G":37,"T":-13,"V":-16,"W":-16,"Y":-20,"d":111,"f":44,"t":18,"u":73,"v":69,"w":69,"y":71,"c":94,"e":103,"o":93,"O":20,")":-20,"]":-20,"A":119,"J":132,"x":63,"a":72,"z":70,"g":107,"n":96,"p":100,"s":91,"(":79,"[":79}},"\u201e":{"d":"185,91v18,-33,20,-57,24,-96v-39,-22,-26,-101,28,-101v86,0,52,125,25,168v-16,25,-32,64,-66,47v-6,-3,-9,-9,-11,-18xm34,91v19,-33,21,-56,25,-96v-39,-22,-26,-101,27,-101v86,0,51,125,24,168v-16,25,-29,64,-64,47v-6,-3,-10,-9,-12,-18","w":322,"k":{"\ufb04":39,"\ufb03":39,"\ufb02":39,"\ufb01":39,"\ufb00":39,"\u0178":61,"\u0153":20,"\u0152":27,"\u00ff":48,"\u00fd":48,"\u00fc":24,"\u00fb":24,"\u00fa":24,"\u00f9":24,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":7,"\u00dd":61,"\u00dc":7,"\u00db":7,"\u00da":7,"\u00d9":7,"\u00d8":27,"\u00d6":27,"\u00d5":27,"\u00d4":27,"\u00d3":27,"\u00d2":27,"\u00c7":31,"q":20,"\\":128,"Q":27,"C":31,"G":13,"T":89,"V":48,"W":31,"Y":61,"d":20,"f":39,"t":48,"u":24,"v":45,"w":33,"y":48,"c":7,"e":20,"o":20,"\u00f8":20,"O":27,"j":-81,"U":7}},"\u2022":{"d":"114,-208v-53,0,-72,-27,-73,-76v0,-42,28,-77,73,-77v53,0,74,28,75,77v0,43,-30,76,-75,76","w":223},"\u2026":{"d":"92,6v-41,0,-55,-19,-56,-57v0,-31,22,-58,56,-58v40,0,55,21,56,58v0,32,-23,57,-56,57xm261,6v-41,0,-55,-19,-56,-57v0,-31,22,-58,56,-58v40,0,55,21,56,58v0,32,-23,57,-56,57xm431,6v-41,0,-55,-19,-56,-57v0,-31,22,-58,56,-58v40,0,55,21,56,58v0,32,-23,57,-56,57","w":522,"k":{"\u00f8":20,"y":48,"w":33,"v":45,"u":24,"t":48,"o":20,"f":39,"e":20,"d":20,"c":7,"Y":61,"W":31,"V":48,"U":7,"T":89,"O":27,"G":13,"C":31,"\ufb04":39,"\ufb03":39,"\ufb02":39,"\ufb01":39,"\ufb00":39,"\u0178":61,"\u0153":20,"\u0152":27,"\u00ff":48,"\u00fd":48,"\u00fc":24,"\u00fb":24,"\u00fa":24,"\u00f9":24,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":7,"\u00dd":61,"\u00dc":7,"\u00db":7,"\u00da":7,"\u00d9":7,"\u00d8":27,"\u00d6":27,"\u00d5":27,"\u00d4":27,"\u00d3":27,"\u00d2":27,"\u00c7":31,"q":20,"\\":128,"Q":27,"\/":-7}},"\u2030":{"d":"155,9v-20,-7,-44,-11,-50,-31r404,-687v18,8,42,14,46,35r-200,346xm180,-340v-113,3,-136,-70,-136,-186v0,-114,40,-181,142,-183v108,-2,133,72,133,182v0,116,-36,184,-139,187xm186,-646v-59,0,-64,58,-64,122v0,63,0,121,60,121v56,0,62,-60,62,-123v0,-63,0,-120,-58,-120xm499,9v-112,3,-135,-70,-135,-185v0,-115,40,-181,142,-183v107,-2,133,71,133,181v0,116,-36,184,-140,187xm505,-296v-59,0,-63,59,-63,122v0,63,0,120,60,120v55,0,61,-60,61,-123v0,-62,1,-119,-58,-119xm798,9v-113,3,-135,-70,-135,-185v0,-115,40,-181,141,-183v107,-2,133,71,133,181v0,116,-36,184,-139,187xm804,-296v-59,0,-64,58,-64,122v0,63,0,120,60,120v52,0,62,-50,62,-123v0,-62,1,-119,-58,-119","w":981,"k":{"\"":74,"\u201d":74,"\u201c":74,"\u2019":74,"\u2018":74,"'":74}},"\u2039":{"d":"163,-500v27,2,38,23,49,41v-25,84,-74,139,-118,209r82,122v15,25,32,50,38,81v-9,22,-21,45,-48,47r-101,-155v-15,-31,-38,-59,-47,-95v33,-95,96,-169,145,-250","w":247,"k":{"\u0178":39,"\u00dd":39,"Y":39,"V":26,"T":65,"W":27}},"\u203a":{"d":"81,0v-28,-8,-61,-29,-44,-66v30,-67,76,-125,115,-184r-80,-126v-17,-33,-62,-89,-13,-114v7,-4,15,-7,24,-10r123,196v11,26,32,46,16,76v-41,81,-93,154,-141,228","w":247,"k":{"\ufb02":32,"\ufb01":32,"\u017e":24,"\u0178":55,"\u00ff":3,"\u00fd":3,"\u00dd":55,"\u00c6":8,"z":24,"y":3,"x":14,"w":2,"t":21,"f":32,"]":14,"Y":55,"X":27,"W":31,"V":31,"T":65,"J":41,"A":8,")":14,"\u2014":-11,"\u2013":-11,"\u017d":8,"\u0160":8,"\u00dc":8,"\u00db":8,"\u00d6":8,"\u00d5":8,"\u00d4":8,"\u00d1":8,"\u00cb":8,"\u00ca":8,"\u00c5":8,"\u00c4":8,"\u00c3":8,"\u00c2":8,"\u00c1":8,"\u00c0":8,"v":8,"-":-11,"\u2212":-11,"Z":8}},"\u2044":{"d":"-26,-5v-16,31,-68,5,-81,-14r335,-672v14,-36,69,-13,83,10","w":195},"\u20ac":{"d":"111,-407v20,-115,62,-199,185,-199v57,0,114,11,96,72v-2,10,-6,18,-10,23v-29,-22,-99,-31,-131,1v-25,25,-41,57,-51,103r143,0v-2,41,3,68,-32,68r-120,0v-3,22,-2,49,-2,74r121,0v-2,40,2,67,-32,67r-86,0v8,73,20,129,97,128v35,0,69,-10,88,-25v7,12,12,31,12,52v-13,39,-64,51,-116,52v-128,3,-159,-83,-169,-207r-88,0v2,-41,-3,-67,32,-67r54,0r2,-74r-88,0v2,-41,-3,-68,32,-68r63,0","k":{"\u2212":11,"\u2014":11,"\u2013":11,"]":17,"-":11,")":17}},"\u2122":{"d":"452,-391v1,16,-27,7,-42,9r9,-227r-25,80r-28,74v-3,8,-17,2,-26,4v-20,-52,-38,-106,-54,-162r8,120r1,102v-4,15,-14,6,-41,9r0,-309v1,-15,24,-7,38,-9r63,181r59,-178v7,-7,26,-1,38,-3r0,309xm229,-700v-2,15,6,39,-10,39r-66,0r0,270v1,16,-26,7,-41,9r0,-279r-82,0v2,-14,-7,-39,9,-39r190,0","w":503,"k":{"\/":78}},"\u2212":{"d":"384,-317v-3,37,7,64,-16,71r-334,0v3,-37,-7,-65,17,-71r333,0","k":{"\ufb04":30,"\ufb03":30,"\ufb02":30,"\ufb01":30,"\ufb00":30,"\u017e":62,"\u017d":47,"\u0178":64,"\u0160":93,"\u00ff":32,"\u00fd":32,"\u00dd":64,"\u00c8":1,"\u00c6":33,"\u00c5":33,"\u00c4":33,"\u00c3":33,"\u00c2":33,"\u00c1":33,"\u00c0":33,"\\":83,"T":105,"V":37,"W":29,"Y":64,"f":30,"t":29,"v":25,"w":20,"y":32,")":31,"]":31,"A":33,"J":122,"X":65,"x":74,"S":93,"z":62,"\u00bb":30,"\u203a":30,"Z":47,"B":1,"D":1,"E":1,"F":1,"H":1,"K":1,"L":1,"N":1,"P":1,"R":1,"\u00c9":1,"\u00ca":1,"\u00cb":1,"\u00d1":1}},"\ufb00":{"d":"365,-16v-3,29,-53,11,-81,16r0,-431r-122,0r0,415v-3,29,-53,11,-81,16r0,-431r-69,0v3,-32,-10,-68,21,-69r48,0r0,-69v-1,-110,53,-165,157,-165v40,0,75,13,100,28v28,-24,69,-32,114,-33v60,0,100,10,90,65v-1,7,-3,14,-6,21v-22,-10,-43,-12,-71,-12v-68,-2,-101,29,-100,98r0,67r89,0v-3,31,10,69,-17,69r-72,0r0,415xm239,-665v-83,0,-80,82,-77,165r122,0v0,-55,-2,-114,14,-151v-17,-10,-32,-14,-59,-14","w":456,"k":{"\"":-123,"\u201e":48,"\u201d":-123,"\u201c":-123,"u":7,"p":33,"o":17,"k":-3,"h":-3,"g":20,"f":40,"e":20,"d":21,"c":15,"b":-3,".":48,")":-112,"!":-86,"\ufb04":40,"\ufb03":40,"\ufb02":40,"\ufb01":40,"\ufb00":40,"\u2122":-94,"\u2030":-45,"\u2026":48,"\u201a":48,"\u2019":-123,"\u2018":-123,"\u017e":13,"\u0153":20,"\u00fc":7,"\u00fb":7,"\u00fa":7,"\u00f9":7,"\u00f8":27,"\u00f6":20,"\u00f5":20,"\u00f4":20,"\u00f3":20,"\u00f2":20,"\u00eb":20,"\u00ea":20,"\u00e9":20,"\u00e8":20,"\u00e7":15,"\u00ae":-63,"\u00a9":-62,"r":7,"q":27,"m":3,"]":-51,"\\":-100,"?":-82,"8":-19,",":48,"*":-26,"'":-123,"&":-36}},"\ufb03":{"d":"160,-16v-3,29,-53,11,-81,16r0,-431r-69,0v3,-32,-10,-68,21,-69r48,0r0,-69v-1,-111,53,-165,157,-165v40,0,75,13,100,28v31,-25,75,-33,126,-33v65,0,127,8,112,72v-2,9,-3,17,-6,24v-25,-13,-66,-22,-104,-22v-71,0,-104,30,-102,103r0,62r70,0v-3,31,10,69,-17,69r-53,0r0,415v-3,29,-53,11,-81,16r0,-431r-121,0r0,415xm560,-16v0,29,-53,11,-83,16r0,-463v-2,-45,39,-35,83,-37r0,484xm236,-665v-83,-4,-79,82,-76,165r121,0v0,-54,-2,-115,14,-151v-16,-9,-33,-13,-59,-14","w":606},"\ufb04":{"d":"160,-16v-3,29,-53,11,-81,16r0,-431r-69,0v3,-32,-10,-68,21,-69r48,0r0,-69v-1,-111,53,-165,157,-165v39,0,73,12,98,27v54,-52,184,-33,236,2r0,689v0,29,-52,11,-82,16r0,-659v-68,-22,-136,6,-126,87r0,72r69,0v-3,31,10,69,-17,69r-52,0r0,415v-3,29,-53,11,-81,16r0,-431r-121,0r0,415xm236,-665v-83,-4,-79,82,-76,165r121,0v0,-54,-2,-115,14,-151v-16,-9,-33,-13,-59,-14","w":616},"\u00d0":{"d":"44,-681v1,-15,8,-19,27,-19r97,0v168,0,195,131,196,306v0,131,-11,233,-51,310v-28,54,-71,84,-144,84r-125,0r0,-330r-40,0v2,-46,-11,-78,40,-72r0,-279xm204,-402v-3,37,6,65,-16,72r-63,0r0,252v60,4,97,-3,115,-54v24,-67,33,-151,31,-262v-2,-132,3,-250,-146,-231r0,223r79,0","w":393},"\u0141":{"d":"297,-76v-4,27,12,76,-17,76r-237,0r0,-312r-34,9v-6,-24,-10,-42,-11,-53v-3,-27,28,-21,45,-29r1,-305v15,-15,47,-8,81,-10r0,293r97,-27v6,25,10,43,11,54v1,11,-2,17,-10,19r-98,27r0,258r172,0","w":317},"\u0142":{"d":"127,-16v1,29,-51,11,-81,16r0,-307r-40,11v-6,-36,-22,-58,0,-74r40,-11r0,-317v-3,-44,38,-36,81,-37r0,332r43,-12v6,25,10,42,11,53v3,30,-35,22,-54,33r0,313","w":173},"\u00b9":{"d":"49,-289v-7,-28,-13,-77,23,-77r93,0r0,-255r-108,22v-18,-26,-11,-70,17,-77v51,-13,111,-40,173,-31r0,341r87,0v3,32,12,77,-21,77r-264,0","w":381},"\u00b3":{"d":"127,-473v-8,-18,-20,-62,17,-62v17,0,35,1,52,3v23,-17,38,-30,38,-61v0,-70,-134,-43,-167,-11v-17,-15,-25,-52,-7,-67v29,-25,82,-39,144,-39v134,0,155,130,67,194v37,16,68,46,68,93v0,102,-73,144,-175,144v-67,0,-138,-13,-114,-80v4,-8,8,-15,14,-20v45,34,191,44,191,-37v-1,-58,-67,-57,-128,-57","w":383},"\u00b2":{"d":"167,-627v-44,0,-75,19,-101,38v-15,-26,-25,-55,-1,-77v65,-58,278,-78,264,62v-11,117,-108,167,-166,238r175,0v9,27,8,77,-21,77r-271,0v-24,-68,38,-101,68,-133v44,-48,106,-79,117,-153v-2,-36,-18,-52,-64,-52","w":384},"\u2074":{"d":"154,-629v35,-45,68,-97,147,-76r0,269r60,0v9,24,12,76,-19,77r-41,0v-1,42,11,80,-43,76v-11,0,-23,-2,-33,-4r0,-72r-171,0v-32,-45,1,-97,19,-137v21,-47,51,-94,81,-133xm228,-431r4,-186v-50,45,-94,113,-117,186r113,0","w":396},"\u00bd":{"d":"49,-289v-7,-28,-13,-77,23,-77r93,0r0,-255r-108,22v-18,-26,-11,-70,17,-77v51,-13,111,-40,173,-31r0,341r87,0v3,32,12,77,-21,77r-264,0xm330,-5v-16,31,-68,5,-81,-14r335,-672v14,-36,69,-13,83,10xm679,-338v-44,0,-75,19,-101,38v-15,-26,-25,-55,-1,-77v65,-58,278,-78,264,62v-11,117,-108,167,-166,238r175,0v9,27,8,77,-21,77r-271,0v-24,-68,38,-101,68,-133v44,-48,106,-79,117,-153v-2,-36,-18,-52,-64,-52","w":900},"\u00bc":{"d":"49,-289v-7,-28,-13,-77,23,-77r93,0r0,-255r-108,22v-18,-26,-11,-70,17,-77v51,-13,111,-40,173,-31r0,341r87,0v3,32,12,77,-21,77r-264,0xm612,-341v35,-45,68,-97,147,-76r0,269r60,0v9,24,12,76,-19,77r-41,0v-1,42,11,80,-43,76v-11,0,-23,-2,-33,-4r0,-72r-171,0v-32,-45,1,-97,19,-137v21,-47,51,-94,81,-133xm686,-143r4,-186v-50,45,-94,113,-117,186r113,0xm330,-5v-16,31,-68,5,-81,-14r335,-672v14,-36,69,-13,83,10","w":869},"\u00be":{"d":"127,-473v-8,-18,-20,-62,17,-62v17,0,35,1,52,3v23,-17,38,-30,38,-61v0,-70,-134,-43,-167,-11v-17,-15,-25,-52,-7,-67v29,-25,82,-39,144,-39v134,0,155,130,67,194v37,16,68,46,68,93v0,102,-73,144,-175,144v-67,0,-138,-13,-114,-80v4,-8,8,-15,14,-20v45,34,191,44,191,-37v-1,-58,-67,-57,-128,-57xm609,-341v35,-45,68,-97,147,-76r0,269r60,0v9,24,12,76,-19,77r-41,0v-1,42,11,80,-43,76v-11,0,-23,-2,-33,-4r0,-72r-171,0v-32,-45,1,-97,19,-137v21,-47,51,-94,81,-133xm683,-143r4,-186v-50,45,-94,113,-117,186r113,0xm327,-5v-16,31,-68,5,-81,-14r335,-672v14,-36,69,-13,83,10","w":866},"\u00a6":{"d":"73,-711v-5,-42,52,-34,81,-26r0,383v5,40,-51,27,-81,24r0,-381xm73,-192v-5,-42,52,-35,81,-27r0,388v5,41,-52,29,-81,24r0,-385","w":227},"<":{"d":"329,-431v19,17,47,63,14,79r-198,97r215,96v-2,38,-19,76,-64,56r-244,-108v-19,-31,-18,-76,13,-91","w":400},">":{"d":"74,-85v-18,-17,-46,-64,-14,-79r199,-97r-216,-96v3,-37,21,-75,64,-56r244,108v20,30,20,75,-13,91","w":400},"^":{"d":"110,-218v-27,24,-64,-2,-62,-32r173,-148r145,127v30,24,5,65,-25,65r-129,-87","w":430},"{":{"d":"90,-362v54,-115,-82,-338,92,-375v19,-5,39,-7,62,-7v14,15,25,70,1,79v-48,4,-73,28,-73,80v-1,94,44,257,-44,285v103,36,24,217,49,324v9,35,36,46,75,51v6,34,6,74,-25,75v-97,3,-137,-42,-138,-135v0,-71,15,-125,14,-197v0,-51,-17,-70,-56,-78v-16,-36,1,-77,29,-86v6,-4,10,-10,14,-16","w":276},"}":{"d":"218,-261v-135,80,110,413,-185,411v-14,-16,-26,-71,0,-79v47,-4,72,-28,72,-80v0,-93,-44,-257,43,-285v-101,-37,-24,-218,-48,-324v-9,-35,-37,-46,-75,-51v-8,-32,-6,-75,26,-75v97,-1,136,43,137,135v0,71,-15,125,-14,197v0,51,16,70,55,78v11,25,10,61,-11,73","w":276},"~":{"d":"391,-276v-29,53,-139,90,-201,42v-26,-20,-79,-29,-108,-4v-15,13,-43,33,-60,8v-6,-9,-10,-21,-11,-36v25,-35,70,-61,129,-63v70,-3,98,69,170,33v20,-10,37,-46,64,-22v10,10,16,24,17,42","w":400},"\u2020":{"d":"173,-668v-9,-44,66,-51,88,-21r-23,177v-5,22,-27,21,-42,10xm361,-515v35,-12,44,39,33,69v-3,8,-7,13,-12,18r-120,-21v-21,-5,-20,-26,-11,-43xm69,-429v-44,9,-50,-67,-20,-88r120,23v23,7,24,27,12,44xm259,-33v7,45,-68,49,-88,21r23,-412v0,-23,30,-24,43,-12","w":430},"\u00b0":{"d":"177,-552v-67,0,-94,-24,-94,-97v0,-67,36,-97,100,-97v68,0,93,24,93,96v0,66,-34,98,-99,98xm184,-694v-31,0,-46,14,-46,46v0,29,13,44,40,44v29,-1,45,-14,44,-46v0,-30,-10,-43,-38,-44","w":358},"\u00a3":{"d":"288,-348v-3,37,7,64,-16,71r-114,0v0,36,1,69,2,101v1,32,3,64,6,95r156,7v5,11,6,23,6,37v1,27,-24,37,-51,37r-189,0r-11,-277r-62,0v3,-37,-7,-64,16,-71r46,0v6,-135,30,-244,161,-247v54,-1,114,18,96,78v-2,7,-4,16,-7,25v-36,-28,-115,-30,-140,11v-20,32,-28,75,-29,133r130,0","w":366},"\u00a7":{"d":"46,-587v0,-82,67,-116,151,-116v57,0,109,11,109,59v0,18,-5,35,-15,50v-42,-40,-191,-28,-145,50v39,66,124,111,156,184v25,57,-2,124,-47,149v25,30,46,52,46,99v0,82,-68,116,-152,116v-57,0,-109,-14,-109,-59v0,-18,5,-35,15,-50v42,40,191,27,145,-51v-39,-66,-124,-109,-156,-183v-25,-57,2,-124,47,-149v-24,-31,-45,-53,-45,-99xm150,-434v-31,10,-50,53,-31,87v17,31,48,60,76,82v49,-16,49,-87,11,-119v-14,-19,-37,-35,-56,-50","w":348},"\u00b6":{"d":"231,-710v48,-2,90,13,121,28r0,656v2,39,-55,30,-82,23r0,-202v-17,10,-52,15,-79,15v-123,0,-158,-98,-158,-230v0,-163,44,-285,198,-290xm211,-256v19,0,47,-5,59,-14r0,-360v-116,-42,-158,70,-153,202v3,93,12,172,94,172xm414,-658v-4,-41,51,-34,82,-26r0,658v5,41,-53,29,-82,24r0,-656","w":541},"\u2260":{"d":"375,-187v-3,37,7,64,-16,71r-165,0r-37,106v-16,33,-56,14,-81,-10r33,-96r-84,0v3,-37,-7,-65,17,-71r92,0r40,-115r-149,0v3,-37,-7,-65,17,-71r156,0r40,-114v18,-35,56,-20,84,6r-38,108r91,0v-3,37,7,64,-16,71r-100,0r-40,115r156,0","w":400},"\u221e":{"d":"171,-116v-86,1,-132,-59,-131,-143v1,-92,42,-148,136,-148v71,0,104,40,132,83v30,-39,63,-84,129,-83v82,1,129,57,129,146v0,98,-44,149,-133,149v-67,0,-107,-38,-134,-83v-31,37,-66,79,-128,79xm167,-323v-67,11,-59,136,13,132v44,-2,65,-36,86,-66v-17,-37,-42,-75,-99,-66xm422,-190v74,7,88,-125,20,-137v-56,-10,-73,36,-97,67v18,30,32,66,77,70","w":606},"\u00b1":{"d":"385,-360v-3,37,7,64,-16,71r-123,0r0,123v-6,23,-35,13,-71,16r0,-139r-140,0v3,-37,-7,-65,17,-71r123,0r0,-123v6,-24,34,-14,71,-17r0,140r139,0xm384,-85v-3,37,7,64,-16,71r-334,0v3,-37,-7,-65,17,-71r333,0","w":419},"\u00b5":{"d":"349,-24v-51,24,-175,60,-223,9r0,178v1,38,-52,35,-82,27r0,-660v-4,-41,49,-39,82,-30r0,369v-8,76,92,72,141,50r0,-389v-5,-43,49,-38,82,-30r0,476","w":394},"\u03bc":{"d":"349,-24v-51,24,-175,60,-223,9r0,178v1,38,-52,35,-82,27r0,-660v-4,-41,49,-39,82,-30r0,369v-8,76,92,72,141,50r0,-389v-5,-43,49,-38,82,-30r0,476","w":394},"\u2202":{"d":"44,-257v-1,-140,43,-252,160,-252v36,0,65,10,88,29v-28,-104,-77,-163,-152,-226v13,-28,60,-51,90,-24v110,97,166,230,165,441v-1,154,-19,299,-171,299v-149,0,-179,-113,-180,-267xm222,-58v110,-10,88,-163,88,-281v0,-17,-2,-33,-3,-48v-20,-29,-40,-50,-81,-50v-84,0,-98,101,-98,193v0,104,15,177,94,186","w":425},"\u2211":{"d":"320,-700v7,24,7,77,-18,77r-143,0r121,416r-124,321r170,0v5,31,6,76,-22,76r-257,0r149,-403r-148,-487r272,0","w":390},"\u220f":{"d":"401,-700v11,25,11,77,-22,77r-27,0r0,786v-1,35,-53,34,-82,24r0,-810r-108,0r0,786v0,34,-54,35,-81,24r0,-810r-45,0v-8,-24,-13,-77,20,-77r345,0","w":438},"\u03c0":{"d":"401,-500v11,25,11,77,-22,77r-27,0r0,398v-1,34,-52,32,-82,24r0,-422r-108,0r0,398v0,34,-53,33,-81,24r0,-422r-45,0v-8,-24,-13,-77,20,-77r345,0","w":438},"\u222b":{"d":"22,111v75,27,171,18,171,-82r0,-593v-2,-120,53,-174,168,-174v75,0,109,27,84,86v-75,-27,-171,-18,-171,81r0,594v2,119,-54,173,-168,173v-74,0,-110,-26,-84,-85","w":467},"\u00aa":{"d":"214,-581v5,-87,-113,-56,-157,-35v-11,-11,-18,-45,-5,-59v24,-25,68,-36,124,-35v65,1,106,32,106,102r0,291v-29,14,-82,29,-129,29v-80,0,-113,-40,-113,-123v0,-108,82,-142,174,-113r0,-57xm106,-409v-8,68,65,72,108,51r0,-110v-52,-18,-117,-8,-108,59","w":322},"\u00ba":{"d":"165,-289v-113,0,-129,-91,-130,-210v-1,-126,36,-208,139,-211v115,-3,128,91,129,209v1,125,-32,212,-138,212xm174,-638v-67,0,-70,71,-70,144v0,70,-2,138,62,138v59,0,68,-62,68,-143v0,-69,2,-139,-60,-139","w":338},"\u03a9":{"d":"392,-77v10,25,13,77,-21,77r-129,0v64,-136,93,-382,50,-562v-17,-71,-123,-84,-145,-12v-52,167,-16,439,45,574r-150,0v-10,-26,-13,-77,20,-77r51,0v-48,-74,-74,-182,-74,-308v0,-192,29,-325,191,-325v160,0,165,155,167,321v2,129,-26,238,-75,312r70,0","w":435},"\u2126":{"d":"392,-77v10,25,13,77,-21,77r-129,0v64,-136,93,-382,50,-562v-17,-71,-123,-84,-145,-12v-52,167,-16,439,45,574r-150,0v-10,-26,-13,-77,20,-77r51,0v-48,-74,-74,-182,-74,-308v0,-192,29,-325,191,-325v160,0,165,155,167,321v2,129,-26,238,-75,312r70,0","w":435},"\u00ac":{"d":"40,-232v-9,-28,-13,-77,20,-77r298,0r0,198v-25,10,-76,13,-77,-20r0,-101r-241,0","w":400},"\u221a":{"d":"441,-700v11,24,12,77,-21,77r-70,0r-97,778v-2,46,-66,44,-104,33r-102,-406v15,-21,74,-30,82,4r61,251r88,-737r163,0","w":468},"\u0192":{"d":"420,-500v-3,37,7,64,-16,71r-130,0r0,452v2,119,-54,173,-168,173v-74,0,-110,-26,-84,-85v75,27,171,18,171,-82r0,-458r-123,0v3,-37,-7,-65,17,-71r106,0r0,-64v-2,-120,53,-174,168,-174v75,0,109,27,84,86v-75,-27,-183,-17,-171,81r0,71r146,0","w":467},"\u2248":{"d":"263,-272v-68,0,-86,-56,-159,-38v-29,7,-55,48,-78,18v-6,-7,-9,-19,-10,-34v24,-28,67,-63,125,-63v60,0,67,43,124,43v31,0,54,-18,70,-35v29,-18,52,15,46,51v-20,27,-66,58,-118,58xm258,-132v-61,3,-68,-38,-120,-43v-46,-4,-70,59,-106,27v-11,-9,-16,-24,-17,-43v22,-25,67,-58,119,-58v68,0,86,55,158,38v29,-7,59,-45,84,-17v6,7,9,18,10,31v-26,35,-67,62,-128,65","w":400},"\u0394":{"d":"165,-652v1,-47,62,-67,99,-39r144,691r-384,0xm116,-77r203,0r-100,-513r-4,0","w":427},"\u2206":{"d":"165,-652v1,-47,62,-67,99,-39r144,691r-384,0xm116,-77r203,0r-100,-513r-4,0","w":427},"\u00a0":{"w":157},"\u25ca":{"d":"228,6r-199,-355r199,-356r200,356xm228,-545r-110,196r110,194r111,-194","w":455},"\u2021":{"d":"189,-421v0,-26,29,-30,53,-18r0,169v-1,25,-28,25,-53,16r0,-167xm173,-668v-9,-44,66,-51,88,-21r-23,177v-5,22,-27,21,-42,10xm361,-515v35,-12,44,39,33,69v-3,8,-7,13,-12,18r-120,-21v-21,-5,-20,-26,-11,-43xm69,-429v-44,9,-50,-67,-20,-88r120,23v23,7,24,27,12,44xm234,-192v6,58,22,116,22,174v-12,27,-71,27,-87,3r22,-166v5,-22,27,-22,43,-11xm179,-201v-42,7,-84,21,-127,25v-28,-11,-28,-75,-4,-90r120,22v20,4,19,27,11,43xm360,-264v44,-7,50,66,21,88r-121,-23v-22,-6,-22,-26,-12,-43","w":430},"\u00af":{"d":"260,-670v13,28,10,77,-24,77r-230,0v-12,-29,-9,-78,26,-77r228,0","w":267},"\u02d8":{"d":"124,-567v-68,0,-124,-48,-124,-111v0,-29,17,-35,42,-45v10,52,80,109,132,57v17,-17,24,-70,60,-48v10,7,21,22,24,36v-22,58,-56,111,-134,111","w":258},"\u02dd":{"d":"124,-745v9,-30,55,-27,73,-4v32,-28,78,8,75,47r-118,133v-14,12,-35,7,-47,-6v-19,23,-58,5,-63,-17","w":320},"\u02db":{"d":"82,195v-95,9,-100,-123,-48,-175v19,-30,84,-70,108,-20v-31,22,-64,52,-69,100v-3,38,36,43,61,28v5,12,8,22,8,31v1,34,-29,33,-60,36","w":143},"\u2264":{"d":"334,-466v20,15,45,63,14,78r-198,97r215,97v0,38,-23,74,-64,56r-244,-108v-19,-30,-18,-77,13,-92xm367,-71v-3,37,7,64,-16,71r-302,0v3,-37,-7,-64,16,-71r302,0","w":412},"\u2265":{"d":"75,-129v-20,-17,-47,-64,-15,-79r199,-97r-215,-96v2,-38,21,-75,64,-56r244,108v18,32,19,75,-14,91xm363,-71v-3,37,7,64,-16,71r-298,0v3,-37,-7,-65,17,-71r297,0","w":409},"\u00f0":{"d":"139,-707v11,-28,61,-51,89,-24r43,41r69,-27v9,23,15,40,18,51v7,28,-27,25,-42,35v53,88,80,198,79,342v-1,154,-19,299,-171,299v-149,0,-179,-113,-180,-267v-1,-140,43,-252,160,-252v36,0,65,10,88,29v-12,-47,-30,-85,-54,-121r-94,37v-9,-23,-15,-41,-18,-52v-3,-11,0,-18,7,-21r58,-22xm222,-58v110,-10,88,-163,88,-281v0,-17,-2,-33,-3,-48v-20,-29,-40,-50,-81,-50v-84,0,-98,101,-98,193v0,104,15,177,94,186","w":425},"\u00fe":{"d":"127,194v-28,5,-81,22,-81,-28r0,-864v-3,-44,38,-36,81,-37r0,233v21,-4,41,-7,65,-7v125,-1,163,80,163,209v0,113,-19,194,-54,255v-32,56,-127,72,-174,29r0,210xm265,-293v0,-79,-2,-145,-78,-145v-22,0,-42,7,-60,21r0,329v12,27,50,39,78,20v54,-36,60,-123,60,-225","w":383},"\u00de":{"d":"124,-16v0,29,-51,11,-81,16r0,-680v0,-31,43,-16,81,-20r0,125v151,-7,219,48,219,198v0,148,-66,227,-219,218r0,143xm124,-236v104,14,131,-41,129,-151v-1,-65,-16,-117,-79,-117r-50,2r0,266","w":360},"!":{"d":"97,7v-41,0,-54,-20,-55,-57v0,-31,22,-58,55,-58v40,0,55,21,56,58v0,31,-23,57,-56,57xm45,-682v7,-38,63,-19,111,-24r-16,454v0,42,-38,37,-81,38","w":195},"\u0237":{"d":"-6,121v58,-2,60,-35,60,-98r0,-486v-2,-44,37,-36,81,-37r0,536v0,97,-32,160,-131,160v-67,0,-116,-14,-104,-75v2,-7,5,-14,10,-20v23,13,51,20,84,20","w":184},"\"":{"d":"65,-786v15,0,34,0,46,3v-3,62,-7,147,-21,197r-45,3r-14,-183v-3,-26,14,-20,34,-20xm188,-786v15,0,34,0,46,3v-3,62,-7,147,-21,197r-45,3r-15,-183v-3,-26,15,-20,35,-20","w":264,"k":{"\ufb04":44,"\ufb03":44,"\ufb02":44,"\ufb01":44,"\ufb00":44,"\u20ac":122,"\u017e":70,"\u0178":-20,"\u0161":91,"\u0160":11,"\u0153":93,"\u0152":20,"\u00ff":71,"\u00fd":71,"\u00fc":73,"\u00fb":73,"\u00fa":73,"\u00f9":73,"\u00f8":93,"\u00f6":93,"\u00f5":93,"\u00f4":93,"\u00f3":93,"\u00f2":93,"\u00f1":96,"\u00ef":-54,"\u00ee":-41,"\u00ec":-52,"\u00eb":103,"\u00ea":103,"\u00e9":103,"\u00e8":103,"\u00e7":94,"\u00e6":72,"\u00e5":72,"\u00e4":72,"\u00e3":72,"\u00e2":72,"\u00e1":72,"\u00e0":72,"\u00dd":-20,"\u00dc":10,"\u00db":11,"\u00da":1,"\u00d9":1,"\u00d8":20,"\u00d6":20,"\u00d5":20,"\u00d4":20,"\u00d3":20,"\u00d2":20,"\u00d1":9,"\u00cf":-19,"\u00ce":-41,"\u00cb":16,"\u00ca":5,"\u00c7":55,"\u00c6":119,"\u00c5":119,"\u00c4":119,"\u00c3":119,"\u00c2":119,"\u00c1":119,"\u00c0":119,"\u00bf":104,"\u00a2":56,"r":96,"q":111,"m":96,"\\":-37,"Q":20,"@":75,"?":-20,"9":46,"6":31,"4":101,"3":4,"2":19,"1":39,"0":43,"\/":130,"+":21,"C":55,"G":37,"T":-13,"V":-16,"W":-16,"Y":-20,"d":111,"f":44,"t":18,"u":73,"v":69,"w":69,"y":71,"c":94,"e":103,"o":93,"O":20,")":-20,"]":-20,"A":119,"J":132,"x":63,"a":72,"z":70,"g":107,"n":96,"p":100,"s":91,"(":79,"[":79}}}});
