<?php       
/**
 * @package WordPress
 * @since 1.0
 */
 
/*
Template Name: Blog
*/

get_header() ?>           
        


        <div class="layout-<?php echo yiw_layout_page() ?>">
            <?php if( get_post_meta( get_the_ID(), '_slogan_page', true ) ): ?>
            <div id="slogan">
                <h1><?php echo get_post_meta( get_the_ID(), '_slogan_page', true ); ?></h1>
                <h3><?php echo get_post_meta( get_the_ID(), '_subslogan_page', true ); ?></h3>
            </div>
            <?php endif ?>
        
            <?php 
                global $paged, $blog_type; 
                
                if( !$blog_type) $blog_type = yiw_get_option('blog_type');
            ?>
            <?php query_posts('cat=' . yiw_get_exclude_categories() . '&posts_per_page=' . get_option('posts_per_page') . '&paged=' . $paged) ?>
            
            <!-- START CONTENT -->
            <div id="content" class="group">
                <?php get_template_part('loop', 'index') ?>
            </div>                       
            <!-- END CONTENT -->
            
            <!-- START LATEST NEWS -->
            <?php get_sidebar('blog') ?>
            <!-- END LATEST NEWS -->   
        
        </div>      
        
<?php get_footer() ?>
